-- logTable(textures:getTextures())

-- Stop all emotes when playing a new one
function stopAllAnimations()
    for _, emote in pairs({"Sit", "Lay", "Wave", "Point", "Bow", "Faceplant"}) do
        animations.player_model[emote]:stop()
    end
end

-- Stop animations if sprinting
function events.tick()
    if player:isSprinting() then
        stopAllAnimations()
        if povToggle then
            renderer:offsetCameraPivot(0, playerpov, 0)
          else
            renderer:offsetCameraPivot(0, 0, 0)
          end
    end
end

-- Pings to synchronize texture changes
function pings.setTexture(textureName)
    log(textureName)
    models.player_model.Player.HEAD.Face:setPrimaryTexture("Custom", textures[textureName])
    models.player_model.Player.BODY.Torso:setPrimaryTexture("Custom", textures[textureName])
    models.player_model.Player.LEFT_ARM.LArm:setPrimaryTexture("Custom", textures[textureName])
    models.player_model.Player.RIGHT_ARM.RArm:setPrimaryTexture("Custom", textures[textureName])
    models.player_model.Player.LEFT_LEG.LLeg:setPrimaryTexture("Custom", textures[textureName])
    models.player_model.Player.RIGHT_LEG.RLeg:setPrimaryTexture("Custom", textures[textureName])
end

-- Texture Swap Page
local mainPage = action_wheel:newPage()
action_wheel:setPage(mainPage)

-- Add as many skins to \figura\avatars\ImprovedTemplate\textures as you like, making sure to name them 'texture2.png' and so on, replace files when prompted by your OS!

-- Change the names and icons that appear in the action wheel by changing the information for 'title' and 'item' in the table below. For example: 
-- {title = "Fancy Outfit", textureNames = "player_model.texture2", item = "gold_block"},

local texturePage = action_wheel:newPage("Textures")
local playertextures = {
    {title = "Default", textureNames = "player_model.texture", item = "red_wool"},
    {title = "Unused 2", textureNames = "player_model.texture2", item = "white_wool"},
    {title = "Unused 3", textureNames = "player_model.texture3", item = "blue_wool"},
    {title = "Unused 4", textureNames = "player_model.texture4", item = "purple_wool"},
    {title = "Unused 5", textureNames = "player_model.texture5", item = "black_wool"},
    {title = "Unused 6", textureNames = "player_model.texture6", item = "gray_wool"},
    {title = "Unused 7", textureNames = "player_model.texture7", item = "yellow_wool"},
}

for _, skins in ipairs(playertextures) do
    texturePage:newAction()
        :title(skins.title)
        :item(skins.item)
        :onLeftClick(function()
            pings.setTexture(skins.textureNames) -- Sync texture change
        end)
end

texturePage:newAction()
    :title("Back to Main Page")
    :item("minecraft:arrow")
    :onLeftClick(function()
        action_wheel:setPage(mainPage)
    end)

mainPage:newAction()
    :title("Open Textures")
    :item("minecraft:chest")
    :onLeftClick(function()
        action_wheel:setPage(texturePage)
    end)


-- Emote Page Setup

function pings.emote(animname)
    stopAllAnimations()
    animations.player_model[animname]:play()
end

local emotePage = action_wheel:newPage("Emotes")
local emotes = {
    {title = "Wave", item = "red_concrete"},
    {title = "Bow", item = "orange_concrete"},
}

for _, emote in ipairs(emotes) do
    emotePage:newAction()
        :title(emote.title)
        :item(emote.item)
        :onLeftClick(function()
            pings.emote(emote.title)
            renderer:offsetCameraPivot(0, state and emote.povY or playerpov, 0)
        end)
end

function pings.toggleEmote(state, animname)
    animations.player_model[animname]:setPlaying(state)
  end

local emotessimple = {
    {title = "Point", item = "yellow_concrete"},
}
for _, emote in ipairs(emotessimple) do
    emotePage:newAction()
        :title(emote.title)
        :item(emote.item)
        :onToggle(function(state) 
            pings.toggleEmote(state, emote.title)
        end)
end

local emotes2 = {
    {title = "Sit", item = "lime_concrete",  povY =  -.4},
    {title = "Lay", item = "light_blue_concrete",  povY = -1.4},
    {title = "Faceplant", item = "blue_concrete",  povY = -1.4},
}

for _, emote in ipairs(emotes2) do
    emotePage:newAction()
        :title(emote.title)
        :item(emote.item)
        :onToggle(function(state)
            stopAllAnimations()
            pings.toggleEmote(state, emote.title)
            renderer:offsetCameraPivot(0, state and emote.povY or playerpov, 0)
        end)
    end

emotePage:newAction()
    :title("Back to Main Page")
    :item("minecraft:arrow")
    :onLeftClick(function()
        action_wheel:setPage(mainPage)
    end)

mainPage:newAction()
    :title("Open Emotes")
    :item("armor_stand")
    :onLeftClick(function()
        action_wheel:setPage(emotePage)
    end)


-- Toggle Page Setup

-- This is an example of how to toggle a prayer seal on an avatar, to modify it to your needs, change 'models.player_model.Player.BODY.Seal' to the index of the part of the model you want to be able to toggle. 
-- Dont forget to uncomment the lines below once done!

--function pings.togglepart(state)
    --models.player_model.Player.BODY.Seal:setVisible(state)
--end

--models.player_model.Player.BODY.Seal:setVisible(false)

local togglePage = action_wheel:newPage("Toggles")
local toggles = {
    {title = "Example Toggle", item = "paper"},
}

togglePage:newAction()
    :title("Back to Main Page")
    :item("minecraft:arrow")
    :onLeftClick(function()
        action_wheel:setPage(mainPage)
    end)

mainPage:newAction()
    :title("Open Toggles")
    :item("lever")
    :onLeftClick(function()
        action_wheel:setPage(togglePage)
    end)

for _, toggle in ipairs(toggles) do
    togglePage:newAction()
        :title(toggle.title)
        :item(toggle.item)
        :onToggle(pings.togglepart)
    end
    
-- Extra Page Setup
local extraPage = action_wheel:newPage("Extras")
local extras = {
    {title = "Stop Animations", item = "red_concrete"},
}

for _, extra in ipairs(extras) do
    extraPage:newAction()
        :title(extra.title)
        :item(extra.item)
        :onLeftClick(function()
            stopAllAnimations()
        end)
end

extraPage:newAction()
    :title("Back to Main Page")
    :item("minecraft:arrow")
    :onLeftClick(function()
        action_wheel:setPage(mainPage)
    end)

mainPage:newAction()
    :title("Open Extras")
    :item("barrel")
    :onLeftClick(function()
        action_wheel:setPage(extraPage)
    end)
