-- Sets your player model and vanilla armor as invisible, while allowing held items to exist
vanilla_model.PLAYER:setVisible(false)
vanilla_model.HELD_ITEMS:setVisible(true)
vanilla_model.ARMOR:setVisible(false)

-- set your avatar blockbench model name.
local model = models.player_model

-- Controls camera positions. This controls both first and third person.
playerpov = 0
-- The crosshair will move from the center of the screen while in custom POV
local pov = keybinds:newKeybind("POV Toggle", "key.keyboard.h")
povToggle = true
function pov:press()
  povToggle=not povToggle
  if povToggle then
    renderer:offsetCameraPivot(0, playerpov, 0)
  else
    renderer:offsetCameraPivot(0, 0, 0)
  end
end

-- Sets the camera to be custom height from start
renderer:offsetCameraPivot(0, playerpov, 0)

-- Fixes crouching and GSit/Mount positions
function events.tick()
  local currentPose = player:getPose()
  if currentPose == "CROUCHING" then --Crouching Positions
      models.player_model:setPos(0, 3, -2)
      model.Player.LEFT_LEG:setPos(0, -1, 1)
      model.Player.RIGHT_LEG:setPos(0, -1, 1)
  elseif player:getVehicle() then --GSit/Mount Positions
      models.player_model:setPos(0, 0, 0)
      model.Player.LEFT_LEG:setPos(defaultPos)
      model.Player.RIGHT_LEG:setPos(defaultPos)
  else
      models.player_model:setPos(defaultPos)
      model.Player.LEFT_LEG:setPos(defaultPos)
      model.Player.RIGHT_LEG:setPos(defaultPos)
  end
end

-- Use speechBubble2 as a sent indicator
models.player_model.Player.HEAD.speechBubble2:setVisible(false)

function pings.messageSent()
  -- Animation contains scripts to set visibility true then false at the correct time
  animations.player_model.MessageSent:setPlaying(true)
end

function events.CHAT_SEND_MESSAGE(message)
  pings.messageSent()
  return message
end