-- Helmets Table. Add new entries to the end by the given format
local helmets = {
    -- Heavy
    {"Armet", textures["player_model.plate"],"minecraft:leather_helmet"},
    {"Reinforced Sallet", textures["player_model.splint"],"minecraft:leather_helmet"},
    {"Padded Spangenhelm", textures["player_model.lamellar"],"minecraft:leather_helmet"},
    -- Medium
    {"Kettlehelm", textures["player_model.halfplate"],"minecraft:leather_helmet"},
    {"Mail Coif", textures["player_model.chainmail"],"minecraft:leather_helmet"},
    {"Scale Skullcap", textures["player_model.scalemail"],"minecraft:leather_helmet"},
    -- Light
    {"Padded Hood", textures["player_model.doublet"],"minecraft:leather_helmet"},
    {"Tallerbarret", textures["player_model.brigandine"],"minecraft:leather_helmet"},
    {"Cap", textures["player_model.leathers"],"minecraft:leather_helmet"},
    -- Crude
    {"Crude Leather Helmet", textures["player_model.defaultBadLeather"],"minecraft:leather_helmet"},
    {"Crude Iron Helmet", textures["player_model.defaultIronCrude"],"minecraft:leather_helmet"},
    -- Custom
    --{"Name of Helmet", textures["path.to.texture"],"minecraft:type_helmet"},
}
-- Chestplates Table. Add new entries to the end by the given format
local chestslots = {
    -- Heavy
    {"Cuirass", textures["player_model.plate"],"minecraft:leather_chestplate"},
    {"Reinforced Brigandine", textures["player_model.splint"],"minecraft:leather_chestplate"},
    {"Padded Lamellar", textures["player_model.lamellar"],"minecraft:leather_chestplate"},
    -- Medium
    {"Halfplate Cuirass", textures["player_model.halfplate"],"minecraft:leather_chestplate"},
    {"Mail Hauberk", textures["player_model.chainmail"],"minecraft:leather_chestplate"},
    {"Scale Mail", textures["player_model.scalemail"],"minecraft:leather_chestplate"},
    -- Light
    {"Padded Gambeson", textures["player_model.doublet"],"minecraft:leather_chestplate"},
    {"Jack Doublet", textures["player_model.brigandine"],"minecraft:leather_chestplate"},
    {"Fitted Jerkin", textures["player_model.leathers"],"minecraft:leather_chestplate"},
    -- Crude
    {"Crude Leather Chestplate", textures["player_model.defaultBadLeather"],"minecraft:leather_chestplate"},
    {"Crude Iron Chestplate", textures["player_model.defaultIronCrude"],"minecraft:leather_chestplate"},
    --Custom
    --{"Name of Chestplate", textures["path.to.texture"],"minecraft:type_chestplate"},
}
-- Leggings Table. Add new entries to the end by the given format
local legslots = {
    -- Heavy
    {"Chausses", textures["player_model.plate"],"minecraft:leather_leggings"},
    {"Reinforced Cuisses", textures["player_model.splint"],"minecraft:leather_leggings"},
    {"Padded Poleyn", textures["player_model.lamellar"],"minecraft:leather_leggings"},
    -- Medium
    {"Halfplate Tassets", textures["player_model.halfplate"],"minecraft:leather_leggings"},
    {"Mail Chausses", textures["player_model.chainmail"],"minecraft:leather_leggings"},
    {"Scale Chausses", textures["player_model.scalemail"],"minecraft:leather_leggings"},
    -- Light
    {"Padded Hose", textures["player_model.doublet"],"minecraft:leather_leggings"},
    {"Jack Kneecap", textures["player_model.brigandine"],"minecraft:leather_leggings"},
    {"Fitted Hose", textures["player_model.leathers"],"minecraft:leather_leggings"},
    -- Crude
    {"Crude Leather Leggings", textures["player_model.defaultBadLeather"],"minecraft:leather_leggings"},
    {"Crude Iron Leggings", textures["player_model.defaultIronCrude"],"minecraft:leather_leggings"},
    -- Custom
    --{"Name of Leggings", textures["path.to.texture"],"minecraft:type_leggings"},
}
-- Boots Table. Add new entries to the end by the given format
local bootslots = {
    -- Heavy
    {"Sabatons", textures["player_model.plate"],"minecraft:leather_boots"},
    {"Reinforced Greaves", textures["player_model.splint"],"minecraft:leather_boots"},
    {"Padded Sabatons", textures["player_model.lamellar"],"minecraft:leather_boots"},
    -- Medium
    {"Toecap Boots", textures["player_model.halfplate"],"minecraft:leather_boots"},
    {"Mail Boots", textures["player_model.chainmail"],"minecraft:leather_boots"},
    {"Scale Boots", textures["player_model.scalemail"],"minecraft:leather_boots"},
    -- Light
    {"Padded Tallboots", textures["player_model.doublet"],"minecraft:leather_boots"},
    {"Jack Boots", textures["player_model.brigandine"],"minecraft:leather_boots"},
    {"Fitted Boots", textures["player_model.leathers"],"minecraft:leather_boots"},
    -- Crude
    {"Crude Leather Boots", textures["player_model.defaultBadLeather"],"minecraft:leather_boots"},
    {"Crude Iron Boots", textures["player_model.defaultIronCrude"],"minecraft:leather_boots"},
    -- Custom
    --{"Name of Leggings", textures["path.to.texture"],"minecraft:type_leggings"},
}

-- Index of model parts tied to armors. Setting model parts to variables saves you from typing the full path.to.part out each time it is needed.
-- Set any new armor parts to variables for this purpose. DO NOT CHANGE WHAT IS ALREADY HERE.
local helms = models.player_model.Player.HEAD.Helmet
local oldHelm -- What was just in the helmet slot
local helm -- What is currently in the helmet slot

local RChest = models.player_model.Player.RIGHT_ARM.RArmor
local LChest = models.player_model.Player.LEFT_ARM.LArmor
local MChest = models.player_model.Player.BODY.ArmorTorso
local oldChest -- What was just in the chestplate slot
local chest -- What is currently in the chestplate slot

local RLegArmor = models.player_model.Player.RIGHT_LEG.RLegArmor
local LLegArmor = models.player_model.Player.LEFT_LEG.LLegArmor
local oldLegg -- What was just in the leggings slot
local legg -- what is currently in the leggings slot

local RBoot = models.player_model.Player.RIGHT_LEG.RBoot
local LBoot = models.player_model.Player.LEFT_LEG.LBoot
local oldBoot -- What was just in the boots slot
local boot -- what is currently in the boots slot

-- Add variables for parts tied to weapons here

local oldOHand
local ohand
local oldHand
local hand
--[[ Example Part Variable:
local part = models.player_model.path.to.part
]]

-- events.entity_init() runs when the avatar is loaded. This makes it so the armors only change on the model when they change in game. Saves instruction count.
function events.entity_init()
    helm = player:getItem(6)
    oldHelm = false
    chest = player:getItem(5)
    oldChest = false
    legg = player:getItem(4)
    oldLegg = false
    boot = player:getItem(3)
    oldBoot = false
    ohand = player:getItem(2)
    oldOHand = false
    hand = player:getItem(1)
    oldHand = false
    items()
end

-- makes the items() function run every tick
function events.tick()
    items()
end

function items()
    helm = player:getItem(6) -- gets the item in the helmet slot
    if helm ~= oldHelm then -- checks if the current helmet matches the old helmet
        local helmName = helm:getName() -- gets the name of the item in the helmet slot

        -- Sets cubes tied to helmet invisible. Add any new parts tied to helmet under them
        helms:setVisible(false)

        for i = 1,#helmets do -- References the Helmets Table, setting the texture of the helmet cubes
            if helmName:match("Leather Cap") and "minecraft:leather_helmet" == helm.id then
                helms:setPrimaryTexture("CUSTOM",textures["player_model.defaultBadLeather"])
                helms:setVisible(true)
            elseif helmName:match(helmets[i][1]) and helmets[i][3] == helm.id then
                helms:setPrimaryTexture("CUSTOM",helmets[i][2])
                helms:setVisible(true)
            end
            --[[An example for adding new cubes for custom armors
            if helmName:match("Name of Item") and "minecraft:type_helmet" == helm.id then
                part:setVisible(true)
            end
            ]]
        end
        oldHelm = helm -- Sets oldHelm to current helmet, to be referenced at the start of the script
    end
    chest = player:getItem(5) -- gets the item in the chestplate slot
    if chest ~= oldChest then -- checks if the current chestplate matches the old chestplate
        local chestName = chest:getName() -- gets the name of the item in the chestplate slot

        -- Sets cubes tied to chestplate invisible. Add any new parts tied to chestplate under them
        RChest:setVisible(false)
        LChest:setVisible(false)
        MChest:setVisible(false)

        for i = 1,#chestslots do -- References the Chestplates Table, setting the texture of the chestplate cubes
            if chestName:match("Leather Tunic") and "minecraft:leather_chestplate" == chest.id then
                RChest:setPrimaryTexture("CUSTOM",textures["player_model.defaultBadLeather"])
                LChest:setPrimaryTexture("CUSTOM",textures["player_model.defaultBadLeather"])
                MChest:setPrimaryTexture("CUSTOM",textures["player_model.defaultBadLeather"])
                RChest:setVisible(true)
                LChest:setVisible(true)
                MChest:setVisible(true)
            elseif chestName:match(chestslots[i][1]) and chestslots[i][3] == chest.id then
                RChest:setPrimaryTexture("CUSTOM",chestslots[i][2])
                LChest:setPrimaryTexture("CUSTOM",chestslots[i][2])
                MChest:setPrimaryTexture("CUSTOM",chestslots[i][2])
                RChest:setVisible(true)
                LChest:setVisible(true)
                MChest:setVisible(true)
            end
            --[[An example for adding new cubes for custom armors
            if chestName:match("Name of Item") and "minecraft:type_chestplate" == chest.id then
                part:setVisible(true)
            end
            ]]
        end
        oldChest = chest -- Sets oldChest to current chestplate, to be referenced at the start of the script
    end
    legg = player:getItem(4) -- gets the item in the leggings slot
    if legg ~= oldLegg then -- checks if the current leggings matches the old leggings
        local leggName = legg:getName() -- gets the name of the item in the leggings slot

        -- Sets cubes tied to leggings invisible. Add any new parts tied to leggings under them
        RLegArmor:setVisible(false)
        LLegArmor:setVisible(false)

        for i = 1,#legslots do -- References the Leggings Table, setting the texture of the leggings cubes
            if leggName:match("Leather Pants") and "minecraft:leather_leggings" == legg.id then
                RLegArmor:setPrimaryTexture("CUSTOM",textures["player_model.defaultBadLeather"])
                LLegArmor:setPrimaryTexture("CUSTOM",textures["player_model.defaultBadLeather"])
                RLegArmor:setVisible(true)
                LLegArmor:setVisible(true)
            elseif leggName:match(legslots[i][1]) and legslots[i][3] == legg.id then
                RLegArmor:setPrimaryTexture("CUSTOM",legslots[i][2])
                LLegArmor:setPrimaryTexture("CUSTOM",legslots[i][2])
                RLegArmor:setVisible(true)
                LLegArmor:setVisible(true)
            end
            --[[An example for adding new cubes for custom armors
            if leggName:match("Name of Item") and "minecraft:type_leggings" == boot.id then
                part:setVisible(true)
            end
            ]]
        end
        oldLegg = legg -- Sets oldLegg to current leggings, to be referenced at the start of the script
    end
    boot = player:getItem(3) -- gets the item in the boots slot
    if boot ~= oldBoot then -- checks if the current boots match the old boots
        local bootName = boot:getName() -- gets the name of the item in the boots slot

        -- Sets cubes tied to boots invisible. Add any new parts tied to boots under them
        RBoot:setVisible(false)
        LBoot:setVisible(false)

        for i = 1,#bootslots do -- References the Boots Table, setting the texture of the boots cubes
            if bootName:match(bootslots[i][1]) and bootslots[i][3] == boot.id then
                RBoot:setPrimaryTexture("CUSTOM",bootslots[i][2])
                LBoot:setPrimaryTexture("CUSTOM",bootslots[i][2])
                RBoot:setVisible(true)
                LBoot:setVisible(true)
            end
            --[[An example for adding new cubes for custom armors
            if bootName:match("Name of Item") and "minecraft:type_boots" == boot.id then
                part:setVisible(true)
            end
            ]]
        end
        oldBoot = boot -- Sets oldBoot to current boots, to be referenced at the start of the script
    end
    --[[ Weapon model toggle. Remove brackets to enable.
    ohand = player:getItem(2)
    if ohand ~= oldOHand then
        local ohandName = ohand:getName()

        -- Sets cube tied to weapon handles visible. Add any new weapon handles under them
        part:setVisible(true)

        if ohandName:match("Name of Weapon") and "minecraft:weapon_type" == ohand.id then
            --Sets cube tied to weapon handles invisible. Add any new weapon handles under them
            part:setVisible(false)
        end
        oldOHand = ohand
    end
    hand = player:getItem(1)
    if hand ~= oldHand then
        local handName = hand:getName()

        -- Sets cube tied to weapon handles visible. Add any new weapon handles under them
        part:setVisible(true)

        if handName:match("Name of Weapon") and "minecraft:weapon_type" == hand.id then
            --Sets cube tied to weapon handles invisible. Add any new weapon handles under them
            part:setVisible(false)
        end
        oldHand = hand
    end
    ]]
end