/*
 * Decompiled with CFR 0.152.
 */
package me.pepperbell.continuity.client.util;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.locks.StampedLock;
import java.util.function.Supplier;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_773;
import net.minecraft.class_777;
import org.jetbrains.annotations.ApiStatus;

public final class SpriteCalculator {
    private static final class_773 MODELS = class_310.method_1551().method_1554().method_4743();
    private static final EnumMap<class_2350, SpriteCache> SPRITE_CACHES = new EnumMap(class_2350.class);

    public static class_1058 getSprite(class_2680 state, class_2350 face) {
        return SPRITE_CACHES.get(face).getSprite(state);
    }

    public static class_1058 calculateSprite(class_2680 state, class_2350 face, Supplier<Random> randomSupplier) {
        class_1087 model = MODELS.method_3335(state);
        try {
            List quads = model.method_4707(state, face, randomSupplier.get());
            if (!quads.isEmpty()) {
                return ((class_777)quads.get(0)).method_35788();
            }
            quads = model.method_4707(state, null, randomSupplier.get());
            if (!quads.isEmpty()) {
                int amount = quads.size();
                for (int i = 0; i < amount; ++i) {
                    class_777 quad = (class_777)quads.get(i);
                    if (quad.method_3358() != face) continue;
                    return quad.method_35788();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return model.method_4711();
    }

    @ApiStatus.Internal
    public static void clearCache() {
        for (SpriteCache cache : SPRITE_CACHES.values()) {
            cache.clear();
        }
    }

    static {
        for (class_2350 direction : class_2350.values()) {
            SPRITE_CACHES.put(direction, new SpriteCache(direction));
        }
    }

    private static class SpriteCache {
        private final class_2350 face;
        private final Map<class_2680, class_1058> sprites = new Object2ObjectOpenHashMap();
        private final Supplier<Random> randomSupplier = new Supplier<Random>(){
            private final Random random = new Random();

            @Override
            public Random get() {
                this.random.setSeed(42L);
                return this.random;
            }
        };
        private final StampedLock lock = new StampedLock();

        public SpriteCache(class_2350 face) {
            this.face = face;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public class_1058 getSprite(class_2680 state) {
            class_1058 sprite;
            long readStamp = this.lock.readLock();
            try {
                sprite = this.sprites.get(state);
            }
            finally {
                this.lock.unlockRead(readStamp);
            }
            if (sprite == null) {
                long writeStamp = this.lock.writeLock();
                try {
                    sprite = SpriteCalculator.calculateSprite(state, this.face, this.randomSupplier);
                    this.sprites.put(state, sprite);
                }
                finally {
                    this.lock.unlockWrite(writeStamp);
                }
            }
            return sprite;
        }

        public void clear() {
            long writeStamp = this.lock.writeLock();
            try {
                this.sprites.clear();
            }
            finally {
                this.lock.unlockWrite(writeStamp);
            }
        }
    }
}

