/*
 * Decompiled with CFR 0.152.
 */
package me.pepperbell.continuity.client.processor.simple;

import java.util.Random;
import java.util.function.Supplier;
import me.pepperbell.continuity.api.client.ProcessingDataProvider;
import me.pepperbell.continuity.client.processor.ProcessingDataKeys;
import me.pepperbell.continuity.client.processor.Symmetry;
import me.pepperbell.continuity.client.processor.simple.FixedSpriteProvider;
import me.pepperbell.continuity.client.processor.simple.SpriteProvider;
import me.pepperbell.continuity.client.properties.RandomCTMProperties;
import me.pepperbell.continuity.client.util.MathUtil;
import me.pepperbell.continuity.client.util.RandomIndexProvider;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadView;
import net.minecraft.class_1058;
import net.minecraft.class_1920;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import org.jetbrains.annotations.Nullable;

public class RandomSpriteProvider
implements SpriteProvider {
    protected class_1058[] sprites;
    protected RandomIndexProvider indexProvider;
    protected int randomLoops;
    protected Symmetry symmetry;
    protected boolean linked;

    public RandomSpriteProvider(class_1058[] sprites, RandomIndexProvider indexProvider, int randomLoops, Symmetry symmetry, boolean linked) {
        this.sprites = sprites;
        this.indexProvider = indexProvider;
        this.randomLoops = randomLoops;
        this.symmetry = symmetry;
        this.linked = linked;
    }

    @Override
    @Nullable
    public class_1058 getSprite(QuadView quad, class_1058 sprite, class_1920 blockView, class_2680 state, class_2338 pos, Supplier<Random> randomSupplier, ProcessingDataProvider dataProvider) {
        class_2350 face = this.symmetry.getActualFace(quad.lightFace());
        int x = pos.method_10263();
        int y = pos.method_10264();
        int z = pos.method_10260();
        if (this.linked) {
            class_2248 block = state.method_26204();
            class_2338.class_2339 mutablePos = dataProvider.getData(ProcessingDataKeys.MUTABLE_POS_KEY).method_10101((class_2382)pos);
            int i = 0;
            do {
                mutablePos.method_33098(mutablePos.method_10264() - 1);
            } while (++i < 3 && block == blockView.method_8320((class_2338)mutablePos).method_26204());
            y = mutablePos.method_10264() + 1;
        }
        int seed = MathUtil.mix(x, y, z, face.ordinal(), this.randomLoops);
        return this.sprites[this.indexProvider.getRandomIndex(seed)];
    }

    public static class Factory
    implements SpriteProvider.Factory<RandomCTMProperties> {
        @Override
        public SpriteProvider createSpriteProvider(class_1058[] sprites, RandomCTMProperties properties) {
            if (sprites.length == 1) {
                return new FixedSpriteProvider(sprites[0]);
            }
            return new RandomSpriteProvider(sprites, properties.getIndexProviderFactory().createIndexProvider(sprites.length), properties.getRandomLoops(), properties.getSymmetry(), properties.getLinked());
        }

        @Override
        public int getTextureAmount(RandomCTMProperties properties) {
            return properties.getSpriteIds().size();
        }
    }
}

