/*
 * Decompiled with CFR 0.152.
 */
package me.lortseam.completeconfig.util;

import com.google.common.reflect.TypeToken;
import io.leangen.geantyref.GenericTypeReflector;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public final class ReflectionUtils {
    public static Class<?> getTypeClass(Type type) {
        return TypeToken.of((Type)type).getRawType();
    }

    public static Type getFieldType(Field field) {
        return GenericTypeReflector.getExactFieldType(field, field.getDeclaringClass());
    }

    public static <T> T instantiateClass(Class<T> clazz) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        Constructor<T> constructor = clazz.getDeclaredConstructor(new Class[0]);
        if (!constructor.canAccess(null)) {
            constructor.setAccessible(true);
        }
        return constructor.newInstance(new Object[0]);
    }

    public static Optional<Method> getSetterMethod(Field field, Object object) {
        Method method;
        try {
            method = field.getDeclaringClass().getDeclaredMethod("set" + StringUtils.capitalize((String)field.getName()), ReflectionUtils.getTypeClass(ReflectionUtils.getFieldType(field)));
        }
        catch (NoSuchMethodException ignore) {
            return Optional.empty();
        }
        if (Modifier.isStatic(field.getModifiers()) != Modifier.isStatic(method.getModifiers()) || !method.getReturnType().equals(Void.TYPE)) {
            return Optional.empty();
        }
        if (!method.canAccess(object)) {
            method.setAccessible(true);
        }
        return Optional.of(method);
    }

    public static Type boxType(Type type) {
        return GenericTypeReflector.box(type);
    }

    private ReflectionUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

