/*
 * Decompiled with CFR 0.152.
 */
package me.lortseam.completeconfig.gui.cloth;

import java.lang.reflect.Type;
import java.util.function.Predicate;
import me.lortseam.completeconfig.data.Entry;
import me.lortseam.completeconfig.gui.cloth.EntryBuilder;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.apache.commons.lang3.ArrayUtils;

@Environment(value=EnvType.CLIENT)
public final class GuiProvider {
    private final Predicate<Entry<?>> predicate;
    private final EntryBuilder<?> builder;

    public static <E extends Entry<?>> GuiProvider create(Class<E> entryType, EntryBuilder<? extends E> builder, Predicate<E> predicate, Type ... types) {
        return new GuiProvider(entry -> {
            if (entry.getClass() != (entryType != null ? entryType : Entry.class)) {
                return false;
            }
            if (types.length > 0 && !ArrayUtils.contains((Object[])types, (Object)entry.getType())) {
                return false;
            }
            return predicate.test(entry);
        }, builder);
    }

    public static <E extends Entry<?>> GuiProvider create(Class<E> entryType, EntryBuilder<? extends E> builder, Type ... types) {
        return GuiProvider.create(entryType, builder, (E entry) -> true, types);
    }

    public static GuiProvider create(EntryBuilder<?> builder, Predicate<Entry<?>> predicate, Type ... types) {
        return GuiProvider.create(null, builder, predicate, types);
    }

    public static GuiProvider create(EntryBuilder<?> builder, Type ... types) {
        if (types.length == 0) {
            throw new IllegalArgumentException("Types must not be empty");
        }
        return GuiProvider.create(builder, (Entry<?> entry) -> true, types);
    }

    boolean test(Entry<?> entry) {
        return this.predicate.test(entry);
    }

    private GuiProvider(Predicate<Entry<?>> predicate, EntryBuilder<?> builder) {
        this.predicate = predicate;
        this.builder = builder;
    }

    EntryBuilder<?> getBuilder() {
        return this.builder;
    }
}

