/*
 * Decompiled with CFR 0.152.
 */
package me.lortseam.completeconfig.gui.cloth;

import com.google.common.collect.Lists;
import com.google.common.collect.MoreCollectors;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Stream;
import lombok.NonNull;
import me.lortseam.completeconfig.CompleteConfig;
import me.lortseam.completeconfig.data.BooleanEntry;
import me.lortseam.completeconfig.data.BoundedEntry;
import me.lortseam.completeconfig.data.Cluster;
import me.lortseam.completeconfig.data.ColorEntry;
import me.lortseam.completeconfig.data.Config;
import me.lortseam.completeconfig.data.DropdownEntry;
import me.lortseam.completeconfig.data.Entry;
import me.lortseam.completeconfig.data.EnumEntry;
import me.lortseam.completeconfig.data.SliderEntry;
import me.lortseam.completeconfig.gui.ConfigScreenBuilder;
import me.lortseam.completeconfig.gui.cloth.GuiExtension;
import me.lortseam.completeconfig.gui.cloth.GuiProvider;
import me.lortseam.completeconfig.gui.cloth.GuiProviderRegistry;
import me.lortseam.completeconfig.text.TranslationKey;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import me.shedaniel.clothconfig2.impl.builders.DropdownMenuBuilder;
import me.shedaniel.clothconfig2.impl.builders.SubCategoryBuilder;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_437;
import net.minecraft.class_5348;

public final class ClothConfigScreenBuilder
extends ConfigScreenBuilder {
    private static final List<GuiProvider> globalProviders = Lists.newArrayList((Object[])new GuiProvider[]{GuiProvider.create(BooleanEntry.class, entry -> ConfigEntryBuilder.create().startBooleanToggle(entry.getText(), ((Boolean)entry.getValue()).booleanValue()).setDefaultValue(((Boolean)entry.getDefaultValue()).booleanValue()).setYesNoTextSupplier(entry.getValueTextSupplier()).setTooltip(entry.getTooltip()).setSaveConsumer(entry::setValue), new Type[]{Boolean.TYPE, Boolean.class}), GuiProvider.create(entry -> ConfigEntryBuilder.create().startIntField(entry.getText(), ((Integer)entry.getValue()).intValue()).setDefaultValue(((Integer)entry.getDefaultValue()).intValue()).setTooltip(entry.getTooltip()).setSaveConsumer(entry::setValue), new Type[]{Integer.TYPE, Integer.class}), GuiProvider.create(BoundedEntry.class, entry -> ConfigEntryBuilder.create().startIntField(entry.getText(), ((Integer)entry.getValue()).intValue()).setDefaultValue(((Integer)entry.getDefaultValue()).intValue()).setMin(((Integer)entry.getMin()).intValue()).setMax(((Integer)entry.getMax()).intValue()).setTooltip(entry.getTooltip()).setSaveConsumer(entry::setValue), new Type[]{Integer.TYPE, Integer.class}), GuiProvider.create(SliderEntry.class, entry -> ConfigEntryBuilder.create().startIntSlider(entry.getText(), ((Integer)entry.getValue()).intValue(), ((Integer)entry.getMin()).intValue(), ((Integer)entry.getMax()).intValue()).setDefaultValue(((Integer)entry.getDefaultValue()).intValue()).setTextGetter(entry.getValueTextSupplier()).setTooltip(entry.getTooltip()).setSaveConsumer(entry::setValue), new Type[]{Integer.TYPE, Integer.class}), GuiProvider.create(ColorEntry.class, entry -> ConfigEntryBuilder.create().startColorField(entry.getText(), ((Integer)entry.getValue()).intValue()).setDefaultValue(((Integer)entry.getDefaultValue()).intValue()).setAlphaMode(entry.isAlphaMode()).setTooltip(entry.getTooltip()).setSaveConsumer(entry::setValue), new Type[]{Integer.TYPE, Integer.class}), GuiProvider.create(entry -> ConfigEntryBuilder.create().startLongField(entry.getText(), ((Long)entry.getValue()).longValue()).setDefaultValue(((Long)entry.getDefaultValue()).longValue()).setTooltip(entry.getTooltip()).setSaveConsumer(entry::setValue), new Type[]{Long.TYPE, Long.class}), GuiProvider.create(BoundedEntry.class, entry -> ConfigEntryBuilder.create().startLongField(entry.getText(), ((Long)entry.getValue()).longValue()).setDefaultValue(((Long)entry.getDefaultValue()).longValue()).setMin(((Long)entry.getMin()).longValue()).setMax(((Long)entry.getMax()).longValue()).setTooltip(entry.getTooltip()).setSaveConsumer(entry::setValue), new Type[]{Long.TYPE, Long.class}), GuiProvider.create(SliderEntry.class, entry -> ConfigEntryBuilder.create().startLongSlider(entry.getText(), ((Long)entry.getValue()).longValue(), ((Long)entry.getMin()).longValue(), ((Long)entry.getMax()).longValue()).setDefaultValue(((Long)entry.getDefaultValue()).longValue()).setTextGetter(entry.getValueTextSupplier()).setTooltip(entry.getTooltip()).setSaveConsumer(entry::setValue), new Type[]{Long.TYPE, Long.class}), GuiProvider.create(entry -> ConfigEntryBuilder.create().startFloatField(entry.getText(), ((Float)entry.getValue()).floatValue()).setDefaultValue(((Float)entry.getDefaultValue()).floatValue()).setTooltip(entry.getTooltip()).setSaveConsumer(entry::setValue), new Type[]{Float.TYPE, Float.class}), GuiProvider.create(BoundedEntry.class, entry -> ConfigEntryBuilder.create().startFloatField(entry.getText(), ((Float)entry.getValue()).floatValue()).setDefaultValue(((Float)entry.getDefaultValue()).floatValue()).setMin(((Float)entry.getMin()).floatValue()).setMax(((Float)entry.getMax()).floatValue()).setTooltip(entry.getTooltip()).setSaveConsumer(entry::setValue), new Type[]{Float.TYPE, Float.class}), GuiProvider.create(entry -> ConfigEntryBuilder.create().startDoubleField(entry.getText(), ((Double)entry.getValue()).doubleValue()).setDefaultValue(((Double)entry.getDefaultValue()).doubleValue()).setTooltip(entry.getTooltip()).setSaveConsumer(entry::setValue), new Type[]{Double.TYPE, Double.class}), GuiProvider.create(BoundedEntry.class, entry -> ConfigEntryBuilder.create().startDoubleField(entry.getText(), ((Double)entry.getValue()).doubleValue()).setDefaultValue(((Double)entry.getDefaultValue()).doubleValue()).setMin(((Double)entry.getMin()).doubleValue()).setMax(((Double)entry.getMax()).doubleValue()).setTooltip(entry.getTooltip()).setSaveConsumer(entry::setValue), new Type[]{Double.TYPE, Double.class}), GuiProvider.create(entry -> ConfigEntryBuilder.create().startStrField(entry.getText(), (String)entry.getValue()).setDefaultValue((String)entry.getDefaultValue()).setTooltip(entry.getTooltip()).setSaveConsumer(entry::setValue), new Type[]{String.class}), GuiProvider.create(EnumEntry.class, entry -> ConfigEntryBuilder.create().startEnumSelector(entry.getText(), entry.getTypeClass(), (Enum)entry.getValue()).setDefaultValue((Enum)entry.getDefaultValue()).setTooltip(entry.getTooltip()).setEnumNameProvider(entry.getValueTextSupplier()).setSaveConsumer(entry::setValue), new Type[0]), GuiProvider.create(DropdownEntry.class, entry -> {
        List<Enum> enumValues = Arrays.asList((Enum[])entry.getTypeClass().getEnumConstants());
        return ConfigEntryBuilder.create().startDropdownMenu(entry.getText(), DropdownMenuBuilder.TopCellElementBuilder.of((Object)((Enum)entry.getValue()), enumTranslation -> ((Optional)enumValues.stream().filter(enumValue -> entry.getValueTextSupplier().apply((Enum)enumValue).getString().equals(enumTranslation)).collect(MoreCollectors.toOptional())).orElse(null), entry.getValueTextSupplier()), DropdownMenuBuilder.CellCreatorBuilder.of(entry.getValueTextSupplier())).setSelections(enumValues).setSuggestionMode(entry.isSuggestionMode()).setDefaultValue((Object)((Enum)entry.getDefaultValue())).setSaveConsumer(entry::setValue);
    }, new Type[0]), GuiProvider.create(entry -> ConfigEntryBuilder.create().startIntList(entry.getText(), (List)entry.getValue()).setDefaultValue((List)entry.getDefaultValue()).setTooltip(entry.getTooltip()).setSaveConsumer(entry::setValue), new TypeToken<List<Integer>>(){}.getType()), GuiProvider.create(entry -> ConfigEntryBuilder.create().startIntList(entry.getText(), Arrays.asList((Integer[])entry.getValue())).setDefaultValue(Arrays.asList((Integer[])entry.getDefaultValue())).setTooltip(entry.getTooltip()).setSaveConsumer(list -> entry.setValue(list.toArray(new Integer[0]))), new Type[]{int[].class, Integer[].class}), GuiProvider.create(entry -> ConfigEntryBuilder.create().startLongList(entry.getText(), (List)entry.getValue()).setDefaultValue((List)entry.getDefaultValue()).setTooltip(entry.getTooltip()).setSaveConsumer(entry::setValue), new TypeToken<List<Long>>(){}.getType()), GuiProvider.create(entry -> ConfigEntryBuilder.create().startLongList(entry.getText(), Arrays.asList((Long[])entry.getValue())).setDefaultValue(Arrays.asList((Long[])entry.getDefaultValue())).setTooltip(entry.getTooltip()).setSaveConsumer(list -> entry.setValue(list.toArray(new Long[0]))), new Type[]{long[].class, Long[].class}), GuiProvider.create(entry -> ConfigEntryBuilder.create().startFloatList(entry.getText(), (List)entry.getValue()).setDefaultValue((List)entry.getDefaultValue()).setTooltip(entry.getTooltip()).setSaveConsumer(entry::setValue), new TypeToken<List<Float>>(){}.getType()), GuiProvider.create(entry -> ConfigEntryBuilder.create().startFloatList(entry.getText(), Arrays.asList((Float[])entry.getValue())).setDefaultValue(Arrays.asList((Float[])entry.getDefaultValue())).setTooltip(entry.getTooltip()).setSaveConsumer(list -> entry.setValue(list.toArray(new Float[0]))), new Type[]{float[].class, Float[].class}), GuiProvider.create(entry -> ConfigEntryBuilder.create().startDoubleList(entry.getText(), (List)entry.getValue()).setDefaultValue((List)entry.getDefaultValue()).setTooltip(entry.getTooltip()).setSaveConsumer(entry::setValue), new TypeToken<List<Double>>(){}.getType()), GuiProvider.create(entry -> ConfigEntryBuilder.create().startDoubleList(entry.getText(), Arrays.asList((Double[])entry.getValue())).setDefaultValue(Arrays.asList((Double[])entry.getDefaultValue())).setTooltip(entry.getTooltip()).setSaveConsumer(list -> entry.setValue(list.toArray(new Double[0]))), new Type[]{double[].class, Double[].class}), GuiProvider.create(entry -> ConfigEntryBuilder.create().startStrList(entry.getText(), (List)entry.getValue()).setDefaultValue((List)entry.getDefaultValue()).setTooltip(entry.getTooltip()).setSaveConsumer(entry::setValue), new TypeToken<List<String>>(){}.getType()), GuiProvider.create(entry -> ConfigEntryBuilder.create().startStrList(entry.getText(), Arrays.asList((String[])entry.getValue())).setDefaultValue(Arrays.asList((String[])entry.getDefaultValue())).setTooltip(entry.getTooltip()).setSaveConsumer(list -> entry.setValue(list.toArray(new String[0]))), new Type[]{String[].class})});
    private final Supplier<ConfigBuilder> supplier;
    private final GuiProviderRegistry registry = new GuiProviderRegistry(this);
    private final List<GuiProvider> providers = new ArrayList<GuiProvider>();

    public ClothConfigScreenBuilder(@NonNull Supplier<ConfigBuilder> supplier) {
        if (supplier == null) {
            throw new NullPointerException("supplier is marked non-null but is null");
        }
        this.supplier = supplier;
    }

    public ClothConfigScreenBuilder() {
        this(ConfigBuilder::create);
    }

    public void register(GuiProvider ... providers) {
        Collections.addAll(this.providers, providers);
    }

    @Override
    public class_437 build(class_437 parentScreen, Config config) {
        ConfigBuilder builder = this.supplier.get().setParentScreen(parentScreen).setSavingRunnable(config::save);
        TranslationKey customTitle = config.getTranslation(true).append("title");
        builder.setTitle((class_2561)(customTitle.exists() ? customTitle.toText(new Object[0]) : new class_2588("completeconfig.gui.defaultTitle", new Object[]{config.getMod().getName()})));
        if (!config.getEntries().isEmpty()) {
            ConfigCategory category = builder.getOrCreateCategory(config.getText());
            for (Entry entry : config.getEntries()) {
                category.addEntry(this.buildEntry(entry));
            }
        }
        for (Cluster cluster : config.getClusters()) {
            ConfigCategory category = builder.getOrCreateCategory(cluster.getText());
            category.setDescription(() -> cluster.getTooltip().map(lines -> (class_5348[])Arrays.stream(lines).map(line -> line).toArray(class_5348[]::new)));
            for (AbstractConfigListEntry entry : this.buildCluster(cluster)) {
                category.addEntry(entry);
            }
        }
        return builder.build();
    }

    private AbstractConfigListEntry<?> buildEntry(Entry<?> entry) {
        return Stream.of(this.providers, globalProviders).flatMap(Collection::stream).filter(provider -> provider.test(entry)).findFirst().map(provider -> provider.getBuilder()).orElseThrow(() -> new UnsupportedOperationException("Could not generate GUI for entry " + entry)).build(entry);
    }

    private List<AbstractConfigListEntry> buildCluster(Cluster cluster) {
        ArrayList<AbstractConfigListEntry> clusterGui = new ArrayList<AbstractConfigListEntry>();
        for (Entry entry : cluster.getEntries()) {
            clusterGui.add(this.buildEntry(entry));
        }
        for (Cluster subCluster : cluster.getClusters()) {
            SubCategoryBuilder subBuilder = ConfigEntryBuilder.create().startSubCategory(subCluster.getText()).setTooltip(subCluster.getTooltip());
            subBuilder.addAll(this.buildCluster(subCluster));
            clusterGui.add((AbstractConfigListEntry)subBuilder.build());
        }
        return clusterGui;
    }

    @Deprecated
    public GuiProviderRegistry getRegistry() {
        return this.registry;
    }

    static {
        for (GuiProvider[] providers : CompleteConfig.collectExtensions(GuiExtension.class, GuiExtension::getProviders)) {
            globalProviders.addAll(Arrays.asList(providers));
        }
    }
}

