/*
 * Decompiled with CFR 0.152.
 */
package me.lortseam.completeconfig.data.transform;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import me.lortseam.completeconfig.api.ConfigEntry;
import me.lortseam.completeconfig.data.BooleanEntry;
import me.lortseam.completeconfig.data.BoundedEntry;
import me.lortseam.completeconfig.data.ColorEntry;
import me.lortseam.completeconfig.data.DropdownEntry;
import me.lortseam.completeconfig.data.EntryOrigin;
import me.lortseam.completeconfig.data.EnumEntry;
import me.lortseam.completeconfig.data.SliderEntry;
import me.lortseam.completeconfig.data.transform.Transformer;
import me.lortseam.completeconfig.util.ReflectionUtils;
import org.apache.commons.lang3.ArrayUtils;

public final class Transformation {
    private static final Set<Class<? extends Annotation>> registeredAnnotations = new HashSet<Class<? extends Annotation>>();
    public static final Transformation[] DEFAULTS = new Transformation[]{Transformation.builder().byType(new Type[]{Boolean.TYPE, Boolean.class}).byAnnotation(ConfigEntry.Boolean.class, true).transforms(BooleanEntry::new), Transformation.builder().byType(new Type[]{Integer.TYPE, Integer.class}).byAnnotation(ConfigEntry.BoundedInteger.class).transforms(origin -> {
        ConfigEntry.BoundedInteger bounds = origin.getAnnotation(ConfigEntry.BoundedInteger.class);
        return new BoundedEntry<Integer>(origin, bounds.min(), bounds.max());
    }), Transformation.builder().byType(new Type[]{Integer.TYPE, Integer.class}).byAnnotation(Arrays.asList(ConfigEntry.BoundedInteger.class, ConfigEntry.Slider.class)).transforms(origin -> {
        ConfigEntry.BoundedInteger bounds = origin.getAnnotation(ConfigEntry.BoundedInteger.class);
        return new SliderEntry<Integer>(origin, bounds.min(), bounds.max());
    }), Transformation.builder().byType(new Type[]{Long.TYPE, Long.class}).byAnnotation(ConfigEntry.BoundedLong.class).transforms(origin -> {
        ConfigEntry.BoundedLong bounds = origin.getAnnotation(ConfigEntry.BoundedLong.class);
        return new BoundedEntry<Long>(origin, bounds.min(), bounds.max());
    }), Transformation.builder().byType(new Type[]{Long.TYPE, Long.class}).byAnnotation(Arrays.asList(ConfigEntry.BoundedLong.class, ConfigEntry.Slider.class)).transforms(origin -> {
        ConfigEntry.BoundedLong bounds = origin.getAnnotation(ConfigEntry.BoundedLong.class);
        return new SliderEntry<Long>(origin, bounds.min(), bounds.max());
    }), Transformation.builder().byType(new Type[]{Float.TYPE, Float.class}).byAnnotation(ConfigEntry.BoundedFloat.class).transforms(origin -> {
        ConfigEntry.BoundedFloat bounds = origin.getAnnotation(ConfigEntry.BoundedFloat.class);
        return new BoundedEntry<Float>(origin, Float.valueOf(bounds.min()), Float.valueOf(bounds.max()));
    }), Transformation.builder().byType(new Type[]{Double.TYPE, Double.class}).byAnnotation(ConfigEntry.BoundedDouble.class).transforms(origin -> {
        ConfigEntry.BoundedDouble bounds = origin.getAnnotation(ConfigEntry.BoundedDouble.class);
        return new BoundedEntry<Double>(origin, bounds.min(), bounds.max());
    }), Transformation.builder().byType(type -> Enum.class.isAssignableFrom(ReflectionUtils.getTypeClass(type))).transforms(EnumEntry::new), Transformation.builder().byType(type -> Enum.class.isAssignableFrom(ReflectionUtils.getTypeClass(type))).byAnnotation(ConfigEntry.Dropdown.class).transforms(DropdownEntry::new), Transformation.builder().byAnnotation(ConfigEntry.Color.class).transforms(origin -> new ColorEntry(origin, origin.getAnnotation(ConfigEntry.Color.class).alphaMode()))};
    private final Predicate<EntryOrigin> predicate;
    private final Transformer transformer;

    public static Builder builder() {
        return new Builder();
    }

    public boolean test(EntryOrigin origin) {
        return this.predicate.test(origin);
    }

    private Transformation(Predicate<EntryOrigin> predicate, Transformer transformer) {
        this.predicate = predicate;
        this.transformer = transformer;
    }

    public Transformer getTransformer() {
        return this.transformer;
    }

    public static class Builder {
        private Predicate<EntryOrigin> predicate;
        private final Set<Class<? extends Annotation>> requiredAnnotations = new HashSet<Class<? extends Annotation>>();
        private final Set<Class<? extends Annotation>> optionalAnnotations = new HashSet<Class<? extends Annotation>>();

        private Builder by(Predicate<EntryOrigin> predicate) {
            this.predicate = this.predicate == null ? predicate : this.predicate.and(predicate);
            return this;
        }

        public Builder byType(Type ... types) {
            return this.byType((Type type) -> ArrayUtils.contains((Object[])types, (Object)type));
        }

        public Builder byType(Predicate<Type> typePredicate) {
            return this.by(origin -> typePredicate.test(origin.getType()));
        }

        public Builder byAnnotation(Class<? extends Annotation> annotation, boolean optional) {
            registeredAnnotations.add(annotation);
            (optional ? this.optionalAnnotations : this.requiredAnnotations).add(annotation);
            return this;
        }

        public Builder byAnnotation(Class<? extends Annotation> annotation) {
            return this.byAnnotation(annotation, false);
        }

        public Builder byAnnotation(Iterable<Class<? extends Annotation>> annotations) {
            for (Class<? extends Annotation> annotation : annotations) {
                this.byAnnotation(annotation);
            }
            return this;
        }

        public Transformation transforms(Transformer transformer) {
            if (this.predicate == null && this.requiredAnnotations.isEmpty()) {
                throw new IllegalStateException("Missing transformation filter");
            }
            this.by(origin -> {
                Set declaredAnnotations = Arrays.stream(origin.getField().getDeclaredAnnotations()).map(Annotation::annotationType).filter(registeredAnnotations::contains).collect(Collectors.toSet());
                for (Class<? extends Annotation> requiredAnnotation : this.requiredAnnotations) {
                    if (declaredAnnotations.remove(requiredAnnotation)) continue;
                    return false;
                }
                return this.optionalAnnotations.containsAll(declaredAnnotations);
            });
            return new Transformation(this.predicate, transformer);
        }

        private Builder() {
        }
    }
}

