/*
 * Decompiled with CFR 0.152.
 */
package me.lortseam.completeconfig.data;

import java.util.Arrays;
import me.lortseam.completeconfig.api.ConfigGroup;
import me.lortseam.completeconfig.data.Config;
import me.lortseam.completeconfig.data.Parent;
import me.lortseam.completeconfig.data.structure.Identifiable;
import me.lortseam.completeconfig.data.structure.client.TooltipSupplier;
import me.lortseam.completeconfig.text.TranslationKey;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.spongepowered.configurate.CommentedConfigurationNode;

public final class Cluster
extends Parent
implements Identifiable,
TooltipSupplier {
    private final Parent parent;
    private final ConfigGroup group;
    @Environment(value=EnvType.CLIENT)
    private TranslationKey translation;
    @Environment(value=EnvType.CLIENT)
    private TranslationKey[] tooltipTranslation;

    @Override
    Config getRoot() {
        return this.parent.getRoot();
    }

    @Override
    public TranslationKey getTranslation() {
        if (this.translation == null) {
            this.translation = this.parent.getTranslation().append(this.group.getId());
        }
        return this.translation;
    }

    @Override
    public TranslationKey[] getTooltipTranslation() {
        if (this.tooltipTranslation == null) {
            this.tooltipTranslation = ArrayUtils.isNotEmpty((Object[])this.group.getTooltipTranslationKeys()) ? (TranslationKey[])Arrays.stream(this.group.getTooltipTranslationKeys()).map(key -> this.getTranslation().root().append((String)key)).toArray(TranslationKey[]::new) : this.getTranslation().appendTooltip().orElse(new TranslationKey[0]);
        }
        return this.tooltipTranslation;
    }

    @Override
    public void fetch(CommentedConfigurationNode node) {
        if (!StringUtils.isEmpty((CharSequence)this.group.getComment())) {
            node.comment(this.group.getComment());
        }
        super.fetch(node);
    }

    @Override
    public String getId() {
        return this.group.getId();
    }

    Cluster(Parent parent, ConfigGroup group) {
        this.parent = parent;
        this.group = group;
    }
}

