/*
 * Decompiled with CFR 0.152.
 */
package me.lortseam.completeconfig.api;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.Collections;

public interface ConfigContainer {
    default public Iterable<Class<? extends ConfigContainer>> getConfigClasses() {
        ArrayList<Class<? extends ConfigContainer>> classes = new ArrayList<Class<? extends ConfigContainer>>();
        for (Class<?> clazz = this.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            classes.add(clazz);
            if (!ConfigContainer.class.isAssignableFrom(clazz.getSuperclass())) break;
        }
        Collections.reverse(classes);
        return classes;
    }

    default public ConfigContainer[] getTransitives() {
        return new ConfigContainer[0];
    }

    default public void onUpdate() {
    }

    @Target(value={ElementType.FIELD, ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Transitive {
    }
}

