/*
 * Decompiled with CFR 0.152.
 */
package me.lortseam.completeconfig;

import com.google.common.collect.Sets;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.NonNull;
import me.lortseam.completeconfig.Extension;
import me.lortseam.completeconfig.data.extension.BaseExtension;
import me.lortseam.completeconfig.data.extension.ClientExtension;
import me.lortseam.completeconfig.data.extension.ServerExtension;
import me.lortseam.completeconfig.extensions.clothbasicmath.ClothBasicMathExtension;
import me.lortseam.completeconfig.extensions.clothconfig.ClothConfigExtension;
import me.lortseam.completeconfig.extensions.minecraft.MinecraftExtension;
import me.lortseam.completeconfig.gui.cloth.GuiExtension;
import me.lortseam.completeconfig.util.ReflectionUtils;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.entrypoint.EntrypointContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CompleteConfig {
    private static final Logger logger = LoggerFactory.getLogger((String)"CompleteConfig");
    private static final Set<Class<? extends Extension>> validExtensionTypes = Sets.newHashSet((Object[])new Class[]{BaseExtension.class});
    private static final Set<Extension> extensions = new HashSet<Extension>();

    public static void registerExtensionType(@NonNull Class<? extends Extension> extensionType, EnvType environment, String ... mods) {
        if (extensionType == null) {
            throw new NullPointerException("extensionType is marked non-null but is null");
        }
        if (validExtensionTypes.contains(extensionType)) {
            return;
        }
        if (environment != null && FabricLoader.getInstance().getEnvironmentType() != environment || Arrays.stream(mods).anyMatch(modId -> !FabricLoader.getInstance().isModLoaded(Objects.requireNonNull(modId)))) {
            return;
        }
        validExtensionTypes.add(extensionType);
    }

    public static void registerExtensionType(@NonNull Class<? extends Extension> extensionType, String ... mods) {
        if (extensionType == null) {
            throw new NullPointerException("extensionType is marked non-null but is null");
        }
        CompleteConfig.registerExtensionType(extensionType, null, mods);
    }

    private static void registerExtension(Extension extension) {
        extensions.add(extension);
        Set<Class<? extends Extension>> children = extension.children();
        if (children == null) {
            return;
        }
        for (Class<? extends Extension> child : children) {
            CompleteConfig.registerExtension(child);
        }
    }

    private static void registerExtension(Class<? extends Extension> extension) {
        if (!validExtensionTypes.containsAll(Arrays.asList(extension.getInterfaces()))) {
            return;
        }
        try {
            CompleteConfig.registerExtension(ReflectionUtils.instantiateClass(extension));
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            logger.error("Failed to instantiate extension " + extension, (Throwable)e);
        }
    }

    public static void registerExtension(@NonNull String modId, @NonNull Class<? extends Extension> extension) {
        if (modId == null) {
            throw new NullPointerException("modId is marked non-null but is null");
        }
        if (extension == null) {
            throw new NullPointerException("extension is marked non-null but is null");
        }
        if (!FabricLoader.getInstance().isModLoaded(modId)) {
            return;
        }
        CompleteConfig.registerExtension(extension);
    }

    public static <E extends Extension, T> Collection<T> collectExtensions(Class<E> extensionType, Function<E, T> function) {
        return extensions.stream().filter(extensionType::isInstance).map(extension -> function.apply(extension)).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    private CompleteConfig() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        CompleteConfig.registerExtensionType(ClientExtension.class, EnvType.CLIENT, new String[0]);
        CompleteConfig.registerExtensionType(ServerExtension.class, EnvType.SERVER, new String[0]);
        CompleteConfig.registerExtensionType(GuiExtension.class, EnvType.CLIENT, "cloth-config");
        CompleteConfig.registerExtension(MinecraftExtension.class);
        CompleteConfig.registerExtension("cloth-basic-math", ClothBasicMathExtension.class);
        CompleteConfig.registerExtension("cloth-config", ClothConfigExtension.class);
        for (EntrypointContainer entrypoint : FabricLoader.getInstance().getEntrypointContainers("completeconfig-extension", BaseExtension.class)) {
            CompleteConfig.registerExtension((Extension)entrypoint.getEntrypoint());
        }
    }
}

