/*
 * Decompiled with CFR 0.152.
 */
package de.johni0702.minecraft.bobby.commands;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.context.CommandContext;
import de.johni0702.minecraft.bobby.FakeChunkManager;
import de.johni0702.minecraft.bobby.FakeChunkStorage;
import de.johni0702.minecraft.bobby.ext.ClientChunkManagerExt;
import java.io.IOException;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.function.BiConsumer;
import net.fabricmc.fabric.api.client.command.v1.FabricClientCommandSource;
import net.minecraft.class_156;
import net.minecraft.class_1937;
import net.minecraft.class_2164;
import net.minecraft.class_2556;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_5321;
import net.minecraft.class_638;

public class UpgradeCommand
implements Command<FabricClientCommandSource> {
    public int run(CommandContext<FabricClientCommandSource> context) {
        FabricClientCommandSource source = (FabricClientCommandSource)context.getSource();
        class_310 client = source.getClient();
        class_638 world = source.getWorld();
        FakeChunkManager bobbyChunkManager = ((ClientChunkManagerExt)world.method_2935()).bobby_getFakeChunkManager();
        if (bobbyChunkManager == null) {
            throw new class_2164((class_2561)new class_2588("bobby.upgrade.not_enabled"));
        }
        FakeChunkStorage storage = bobbyChunkManager.getStorage();
        source.sendFeedback((class_2561)new class_2588("bobby.upgrade.begin"));
        new Thread(() -> {
            try {
                storage.upgrade((class_5321<class_1937>)world.method_27983(), new ProgressReported(client));
            }
            catch (IOException e) {
                e.printStackTrace();
                source.sendError(class_2561.method_30163((String)e.getMessage()));
            }
            client.method_20493(() -> {
                source.sendFeedback((class_2561)new class_2588("bobby.upgrade.done"));
                bobbyChunkManager.loadMissingChunksFromCache();
            });
        }, "bobby-upgrade").start();
        return 0;
    }

    private static class ProgressReported
    implements BiConsumer<Integer, Integer> {
        private final class_310 client;
        private Instant nextReport = Instant.MIN;
        private int done;
        private int total = Integer.MAX_VALUE;

        public ProgressReported(class_310 client) {
            this.client = client;
        }

        @Override
        public synchronized void accept(Integer done, Integer total) {
            this.done = Math.max(this.done, done);
            this.total = Math.min(this.total, total);
            Instant now = Instant.now();
            if (now.isAfter(this.nextReport)) {
                this.nextReport = now.plus(3L, ChronoUnit.SECONDS);
                class_2588 text = new class_2588("bobby.upgrade.progress", new Object[]{this.done, this.total});
                this.client.method_20493(() -> this.client.field_1705.method_1755(class_2556.field_11735, (class_2561)text, class_156.field_25140));
            }
        }
    }
}

