/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.utils.ui;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.Objects;
import java.util.Stack;
import net.minecraft.class_1058;
import net.minecraft.class_1158;
import net.minecraft.class_1159;
import net.minecraft.class_1160;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_2585;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_757;
import net.minecraft.class_898;
import org.figuramc.figura.FiguraMod;
import org.figuramc.figura.avatar.Avatar;
import org.figuramc.figura.avatar.AvatarManager;
import org.figuramc.figura.avatar.Badges;
import org.figuramc.figura.config.Configs;
import org.figuramc.figura.gui.screens.AbstractPanelScreen;
import org.figuramc.figura.gui.screens.FiguraConfirmScreen;
import org.figuramc.figura.gui.widgets.ContextMenu;
import org.figuramc.figura.gui.widgets.FiguraWidget;
import org.figuramc.figura.math.vector.FiguraVec4;
import org.figuramc.figura.model.rendering.EntityRenderMode;
import org.figuramc.figura.utils.FiguraIdentifier;
import org.figuramc.figura.utils.RenderUtils;
import org.figuramc.figura.utils.TextUtils;
import org.figuramc.figura.utils.ui.CustomFramebuffer;
import org.lwjgl.opengl.GL30;

public class UIHelper
extends class_332 {
    public static final class_2960 OUTLINE_FILL = new FiguraIdentifier("textures/gui/outline_fill.png");
    public static final class_2960 OUTLINE = new FiguraIdentifier("textures/gui/outline.png");
    public static final class_2960 TOOLTIP = new FiguraIdentifier("textures/gui/tooltip.png");
    public static final class_2960 UI_FONT = new FiguraIdentifier("ui");
    public static final class_2960 SPECIAL_FONT = new FiguraIdentifier("special");
    public static final class_2561 UP_ARROW = new class_2585("^").method_27696(class_2583.field_24360.method_27704(UI_FONT));
    public static final class_2561 DOWN_ARROW = new class_2585("V").method_27696(class_2583.field_24360.method_27704(UI_FONT));
    private static final CustomFramebuffer FIGURA_FRAMEBUFFER = new CustomFramebuffer();
    private static int previousFBO = -1;
    public static boolean paperdoll = false;
    public static float fireRot = 0.0f;
    public static float dollScale = 1.0f;
    private static final Stack<FiguraVec4> SCISSORS_STACK = new Stack();

    public static void useFiguraGuiFramebuffer() {
        previousFBO = GL30.glGetInteger((int)36006);
        int width = class_310.method_1551().method_22683().method_4489();
        int height = class_310.method_1551().method_22683().method_4506();
        FIGURA_FRAMEBUFFER.setSize(width, height);
        GL30.glEnable((int)2960);
        GlStateManager._stencilMask((int)255);
        GlStateManager._glBindFramebuffer((int)36160, (int)FIGURA_FRAMEBUFFER.getFbo());
        GlStateManager._clearStencil((int)0);
        GlStateManager._clearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager._clearDepth((double)1.0);
        GlStateManager._clear((int)17664, (boolean)false);
        class_1159 mf = RenderSystem.getProjectionMatrix();
        class_310.method_1551().method_1522().method_22594(width, height, false);
        RenderSystem.setProjectionMatrix((class_1159)mf);
    }

    public static void useVanillaFramebuffer() {
        GlStateManager._enableDepthTest();
        GlStateManager._stencilFunc((int)514, (int)0, (int)255);
        GL30.glDisable((int)2960);
        GlStateManager._glBindFramebuffer((int)36009, (int)previousFBO);
        RenderSystem.disableBlend();
        int windowWidth = class_310.method_1551().method_22683().method_4489();
        int windowHeight = class_310.method_1551().method_22683().method_4506();
        class_1159 mf = RenderSystem.getProjectionMatrix();
        FIGURA_FRAMEBUFFER.drawToScreen(windowWidth, windowHeight);
        RenderSystem.setProjectionMatrix((class_1159)mf);
        RenderSystem.enableBlend();
    }

    public static void drawEntity(float x, float y, float scale, float pitch, float yaw, class_1309 entity, class_4587 stack, EntityRenderMode renderMode) {
        float yRot;
        float xRot;
        float headX = entity.method_36455();
        float headY = entity.field_6241;
        boolean invisible = entity.method_5767();
        float bodyY = entity.field_6283;
        class_1297 class_12972 = entity.method_5854();
        if (class_12972 instanceof class_1309) {
            class_1309 l = (class_1309)class_12972;
            bodyY = l.field_6283;
        }
        double xPos = 0.0;
        double yPos = 0.0;
        switch (renderMode) {
            case PAPERDOLL: {
                xRot = pitch;
                yRot = yaw + bodyY + 180.0f;
                yPos -= 1.0;
                if (entity.method_6128()) {
                    xPos += (double)class_3532.method_24504((float)((float)Math.toRadians(270.0)), (float)((float)Math.PI * 2));
                }
                if (entity.method_6123() || entity.method_20232() || entity.method_6128()) {
                    yPos += 1.0;
                    entity.method_36457(0.0f);
                }
                class_308.method_34742();
                if (!((Boolean)Configs.PAPERDOLL_INVISIBLE.value).booleanValue()) break;
                entity.method_5648(false);
                break;
            }
            case FIGURA_GUI: {
                xRot = pitch;
                yRot = yaw + bodyY + 180.0f;
                if (!((Boolean)Configs.PREVIEW_HEAD_ROTATION.value).booleanValue()) {
                    entity.method_36457(0.0f);
                    entity.field_6241 = bodyY;
                }
                yPos -= 1.0;
                class_308.method_24210();
                RenderSystem.setShaderLights((class_1160)((class_1160)class_156.method_654((Object)new class_1160(-0.2f, -1.0f, -1.0f), class_1160::method_4952)), (class_1160)((class_1160)class_156.method_654((Object)new class_1160(-0.2f, 0.4f, -0.3f), class_1160::method_4952)));
                entity.method_5648(false);
                break;
            }
            default: {
                xRot = pitch;
                yRot = yaw + bodyY + 180.0f;
                entity.method_36457(-xRot);
                entity.field_6241 = -yaw + bodyY;
                class_308.method_34742();
            }
        }
        stack.method_22903();
        stack.method_22904((double)x, (double)y, renderMode == EntityRenderMode.MINECRAFT_GUI ? 250.0 : -250.0);
        stack.method_22905(scale, scale, scale);
        stack.method_23760().method_23761().method_22672(class_1159.method_24019((float)1.0f, (float)1.0f, (float)-1.0f));
        Avatar avatar = AvatarManager.getAvatar((class_1297)entity);
        if (RenderUtils.vanillaModelAndScript(avatar) && !avatar.luaRuntime.renderer.getRootRotationAllowed().booleanValue()) {
            yRot = yaw;
        }
        class_1158 quaternion = class_1160.field_20707.method_23214(180.0f);
        class_1158 quaternion2 = class_1160.field_20705.method_23214(yRot);
        class_1158 quaternion3 = class_1160.field_20703.method_23214(xRot);
        quaternion3.method_4925(quaternion2);
        quaternion.method_4925(quaternion3);
        stack.method_22907(quaternion);
        quaternion3.method_4926();
        class_310 minecraft = class_310.method_1551();
        class_898 dispatcher = minecraft.method_1561();
        boolean renderHitboxes = dispatcher.method_3958();
        dispatcher.method_3955(false);
        dispatcher.method_3948(false);
        dispatcher.method_24196(quaternion3);
        class_4597.class_4598 immediate = minecraft.method_22940().method_23000();
        paperdoll = true;
        fireRot = -yRot;
        dollScale = scale;
        if (avatar != null) {
            avatar.renderMode = renderMode;
        }
        double finalXPos = xPos;
        double finalYPos = yPos;
        RenderSystem.runAsFancy(() -> dispatcher.method_3954((class_1297)entity, finalXPos, finalYPos, 0.0, 0.0f, 1.0f, stack, (class_4597)immediate, 0xF000F0));
        immediate.method_22993();
        paperdoll = false;
        dispatcher.method_3955(renderHitboxes);
        dispatcher.method_3948(true);
        stack.method_22909();
        class_308.method_24211();
        entity.method_36457(headX);
        entity.field_6241 = headY;
        entity.method_5648(invisible);
    }

    public static void setupTexture(class_2960 texture) {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShaderTexture((int)0, (class_2960)texture);
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void renderTexture(class_4587 stack, int x, int y, int width, int height, class_2960 texture) {
        UIHelper.setupTexture(texture);
        UIHelper.method_25293((class_4587)stack, (int)x, (int)y, (int)width, (int)height, (float)0.0f, (float)0.0f, (int)1, (int)1, (int)1, (int)1);
    }

    public static void renderAnimatedBackground(class_4587 stack, class_2960 texture, float x, float y, float width, float height, float textureWidth, float textureHeight, double speed, float delta) {
        if (speed != 0.0) {
            double d = (double)((float)FiguraMod.ticks + delta) * speed;
            x = (float)((double)x - d % (double)textureWidth);
            y = (float)((double)y - d % (double)textureHeight);
        }
        width += textureWidth;
        height += textureHeight;
        if (speed < 0.0) {
            x -= textureWidth;
            y -= textureHeight;
        }
        UIHelper.renderBackgroundTexture(stack, texture, x, y, width, height, textureWidth, textureHeight);
    }

    public static void renderBackgroundTexture(class_4587 stack, class_2960 texture, float x, float y, float width, float height, float textureWidth, float textureHeight) {
        UIHelper.setupTexture(texture);
        class_289 tessellator = class_289.method_1348();
        class_287 bufferBuilder = tessellator.method_1349();
        bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1585);
        float u1 = width / textureWidth;
        float v1 = height / textureHeight;
        UIHelper.quad(bufferBuilder, stack.method_23760().method_23761(), x, y, width, height, -999.0f, 0.0f, u1, 0.0f, v1);
        tessellator.method_1350();
    }

    public static void fillRounded(class_4587 stack, int x, int y, int width, int height, int color) {
        UIHelper.method_25294((class_4587)stack, (int)(x + 1), (int)y, (int)(x + width - 1), (int)(y + 1), (int)color);
        UIHelper.method_25294((class_4587)stack, (int)x, (int)(y + 1), (int)(x + width), (int)(y + height - 1), (int)color);
        UIHelper.method_25294((class_4587)stack, (int)(x + 1), (int)(y + height - 1), (int)(x + width - 1), (int)(y + height), (int)color);
    }

    public static void fillOutline(class_4587 stack, int x, int y, int width, int height, int color) {
        UIHelper.method_25294((class_4587)stack, (int)(x + 1), (int)y, (int)(x + width - 1), (int)(y + 1), (int)color);
        UIHelper.method_25294((class_4587)stack, (int)x, (int)(y + 1), (int)(x + 1), (int)(y + height - 1), (int)color);
        UIHelper.method_25294((class_4587)stack, (int)(x + width - 1), (int)(y + 1), (int)(x + width), (int)(y + height - 1), (int)color);
        UIHelper.method_25294((class_4587)stack, (int)(x + 1), (int)(y + height - 1), (int)(x + width - 1), (int)(y + height), (int)color);
    }

    public static void renderSliced(class_4587 stack, int x, int y, int width, int height, class_2960 texture) {
        UIHelper.renderSliced(stack, x, y, width, height, 0.0f, 0.0f, 15, 15, 15, 15, texture);
    }

    public static void renderSliced(class_4587 stack, int x, int y, int width, int height, float u, float v, int regionWidth, int regionHeight, int textureWidth, int textureHeight, class_2960 texture) {
        UIHelper.setupTexture(texture);
        class_1159 pose = stack.method_23760().method_23761();
        class_289 tessellator = class_289.method_1348();
        class_287 buffer = tessellator.method_1349();
        buffer.method_1328(class_293.class_5596.field_27382, class_290.field_1585);
        float rWidthThird = (float)regionWidth / 3.0f;
        float rHeightThird = (float)regionHeight / 3.0f;
        UIHelper.quad(buffer, pose, x, y, rWidthThird, rHeightThird, u, v, rWidthThird, rHeightThird, textureWidth, textureHeight);
        UIHelper.quad(buffer, pose, (float)x + rWidthThird, y, (float)width - rWidthThird * 2.0f, rHeightThird, u + rWidthThird, v, rWidthThird, rHeightThird, textureWidth, textureHeight);
        UIHelper.quad(buffer, pose, (float)(x + width) - rWidthThird, y, rWidthThird, rHeightThird, u + rWidthThird * 2.0f, v, rWidthThird, rHeightThird, textureWidth, textureHeight);
        UIHelper.quad(buffer, pose, x, (float)y + rHeightThird, rWidthThird, (float)height - rHeightThird * 2.0f, u, v + rHeightThird, rWidthThird, rHeightThird, textureWidth, textureHeight);
        UIHelper.quad(buffer, pose, (float)x + rWidthThird, (float)y + rHeightThird, (float)width - rWidthThird * 2.0f, (float)height - rHeightThird * 2.0f, u + rWidthThird, v + rHeightThird, rWidthThird, rHeightThird, textureWidth, textureHeight);
        UIHelper.quad(buffer, pose, (float)(x + width) - rWidthThird, (float)y + rHeightThird, rWidthThird, (float)height - rHeightThird * 2.0f, u + rWidthThird * 2.0f, v + rHeightThird, rWidthThird, rHeightThird, textureWidth, textureHeight);
        UIHelper.quad(buffer, pose, x, (float)(y + height) - rHeightThird, rWidthThird, rHeightThird, u, v + rHeightThird * 2.0f, rWidthThird, rHeightThird, textureWidth, textureHeight);
        UIHelper.quad(buffer, pose, (float)x + rWidthThird, (float)(y + height) - rHeightThird, (float)width - rWidthThird * 2.0f, rHeightThird, u + rWidthThird, v + rHeightThird * 2.0f, rWidthThird, rHeightThird, textureWidth, textureHeight);
        UIHelper.quad(buffer, pose, (float)(x + width) - rWidthThird, (float)(y + height) - rHeightThird, rWidthThird, rHeightThird, u + rWidthThird * 2.0f, v + rHeightThird * 2.0f, rWidthThird, rHeightThird, textureWidth, textureHeight);
        tessellator.method_1350();
    }

    public static void renderHalfTexture(class_4587 stack, int x, int y, int width, int height, int textureWidth, class_2960 texture) {
        UIHelper.renderHalfTexture(stack, x, y, width, height, 0.0f, 0.0f, textureWidth, 1, textureWidth, 1, texture);
    }

    public static void renderHalfTexture(class_4587 stack, int x, int y, int width, int height, float u, float v, int regionWidth, int regionHeight, int textureWidth, int textureHeight, class_2960 texture) {
        UIHelper.setupTexture(texture);
        int w = width / 2;
        UIHelper.method_25293((class_4587)stack, (int)x, (int)y, (int)w, (int)height, (float)u, (float)v, (int)w, (int)regionHeight, (int)textureWidth, (int)textureHeight);
        x += w;
        if (width % 2 == 1) {
            ++w;
        }
        UIHelper.method_25293((class_4587)stack, (int)x, (int)y, (int)w, (int)height, (float)(u + (float)regionWidth - (float)w), (float)v, (int)w, (int)regionHeight, (int)textureWidth, (int)textureHeight);
    }

    public static void renderSprite(class_4587 stack, int x, int y, int z, int width, int height, class_1058 sprite) {
        UIHelper.setupTexture(sprite.method_24119().method_24106());
        class_287 bufferBuilder = class_289.method_1348().method_1349();
        bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1585);
        UIHelper.quad(bufferBuilder, stack.method_23760().method_23761(), x, y, width, height, z, sprite.method_4594(), sprite.method_4577(), sprite.method_4593(), sprite.method_4575());
        bufferBuilder.method_1326();
        class_286.method_1309((class_287)bufferBuilder);
    }

    public static void setupScissor(int x, int y, int width, int height) {
        FiguraVec4 vec = FiguraVec4.of(x, y, width, height);
        if (!SCISSORS_STACK.isEmpty()) {
            FiguraVec4 old = SCISSORS_STACK.peek();
            double newX = Math.max((double)x, old.x());
            double newY = Math.max((double)y, old.y());
            double newWidth = Math.min((double)(x + width), old.x() + old.z()) - newX;
            double newHeight = Math.min((double)(y + height), old.y() + old.w()) - newY;
            vec.set(newX, newY, newWidth, newHeight);
        }
        SCISSORS_STACK.push(vec);
        UIHelper.setupScissor(vec);
    }

    private static void quad(class_287 bufferBuilder, class_1159 pose, float x, float y, float width, float height, float u, float v, float regionWidth, float regionHeight, int textureWidth, int textureHeight) {
        float u0 = u / (float)textureWidth;
        float v0 = v / (float)textureHeight;
        float u1 = (u + regionWidth) / (float)textureWidth;
        float v1 = (v + regionHeight) / (float)textureHeight;
        UIHelper.quad(bufferBuilder, pose, x, y, width, height, 0.0f, u0, u1, v0, v1);
    }

    private static void quad(class_287 bufferBuilder, class_1159 pose, float x, float y, float width, float height, float z, float u0, float u1, float v0, float v1) {
        float x1 = x + width;
        float y1 = y + height;
        bufferBuilder.method_22918(pose, x, y1, z).method_22913(u0, v1).method_1344();
        bufferBuilder.method_22918(pose, x1, y1, z).method_22913(u1, v1).method_1344();
        bufferBuilder.method_22918(pose, x1, y, z).method_22913(u1, v0).method_1344();
        bufferBuilder.method_22918(pose, x, y, z).method_22913(u0, v0).method_1344();
    }

    private static void setupScissor(FiguraVec4 dimensions) {
        double scale = class_310.method_1551().method_22683().method_4495();
        int screenY = class_310.method_1551().method_22683().method_4506();
        int scaledWidth = (int)Math.max(dimensions.z * scale, 0.0);
        int scaledHeight = (int)Math.max(dimensions.w * scale, 0.0);
        RenderSystem.enableScissor((int)((int)(dimensions.x * scale)), (int)((int)((double)screenY - dimensions.y * scale - (double)scaledHeight)), (int)scaledWidth, (int)scaledHeight);
    }

    public static void disableScissor() {
        SCISSORS_STACK.pop();
        if (!SCISSORS_STACK.isEmpty()) {
            UIHelper.setupScissor(SCISSORS_STACK.peek());
        } else {
            RenderSystem.disableScissor();
        }
    }

    public static void renderWithoutScissors(Runnable toRun) {
        RenderSystem.disableScissor();
        toRun.run();
        if (!SCISSORS_STACK.isEmpty()) {
            UIHelper.setupScissor(SCISSORS_STACK.peek());
        }
    }

    public static void highlight(class_4587 stack, FiguraWidget widget, class_2561 text) {
        class_437 class_4372 = class_310.method_1551().field_1755;
        if (!(class_4372 instanceof AbstractPanelScreen)) {
            return;
        }
        AbstractPanelScreen panel = (AbstractPanelScreen)class_4372;
        int screenW = panel.field_22789;
        int screenH = panel.field_22790;
        int x = widget.getX();
        int y = widget.getY();
        int width = widget.method_25368();
        int height = widget.method_25364();
        int color = -587202560;
        UIHelper.method_25294((class_4587)stack, (int)0, (int)0, (int)x, (int)(y + height), (int)color);
        UIHelper.method_25294((class_4587)stack, (int)(x + width), (int)y, (int)screenW, (int)screenH, (int)color);
        UIHelper.method_25294((class_4587)stack, (int)x, (int)0, (int)screenW, (int)y, (int)color);
        UIHelper.method_25294((class_4587)stack, (int)0, (int)(y + height), (int)(x + width), (int)screenH, (int)color);
        UIHelper.fillOutline(stack, Math.max(x - 1, 0), Math.max(y - 1, 0), Math.min(width + 2, screenW), Math.min(height + 2, screenH), -1);
        if (text == null) {
            return;
        }
        int bottomDistance = screenH - (y + height);
        int rightDistance = screenW - (x + width);
        int verArea = y * screenW - bottomDistance * screenW;
        int horArea = x * screenH - rightDistance * screenH;
        FiguraVec4 square = new FiguraVec4();
        if (Math.abs(verArea) > Math.abs(horArea)) {
            if (verArea >= 0) {
                square.set(0.0, 0.0, (double)screenW, (double)y);
            } else {
                square.set(0.0, (double)(y + height), (double)screenW, (double)bottomDistance);
            }
        } else if (horArea >= 0) {
            square.set(0.0, 0.0, (double)x, (double)screenH);
        } else {
            square.set(x + width, 0.0, (double)rightDistance, (double)screenH);
        }
    }

    public static boolean isMouseOver(int x, int y, int width, int height, double mouseX, double mouseY) {
        return UIHelper.isMouseOver(x, y, width, height, mouseX, mouseY, false);
    }

    public static boolean isMouseOver(int x, int y, int width, int height, double mouseX, double mouseY, boolean force) {
        ContextMenu context = force ? null : UIHelper.getContext();
        return (context == null || !context.isVisible()) && mouseX >= (double)x && mouseX < (double)(x + width) && mouseY >= (double)y && mouseY < (double)(y + height);
    }

    public static void renderOutlineText(class_4587 stack, class_327 textRenderer, class_2561 text, int x, int y, int color, int outline) {
        class_4597.class_4598 bufferSource = class_4597.method_22991((class_287)class_289.method_1348().method_1349());
        textRenderer.method_37296(text.method_30937(), (float)x, (float)y, color, outline, stack.method_23760().method_23761(), (class_4597)bufferSource, 0xF000F0);
        bufferSource.method_22993();
    }

    public static void renderTooltip(class_4587 stack, class_2561 tooltip, int mouseX, int mouseY, boolean background) {
        class_310 minecraft = class_310.method_1551();
        int screenX = minecraft.method_22683().method_4486();
        int screenY = minecraft.method_22683().method_4502();
        boolean reduced = (Boolean)Configs.REDUCED_MOTION.value;
        int x = reduced ? 0 : mouseX;
        int y = reduced ? screenY : mouseY - 12;
        class_327 font = minecraft.field_1772;
        List<class_5481> text = TextUtils.wrapTooltip((class_5348)tooltip, font, x, screenX, 12);
        Objects.requireNonNull(font);
        int height = 9 * text.size();
        y = Math.min(Math.max(y, 0), screenY - height);
        int width = TextUtils.getWidth(text, font);
        if ((x += 12) + width > screenX) {
            x = Math.max(x - width - 24, 0);
        }
        if (reduced) {
            x += (screenX - width) / 2;
            if (background) {
                y -= 4;
            }
        }
        stack.method_22903();
        stack.method_22904(0.0, 0.0, 999.0);
        if (background) {
            UIHelper.renderSliced(stack, x - 4, y - 4, width + 8, height + 8, TOOLTIP);
        }
        for (int i = 0; i < text.size(); ++i) {
            class_5481 charSequence = text.get(i);
            float f = x;
            Objects.requireNonNull(font);
            font.method_27517(stack, charSequence, f, (float)(y + 9 * i), 0xFFFFFF);
        }
        stack.method_22909();
    }

    public static void renderScrollingText(class_4587 stack, class_2561 text, int x, int y, int width, int color) {
        class_327 font = class_310.method_1551().field_1772;
        int textWidth = font.method_27525((class_5348)text);
        int textX = x;
        if (textWidth <= width) {
            font.method_30883(stack, text, (float)textX, (float)y, color);
            return;
        }
        Objects.requireNonNull(font);
        UIHelper.setupScissor(x, y, width, 9);
        font.method_30883(stack, text, (float)(textX += UIHelper.getTextScrollingOffset(textWidth, width, false)), (float)y, color);
        UIHelper.disableScissor();
    }

    public static void renderCenteredScrollingText(class_4587 stack, class_2561 text, int x, int y, int width, int height, int color) {
        class_327 font = class_310.method_1551().field_1772;
        int textWidth = font.method_27525((class_5348)text);
        int textX = x + width / 2;
        int n = y + height / 2;
        Objects.requireNonNull(font);
        int textY = n - 9 / 2;
        if (textWidth <= width) {
            UIHelper.method_27534((class_4587)stack, (class_327)font, (class_2561)text, (int)textX, (int)textY, (int)color);
            return;
        }
        UIHelper.setupScissor(x, y, width, height);
        UIHelper.method_27534((class_4587)stack, (class_327)font, (class_2561)text, (int)(textX += UIHelper.getTextScrollingOffset(textWidth, width, true)), (int)textY, (int)color);
        UIHelper.disableScissor();
    }

    private static int getTextScrollingOffset(int textWidth, int width, boolean centered) {
        float speed = ((Float)Configs.TEXT_SCROLL_SPEED.tempValue).floatValue();
        int scrollLen = textWidth - width;
        int startingOffset = (int)Math.ceil((double)scrollLen / 2.0);
        int stopDelay = (int)((float)((Integer)Configs.TEXT_SCROLL_DELAY.tempValue).intValue() * speed);
        int time = scrollLen + stopDelay;
        int totalTime = time * 2;
        int ticks = (int)((float)FiguraMod.ticks * speed);
        int currentTime = ticks % time;
        int dir = ticks % totalTime > time - 1 ? 1 : -1;
        int clamp = Math.min(Math.max(currentTime - stopDelay, 0), scrollLen);
        return (startingOffset - clamp) * dir - (centered ? 0 : startingOffset);
    }

    public static Runnable openURL(String url) {
        class_310 minecraft = class_310.method_1551();
        return () -> minecraft.method_1507((class_437)new FiguraConfirmScreen.FiguraConfirmLinkScreen(bl -> {
            if (bl) {
                class_156.method_668().method_670(url);
            }
        }, url, minecraft.field_1755));
    }

    public static void renderLoading(class_4587 stack, int x, int y) {
        class_5250 text = new class_2585(Integer.toHexString(Math.abs(FiguraMod.ticks) % 16)).method_27696(class_2583.field_24360.method_27704(Badges.FONT));
        class_327 font = class_310.method_1551().field_1772;
        float f = x - font.method_27525((class_5348)text) / 2;
        Objects.requireNonNull(font);
        font.method_30881(stack, (class_2561)text, f, (float)(y - 9 / 2), -1);
    }

    public static void setContext(ContextMenu context) {
        class_437 class_4372 = class_310.method_1551().field_1755;
        if (class_4372 instanceof AbstractPanelScreen) {
            AbstractPanelScreen panelScreen = (AbstractPanelScreen)class_4372;
            panelScreen.contextMenu = context;
        }
    }

    public static ContextMenu getContext() {
        class_437 class_4372 = class_310.method_1551().field_1755;
        if (class_4372 instanceof AbstractPanelScreen) {
            AbstractPanelScreen panelScreen = (AbstractPanelScreen)class_4372;
            return panelScreen.contextMenu;
        }
        return null;
    }

    public static void setTooltip(class_2561 text) {
        class_437 class_4372 = class_310.method_1551().field_1755;
        if (class_4372 instanceof AbstractPanelScreen) {
            AbstractPanelScreen panelScreen = (AbstractPanelScreen)class_4372;
            panelScreen.tooltip = text;
        }
    }

    public static void setTooltip(class_2583 style) {
        if (style == null || style.method_10969() == null) {
            return;
        }
        class_2561 text = (class_2561)style.method_10969().method_10891(class_2568.class_5247.field_24342);
        if (text != null) {
            UIHelper.setTooltip(text);
        }
    }

    public static void renderOutline(class_4587 matrices, int x, int y, int width, int height, int color) {
        UIHelper.method_25294((class_4587)matrices, (int)x, (int)y, (int)(x + width), (int)(y + 1), (int)color);
        UIHelper.method_25294((class_4587)matrices, (int)x, (int)(y + height - 1), (int)(x + width), (int)(y + height), (int)color);
        UIHelper.method_25294((class_4587)matrices, (int)x, (int)(y + 1), (int)(x + 1), (int)(y + height - 1), (int)color);
        UIHelper.method_25294((class_4587)matrices, (int)(x + width - 1), (int)(y + 1), (int)(x + width), (int)(y + height - 1), (int)color);
    }
}

