/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.utils;

import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.function.Function;
import net.minecraft.class_1058;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_156;
import net.minecraft.class_1723;
import net.minecraft.class_1738;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4668;
import net.minecraft.class_572;
import net.minecraft.class_970;
import org.figuramc.figura.avatar.Avatar;
import org.figuramc.figura.lua.api.vanilla_model.VanillaPart;
import org.figuramc.figura.model.ParentType;
import org.figuramc.figura.permissions.Permissions;
import org.figuramc.figura.utils.fabric.RenderUtilsImpl;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

public class RenderUtils {
    public static boolean vanillaModel(Avatar avatar) {
        return avatar != null && avatar.permissions.get(Permissions.VANILLA_MODEL_EDIT) >= 1;
    }

    public static boolean vanillaModelAndScript(Avatar avatar) {
        return avatar != null && avatar.luaRuntime != null && avatar.permissions.get(Permissions.VANILLA_MODEL_EDIT) >= 1;
    }

    public static class_1058 firstFireLayer(Avatar avatar) {
        if (!RenderUtils.vanillaModelAndScript(avatar)) {
            return null;
        }
        class_2960 layer = avatar.luaRuntime.renderer.fireLayer1;
        return layer != null ? (class_1058)class_310.method_1551().method_1549(class_1723.field_21668).apply(layer) : null;
    }

    public static class_1058 secondFireLayer(Avatar avatar) {
        if (!RenderUtils.vanillaModelAndScript(avatar)) {
            return null;
        }
        class_2960 layer1 = avatar.luaRuntime.renderer.fireLayer1;
        class_2960 layer2 = avatar.luaRuntime.renderer.fireLayer2;
        if (layer2 != null) {
            return (class_1058)class_310.method_1551().method_1549(class_1723.field_21668).apply(layer2);
        }
        if (layer1 != null) {
            return (class_1058)class_310.method_1551().method_1549(class_1723.field_21668).apply(layer1);
        }
        return null;
    }

    public static VanillaPart partFromSlot(Avatar avatar, class_1304 equipmentSlot) {
        if (!RenderUtils.vanillaModelAndScript(avatar)) {
            return null;
        }
        return switch (equipmentSlot) {
            case class_1304.field_6169 -> avatar.luaRuntime.vanilla_model.HELMET;
            case class_1304.field_6174 -> avatar.luaRuntime.vanilla_model.CHESTPLATE;
            case class_1304.field_6172 -> avatar.luaRuntime.vanilla_model.LEGGINGS;
            case class_1304.field_6166 -> avatar.luaRuntime.vanilla_model.BOOTS;
            default -> null;
        };
    }

    public static VanillaPart pivotToPart(Avatar avatar, ParentType type) {
        if (!RenderUtils.vanillaModelAndScript(avatar)) {
            return null;
        }
        return switch (type) {
            case ParentType.HelmetPivot -> avatar.luaRuntime.vanilla_model.HELMET;
            case ParentType.ChestplatePivot -> avatar.luaRuntime.vanilla_model.CHESTPLATE;
            case ParentType.LeftShoulderPivot -> avatar.luaRuntime.vanilla_model.CHESTPLATE_LEFT_ARM;
            case ParentType.RightShoulderPivot -> avatar.luaRuntime.vanilla_model.CHESTPLATE_RIGHT_ARM;
            case ParentType.LeggingsPivot -> avatar.luaRuntime.vanilla_model.LEGGINGS;
            case ParentType.LeftLeggingPivot -> avatar.luaRuntime.vanilla_model.LEGGINGS_LEFT_LEG;
            case ParentType.RightLeggingPivot -> avatar.luaRuntime.vanilla_model.LEGGINGS_RIGHT_LEG;
            case ParentType.LeftBootPivot -> avatar.luaRuntime.vanilla_model.BOOTS_LEFT_LEG;
            case ParentType.RightBootPivot -> avatar.luaRuntime.vanilla_model.BOOTS_RIGHT_LEG;
            case ParentType.LeftElytraPivot -> avatar.luaRuntime.vanilla_model.LEFT_ELYTRA;
            case ParentType.RightElytraPivot -> avatar.luaRuntime.vanilla_model.RIGHT_ELYTRA;
            default -> null;
        };
    }

    public static class_1304 slotFromPart(ParentType type) {
        switch (type) {
            case HelmetPivot: 
            case Head: 
            case HelmetItemPivot: 
            case Skull: {
                return class_1304.field_6169;
            }
            case ChestplatePivot: 
            case LeftShoulderPivot: 
            case RightShoulderPivot: 
            case LeftElytraPivot: 
            case RightElytraPivot: 
            case Body: 
            case LeftElytra: 
            case RightElytra: {
                return class_1304.field_6174;
            }
            case LeftArm: 
            case LeftItemPivot: 
            case LeftSpyglassPivot: {
                return class_1304.field_6171;
            }
            case RightArm: 
            case RightItemPivot: 
            case RightSpyglassPivot: {
                return class_1304.field_6173;
            }
            case LeggingsPivot: 
            case LeftLeggingPivot: 
            case RightLeggingPivot: 
            case LeftLeg: 
            case RightLeg: {
                return class_1304.field_6172;
            }
            case LeftBootPivot: 
            case RightBootPivot: {
                return class_1304.field_6166;
            }
        }
        return null;
    }

    public static boolean renderArmItem(Avatar avatar, boolean lefty, CallbackInfo ci) {
        if (!RenderUtils.vanillaModel(avatar)) {
            return false;
        }
        if (avatar.luaRuntime != null && (lefty && !avatar.luaRuntime.vanilla_model.LEFT_ITEM.checkVisible() || !lefty && !avatar.luaRuntime.vanilla_model.RIGHT_ITEM.checkVisible())) {
            ci.cancel();
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static <T extends class_1309, M extends class_572<T>, A extends class_572<T>> class_2960 getArmorResource(class_970<T, M, A> armorLayer, class_1297 entity, class_1799 stack, class_1738 item, class_1304 slot, boolean isInner, String type) {
        void var6_6;
        void var5_5;
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        return RenderUtilsImpl.getArmorResource(armorLayer, (class_1297)var1_1, (class_1799)var2_2, (class_1738)var3_3, (class_1304)var4_4, (boolean)var5_5, (String)var6_6);
    }

    public static class TextRenderType
    extends class_1921 {
        public static Function<class_2960, class_1921> TEXT_BACKGROUND_SEE_THROUGH = class_156.method_34866(texture -> TextRenderType.method_24049((String)"text_background_see_through", (class_293)class_290.field_20888, (class_293.class_5596)class_293.class_5596.field_27382, (int)256, (boolean)false, (boolean)true, (class_1921.class_4688)class_1921.class_4688.method_23598().method_34578(class_4668.field_33629).method_34577((class_4668.class_5939)new class_4668.class_4683(texture, false, false)).method_23615(field_21370).method_23608(field_21383).method_23604(field_21346).method_23616(field_21350).method_23617(false)));
        public static Function<class_2960, class_1921> TEXT_BACKGROUND = class_156.method_34866(texture -> TextRenderType.method_24049((String)"text_background", (class_293)class_290.field_20888, (class_293.class_5596)class_293.class_5596.field_27382, (int)256, (boolean)false, (boolean)true, (class_1921.class_4688)class_1921.class_4688.method_23598().method_34578(field_33628).method_34577((class_4668.class_5939)new class_4668.class_4683(texture, false, false)).method_23615(field_21370).method_23608(field_21383).method_23617(false)));

        public TextRenderType(String name, class_293 vertexFormat, class_293.class_5596 drawMode, int expectedBufferSize, boolean hasCrumbling, boolean translucent, Runnable startAction, Runnable endAction) {
            super(name, vertexFormat, drawMode, expectedBufferSize, hasCrumbling, translucent, startAction, endAction);
        }
    }
}

