/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.utils;

import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import net.minecraft.class_1158;
import net.minecraft.class_1159;
import net.minecraft.class_1160;
import net.minecraft.class_1162;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_4581;
import org.figuramc.figura.config.Configs;
import org.figuramc.figura.ducks.GameRendererAccessor;
import org.figuramc.figura.math.matrix.FiguraMat2;
import org.figuramc.figura.math.matrix.FiguraMat3;
import org.figuramc.figura.math.matrix.FiguraMat4;
import org.figuramc.figura.math.matrix.FiguraMatrix;
import org.figuramc.figura.math.vector.FiguraVec2;
import org.figuramc.figura.math.vector.FiguraVec3;
import org.figuramc.figura.math.vector.FiguraVec4;
import org.figuramc.figura.math.vector.FiguraVector;

public class MathUtils {
    public static final double DEG_TO_RAD = Math.PI / 180;
    public static final double RAD_TO_DEG = 57.29577951308232;
    private static final String[] SIZE_UNITS = new String[]{"b", "kb", "mb", "gb"};

    public static FiguraVector<?, ?> sizedVector(double ... vals) {
        return switch (vals.length) {
            case 2 -> FiguraVec2.of(vals[0], vals[1]);
            case 3 -> FiguraVec3.of(vals[0], vals[1], vals[2]);
            case 4 -> FiguraVec4.of(vals[0], vals[1], vals[2], vals[3]);
            default -> throw new IllegalStateException("Cannot create vector of size: " + vals.length);
        };
    }

    public static FiguraMatrix<?, ?> sizedMat(FiguraVector<?, ?> ... vectors) {
        return switch (vectors.length) {
            case 4 -> FiguraMat4.of(vectors[0].index(0), vectors[0].index(1), vectors[0].index(2), vectors[0].index(3), vectors[1].index(0), vectors[1].index(1), vectors[1].index(2), vectors[1].index(3), vectors[2].index(0), vectors[2].index(1), vectors[2].index(2), vectors[2].index(3), vectors[3].index(0), vectors[3].index(1), vectors[3].index(2), vectors[3].index(3));
            case 3 -> FiguraMat3.of(vectors[0].index(0), vectors[0].index(1), vectors[0].index(2), vectors[1].index(0), vectors[1].index(1), vectors[1].index(2), vectors[2].index(0), vectors[2].index(1), vectors[2].index(2));
            case 2 -> FiguraMat2.of(vectors[0].index(0), vectors[0].index(1), vectors[1].index(0), vectors[1].index(1));
            default -> throw new IllegalStateException("Cannot create matrix of size: " + vectors.length);
        };
    }

    public static FiguraVec3 rotateAroundAxis(FiguraVec3 vec, FiguraVec3 axis, double degrees) {
        FiguraVec3 normalizedAxis = axis.normalized();
        class_1158 vectorQuat = new class_1158((float)vec.x, (float)vec.y, (float)vec.z, 0.0f);
        class_1158 rotatorQuat = new class_1158(new class_1160((float)normalizedAxis.x, (float)normalizedAxis.y, (float)normalizedAxis.z), (float)degrees, true);
        class_1158 rotatorQuatConj = new class_1158(rotatorQuat);
        rotatorQuatConj.method_4926();
        rotatorQuat.method_4925(vectorQuat);
        rotatorQuat.method_4925(rotatorQuatConj);
        return FiguraVec3.of(rotatorQuat.method_4921(), rotatorQuat.method_4922(), rotatorQuat.method_4923());
    }

    public static FiguraVec3 toCameraSpace(FiguraVec3 vec) {
        class_4184 camera = class_310.method_1551().field_1773.method_19418();
        FiguraMat3 transformMatrix = FiguraMat3.of().set(new class_4581(camera.method_23767()));
        class_243 pos = camera.method_19326();
        transformMatrix.invert();
        FiguraVec3 ret = vec.copy();
        ret.subtract(pos.field_1352, pos.field_1351, pos.field_1350);
        ret.transform(transformMatrix);
        return ret;
    }

    public static FiguraVec4 worldToScreenSpace(FiguraVec3 worldSpace) {
        class_310 minecraft = class_310.method_1551();
        class_4184 camera = minecraft.field_1773.method_19418();
        class_4581 transformMatrix = new class_4581(camera.method_23767());
        transformMatrix.method_23732();
        class_243 camPos = camera.method_19326();
        FiguraVec3 posDiff = worldSpace.copy().subtract(camPos.field_1352, camPos.field_1351, camPos.field_1350);
        class_1160 camSpace = posDiff.asVec3f();
        camSpace.method_23215(transformMatrix);
        class_1162 projectiveCamSpace = new class_1162(camSpace);
        class_1159 projMat = minecraft.field_1773.method_22973(((GameRendererAccessor)minecraft.field_1773).figura$getFov(camera, minecraft.method_1488(), true));
        projectiveCamSpace.method_22674(projMat);
        float w = projectiveCamSpace.method_23853();
        return FiguraVec4.of(projectiveCamSpace.method_4953() / w, projectiveCamSpace.method_4956() / w, projectiveCamSpace.method_4957() / w, Math.sqrt(posDiff.dot(posDiff)));
    }

    public static String asFileSize(double size) {
        int i;
        for (i = 0; i < SIZE_UNITS.length && !(size < 1000.0); size /= 1000.0, ++i) {
        }
        DecimalFormat df = new DecimalFormat("0.00", new DecimalFormatSymbols(Locale.US));
        df.setRoundingMode(RoundingMode.HALF_UP);
        return df.format(size) + SIZE_UNITS[i];
    }

    public static float magicDelta(float speed, float delta) {
        return (Boolean)Configs.REDUCED_MOTION.value != false ? 1.0f : (float)(1.0 - Math.pow(speed, delta));
    }

    public static FiguraVec3 min(FiguraVec3 val, double min) {
        return FiguraVec3.of(Math.min(val.x, min), Math.min(val.y, min), Math.min(val.z, min));
    }

    public static FiguraVec3 max(FiguraVec3 val, double max) {
        return FiguraVec3.of(Math.max(val.x, max), Math.max(val.y, max), Math.max(val.z, max));
    }

    public static FiguraVec3 clamp(FiguraVec3 val, double min, double max) {
        return FiguraVec3.of(Math.min(Math.max(val.x, min), max), Math.min(Math.max(val.y, min), max), Math.min(Math.max(val.z, min), max));
    }

    public static FiguraVec3 lerp(double delta, FiguraVec3 prev, FiguraVec3 next) {
        return FiguraVec3.of(MathUtils.lerp(delta, prev.x, next.x), MathUtils.lerp(delta, prev.y, next.y), MathUtils.lerp(delta, prev.z, next.z));
    }

    public static double lerp(double delta, double prev, double next) {
        return delta * (next - prev) + prev;
    }

    public static FiguraVec3 catmullrom(double delta, FiguraVec3 prevA, FiguraVec3 prevB, FiguraVec3 nextA, FiguraVec3 nextB) {
        return FiguraVec3.of(MathUtils.catmullrom(delta, prevA.x, prevB.x, nextA.x, nextB.x), MathUtils.catmullrom(delta, prevA.y, prevB.y, nextA.y, nextB.y), MathUtils.catmullrom(delta, prevA.z, prevB.z, nextA.z, nextB.z));
    }

    public static double catmullrom(double delta, double prevA, double prevB, double nextA, double nextB) {
        return 0.5 * (2.0 * prevB + (nextA - prevA) * delta + (2.0 * prevA - 5.0 * prevB + 4.0 * nextA - nextB) * delta * delta + (3.0 * prevB - prevA - 3.0 * nextA + nextB) * delta * delta * delta);
    }

    public static double bezier(double t, double p0, double p1, double p2, double p3) {
        double d = 1.0 - t;
        return p0 * d * d * d + 3.0 * p1 * d * d * t + 3.0 * p2 * d * t * t + p3 * t * t * t;
    }

    public static double bezierFindT(double x, double p0, double p1, double p2, double p3) {
        double x0 = 0.4;
        double x1 = 0.6;
        double tolerance = 0.001;
        int iterations = 100;
        for (int i = 0; i < iterations; ++i) {
            double fx0;
            double fx1 = MathUtils.bezier(x1, p0, p1, p2, p3) - x;
            double xNext = x1 - fx1 * (x1 - x0) / (fx1 - (fx0 = MathUtils.bezier(x0, p0, p1, p2, p3) - x));
            if (Math.abs(xNext - x1) < tolerance) {
                return xNext;
            }
            x0 = x1;
            x1 = xNext;
        }
        return x1;
    }

    public static FiguraVec3 quaternionToYXZ(class_1158 quaternion) {
        double r = quaternion.method_4924();
        double i = quaternion.method_4921();
        double j = quaternion.method_4922();
        double k = quaternion.method_4923();
        double f = r * r;
        double g = i * i;
        double h = j * j;
        double m = k * k;
        double n = f + g + h + m;
        double o = 2.0 * r * i - 2.0 * j * k;
        double l = Math.asin(Math.max(Math.min(1.0, o / n), -1.0));
        return Math.abs(o) > 0.999 * n ? FiguraVec3.of(l, 2.0 * Math.atan2(j, r), 0.0) : FiguraVec3.of(l, Math.atan2(2.0 * i * k + 2.0 * j * r, f - g - h + m), Math.atan2(2.0 * i * j + 2.0 * r * k, f - g + h - m));
    }
}

