/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1162;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_2585;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import net.minecraft.class_5348;
import org.figuramc.figura.utils.TextUtils;
import org.figuramc.figura.utils.ui.UIHelper;
import org.jetbrains.annotations.Nullable;

public class ClickableTextHelper {
    protected TextLine[] lines;
    protected HashMap<class_1162, String> clickUrls = new HashMap();
    protected HashMap<class_1162, class_2561> hoverText = new HashMap();
    protected boolean dirty = true;
    protected class_2561 message;

    public void setMessage(@Nullable class_2561 message) {
        if (this.message == message) {
            return;
        }
        this.message = message;
        if (message == null) {
            this.clear();
            return;
        }
        this.dirty = true;
    }

    public void renderDebug(class_4587 poseStack, int x, int y, int mouseX, int mouseY) {
        for (class_1162 area : this.hoverText.keySet()) {
            UIHelper.renderOutline(poseStack, (int)((float)x + area.method_4953()), (int)((float)y + area.method_4956()), (int)(area.method_4957() - area.method_4953()), (int)(area.method_23853() - area.method_4956()), ClickableTextHelper.isPointWithinBounds(area, x, y, mouseX, mouseY) ? -16711936 : -65281);
        }
        for (class_1162 area : this.clickUrls.keySet()) {
            UIHelper.renderOutline(poseStack, (int)((float)x + area.method_4953()), (int)((float)y + area.method_4956()), (int)(area.method_4957() - area.method_4953()), (int)(area.method_23853() - area.method_4956()), ClickableTextHelper.isPointWithinBounds(area, x, y, mouseX, mouseY) ? -16711936 : -65281);
        }
        UIHelper.renderOutline(poseStack, mouseX - 1, mouseY - 1, 3, 3, -16711681);
    }

    public void update(class_327 font, int lineWidth) {
        if (!this.dirty || this.message == null) {
            return;
        }
        this.dirty = false;
        this.clear();
        ArrayList<TextLine> lines = new ArrayList<TextLine>();
        List split = font.method_27527().method_27495((class_5348)this.message, lineWidth, class_2583.field_24360);
        for (class_5348 curLine : split) {
            ArrayList nodes = new ArrayList();
            TextUtils.formattedTextToText(curLine).method_27658((style, string) -> {
                nodes.add(new TextNode(string, style));
                return Optional.empty();
            }, class_2583.field_24360);
            lines.add(new TextLine(nodes.toArray(new TextNode[0])));
        }
        this.lines = lines.toArray(new TextLine[0]);
        this.visit((a, style, x, y, w, h) -> {
            Object value;
            class_2558 clickEvent = style.method_10970();
            class_2568 hoverEvent = style.method_10969();
            if (clickEvent == null && hoverEvent == null) {
                return;
            }
            class_1162 rect = new class_1162((float)x, (float)y, (float)(x + w), (float)(y + h));
            if (clickEvent != null && clickEvent.method_10845() == class_2558.class_2559.field_11749) {
                this.clickUrls.put(rect, clickEvent.method_10844());
            }
            if (hoverEvent != null && (value = hoverEvent.method_10891(hoverEvent.method_10892())) instanceof class_2561) {
                class_2561 component = (class_2561)value;
                this.hoverText.put(rect, component);
            }
        });
    }

    @Nullable
    public class_2561 getHoverTooltip(int cx, int cy, int mouseX, int mouseY) {
        for (class_1162 area : this.hoverText.keySet()) {
            if (!ClickableTextHelper.isPointWithinBounds(area, cx, cy, mouseX, mouseY)) continue;
            return this.hoverText.get(area);
        }
        return null;
    }

    @Nullable
    public String getClickLink(int cx, int cy, int mouseX, int mouseY) {
        for (class_1162 area : this.clickUrls.keySet()) {
            if (!ClickableTextHelper.isPointWithinBounds(area, cx, cy, mouseX, mouseY)) continue;
            return this.clickUrls.get(area);
        }
        return null;
    }

    public int lineCount() {
        return this.lines == null ? 1 : this.lines.length;
    }

    private static boolean isPointWithinBounds(class_1162 area, int xOffset, int yOffset, int x, int y) {
        int x1 = (int)(area.method_4953() + (float)xOffset);
        int y1 = (int)(area.method_4956() + (float)yOffset);
        int x2 = (int)(area.method_4957() + (float)xOffset);
        int y2 = (int)(area.method_23853() + (float)yOffset);
        return x > x1 && x < x2 && y > y1 && y < y2;
    }

    public void visit(MultilineTextVisitor visitor) {
        if (this.lines == null) {
            return;
        }
        class_327 font = class_310.method_1551().field_1772;
        int y = 0;
        for (TextLine line : this.lines) {
            int x = 0;
            for (TextNode node : line.nodes) {
                int width = node.getWidth(font);
                String string = node.text;
                class_2583 class_25832 = node.style;
                Objects.requireNonNull(font);
                visitor.visit(string, class_25832, x, y, width, 9);
                x += width;
            }
            Objects.requireNonNull(font);
            y += 9;
        }
    }

    public void clear() {
        this.lines = new TextLine[0];
        this.clickUrls.clear();
        this.hoverText.clear();
    }

    public void markDirty() {
        this.dirty = true;
    }

    protected record TextLine(TextNode[] nodes) {
    }

    protected record TextNode(String text, class_2583 style) {
        public int getWidth(class_327 font) {
            return font.method_27525((class_5348)this.asText());
        }

        public class_2561 asText() {
            return new class_2585(this.text).method_27696(this.style);
        }
    }

    @FunctionalInterface
    public static interface MultilineTextVisitor {
        public void visit(String var1, class_2583 var2, int var3, int var4, int var5, int var6);
    }
}

