/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.parsers;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.class_2481;
import net.minecraft.class_2487;
import net.minecraft.class_2494;
import net.minecraft.class_2497;
import net.minecraft.class_2499;
import net.minecraft.class_2516;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import org.figuramc.figura.FiguraMod;
import org.figuramc.figura.math.vector.FiguraVec3;
import org.figuramc.figura.model.ParentType;
import org.figuramc.figura.parsers.BlockbenchModel;
import org.figuramc.figura.utils.IOUtils;

public class BlockbenchModelParser {
    private static final Gson GSON = new GsonBuilder().create();
    private int textureOffset = 0;
    private int animationOffset = 0;
    private final HashMap<String, class_2487> elementMap = new HashMap();
    private final HashMap<String, class_2499> animationMap = new HashMap();
    private final HashMap<String, TextureData> textureMap = new HashMap();
    private final HashMap<Integer, String> textureIdMap = new HashMap();
    private static final FiguraVec3 v1 = FiguraVec3.of();
    private static final FiguraVec3 v2 = FiguraVec3.of();
    private static final FiguraVec3 v3 = FiguraVec3.of();
    private static final FiguraVec3 v4 = FiguraVec3.of();
    private static final FiguraVec3 t1 = FiguraVec3.of();
    private static final FiguraVec3 t2 = FiguraVec3.of();
    private static final FiguraVec3 t3 = FiguraVec3.of();
    private static final FiguraVec3 t4 = FiguraVec3.of();

    public ModelData parseModel(Path avatarFolder, Path sourceFile, String json, String modelName, String folders) throws Exception {
        BlockbenchModel model = (BlockbenchModel)GSON.fromJson(json, BlockbenchModel.class);
        if (!model.meta.model_format.equals("free") && !model.meta.model_format.contains("figura")) {
            throw new Exception("Model \"" + modelName + "\" have an incompatible model format. Compatibility is limited to \"Generic Model\" format and third-party Figura specific formats");
        }
        if (Integer.parseInt(model.meta.format_version.split("\\.")[0]) < 4) {
            throw new Exception("Model \"" + modelName + "\" was created using a version too old (" + model.meta.format_version + ") of Blockbench. Minimum compatible version is 4.0");
        }
        class_2487 textures = new class_2487();
        ArrayList<class_2487> animationList = new ArrayList<class_2487>();
        class_2487 nbt = new class_2487();
        nbt.method_10582("name", modelName);
        BlockbenchModelParser.parseParent(modelName, nbt);
        this.parseTextures(avatarFolder, sourceFile, folders, modelName, textures, model.textures, model.resolution);
        this.parseElements(model.elements);
        this.parseAnimations(animationList, model.animations, modelName, folders);
        nbt.method_10566("chld", (class_2520)this.parseOutliner(model.outliner, true));
        this.elementMap.clear();
        this.animationMap.clear();
        this.textureMap.clear();
        this.textureIdMap.clear();
        return new ModelData(textures, animationList, nbt);
    }

    public static void parseParent(String name, class_2487 nbt) {
        ParentType parentType = ParentType.get(name);
        if (parentType != ParentType.None) {
            nbt.method_10582("pt", parentType.name());
        }
    }

    private void parseTextures(Path avatar, Path sourceFile, String folders, String modelName, class_2487 texturesNbt, BlockbenchModel.Texture[] textures, BlockbenchModel.Resolution resolution) throws Exception {
        if (textures == null) {
            return;
        }
        LinkedHashMap<Object, class_2487> texturesTemp = new LinkedHashMap<Object, class_2487>();
        ArrayList<Object> textureIndex = new ArrayList<Object>();
        class_2487 src = new class_2487();
        class_2499 data = new class_2499();
        for (int i = 0; i < textures.length; ++i) {
            float[] fixedSize;
            Object path;
            byte[] source;
            BlockbenchModel.Texture texture = textures[i];
            Object name = texture.name;
            if (((String)name).endsWith(".png")) {
                name = ((String)name).substring(0, ((String)name).length() - 4);
            }
            String textureType = ((String)name).endsWith("_e") ? "e" : (((String)name).endsWith("_n") ? "n" : (((String)name).endsWith("_s") ? "s" : "d"));
            try {
                Path p = sourceFile.resolve(texture.relative_path);
                if (p.getFileSystem() == FileSystems.getDefault()) {
                    File f = p.toFile().getCanonicalFile();
                    p = f.toPath();
                    if (!f.exists()) {
                        throw new IllegalStateException("File do not exists!");
                    }
                } else if ((p = p.normalize()).getFileSystem() != avatar.getFileSystem()) {
                    throw new IllegalStateException("File from outside the avatar folder!");
                }
                if (avatar.getNameCount() > 1 && !p.startsWith(avatar)) {
                    throw new IllegalStateException("File from outside the avatar folder!");
                }
                FiguraMod.debug("path is {}", p.toString());
                source = IOUtils.readFileBytes(p);
                path = avatar.relativize(p).toString().replace(p.getFileSystem().getSeparator(), ".");
                path = ((String)path).substring(0, ((String)path).length() - 4);
                name = folders + (String)name;
                FiguraMod.debug("Loaded {} Texture \"{}\" from {}", textureType.toUpperCase(Locale.US), name, p);
            }
            catch (Exception e) {
                if (e instanceof IOException) {
                    FiguraMod.LOGGER.error("", (Throwable)e);
                }
                source = Base64.getDecoder().decode(texture.source.substring("data:image/png;base64,".length()));
                path = folders + modelName + "." + (String)name;
                FiguraMod.debug("Loaded {} Texture \"{}\" from {}", textureType.toUpperCase(Locale.US), name, path);
            }
            src.method_10570((String)path, source);
            if (!textureType.equals("d")) {
                name = ((String)name).substring(0, ((String)name).length() - 2);
            }
            if (texturesTemp.containsKey(name)) {
                class_2487 textureContainer = (class_2487)texturesTemp.get(name);
                if (textureContainer.method_10545(textureType)) {
                    throw new Exception("Model \"" + modelName + "\" contains texture with duplicate name \"" + (String)name + "\"");
                }
                textureContainer.method_10582(textureType, (String)path);
            } else {
                class_2487 compound = new class_2487();
                compound.method_10582(textureType, (String)path);
                texturesTemp.put(name, compound);
                textureIndex.add(name);
            }
            this.textureIdMap.put(i, (String)name);
            if (this.textureMap.containsKey(name)) continue;
            int id = textureIndex.indexOf(name) + this.textureOffset;
            if (texture.width != null) {
                fixedSize = new float[]{texture.width.floatValue() / texture.uv_width.floatValue(), texture.height.floatValue() / texture.uv_height.floatValue()};
            } else {
                int[] imageSize = BlockbenchModelParser.getTextureSize(source);
                fixedSize = new float[]{(float)imageSize[0] / (float)resolution.width, (float)imageSize[1] / (float)resolution.height};
            }
            this.textureMap.put((String)name, new TextureData(id, fixedSize));
        }
        for (Map.Entry entry : texturesTemp.entrySet()) {
            data.add((Object)((class_2520)entry.getValue()));
        }
        this.textureOffset += data.size();
        texturesNbt.method_10566("src", (class_2520)src);
        texturesNbt.method_10566("data", (class_2520)data);
    }

    private void parseElements(BlockbenchModel.Element[] elements) {
        for (BlockbenchModel.Element element : elements) {
            if (element.type == null) {
                element.type = "cube";
            }
            if (!element.type.equalsIgnoreCase("cube") && !element.type.equalsIgnoreCase("mesh") || element.export != null && !element.export.booleanValue()) continue;
            String id = element.uuid;
            class_2487 nbt = new class_2487();
            nbt.method_10582("name", element.name);
            if (BlockbenchModelParser.notZero(element.from)) {
                nbt.method_10566("f", (class_2520)BlockbenchModelParser.toNbtList(element.from));
            }
            if (BlockbenchModelParser.notZero(element.to)) {
                nbt.method_10566("t", (class_2520)BlockbenchModelParser.toNbtList(element.to));
            }
            if (BlockbenchModelParser.notZero(element.rotation)) {
                nbt.method_10566("rot", (class_2520)BlockbenchModelParser.toNbtList(element.rotation));
            }
            if (BlockbenchModelParser.notZero(element.origin)) {
                nbt.method_10566("piv", (class_2520)BlockbenchModelParser.toNbtList(element.origin));
            }
            if (element.inflate != 0.0f) {
                nbt.method_10548("inf", element.inflate);
            }
            nbt.method_10556("vsb", element.visibility == null || element.visibility != false);
            if (element.type.equalsIgnoreCase("cube")) {
                data = this.parseCubeFaces(element.faces);
                nbt.method_10566("cube_data", (class_2520)data);
            } else {
                data = this.parseMesh(element.faces, element.vertices, element.origin);
                nbt.method_10566("mesh_data", (class_2520)data);
            }
            this.elementMap.put(id, nbt);
        }
    }

    private class_2487 parseCubeFaces(JsonObject faces) {
        class_2487 nbt = new class_2487();
        for (String cubeFace : BlockbenchModel.CubeFace.FACES) {
            TextureData texture;
            if (!faces.has(cubeFace)) continue;
            BlockbenchModel.CubeFace face = (BlockbenchModel.CubeFace)GSON.fromJson((JsonElement)faces.getAsJsonObject(cubeFace), BlockbenchModel.CubeFace.class);
            if (face.texture == null || (texture = this.textureMap.get(this.textureIdMap.get(face.texture))) == null) continue;
            class_2487 faceNbt = new class_2487();
            faceNbt.method_10569("tex", texture.id);
            if (face.rotation != 0.0f) {
                faceNbt.method_10548("rot", face.rotation);
            }
            if (BlockbenchModelParser.notZero(face.uv)) {
                float[] uv = new float[]{face.uv[0] * texture.fixedSize[0], face.uv[1] * texture.fixedSize[1], face.uv[2] * texture.fixedSize[0], face.uv[3] * texture.fixedSize[1]};
                faceNbt.method_10566("uv", (class_2520)BlockbenchModelParser.toNbtList(uv));
            }
            nbt.method_10566(String.valueOf(cubeFace.charAt(0)), (class_2520)faceNbt);
        }
        return nbt;
    }

    private class_2487 parseMesh(JsonObject faces, JsonObject vertices, float[] offset) {
        class_2487 nbt = new class_2487();
        HashMap<String, Integer> verticesMap = new HashMap<String, Integer>();
        class_2499 verticesList = new class_2499();
        int index = 0;
        for (Map.Entry entry : vertices.entrySet()) {
            verticesMap.put((String)entry.getKey(), index);
            float[] arr = BlockbenchModelParser.jsonToFloat(((JsonElement)entry.getValue()).getAsJsonArray());
            verticesList.add((Object)class_2494.method_23244((float)(arr[0] + offset[0])));
            verticesList.add((Object)class_2494.method_23244((float)(arr[1] + offset[1])));
            verticesList.add((Object)class_2494.method_23244((float)(arr[2] + offset[2])));
            ++index;
        }
        class_2499 texesList = new class_2499();
        class_2499 uvsList = new class_2499();
        class_2499 facesList = new class_2499();
        int bestType = 0;
        if (index > 255) {
            bestType = 1;
        }
        if (index > Short.MAX_VALUE) {
            bestType = 2;
        }
        for (Map.Entry entry : faces.entrySet()) {
            TextureData texture;
            BlockbenchModel.MeshFace face = (BlockbenchModel.MeshFace)GSON.fromJson((JsonElement)entry.getValue(), BlockbenchModel.MeshFace.class);
            if (face.texture == null || face.vertices == null || face.uv == null || face.vertices.length < 3 || face.vertices.length > 4 || (texture = this.textureMap.get(this.textureIdMap.get(face.texture))) == null) continue;
            short k = (short)((texture.id << 4) + face.vertices.length);
            texesList.add((Object)class_2516.method_23254((short)k));
            if (face.vertices.length > 3) {
                BlockbenchModelParser.reorderVertices(face.vertices, verticesMap, verticesList);
            }
            for (String vertex : face.vertices) {
                class_2481 bestVal = switch (bestType) {
                    case 0 -> class_2481.method_23233((byte)verticesMap.get(vertex).byteValue());
                    case 1 -> class_2516.method_23254((short)verticesMap.get(vertex).shortValue());
                    case 2 -> class_2497.method_23247((int)verticesMap.get(vertex));
                    default -> throw new IllegalStateException("Unexpected value: " + bestType);
                };
                facesList.add((Object)bestVal);
                float[] uv = BlockbenchModelParser.jsonToFloat(face.uv.getAsJsonArray(vertex));
                float u = uv[0] * texture.fixedSize[0];
                float v = uv[1] * texture.fixedSize[1];
                uvsList.add((Object)class_2494.method_23244((float)u));
                uvsList.add((Object)class_2494.method_23244((float)v));
            }
        }
        nbt.method_10566("vtx", (class_2520)verticesList);
        nbt.method_10566("tex", (class_2520)texesList);
        nbt.method_10566("fac", (class_2520)facesList);
        nbt.method_10566("uvs", (class_2520)uvsList);
        return nbt;
    }

    private static void reorderVertices(String[] vertexNames, Map<String, Integer> nameToIndex, class_2499 vertices) {
        BlockbenchModelParser.readVectors(vertexNames, nameToIndex, vertices);
        if (BlockbenchModelParser.testOppositeSides(v2, v3, v1, v4)) {
            String temp = vertexNames[2];
            vertexNames[2] = vertexNames[1];
            vertexNames[1] = vertexNames[0];
            vertexNames[0] = temp;
        } else if (BlockbenchModelParser.testOppositeSides(v1, v2, v3, v4)) {
            String temp = vertexNames[2];
            vertexNames[2] = vertexNames[1];
            vertexNames[1] = temp;
        }
    }

    private static void readVectors(String[] vertexNames, Map<String, Integer> nameToIndex, class_2499 vertices) {
        int i = nameToIndex.get(vertexNames[0]);
        v1.set(vertices.method_10604(3 * i), (double)vertices.method_10604(3 * i + 1), (double)vertices.method_10604(3 * i + 2));
        i = nameToIndex.get(vertexNames[1]);
        v2.set(vertices.method_10604(3 * i), (double)vertices.method_10604(3 * i + 1), (double)vertices.method_10604(3 * i + 2));
        i = nameToIndex.get(vertexNames[2]);
        v3.set(vertices.method_10604(3 * i), (double)vertices.method_10604(3 * i + 1), (double)vertices.method_10604(3 * i + 2));
        i = nameToIndex.get(vertexNames[3]);
        v4.set(vertices.method_10604(3 * i), (double)vertices.method_10604(3 * i + 1), (double)vertices.method_10604(3 * i + 2));
    }

    private static boolean testOppositeSides(FiguraVec3 linePoint1, FiguraVec3 linePoint2, FiguraVec3 point1, FiguraVec3 point2) {
        t1.set(linePoint1);
        t2.set(linePoint2);
        t3.set(point1);
        t4.set(point2);
        t2.subtract(t1);
        t3.subtract(t1);
        t4.subtract(t1);
        t1.set(t2);
        t1.cross(t3);
        t2.cross(t4);
        return t1.dot(t2) < 0.0;
    }

    private void parseAnimations(List<class_2487> list, BlockbenchModel.Animation[] animations, String modelName, String folders) {
        if (animations == null) {
            return;
        }
        int i = 0;
        for (BlockbenchModel.Animation animation : animations) {
            float loopDelay;
            float startDelay;
            float blend;
            float offset;
            class_2487 animNbt = new class_2487();
            animNbt.method_10582("mdl", (String)(folders.isBlank() ? modelName : folders + modelName));
            animNbt.method_10582("name", animation.name);
            if (!animation.loop.equals("once")) {
                animNbt.method_10582("loop", animation.loop);
            }
            if (animation.override != null && animation.override.booleanValue()) {
                animNbt.method_10556("ovr", true);
            }
            if (animation.length != 0.0f) {
                animNbt.method_10548("len", animation.length);
            }
            if ((offset = BlockbenchModelParser.toFloat(animation.anim_time_update, 0.0f)) != 0.0f) {
                animNbt.method_10548("off", offset);
            }
            if ((blend = BlockbenchModelParser.toFloat(animation.blend_weight, 1.0f)) != 1.0f) {
                animNbt.method_10548("bld", blend);
            }
            if ((startDelay = BlockbenchModelParser.toFloat(animation.start_delay, 0.0f)) != 0.0f) {
                animNbt.method_10548("sdel", startDelay);
            }
            if ((loopDelay = BlockbenchModelParser.toFloat(animation.loop_delay, 0.0f)) != 0.0f) {
                animNbt.method_10548("ldel", loopDelay);
            }
            if (animation.animators == null) {
                animation.animators = new JsonObject();
            }
            for (Map.Entry entry : animation.animators.entrySet()) {
                String id = (String)entry.getKey();
                boolean effect = id.equalsIgnoreCase("effects");
                class_2499 effectData = new class_2499();
                class_2499 rotData = new class_2499();
                class_2499 posData = new class_2499();
                class_2499 scaleData = new class_2499();
                JsonObject animationData = ((JsonElement)entry.getValue()).getAsJsonObject();
                for (JsonElement keyframeJson : animationData.get("keyframes").getAsJsonArray()) {
                    BlockbenchModel.KeyFrame keyFrame = (BlockbenchModel.KeyFrame)GSON.fromJson(keyframeJson, BlockbenchModel.KeyFrame.class);
                    class_2487 keyframeNbt = new class_2487();
                    keyframeNbt.method_10548("time", keyFrame.time);
                    if (effect) {
                        if (!keyFrame.channel.equalsIgnoreCase("timeline")) continue;
                        keyframeNbt.method_10582("src", keyFrame.data_points.get(0).getAsJsonObject().get("script").getAsString());
                        effectData.add((Object)keyframeNbt);
                        continue;
                    }
                    keyframeNbt.method_10582("int", keyFrame.interpolation);
                    JsonObject dataPoints = keyFrame.data_points.get(0).getAsJsonObject();
                    keyframeNbt.method_10566("pre", (class_2520)this.parseKeyFrameData(dataPoints, keyFrame.channel));
                    if (keyFrame.data_points.size() > 1) {
                        JsonObject endDataPoints = keyFrame.data_points.get(1).getAsJsonObject();
                        keyframeNbt.method_10566("end", (class_2520)this.parseKeyFrameData(endDataPoints, keyFrame.channel));
                    }
                    if (BlockbenchModelParser.notZero(keyFrame.bezier_left_value)) {
                        keyframeNbt.method_10566("bl", (class_2520)BlockbenchModelParser.toNbtList(keyFrame.bezier_left_value));
                    }
                    if (BlockbenchModelParser.notZero(keyFrame.bezier_right_value)) {
                        keyframeNbt.method_10566("br", (class_2520)BlockbenchModelParser.toNbtList(keyFrame.bezier_right_value));
                    }
                    if (BlockbenchModelParser.isDifferent(keyFrame.bezier_left_time, -0.1f)) {
                        keyframeNbt.method_10566("blt", (class_2520)BlockbenchModelParser.toNbtList(keyFrame.bezier_left_time));
                    }
                    if (BlockbenchModelParser.isDifferent(keyFrame.bezier_right_time, 0.1f)) {
                        keyframeNbt.method_10566("brt", (class_2520)BlockbenchModelParser.toNbtList(keyFrame.bezier_right_time));
                    }
                    switch (keyFrame.channel) {
                        case "position": {
                            posData.add((Object)keyframeNbt);
                            break;
                        }
                        case "rotation": {
                            rotData.add((Object)keyframeNbt);
                            break;
                        }
                        case "scale": {
                            scaleData.add((Object)keyframeNbt);
                        }
                    }
                }
                if (effect) {
                    animNbt.method_10566("code", (class_2520)effectData);
                    continue;
                }
                class_2499 partAnimations = this.animationMap.containsKey(id) ? this.animationMap.get(id) : new class_2499();
                class_2487 nbt = new class_2487();
                class_2487 channels = new class_2487();
                if (!rotData.isEmpty()) {
                    JsonElement globalRotJson = animationData.get("rotation_global");
                    if (globalRotJson != null && globalRotJson.getAsBoolean()) {
                        channels.method_10566("grot", (class_2520)rotData);
                    } else {
                        channels.method_10566("rot", (class_2520)rotData);
                    }
                }
                if (!posData.isEmpty()) {
                    channels.method_10566("pos", (class_2520)posData);
                }
                if (!scaleData.isEmpty()) {
                    channels.method_10566("scl", (class_2520)scaleData);
                }
                if (!channels.method_33133()) {
                    nbt.method_10569("id", i + this.animationOffset);
                    nbt.method_10566("data", (class_2520)channels);
                }
                if (!nbt.method_33133()) {
                    partAnimations.add((Object)nbt);
                }
                if (partAnimations.isEmpty()) continue;
                this.animationMap.put(id, partAnimations);
            }
            list.add(animNbt);
            ++i;
        }
        this.animationOffset += list.size();
    }

    /*
     * Enabled aggressive block sorting
     */
    private class_2499 parseKeyFrameData(JsonObject object, String channel) {
        BlockbenchModel.KeyFrameData frameData = (BlockbenchModel.KeyFrameData)GSON.fromJson((JsonElement)object, BlockbenchModel.KeyFrameData.class);
        float fallback = channel.equals("scale") ? 1.0f : 0.0f;
        Object x = BlockbenchModelParser.keyFrameData(frameData.x, fallback);
        Object y = BlockbenchModelParser.keyFrameData(frameData.y, fallback);
        Object z = BlockbenchModelParser.keyFrameData(frameData.z, fallback);
        class_2499 nbt = new class_2499();
        if (x instanceof Float) {
            Float xx = (Float)x;
            if (y instanceof Float) {
                Float yy = (Float)y;
                if (z instanceof Float) {
                    Float zz = (Float)z;
                    nbt.add((Object)class_2494.method_23244((float)xx.floatValue()));
                    nbt.add((Object)class_2494.method_23244((float)yy.floatValue()));
                    nbt.add((Object)class_2494.method_23244((float)zz.floatValue()));
                    return nbt;
                }
            }
        }
        nbt.add((Object)class_2519.method_23256((String)String.valueOf(x)));
        nbt.add((Object)class_2519.method_23256((String)String.valueOf(y)));
        nbt.add((Object)class_2519.method_23256((String)String.valueOf(z)));
        return nbt;
    }

    private class_2499 parseOutliner(JsonArray outliner, boolean parentVsb) {
        class_2499 children = new class_2499();
        if (outliner == null) {
            return children;
        }
        for (JsonElement element : outliner) {
            boolean thisVisibility;
            if (element instanceof JsonPrimitive) {
                String key = element.getAsString();
                if (!this.elementMap.containsKey(key)) continue;
                class_2487 elementNbt = this.elementMap.get(key);
                if (elementNbt.method_10545("vsb") && elementNbt.method_10577("vsb") == parentVsb) {
                    elementNbt.method_10551("vsb");
                }
                children.add((Object)elementNbt);
                continue;
            }
            class_2487 groupNbt = new class_2487();
            BlockbenchModel.GroupElement group = (BlockbenchModel.GroupElement)GSON.fromJson(element, BlockbenchModel.GroupElement.class);
            if (group.export != null && !group.export.booleanValue()) continue;
            groupNbt.method_10582("name", group.name);
            boolean bl = thisVisibility = group.visibility == null || group.visibility != false;
            if (thisVisibility != parentVsb) {
                groupNbt.method_10556("vsb", thisVisibility);
            }
            if (BlockbenchModelParser.notZero(group.origin)) {
                groupNbt.method_10566("piv", (class_2520)BlockbenchModelParser.toNbtList(group.origin));
            }
            if (BlockbenchModelParser.notZero(group.rotation)) {
                groupNbt.method_10566("rot", (class_2520)BlockbenchModelParser.toNbtList(group.rotation));
            }
            BlockbenchModelParser.parseParent(group.name, groupNbt);
            if (group.children != null && !group.children.isEmpty()) {
                groupNbt.method_10566("chld", (class_2520)this.parseOutliner(group.children, thisVisibility));
            }
            if (this.animationMap.containsKey(group.uuid)) {
                groupNbt.method_10566("anim", (class_2520)this.animationMap.get(group.uuid));
            }
            children.add((Object)groupNbt);
        }
        return children;
    }

    public static class_2499 toNbtList(float[] floats) {
        class_2499 list = new class_2499();
        int bestType = 0;
        for (float f : floats) {
            if (Math.rint(f) - (double)f == 0.0) {
                if (f < -127.0f || f >= 128.0f) {
                    bestType = 1;
                }
                if (!(f < -16383.0f) && !(f >= 16384.0f)) continue;
                bestType = 2;
                break;
            }
            bestType = 2;
            break;
        }
        block6: for (float f : floats) {
            switch (bestType) {
                case 0: {
                    list.add((Object)class_2481.method_23233((byte)((byte)f)));
                    continue block6;
                }
                case 1: {
                    list.add((Object)class_2516.method_23254((short)((short)f)));
                    continue block6;
                }
                case 2: {
                    list.add((Object)class_2494.method_23244((float)f));
                }
            }
        }
        return list;
    }

    public static boolean notZero(float[] floats) {
        return BlockbenchModelParser.isDifferent(floats, 0.0f);
    }

    public static boolean isDifferent(float[] floats, float value) {
        if (floats == null) {
            return false;
        }
        for (float f : floats) {
            if (f == value) continue;
            return true;
        }
        return false;
    }

    public static float toFloat(String input, float fallback) {
        try {
            return Float.parseFloat(input);
        }
        catch (Exception ignored) {
            return fallback;
        }
    }

    public static Object keyFrameData(String input, float fallback) {
        try {
            return Float.valueOf(Float.parseFloat(input));
        }
        catch (Exception ignored) {
            return input == null || input.isBlank() ? Float.valueOf(fallback) : input;
        }
    }

    public static int[] getTextureSize(byte[] texture) {
        int w = texture[16] & 0xFF;
        w = (w << 8) + (texture[17] & 0xFF);
        w = (w << 8) + (texture[18] & 0xFF);
        w = (w << 8) + (texture[19] & 0xFF);
        int h = texture[20] & 0xFF;
        h = (h << 8) + (texture[21] & 0xFF);
        h = (h << 8) + (texture[22] & 0xFF);
        h = (h << 8) + (texture[23] & 0xFF);
        return new int[]{w, h};
    }

    public static float[] jsonToFloat(JsonArray array) {
        float[] f = new float[array.size()];
        int i = 0;
        for (JsonElement element : array) {
            f[i] = element.isJsonNull() ? 0.0f : element.getAsFloat();
            ++i;
        }
        return f;
    }

    public record ModelData(class_2487 textures, List<class_2487> animationList, class_2487 modelNbt) {
    }

    private record TextureData(int id, float[] fixedSize) {
    }
}

