/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.parsers;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.minecraft.class_2487;
import net.minecraft.class_2497;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import org.figuramc.figura.FiguraMod;
import org.figuramc.figura.config.Configs;
import org.figuramc.figura.model.ParentType;
import org.figuramc.figura.model.rendering.texture.RenderTypes;
import org.figuramc.figura.parsers.BlockbenchModelParser;
import org.figuramc.figura.utils.PathUtils;
import org.figuramc.figura.utils.Version;

public class AvatarMetadataParser {
    private static final Gson GSON = new GsonBuilder().create();
    private static final Map<String, String> PARTS_TO_MOVE = new HashMap<String, String>();

    public static Metadata read(String json) {
        Metadata metadata = (Metadata)GSON.fromJson(json, Metadata.class);
        return metadata == null ? new Metadata() : metadata;
    }

    public static class_2487 parse(String json, String filename) {
        String name;
        int n;
        Metadata metadata = AvatarMetadataParser.read(json);
        class_2487 nbt = new class_2487();
        JsonElement jsonElement = JsonParser.parseString((String)json);
        if (jsonElement != null && !jsonElement.isJsonNull() && !jsonElement.getAsJsonObject().entrySet().isEmpty()) {
            for (Map.Entry jsonElementEntry : jsonElement.getAsJsonObject().entrySet()) {
                if (jsonElementEntry.getKey() == null || ((String)jsonElementEntry.getKey()).isBlank() || !((String)jsonElementEntry.getKey()).contains("badge_color_")) continue;
                nbt.method_10582((String)jsonElementEntry.getKey(), ((JsonElement)jsonElementEntry.getValue()).getAsString());
            }
        }
        Version version = new Version(metadata.version);
        if (version.invalid) {
            version = FiguraMod.VERSION;
        }
        nbt.method_10582("name", metadata.name == null || metadata.name.isBlank() ? filename : metadata.name);
        nbt.method_10582("ver", version.toString());
        if (metadata.color != null) {
            nbt.method_10582("color", metadata.color);
        }
        if (metadata.background != null) {
            nbt.method_10582("bg", metadata.background);
        }
        if (metadata.id != null) {
            nbt.method_10582("id", metadata.id);
        }
        if (metadata.authors != null) {
            StringBuilder authors = new StringBuilder();
            for (int i = 0; i < metadata.authors.length; ++i) {
                String name2 = metadata.authors[i];
                authors.append(name2);
                if (i >= metadata.authors.length - 1) continue;
                authors.append("\n");
            }
            nbt.method_10582("authors", authors.toString());
        } else {
            nbt.method_10582("authors", metadata.author == null ? "?" : metadata.author);
        }
        if (metadata.autoScripts != null) {
            class_2499 autoScripts = new class_2499();
            String[] stringArray = metadata.autoScripts;
            int n2 = stringArray.length;
            for (n = 0; n < n2; ++n) {
                name = stringArray[n];
                autoScripts.add((Object)class_2519.method_23256((String)PathUtils.computeSafeString(name.replaceAll("\\.lua$", ""))));
            }
            nbt.method_10566("autoScripts", (class_2520)autoScripts);
        }
        if ((Integer)Configs.FORMAT_SCRIPT.value >= 2) {
            nbt.method_10556("minify", true);
        }
        if (metadata.autoAnims != null) {
            class_2499 autoAnims = new class_2499();
            String[] stringArray = metadata.autoAnims;
            int n3 = stringArray.length;
            for (n = 0; n < n3; ++n) {
                name = stringArray[n];
                autoAnims.add((Object)class_2519.method_23256((String)name));
            }
            nbt.method_10566("autoAnims", (class_2520)autoAnims);
        }
        if (metadata.resources != null) {
            class_2499 resourcesPaths = new class_2499();
            for (String resource : metadata.resources) {
                resourcesPaths.add((Object)class_2519.method_23256((String)resource));
            }
            nbt.method_10566("resources_paths", (class_2520)resourcesPaths);
        }
        return nbt;
    }

    public static void injectToModels(String json, class_2487 models) throws IOException {
        PARTS_TO_MOVE.clear();
        Metadata metadata = (Metadata)GSON.fromJson(json, Metadata.class);
        if (metadata != null && metadata.customizations != null) {
            for (Map.Entry<String, Object> entry : metadata.customizations.entrySet()) {
                AvatarMetadataParser.injectCustomization(entry.getKey(), (Customization)entry.getValue(), models);
            }
        }
        for (Map.Entry<String, Object> entry : PARTS_TO_MOVE.entrySet()) {
            class_2487 modelPart = AvatarMetadataParser.getTag(models, entry.getKey(), true);
            class_2487 targetPart = AvatarMetadataParser.getTag(models, (String)entry.getValue(), false);
            class_2499 list = !targetPart.method_10545("chld") ? new class_2499() : targetPart.method_10554("chld", 10);
            list.add((Object)modelPart);
            targetPart.method_10566("chld", (class_2520)list);
        }
    }

    private static void injectCustomization(String path, Customization customization, class_2487 models) throws IOException {
        boolean remove = customization.remove != null && customization.remove != false;
        class_2487 modelPart = AvatarMetadataParser.getTag(models, path, remove);
        if (remove) {
            return;
        }
        if (customization.primaryRenderType != null) {
            try {
                modelPart.method_10582("primary", RenderTypes.valueOf(customization.primaryRenderType.toUpperCase(Locale.US)).name());
            }
            catch (Exception ignored) {
                throw new IOException("Invalid render type \"" + customization.primaryRenderType + "\"!");
            }
        }
        if (customization.secondaryRenderType != null) {
            try {
                modelPart.method_10582("secondary", RenderTypes.valueOf(customization.secondaryRenderType.toUpperCase(Locale.US)).name());
            }
            catch (Exception ignored) {
                throw new IOException("Invalid render type \"" + customization.secondaryRenderType + "\"!");
            }
        }
        if (customization.parentType != null) {
            ParentType type = ParentType.get(customization.parentType);
            if (type == ParentType.None) {
                modelPart.method_10551("pt");
            } else {
                modelPart.method_10582("pt", type.name());
            }
        }
        if (customization.moveTo != null) {
            PARTS_TO_MOVE.put(path, customization.moveTo);
        }
        if (customization.visible != null) {
            if (customization.visible.booleanValue()) {
                modelPart.method_10551("vsb");
            } else {
                modelPart.method_10556("vsb", false);
            }
        }
        if (customization.smooth != null) {
            modelPart.method_10556("smo", customization.smooth.booleanValue());
        }
    }

    private static class_2487 getTag(class_2487 models, String path, boolean remove) throws IOException {
        String[] keys = path.replaceFirst("^models", "").split("\\.", 0);
        class_2487 current = models;
        for (int i = 0; i < keys.length; ++i) {
            int j;
            if (keys[i].isEmpty()) continue;
            if (!current.method_10545("chld")) {
                throw new IOException("Invalid part path: \"" + path + "\"");
            }
            class_2499 children = current.method_10554("chld", 10);
            for (j = 0; j < children.size(); ++j) {
                class_2487 child = children.method_10602(j);
                if (child.method_10558("name").equals(keys[i])) {
                    current = child;
                    break;
                }
                if (j != children.size() - 1) continue;
                throw new IOException("Invalid part path: \"" + path + "\"");
            }
            if (!remove || i != keys.length - 1) continue;
            children.method_10536(j);
        }
        return current;
    }

    public static void injectToTextures(String json, class_2487 textures) {
        Metadata metadata = (Metadata)GSON.fromJson(json, Metadata.class);
        if (metadata == null || metadata.ignoredTextures == null) {
            return;
        }
        class_2487 src = textures.method_10562("src");
        for (String texture : metadata.ignoredTextures) {
            byte[] bytes = src.method_10547(texture);
            int[] size = BlockbenchModelParser.getTextureSize(bytes);
            class_2499 list = new class_2499();
            list.add((Object)class_2497.method_23247((int)size[0]));
            list.add((Object)class_2497.method_23247((int)size[1]));
            src.method_10566(texture, (class_2520)list);
        }
    }

    public static class Metadata {
        public String name;
        public String description;
        public String author;
        public String version;
        public String color;
        public String background;
        public String id;
        public String[] authors;
        public String[] autoScripts;
        public String[] autoAnims;
        public String[] ignoredTextures;
        public String[] resources;
        public HashMap<String, Customization> customizations;
    }

    public static class Customization {
        public String primaryRenderType;
        public String secondaryRenderType;
        public String parentType;
        public String moveTo;
        public Boolean visible;
        public Boolean remove;
        public Boolean smooth;
    }
}

