/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.model.rendering.texture;

import com.mojang.blaze3d.platform.TextureUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.util.Base64;
import java.util.UUID;
import net.minecraft.class_1011;
import net.minecraft.class_1044;
import net.minecraft.class_1049;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import net.minecraft.class_4573;
import org.figuramc.figura.FiguraMod;
import org.figuramc.figura.avatar.Avatar;
import org.figuramc.figura.lua.LuaNotNil;
import org.figuramc.figura.lua.LuaWhitelist;
import org.figuramc.figura.lua.docs.LuaMethodDoc;
import org.figuramc.figura.lua.docs.LuaMethodOverload;
import org.figuramc.figura.lua.docs.LuaTypeDoc;
import org.figuramc.figura.math.matrix.FiguraMat4;
import org.figuramc.figura.math.vector.FiguraVec2;
import org.figuramc.figura.math.vector.FiguraVec3;
import org.figuramc.figura.math.vector.FiguraVec4;
import org.figuramc.figura.mixin.render.TextureManagerAccessor;
import org.figuramc.figura.utils.ColorUtils;
import org.figuramc.figura.utils.FiguraIdentifier;
import org.figuramc.figura.utils.LuaUtils;
import org.luaj.vm2.LuaError;
import org.luaj.vm2.LuaFunction;
import org.luaj.vm2.LuaValue;
import org.lwjgl.BufferUtils;

@LuaWhitelist
@LuaTypeDoc(name="Texture", value="texture")
public class FiguraTexture
extends class_1049 {
    private boolean registered = false;
    private boolean dirty = true;
    private boolean modified = false;
    private final String name;
    private final Avatar owner;
    private final class_1011 texture;
    private class_1011 backup;
    private boolean isClosed = false;

    public FiguraTexture(Avatar owner, String name, byte[] data) {
        super((class_2960)new FiguraIdentifier("avatar_tex/" + owner.owner + "/" + UUID.randomUUID()));
        class_1011 image;
        try {
            ByteBuffer wrapper = BufferUtils.createByteBuffer((int)data.length);
            wrapper.put(data);
            wrapper.rewind();
            image = class_1011.method_4324((ByteBuffer)wrapper);
        }
        catch (IOException e) {
            FiguraMod.LOGGER.error("", (Throwable)e);
            image = new class_1011(1, 1, true);
        }
        this.texture = image;
        this.name = name;
        this.owner = owner;
    }

    public FiguraTexture(Avatar owner, String name, int width, int height) {
        super((class_2960)new FiguraIdentifier("avatar_tex/" + owner.owner + "/" + UUID.randomUUID()));
        this.texture = new class_1011(width, height, true);
        this.name = name;
        this.owner = owner;
    }

    public FiguraTexture(Avatar owner, String name, class_1011 image) {
        super((class_2960)new FiguraIdentifier("avatar_tex/" + owner.owner + "/custom/" + UUID.randomUUID()));
        this.texture = image;
        this.name = name;
        this.owner = owner;
    }

    public void method_4625(class_3300 manager) throws IOException {
    }

    public void close() {
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
        this.texture.close();
        if (this.backup != null) {
            this.backup.close();
        }
        this.method_4528();
        ((TextureManagerAccessor)class_310.method_1551().method_1531()).getByPath().remove(this.field_5224);
    }

    public void uploadIfDirty() {
        if (!this.registered) {
            class_310.method_1551().method_1531().method_4616(this.field_5224, (class_1044)this);
            this.registered = true;
        }
        if (this.dirty && !this.isClosed) {
            this.dirty = false;
            class_4573 runnable = () -> {
                TextureUtil.prepareImage((int)this.method_4624(), (int)this.texture.method_4307(), (int)this.texture.method_4323());
                this.texture.method_4301(0, 0, 0, false);
            };
            if (RenderSystem.isOnRenderThreadOrInit()) {
                runnable.execute();
            } else {
                RenderSystem.recordRenderCall((class_4573)runnable);
            }
        }
    }

    public void writeTexture(Path dest) throws IOException {
        this.texture.method_4314(dest);
    }

    private void backupImage() {
        this.modified = true;
        if (this.backup == null) {
            this.backup = this.copy();
        }
    }

    public class_1011 copy() {
        class_1011 image = new class_1011(this.texture.method_4318(), this.texture.method_4307(), this.texture.method_4323(), true);
        image.method_4317(this.texture);
        return image;
    }

    public int getWidth() {
        return this.texture.method_4307();
    }

    public int getHeight() {
        return this.texture.method_4323();
    }

    public class_2960 getLocation() {
        return this.field_5224;
    }

    private FiguraVec4 parseColor(String method, Object r, Double g, Double b, Double a) {
        return LuaUtils.parseVec4(method, r, g, b, a, 0.0, 0.0, 0.0, 1.0);
    }

    @LuaWhitelist
    @LuaMethodDoc(value="texture.get_name")
    public String getName() {
        return this.name;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="texture.get_path")
    public String getPath() {
        return this.getLocation().toString();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="texture.get_dimensions")
    public FiguraVec2 getDimensions() {
        return FiguraVec2.of(this.getWidth(), this.getHeight());
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={Integer.class, Integer.class}, argumentNames={"x", "y"})}, value="texture.get_pixel")
    public FiguraVec4 getPixel(int x, int y) {
        try {
            return ColorUtils.abgrToRGBA(this.texture.method_4315(x, y));
        }
        catch (Exception e) {
            throw new LuaError(e.getMessage());
        }
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={Integer.class, Integer.class, FiguraVec3.class}, argumentNames={"x", "y", "rgb"}), @LuaMethodOverload(argumentTypes={Integer.class, Integer.class, FiguraVec4.class}, argumentNames={"x", "y", "rgba"}), @LuaMethodOverload(argumentTypes={Integer.class, Integer.class, Double.class, Double.class, Double.class, Double.class}, argumentNames={"x", "y", "r", "g", "b", "a"})}, aliases={"pixel"}, value="texture.set_pixel")
    public FiguraTexture setPixel(int x, int y, Object r, Double g, Double b, Double a) {
        try {
            this.backupImage();
            this.texture.method_4305(x, y, ColorUtils.rgbaToIntABGR(this.parseColor("setPixel", r, g, b, a)));
            return this;
        }
        catch (Exception e) {
            throw new LuaError(e.getMessage());
        }
    }

    @LuaWhitelist
    public FiguraTexture pixel(int x, int y, Object r, Double g, Double b, Double a) {
        return this.setPixel(x, y, r, g, b, a);
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={Integer.class, Integer.class, Integer.class, Integer.class, FiguraVec3.class}, argumentNames={"x", "y", "width", "height", "rgb"}), @LuaMethodOverload(argumentTypes={Integer.class, Integer.class, Integer.class, Integer.class, FiguraVec4.class}, argumentNames={"x", "y", "width", "height", "rgba"}), @LuaMethodOverload(argumentTypes={Integer.class, Integer.class, Integer.class, Integer.class, Double.class, Double.class, Double.class, Double.class}, argumentNames={"x", "y", "width", "height", "r", "g", "b", "a"})}, value="texture.fill")
    public FiguraTexture fill(int x, int y, int width, int height, Object r, Double g, Double b, Double a) {
        try {
            this.backupImage();
            this.texture.method_4326(x, y, width, height, ColorUtils.rgbaToIntABGR(this.parseColor("fill", r, g, b, a)));
            return this;
        }
        catch (Exception e) {
            throw new LuaError(e.getMessage());
        }
    }

    @LuaWhitelist
    @LuaMethodDoc(value="texture.update")
    public FiguraTexture update() {
        this.dirty = true;
        return this;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="texture.restore")
    public FiguraTexture restore() {
        if (this.modified) {
            this.texture.method_4317(this.backup);
            this.modified = false;
        }
        return this;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="texture.save")
    public String save() {
        try {
            return Base64.getEncoder().encodeToString(this.texture.method_24036());
        }
        catch (Exception e) {
            throw new LuaError(e.getMessage());
        }
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={Integer.class, Integer.class, Integer.class, Integer.class, LuaFunction.class}, argumentNames={"x", "y", "width", "height", "func"})}, value="texture.apply_func")
    public FiguraTexture applyFunc(int x, int y, int width, int height, @LuaNotNil LuaFunction function) {
        for (int i = y; i < y + height; ++i) {
            for (int j = x; j < x + width; ++j) {
                FiguraVec4 color = this.getPixel(j, i);
                LuaValue result = function.call(this.owner.luaRuntime.typeManager.javaToLua(color).arg1(), (LuaValue)LuaValue.valueOf((int)j), (LuaValue)LuaValue.valueOf((int)i));
                if (result.isnil() || !result.isuserdata(FiguraVec4.class)) continue;
                this.setPixel(j, i, result.checkuserdata(FiguraVec4.class), null, null, null);
            }
        }
        return this;
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={Integer.class, Integer.class, Integer.class, Integer.class, FiguraMat4.class, Boolean.class}, argumentNames={"x", "y", "width", "height", "matrix", "clip"})}, value="texture.apply_matrix")
    public FiguraTexture applyMatrix(int x, int y, int width, int height, @LuaNotNil FiguraMat4 matrix, boolean clip) {
        for (int i = y; i < y + height; ++i) {
            for (int j = x; j < x + width; ++j) {
                FiguraVec4 color = this.getPixel(j, i);
                color.transform(matrix);
                if (clip) {
                    color.x = Math.max(0.0, Math.min(color.x, 1.0));
                    color.y = Math.max(0.0, Math.min(color.y, 1.0));
                    color.z = Math.max(0.0, Math.min(color.z, 1.0));
                    color.w = Math.max(0.0, Math.min(color.w, 1.0));
                }
                this.setPixel(j, i, color, null, null, null);
            }
        }
        return this;
    }

    @LuaWhitelist
    public Object __index(String arg) {
        return "name".equals(arg) ? this.name : null;
    }

    public String toString() {
        return this.name + " (" + this.getWidth() + "x" + this.getHeight() + ") (Texture)";
    }
}

