/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.mixin.sound;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.class_1113;
import net.minecraft.class_1140;
import net.minecraft.class_1144;
import net.minecraft.class_1145;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_315;
import net.minecraft.class_3300;
import net.minecraft.class_3419;
import net.minecraft.class_359;
import net.minecraft.class_4224;
import net.minecraft.class_4225;
import net.minecraft.class_4227;
import net.minecraft.class_4235;
import net.minecraft.class_4237;
import net.minecraft.class_4238;
import org.figuramc.figura.avatar.AvatarManager;
import org.figuramc.figura.ducks.ChannelHandleAccessor;
import org.figuramc.figura.ducks.SoundEngineAccessor;
import org.figuramc.figura.ducks.SubtitleOverlayAccessor;
import org.figuramc.figura.lua.api.sound.LuaSound;
import org.figuramc.figura.math.vector.FiguraVec3;
import org.figuramc.figura.permissions.Permissions;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Intrinsic;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1140.class})
public abstract class SoundEngineMixin
implements SoundEngineAccessor {
    @Shadow
    @Final
    private class_4225 field_18945;
    @Shadow
    @Final
    private class_4238 field_18948;
    @Shadow
    @Final
    private class_4237 field_18947;
    @Shadow
    private boolean field_5563;
    @Shadow
    private class_4227 field_18946;
    @Shadow
    @Final
    private List<class_1145> field_5558;
    @Unique
    private class_4235 figuraChannel;
    @Unique
    private final List<LuaSound> figuraHandlers = Collections.synchronizedList(new ArrayList());

    @Shadow
    protected abstract float method_4850(@Nullable class_3419 var1);

    @Shadow
    public abstract void method_4855(class_1145 var1);

    @Inject(at={@At(value="RETURN")}, method={"<init>"})
    private void soundEngineInit(class_1144 loader, class_315 settings, class_3300 resourceManager, CallbackInfo ci) {
        this.figuraChannel = new class_4235(this.field_18945, (Executor)this.field_18948);
    }

    @Inject(at={@At(value="RETURN")}, method={"tick"})
    private void tick(boolean bl, CallbackInfo ci) {
        this.figuraChannel.method_19722();
    }

    @Inject(at={@At(value="RETURN")}, method={"tickNonPaused"})
    private void tickNonPaused(CallbackInfo ci) {
        Iterator<LuaSound> iterator = this.figuraHandlers.iterator();
        while (iterator.hasNext()) {
            LuaSound sound = iterator.next();
            class_4235.class_4236 handle = sound.getHandle();
            if (handle == null) {
                iterator.remove();
                continue;
            }
            if (this.method_4850(class_3419.field_15248) <= 0.0f) {
                handle.method_19735(class_4224::method_19655);
                iterator.remove();
                continue;
            }
            if (!handle.method_19732()) continue;
            iterator.remove();
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"stopAll"})
    private void stopAll(CallbackInfo ci) {
        this.figura$stopAllSounds();
    }

    @Inject(at={@At(value="RETURN")}, method={"pause"})
    private void pause(CallbackInfo ci) {
        if (this.field_5563) {
            this.figuraChannel.method_19727(stream -> stream.forEach(class_4224::method_19653));
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"resume"})
    private void resume(CallbackInfo ci) {
        if (this.field_5563) {
            this.figuraChannel.method_19727(stream -> stream.forEach(class_4224::method_19654));
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"updateCategoryVolume"})
    private void updateCategoryVolume(class_3419 category, float volume, CallbackInfo ci) {
        if (!this.field_5563 || category != class_3419.field_15248) {
            return;
        }
        for (LuaSound sound : this.figuraHandlers) {
            sound.volume(sound.getVolume());
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"stop(Lnet/minecraft/resources/ResourceLocation;Lnet/minecraft/sounds/SoundSource;)V"})
    private void stop(class_2960 id, class_3419 category, CallbackInfo ci) {
        if (category == class_3419.field_15248) {
            this.figura$stopAllSounds();
        }
    }

    @Inject(at={@At(value="INVOKE", target="Ljava/util/List;isEmpty()Z")}, method={"play"}, cancellable=true)
    public void play(class_1113 sound, CallbackInfo c) {
        float g = Math.max(sound.method_4781(), 1.0f) * (float)sound.method_4776().method_4770();
        class_243 pos = new class_243(sound.method_4784(), sound.method_4779(), sound.method_4778());
        if (sound.method_4787() || sound.method_4777() == class_1113.class_1114.field_5478 || this.field_18946.method_27268().method_1025(pos) < (double)(g * g)) {
            AvatarManager.executeAll("playSoundEvent", avatar -> {
                boolean cancel = avatar.playSoundEvent(sound.method_4775().toString(), FiguraVec3.fromVec3(pos), sound.method_4781(), sound.method_4782(), sound.method_4786(), sound.method_4774().name(), sound.method_4776().method_4767().toString());
                if (avatar.permissions.get(Permissions.CANCEL_SOUNDS) >= 1) {
                    avatar.noPermissions.remove(Permissions.CANCEL_SOUNDS);
                    if (cancel) {
                        c.cancel();
                    }
                } else {
                    avatar.noPermissions.add(Permissions.CANCEL_SOUNDS);
                }
            });
        }
    }

    @Override
    @Intrinsic
    public void figura$addSound(LuaSound sound) {
        this.figuraHandlers.add(sound);
        for (class_1145 listener : this.field_5558) {
            if (!(listener instanceof class_359)) continue;
            class_359 overlay = (class_359)listener;
            ((SubtitleOverlayAccessor)overlay).figura$PlaySound(sound);
        }
    }

    @Override
    @Intrinsic
    public void figura$stopSound(UUID owner, String name) {
        if (!this.field_5563) {
            return;
        }
        Iterator<LuaSound> iterator = this.figuraHandlers.iterator();
        while (iterator.hasNext()) {
            LuaSound sound = iterator.next();
            ChannelHandleAccessor accessor = (ChannelHandleAccessor)sound.getHandle();
            if (accessor == null || owner != null && (!accessor.getOwner().equals(owner) || name != null && !accessor.getName().equals(name))) continue;
            sound.stop();
            iterator.remove();
        }
    }

    @Override
    @Intrinsic
    public void figura$stopAllSounds() {
        if (this.field_5563) {
            for (LuaSound sound : this.figuraHandlers) {
                sound.stop();
            }
            this.figuraHandlers.clear();
            this.figuraChannel.method_19728();
        }
    }

    @Override
    @Intrinsic
    public class_4235.class_4236 figura$createHandle(UUID owner, String name, class_4225.class_4105 pool) {
        return (class_4235.class_4236)((CompletableFuture)this.figuraChannel.method_19723(pool).thenApply(channelHandle -> {
            if (channelHandle != null) {
                ((ChannelHandleAccessor)channelHandle).setOwner(owner);
                ((ChannelHandleAccessor)channelHandle).setName(name);
            }
            return channelHandle;
        })).join();
    }

    @Override
    @Intrinsic
    public float figura$getVolume(class_3419 category) {
        return this.method_4850(category);
    }

    @Override
    @Intrinsic
    public class_4237 figura$getSoundBuffers() {
        return this.field_18947;
    }

    @Override
    @Intrinsic
    public boolean figura$isPlaying(UUID owner) {
        if (!this.field_5563) {
            return false;
        }
        for (LuaSound sound : List.copyOf(this.figuraHandlers)) {
            ChannelHandleAccessor accessor = (ChannelHandleAccessor)sound.getHandle();
            if (!sound.isPlaying() || accessor == null || !accessor.getOwner().equals(owner)) continue;
            return true;
        }
        return false;
    }
}

