/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.mixin.render;

import net.minecraft.class_1159;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4599;
import net.minecraft.class_4618;
import net.minecraft.class_757;
import net.minecraft.class_761;
import net.minecraft.class_765;
import net.minecraft.class_897;
import net.minecraft.class_898;
import org.figuramc.figura.FiguraMod;
import org.figuramc.figura.avatar.Avatar;
import org.figuramc.figura.avatar.AvatarManager;
import org.figuramc.figura.config.Configs;
import org.figuramc.figura.math.vector.FiguraVec4;
import org.figuramc.figura.mixin.render.PoseStackAccessor;
import org.figuramc.figura.model.rendering.EntityRenderMode;
import org.figuramc.figura.utils.ColorUtils;
import org.figuramc.figura.utils.RenderUtils;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_761.class})
public abstract class LevelRendererMixin {
    @Shadow
    @Final
    private class_898 field_4109;
    @Shadow
    @Final
    private class_4599 field_20951;
    @Shadow
    @Final
    private class_310 field_4088;

    @ModifyArg(method={"renderLevel"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/renderer/LevelRenderer;renderEntity(Lnet/minecraft/world/entity/Entity;DDDFLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;)V"))
    private class_1297 renderLevelRenderEntity(class_1297 entity) {
        Avatar avatar = AvatarManager.getAvatar(entity);
        if (avatar != null) {
            avatar.renderMode = EntityRenderMode.RENDER;
        }
        return entity;
    }

    @Inject(method={"renderEntity"}, at={@At(value="HEAD")})
    private void renderEntity(class_1297 entity, double cameraX, double cameraY, double cameraZ, float tickDelta, class_4587 matrices, class_4597 bufferSource, CallbackInfo ci) {
        Avatar avatar = AvatarManager.getAvatar(entity);
        if (avatar == null) {
            return;
        }
        if (bufferSource instanceof class_4618) {
            class_4618 outline = (class_4618)bufferSource;
            if (RenderUtils.vanillaModelAndScript(avatar) && avatar.luaRuntime.renderer.outlineColor != null) {
                int i = ColorUtils.rgbToInt(avatar.luaRuntime.renderer.outlineColor);
                outline.method_23286(i >> 16 & 0xFF, i >> 8 & 0xFF, i & 0xFF, 255);
            }
        }
        FiguraMod.pushProfiler("figura");
        FiguraMod.pushProfiler(avatar);
        FiguraMod.pushProfiler("worldRender");
        avatar.worldRender(entity, cameraX, cameraY, cameraZ, matrices, bufferSource, this.field_4109.method_23839(entity, tickDelta), tickDelta, EntityRenderMode.WORLD);
        FiguraMod.popProfiler(3);
    }

    @Inject(method={"renderLevel"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/LevelRenderer;checkPoseStack(Lcom/mojang/blaze3d/vertex/PoseStack;)V", ordinal=0)})
    private void renderLevelFirstPerson(class_4587 stack, float tickDelta, long limitTime, boolean renderBlockOutline, class_4184 camera, class_757 gameRenderer, class_765 lightTexture, class_1159 matrix4f, CallbackInfo ci) {
        class_1309 livingEntity;
        class_4597.class_4598 bufferSource;
        block7: {
            block6: {
                if (camera.method_19333()) {
                    return;
                }
                class_1297 e = camera.method_19331();
                Avatar avatar = AvatarManager.getAvatar(e);
                if (avatar == null) {
                    return;
                }
                bufferSource = this.field_20951.method_23000();
                avatar.firstPersonWorldRender(e, (class_4597)bufferSource, stack, camera, tickDelta);
                if (!(e instanceof class_1309)) break block6;
                livingEntity = (class_1309)e;
                if (((Boolean)Configs.FIRST_PERSON_MATRICES.value).booleanValue()) break block7;
            }
            return;
        }
        Avatar.firstPerson = true;
        int size = ((PoseStackAccessor)stack).getPoseStack().size();
        stack.method_22903();
        class_897 entityRenderer = this.field_4109.method_3953((class_1297)livingEntity);
        class_243 offset = entityRenderer.method_23169((class_1297)livingEntity, tickDelta);
        class_243 cam = camera.method_19326();
        stack.method_22904(class_3532.method_16436((double)tickDelta, (double)livingEntity.field_6038, (double)livingEntity.method_23317()) - cam.method_10216() + offset.method_10216(), class_3532.method_16436((double)tickDelta, (double)livingEntity.field_5971, (double)livingEntity.method_23318()) - cam.method_10214() + offset.method_10214(), class_3532.method_16436((double)tickDelta, (double)livingEntity.field_5989, (double)livingEntity.method_23321()) - cam.method_10215() + offset.method_10215());
        float yaw = class_3532.method_16439((float)tickDelta, (float)livingEntity.field_5982, (float)livingEntity.method_36454());
        entityRenderer.method_3936((class_1297)livingEntity, yaw, tickDelta, stack, (class_4597)bufferSource, 0xF000F0);
        do {
            stack.method_22909();
        } while (((PoseStackAccessor)stack).getPoseStack().size() > size);
        Avatar.firstPerson = false;
    }

    @Inject(method={"renderLevel"}, at={@At(value="HEAD")})
    private void onRenderLevel(class_4587 matrices, float tickDelta, long limitTime, boolean renderBlockOutline, class_4184 camera, class_757 gameRenderer, class_765 lightTexture, class_1159 matrix4f, CallbackInfo ci) {
        AvatarManager.executeAll("worldRender", avatar -> avatar.render(tickDelta));
    }

    @Inject(method={"renderLevel"}, at={@At(value="RETURN")})
    private void afterRenderLevel(class_4587 matrices, float tickDelta, long limitTime, boolean renderBlockOutline, class_4184 camera, class_757 gameRenderer, class_765 lightTexture, class_1159 matrix4f, CallbackInfo ci) {
        AvatarManager.executeAll("postWorldRender", avatar -> avatar.postWorldRenderEvent(tickDelta));
    }

    @ModifyArg(method={"renderHitOutline"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/renderer/LevelRenderer;renderShape(Lcom/mojang/blaze3d/vertex/PoseStack;Lcom/mojang/blaze3d/vertex/VertexConsumer;Lnet/minecraft/world/phys/shapes/VoxelShape;DDDFFFF)V"), index=6)
    private float renderHitOutlineX(float x) {
        FiguraVec4 color;
        Avatar avatar = AvatarManager.getAvatar(this.field_4088.method_1560());
        if (avatar == null || avatar.luaRuntime == null || (color = avatar.luaRuntime.renderer.blockOutlineColor) == null) {
            return x;
        }
        return (float)color.x;
    }

    @ModifyArg(method={"renderHitOutline"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/renderer/LevelRenderer;renderShape(Lcom/mojang/blaze3d/vertex/PoseStack;Lcom/mojang/blaze3d/vertex/VertexConsumer;Lnet/minecraft/world/phys/shapes/VoxelShape;DDDFFFF)V"), index=7)
    private float renderHitOutlineY(float y) {
        FiguraVec4 color;
        Avatar avatar = AvatarManager.getAvatar(this.field_4088.method_1560());
        if (avatar == null || avatar.luaRuntime == null || (color = avatar.luaRuntime.renderer.blockOutlineColor) == null) {
            return y;
        }
        return (float)color.y;
    }

    @ModifyArg(method={"renderHitOutline"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/renderer/LevelRenderer;renderShape(Lcom/mojang/blaze3d/vertex/PoseStack;Lcom/mojang/blaze3d/vertex/VertexConsumer;Lnet/minecraft/world/phys/shapes/VoxelShape;DDDFFFF)V"), index=8)
    private float renderHitOutlineZ(float z) {
        FiguraVec4 color;
        Avatar avatar = AvatarManager.getAvatar(this.field_4088.method_1560());
        if (avatar == null || avatar.luaRuntime == null || (color = avatar.luaRuntime.renderer.blockOutlineColor) == null) {
            return z;
        }
        return (float)color.z;
    }

    @ModifyArg(method={"renderHitOutline"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/renderer/LevelRenderer;renderShape(Lcom/mojang/blaze3d/vertex/PoseStack;Lcom/mojang/blaze3d/vertex/VertexConsumer;Lnet/minecraft/world/phys/shapes/VoxelShape;DDDFFFF)V"), index=9)
    private float renderHitOutlineW(float w) {
        FiguraVec4 color;
        Avatar avatar = AvatarManager.getAvatar(this.field_4088.method_1560());
        if (avatar == null || avatar.luaRuntime == null || (color = avatar.luaRuntime.renderer.blockOutlineColor) == null) {
            return w;
        }
        return (float)color.w;
    }
}

