/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.mixin.gui;

import java.util.UUID;
import java.util.regex.Pattern;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_310;
import net.minecraft.class_355;
import net.minecraft.class_4587;
import net.minecraft.class_5348;
import net.minecraft.class_640;
import net.minecraft.class_922;
import org.figuramc.figura.avatar.Avatar;
import org.figuramc.figura.avatar.AvatarManager;
import org.figuramc.figura.avatar.Badges;
import org.figuramc.figura.config.Configs;
import org.figuramc.figura.lua.api.nameplate.NameplateCustomization;
import org.figuramc.figura.permissions.Permissions;
import org.figuramc.figura.utils.TextUtils;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_355.class})
public class PlayerTabOverlayMixin {
    @Shadow
    @Final
    private class_310 field_2155;
    @Unique
    private UUID uuid;

    @Inject(at={@At(value="RETURN")}, method={"getNameForDisplay"}, cancellable=true)
    private void getPlayerName(class_640 playerInfo, CallbackInfoReturnable<class_2561> cir) {
        int config = (Integer)Configs.LIST_NAMEPLATE.value;
        if (config == 0 || AvatarManager.panic) {
            return;
        }
        class_2561 text = (class_2561)cir.getReturnValue();
        class_2585 name = new class_2585(playerInfo.method_2966().getName());
        UUID uuid = playerInfo.method_2966().getId();
        Avatar avatar = AvatarManager.getAvatarForPlayer(uuid);
        NameplateCustomization custom = avatar == null || avatar.luaRuntime == null ? null : avatar.luaRuntime.nameplate.LIST;
        class_2585 replacement = custom != null && custom.getJson() != null && avatar.permissions.get(Permissions.NAMEPLATE_EDIT) == 1 ? TextUtils.replaceInText((class_5348)custom.getJson().method_27661(), "\n|\\\\n", " ") : name;
        replacement = TextUtils.replaceInText((class_5348)replacement, "\\$\\{name\\}", name);
        replacement = Badges.appendBadges((class_2561)replacement, uuid, config > 1);
        replacement = TextUtils.trim((class_5348)replacement);
        text = TextUtils.replaceInText((class_5348)text, "\\b" + Pattern.quote(playerInfo.method_2966().getName()) + "\\b", replacement);
        cir.setReturnValue((Object)text);
    }

    @ModifyArg(at=@At(value="INVOKE", target="Lnet/minecraft/client/multiplayer/ClientLevel;getPlayerByUUID(Ljava/util/UUID;)Lnet/minecraft/world/entity/player/Player;"), method={"render"})
    private UUID getPlayerByUUID(UUID id) {
        this.uuid = id;
        return id;
    }

    @ModifyArg(method={"render"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiComponent;blit(Lcom/mojang/blaze3d/vertex/PoseStack;IIIIFFIIII)V"), index=3)
    private int doNotDrawFace(class_4587 p_93161_, int p_93162_, int p_93163_, int p_93164_, int p_93165_, float p_93166_, float p_93167_, int p_93168_, int p_93169_, int p_93170_, int p_93171_) {
        if (this.uuid != null) {
            boolean upsideDown;
            Avatar avatar = AvatarManager.getAvatarForPlayer(this.uuid);
            class_1657 player = this.field_2155.field_1687.method_18470(this.uuid);
            boolean bl = upsideDown = player != null && class_922.method_38563((class_1309)player);
            if (avatar != null && avatar.renderPortrait(p_93161_, p_93162_, p_93163_, p_93164_, 16.0f, upsideDown)) {
                return 0;
            }
        }
        return p_93164_;
    }
}

