/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.mixin.gui;

import com.mojang.datafixers.util.Pair;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Pattern;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_338;
import net.minecraft.class_5348;
import org.figuramc.figura.FiguraMod;
import org.figuramc.figura.avatar.Avatar;
import org.figuramc.figura.avatar.AvatarManager;
import org.figuramc.figura.avatar.Badges;
import org.figuramc.figura.config.Configs;
import org.figuramc.figura.font.Emojis;
import org.figuramc.figura.lua.api.nameplate.NameplateCustomization;
import org.figuramc.figura.permissions.Permissions;
import org.figuramc.figura.utils.EntityUtils;
import org.figuramc.figura.utils.TextUtils;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;

@Mixin(value={class_338.class})
public class ChatComponentMixin {
    @Unique
    private Integer color;
    @Unique
    private int currColor;

    @ModifyVariable(at=@At(value="HEAD"), method={"addMessage(Lnet/minecraft/network/chat/Component;IIZ)V"}, ordinal=0, argsOnly=true)
    private class_2561 addMessage(class_2561 message, class_2561 msg, int k, int timestamp, boolean refresh) {
        int config;
        if (refresh) {
            return message;
        }
        this.color = null;
        if (AvatarManager.panic) {
            return message;
        }
        Avatar localPlayer = AvatarManager.getAvatarForPlayer(FiguraMod.getLocalPlayerUUID());
        if (localPlayer != null) {
            String json = class_2561.class_2562.method_10867((class_2561)message);
            Pair<String, Integer> event = localPlayer.chatReceivedMessageEvent(message.getString(), json);
            if (event != null) {
                String newMessage = (String)event.getFirst();
                if (newMessage == null) {
                    return null;
                }
                if (!json.equals(newMessage)) {
                    TextUtils.allowScriptEvents = true;
                    message = TextUtils.tryParseJson(newMessage);
                    TextUtils.allowScriptEvents = false;
                }
                this.color = (Integer)event.getSecond();
            }
        }
        if (!FiguraMod.parseMessages) {
            return message;
        }
        if ((Integer)Configs.EMOJIS.value > 0) {
            message = Emojis.applyEmojis(message);
        }
        if ((config = ((Integer)Configs.CHAT_NAMEPLATE.value).intValue()) == 0) {
            return message;
        }
        message = TextUtils.parseLegacyFormatting((class_5348)message);
        Map<String, UUID> players = EntityUtils.getPlayerList();
        String owner = null;
        String msgString = message.getString();
        String[] split = msgString.split("\\W+");
        for (String s2 : split) {
            if (!players.containsKey(s2)) continue;
            owner = s2;
            break;
        }
        for (Map.Entry entry : players.entrySet()) {
            NameplateCustomization custom;
            String name = (String)entry.getKey();
            if (!msgString.toLowerCase(Locale.US).contains(name.toLowerCase(Locale.US))) continue;
            UUID uuid = (UUID)entry.getValue();
            boolean isOwner = name.equals(owner);
            class_2585 playerName = new class_2585(name);
            Avatar avatar = AvatarManager.getAvatarForPlayer(uuid);
            NameplateCustomization nameplateCustomization = custom = avatar == null || avatar.luaRuntime == null ? null : avatar.luaRuntime.nameplate.CHAT;
            if (custom == null && config < 2) continue;
            class_2585 replacement = custom != null && custom.getJson() != null && avatar.permissions.get(Permissions.NAMEPLATE_EDIT) == 1 ? TextUtils.replaceInText((class_5348)custom.getJson().method_27661(), "\n|\\\\n", " ") : playerName;
            replacement = TextUtils.replaceInText((class_5348)replacement, "\\$\\{name\\}", playerName);
            class_2561 emptyReplacement = Badges.appendBadges((class_2561)replacement, uuid, config > 1 && owner == null);
            emptyReplacement = TextUtils.trim((class_5348)emptyReplacement);
            String quotedName = "(?i)\\b" + Pattern.quote(name) + "\\b";
            message = TextUtils.replaceInText((class_5348)message, quotedName, emptyReplacement, (s, style) -> true, isOwner ? 1 : 0, Integer.MAX_VALUE);
            if (config <= 1 || !isOwner) continue;
            class_2561 temp = Badges.appendBadges((class_2561)replacement, uuid, true);
            temp = TextUtils.trim((class_5348)temp);
            message = TextUtils.replaceInText((class_5348)message, quotedName, temp, (s, style) -> true, 1);
        }
        return message;
    }
}

