/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.math.vector;

import org.figuramc.figura.lua.LuaNotNil;
import org.figuramc.figura.lua.LuaWhitelist;
import org.figuramc.figura.lua.docs.LuaFieldDoc;
import org.figuramc.figura.lua.docs.LuaMetamethodDoc;
import org.figuramc.figura.lua.docs.LuaMethodDoc;
import org.figuramc.figura.lua.docs.LuaMethodOverload;
import org.figuramc.figura.lua.docs.LuaTypeDoc;
import org.figuramc.figura.math.matrix.FiguraMat4;
import org.figuramc.figura.math.vector.FiguraVector;
import org.figuramc.figura.utils.MathUtils;
import org.luaj.vm2.LuaError;
import org.luaj.vm2.LuaFunction;
import org.luaj.vm2.LuaValue;

@LuaWhitelist
@LuaTypeDoc(name="Vector4", value="vector4")
public class FiguraVec4
extends FiguraVector<FiguraVec4, FiguraMat4> {
    @LuaWhitelist
    @LuaFieldDoc(value="vector_n.x")
    public double x;
    @LuaWhitelist
    @LuaFieldDoc(value="vector_n.y")
    public double y;
    @LuaWhitelist
    @LuaFieldDoc(value="vector_n.z")
    public double z;
    @LuaWhitelist
    @LuaFieldDoc(value="vector_n.w")
    public double w;

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(returnType=FiguraVec4.class)}, value="vector_n.reset")
    public FiguraVec4 reset() {
        this.w = 0.0;
        this.z = 0.0;
        this.y = 0.0;
        this.x = 0.0;
        return this;
    }

    public static FiguraVec4 of() {
        return new FiguraVec4();
    }

    public static FiguraVec4 of(double x, double y, double z, double w) {
        return FiguraVec4.of().set(x, y, z, w);
    }

    @Override
    public FiguraVec4 set(FiguraVec4 other) {
        return this.set(other.x, other.y, other.z, other.w);
    }

    public FiguraVec4 set(double x, double y, double z, double w) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
        return this;
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={FiguraVec4.class}, argumentNames={"vec"}), @LuaMethodOverload(argumentTypes={Double.class, Double.class, Double.class, Double.class}, argumentNames={"x", "y", "z", "w"})}, value="vector_n.set")
    public FiguraVec4 set(@LuaNotNil Object x, double y, double z, double w) {
        if (x instanceof FiguraVec4) {
            FiguraVec4 vec = (FiguraVec4)x;
            return this.set(vec);
        }
        if (x instanceof Number) {
            Number n = (Number)x;
            return this.set(n.doubleValue(), y, z, w);
        }
        throw new LuaError("Illegal type to set(): " + x.getClass().getSimpleName());
    }

    @Override
    public FiguraVec4 add(FiguraVec4 other) {
        return this.add(other.x, other.y, other.z, other.w);
    }

    public FiguraVec4 add(double x, double y, double z, double w) {
        this.x += x;
        this.y += y;
        this.z += z;
        this.w += w;
        return this;
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={FiguraVec4.class}, argumentNames={"vec"}), @LuaMethodOverload(argumentTypes={Double.class, Double.class, Double.class, Double.class}, argumentNames={"x", "y", "z", "w"})}, value="vector_n.add")
    public FiguraVec4 add(@LuaNotNil Object x, double y, double z, double w) {
        if (x instanceof FiguraVec4) {
            FiguraVec4 vec = (FiguraVec4)x;
            return this.add(vec);
        }
        if (x instanceof Number) {
            Number n = (Number)x;
            return this.add(n.doubleValue(), y, z, w);
        }
        throw new LuaError("Illegal type to add(): " + x.getClass().getSimpleName());
    }

    @Override
    public FiguraVec4 subtract(FiguraVec4 other) {
        return this.subtract(other.x, other.y, other.z, other.w);
    }

    public FiguraVec4 subtract(double x, double y, double z, double w) {
        this.x -= x;
        this.y -= y;
        this.z -= z;
        this.w -= w;
        return this;
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={FiguraVec4.class}, argumentNames={"vec"}), @LuaMethodOverload(argumentTypes={Double.class, Double.class, Double.class, Double.class}, argumentNames={"x", "y", "z", "w"})}, value="vector_n.sub")
    public FiguraVec4 sub(@LuaNotNil Object x, double y, double z, double w) {
        if (x instanceof FiguraVec4) {
            FiguraVec4 vec = (FiguraVec4)x;
            return this.subtract(vec);
        }
        if (x instanceof Number) {
            Number n = (Number)x;
            return this.subtract(n.doubleValue(), y, z, w);
        }
        throw new LuaError("Illegal type to sub(): " + x.getClass().getSimpleName());
    }

    @Override
    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={Double.class}, argumentNames={"factor"}, returnType=FiguraVec4.class)}, value="vector_n.offset")
    public FiguraVec4 offset(double factor) {
        this.x += factor;
        this.y += factor;
        this.z += factor;
        this.w += factor;
        return this;
    }

    @Override
    public FiguraVec4 multiply(FiguraVec4 other) {
        return this.multiply(other.x, other.y, other.z, other.w);
    }

    public FiguraVec4 multiply(double x, double y, double z, double w) {
        this.x *= x;
        this.y *= y;
        this.z *= z;
        this.w *= w;
        return this;
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={FiguraVec4.class}, argumentNames={"vec"}), @LuaMethodOverload(argumentTypes={Double.class, Double.class, Double.class, Double.class}, argumentNames={"x", "y", "z", "w"})}, value="vector_n.mul")
    public FiguraVec4 mul(@LuaNotNil Object x, double y, double z, double w) {
        if (x instanceof FiguraVec4) {
            FiguraVec4 vec = (FiguraVec4)x;
            return this.multiply(vec);
        }
        if (x instanceof Number) {
            Number n = (Number)x;
            return this.multiply(n.doubleValue(), y, z, w);
        }
        throw new LuaError("Illegal type to mul(): " + x.getClass().getSimpleName());
    }

    @Override
    public FiguraVec4 divide(FiguraVec4 other) {
        return this.divide(other.x, other.y, other.z, other.w);
    }

    public FiguraVec4 divide(double x, double y, double z, double w) {
        this.x /= x;
        this.y /= y;
        this.z /= z;
        this.w /= w;
        return this;
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={FiguraVec4.class}, argumentNames={"vec"}), @LuaMethodOverload(argumentTypes={Double.class, Double.class, Double.class, Double.class}, argumentNames={"x", "y", "z", "w"})}, value="vector_n.div")
    public FiguraVec4 div(@LuaNotNil Object x, double y, double z, double w) {
        if (x instanceof FiguraVec4) {
            FiguraVec4 vec = (FiguraVec4)x;
            return this.divide(vec);
        }
        if (x instanceof Number) {
            Number n = (Number)x;
            return this.divide(n.doubleValue(), y, z, w);
        }
        throw new LuaError("Illegal type to div(): " + x.getClass().getSimpleName());
    }

    @Override
    public FiguraVec4 reduce(FiguraVec4 other) {
        return this.reduce(other.x, other.y, other.z, other.w);
    }

    public FiguraVec4 reduce(double x, double y, double z, double w) {
        this.x = (this.x % x + x) % x;
        this.y = (this.y % y + y) % y;
        this.z = (this.z % z + z) % z;
        this.w = (this.w % w + w) % w;
        return this;
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={FiguraVec4.class}, argumentNames={"vec"}), @LuaMethodOverload(argumentTypes={Double.class, Double.class, Double.class, Double.class}, argumentNames={"x", "y", "z", "w"})}, value="vector_n.reduce")
    public FiguraVec4 reduce(@LuaNotNil Object x, double y, double z, double w) {
        if (x instanceof FiguraVec4) {
            FiguraVec4 vec = (FiguraVec4)x;
            return this.reduce(vec);
        }
        if (x instanceof Number) {
            Number n = (Number)x;
            return this.reduce(n.doubleValue(), y, z, w);
        }
        throw new LuaError("Illegal type to reduce(): " + x.getClass().getSimpleName());
    }

    @Override
    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={Double.class}, argumentNames={"factor"}, returnType=FiguraVec4.class)}, value="vector_n.scale")
    public FiguraVec4 scale(double factor) {
        this.x *= factor;
        this.y *= factor;
        this.z *= factor;
        this.w *= factor;
        return this;
    }

    @Override
    @LuaWhitelist
    @LuaMethodDoc(value="vector_n.unpack")
    public double[] unpack() {
        return new double[]{this.x, this.y, this.z, this.w};
    }

    @Override
    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={FiguraMat4.class}, argumentNames={"mat"}, returnType=FiguraVec4.class)}, value="vector_n.transform")
    public FiguraVec4 transform(@LuaNotNil FiguraMat4 mat) {
        return this.set(mat.v11 * this.x + mat.v12 * this.y + mat.v13 * this.z + mat.v14 * this.w, mat.v21 * this.x + mat.v22 * this.y + mat.v23 * this.z + mat.v24 * this.w, mat.v31 * this.x + mat.v32 * this.y + mat.v33 * this.z + mat.v34 * this.w, mat.v41 * this.x + mat.v42 * this.y + mat.v43 * this.z + mat.v44 * this.w);
    }

    @Override
    @LuaWhitelist
    @LuaMethodDoc(value="vector_n.length_squared")
    public double lengthSquared() {
        return this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w;
    }

    @Override
    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(returnType=FiguraVec4.class)}, value="vector_n.copy")
    public FiguraVec4 copy() {
        return FiguraVec4.of(this.x, this.y, this.z, this.w);
    }

    @Override
    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={FiguraVec4.class}, argumentNames={"vec"})}, value="vector_n.dot")
    public double dot(@LuaNotNil FiguraVec4 other) {
        return this.x * other.x + this.y * other.y + this.z * other.z + this.w * other.w;
    }

    @Override
    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(returnType=FiguraVec4.class)}, value="vector_n.normalize")
    public FiguraVec4 normalize() {
        return (FiguraVec4)super.normalize();
    }

    @Override
    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(returnType=FiguraVec4.class)}, value="vector_n.normalized")
    public FiguraVec4 normalized() {
        return (FiguraVec4)super.normalized();
    }

    @Override
    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={Double.class, Double.class}, argumentNames={"minLength", "maxLength"}, returnType=FiguraVec4.class)}, value="vector_n.clamp_length")
    public FiguraVec4 clampLength(Double min, Double max) {
        return (FiguraVec4)super.clampLength(min, max);
    }

    @Override
    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={Double.class, Double.class}, argumentNames={"minLength", "maxLength"}, returnType=FiguraVec4.class)}, value="vector_n.clamped")
    public FiguraVec4 clamped(Double min, Double max) {
        return (FiguraVec4)super.clamped(min, max);
    }

    @Override
    @LuaWhitelist
    @LuaMethodDoc(value="vector_n.length")
    public double length() {
        return super.length();
    }

    @Override
    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(returnType=FiguraVec4.class)}, value="vector_n.to_rad")
    public FiguraVec4 toRad() {
        return (FiguraVec4)super.toRad();
    }

    @Override
    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(returnType=FiguraVec4.class)}, value="vector_n.to_deg")
    public FiguraVec4 toDeg() {
        return (FiguraVec4)super.toDeg();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="vector_n.floor")
    public FiguraVec4 floor() {
        return FiguraVec4.of(Math.floor(this.x), Math.floor(this.y), Math.floor(this.z), Math.floor(this.w));
    }

    @LuaWhitelist
    @LuaMethodDoc(value="vector_n.ceil")
    public FiguraVec4 ceil() {
        return FiguraVec4.of(Math.ceil(this.x), Math.ceil(this.y), Math.ceil(this.z), Math.ceil(this.w));
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={LuaFunction.class}, argumentNames={"func"})}, value="vector_n.apply_func")
    public FiguraVec4 applyFunc(@LuaNotNil LuaFunction function) {
        this.x = function.call((LuaValue)LuaValue.valueOf((double)this.x), (LuaValue)LuaValue.valueOf((int)1)).todouble();
        this.y = function.call((LuaValue)LuaValue.valueOf((double)this.y), (LuaValue)LuaValue.valueOf((int)2)).todouble();
        this.z = function.call((LuaValue)LuaValue.valueOf((double)this.z), (LuaValue)LuaValue.valueOf((int)3)).todouble();
        this.w = function.call((LuaValue)LuaValue.valueOf((double)this.w), (LuaValue)LuaValue.valueOf((int)4)).todouble();
        return this;
    }

    @Override
    public int size() {
        return 4;
    }

    @Override
    public double x() {
        return this.x;
    }

    @Override
    public double y() {
        return this.y;
    }

    @Override
    public double z() {
        return this.z;
    }

    @Override
    public double w() {
        return this.w;
    }

    @Override
    public double index(int i) {
        return switch (i) {
            case 0 -> this.x;
            case 1 -> this.y;
            case 2 -> this.z;
            case 3 -> this.w;
            default -> throw new IndexOutOfBoundsException(i);
        };
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object other) {
        if (!(other instanceof FiguraVec4)) return false;
        FiguraVec4 vec = (FiguraVec4)other;
        if (this.x != vec.x) return false;
        if (this.y != vec.y) return false;
        if (this.z != vec.z) return false;
        if (this.w != vec.w) return false;
        return true;
    }

    @Override
    @LuaWhitelist
    public String toString() {
        return FiguraVec4.getString(this.x, this.y, this.z, this.w);
    }

    @LuaWhitelist
    @LuaMetamethodDoc(overloads={@LuaMetamethodDoc.LuaMetamethodOverload(types={FiguraVec4.class, FiguraVec4.class, FiguraVec4.class}), @LuaMetamethodDoc.LuaMetamethodOverload(types={FiguraVec4.class, FiguraVec4.class, Double.class}), @LuaMetamethodDoc.LuaMetamethodOverload(types={FiguraVec4.class, Double.class, FiguraVec4.class})})
    public static FiguraVec4 __add(@LuaNotNil Object a, @LuaNotNil Object b) {
        if (a instanceof FiguraVec4) {
            FiguraVec4 vec = (FiguraVec4)a;
            if (b instanceof FiguraVec4) {
                FiguraVec4 vec2 = (FiguraVec4)b;
                return vec.plus(vec2);
            }
            if (b instanceof Number) {
                Number d = (Number)b;
                return (FiguraVec4)vec.offseted(d.doubleValue());
            }
        } else if (a instanceof Number) {
            Number d = (Number)a;
            if (b instanceof FiguraVec4) {
                FiguraVec4 vec = (FiguraVec4)b;
                return (FiguraVec4)vec.offseted(d.doubleValue());
            }
        }
        throw new LuaError("Invalid types to __add: " + a.getClass().getSimpleName() + ", " + b.getClass().getSimpleName());
    }

    @LuaWhitelist
    @LuaMetamethodDoc(overloads={@LuaMetamethodDoc.LuaMetamethodOverload(types={FiguraVec4.class, FiguraVec4.class, FiguraVec4.class}), @LuaMetamethodDoc.LuaMetamethodOverload(types={FiguraVec4.class, FiguraVec4.class, Double.class}), @LuaMetamethodDoc.LuaMetamethodOverload(types={FiguraVec4.class, Double.class, FiguraVec4.class})})
    public static FiguraVec4 __sub(@LuaNotNil Object a, @LuaNotNil Object b) {
        if (a instanceof FiguraVec4) {
            FiguraVec4 vec = (FiguraVec4)a;
            if (b instanceof FiguraVec4) {
                FiguraVec4 vec2 = (FiguraVec4)b;
                return vec.minus(vec2);
            }
            if (b instanceof Number) {
                Number d = (Number)b;
                return (FiguraVec4)vec.offseted(-d.doubleValue());
            }
        } else if (a instanceof Number) {
            Number d = (Number)a;
            if (b instanceof FiguraVec4) {
                FiguraVec4 vec = (FiguraVec4)b;
                return ((FiguraVec4)vec.scaled(-1.0)).offset(d.doubleValue());
            }
        }
        throw new LuaError("Invalid types to __sub: " + a.getClass().getSimpleName() + ", " + b.getClass().getSimpleName());
    }

    @LuaWhitelist
    @LuaMetamethodDoc(overloads={@LuaMetamethodDoc.LuaMetamethodOverload(types={FiguraVec4.class, FiguraVec4.class, FiguraVec4.class}), @LuaMetamethodDoc.LuaMetamethodOverload(types={FiguraVec4.class, FiguraVec4.class, Double.class}), @LuaMetamethodDoc.LuaMetamethodOverload(types={FiguraVec4.class, FiguraVec4.class, FiguraMat4.class}), @LuaMetamethodDoc.LuaMetamethodOverload(types={FiguraVec4.class, Double.class, FiguraVec4.class})})
    public static FiguraVec4 __mul(@LuaNotNil Object a, @LuaNotNil Object b) {
        if (a instanceof FiguraVec4) {
            FiguraVec4 vec = (FiguraVec4)a;
            if (b instanceof FiguraVec4) {
                FiguraVec4 vec2 = (FiguraVec4)b;
                return vec.times(vec2);
            }
            if (b instanceof Number) {
                Number d = (Number)b;
                return (FiguraVec4)vec.scaled(d.doubleValue());
            }
            if (b instanceof FiguraMat4) {
                FiguraMat4 mat = (FiguraMat4)b;
                return vec.copy().transform(mat);
            }
        } else if (a instanceof Number) {
            Number d = (Number)a;
            if (b instanceof FiguraVec4) {
                FiguraVec4 vec = (FiguraVec4)b;
                return (FiguraVec4)vec.scaled(d.doubleValue());
            }
        }
        throw new LuaError("Invalid types to __mul: " + a.getClass().getSimpleName() + ", " + b.getClass().getSimpleName());
    }

    @LuaWhitelist
    @LuaMetamethodDoc(overloads={@LuaMetamethodDoc.LuaMetamethodOverload(types={FiguraVec4.class, FiguraVec4.class, FiguraVec4.class}), @LuaMetamethodDoc.LuaMetamethodOverload(types={FiguraVec4.class, FiguraVec4.class, Double.class})})
    public FiguraVec4 __div(@LuaNotNil Object rhs) {
        if (rhs instanceof Number) {
            Number n = (Number)rhs;
            double d = n.doubleValue();
            if (d == 0.0) {
                throw new LuaError("Attempt to divide vector by 0");
            }
            return (FiguraVec4)this.scaled(1.0 / d);
        }
        if (rhs instanceof FiguraVec4) {
            FiguraVec4 vec = (FiguraVec4)rhs;
            return this.dividedBy(vec);
        }
        throw new LuaError("Invalid types to __div: " + this.getClass().getSimpleName() + ", " + rhs.getClass().getSimpleName());
    }

    @LuaWhitelist
    @LuaMetamethodDoc(overloads={@LuaMetamethodDoc.LuaMetamethodOverload(types={FiguraVec4.class, FiguraVec4.class, FiguraVec4.class}), @LuaMetamethodDoc.LuaMetamethodOverload(types={FiguraVec4.class, FiguraVec4.class, Double.class})})
    public FiguraVec4 __mod(@LuaNotNil Object rhs) {
        if (rhs instanceof Number) {
            Number n = (Number)rhs;
            double d = n.doubleValue();
            if (d == 0.0) {
                throw new LuaError("Attempt to reduce vector by 0");
            }
            FiguraVec4 modulus = FiguraVec4.of(d, d, d, d);
            return this.mod(modulus);
        }
        if (rhs instanceof FiguraVec4) {
            FiguraVec4 vec = (FiguraVec4)rhs;
            return this.mod(vec);
        }
        throw new LuaError("Invalid types to __mod: " + this.getClass().getSimpleName() + ", " + rhs.getClass().getSimpleName());
    }

    @LuaWhitelist
    @LuaMetamethodDoc(overloads={@LuaMetamethodDoc.LuaMetamethodOverload(types={Boolean.class, FiguraVec4.class, FiguraVec4.class})})
    public boolean __eq(FiguraVec4 other) {
        return this.equals(other);
    }

    @LuaWhitelist
    @LuaMetamethodDoc(overloads={@LuaMetamethodDoc.LuaMetamethodOverload(types={FiguraVec4.class, FiguraVec4.class})})
    public FiguraVec4 __unm() {
        return (FiguraVec4)this.scaled(-1.0);
    }

    @LuaWhitelist
    @LuaMetamethodDoc(overloads={@LuaMetamethodDoc.LuaMetamethodOverload(types={Integer.class, FiguraVec4.class})})
    public int __len() {
        return this.size();
    }

    @LuaWhitelist
    @LuaMetamethodDoc(overloads={@LuaMetamethodDoc.LuaMetamethodOverload(types={Boolean.class, FiguraVec4.class, FiguraVec4.class})})
    public boolean __lt(@LuaNotNil FiguraVec4 r) {
        return this.x < r.x && this.y < r.y && this.z < r.z && this.w < r.w;
    }

    @LuaWhitelist
    @LuaMetamethodDoc(overloads={@LuaMetamethodDoc.LuaMetamethodOverload(types={Boolean.class, FiguraVec4.class, FiguraVec4.class})})
    public boolean __le(@LuaNotNil FiguraVec4 r) {
        return this.x <= r.x && this.y <= r.y && this.z <= r.z && this.w <= r.w;
    }

    @LuaWhitelist
    @LuaMetamethodDoc(overloads={@LuaMetamethodDoc.LuaMetamethodOverload(types={String.class, FiguraVec4.class})})
    public String __tostring() {
        return this.toString();
    }

    @LuaWhitelist
    @LuaMetamethodDoc(overloads={@LuaMetamethodDoc.LuaMetamethodOverload(types={Double.class, FiguraVec4.class, Integer.class}), @LuaMetamethodDoc.LuaMetamethodOverload(types={Double.class, FiguraVec4.class, String.class}), @LuaMetamethodDoc.LuaMetamethodOverload(types={FiguraVector.class, FiguraVec4.class, String.class}, comment="vector_n.comments.swizzle")})
    public Object __index(Object arg) {
        if (arg == null) {
            return null;
        }
        String str = arg.toString();
        int len = str.length();
        if (len == 1) {
            return switch (str.charAt(0)) {
                case '1', 'r', 'x' -> this.x;
                case '2', 'g', 'y' -> this.y;
                case '3', 'b', 'z' -> this.z;
                case '4', 'a', 'w' -> this.w;
                case '_' -> 0;
                default -> null;
            };
        }
        if (len > 4) {
            return null;
        }
        double[] vals = new double[len];
        boolean fail = false;
        for (int i = 0; i < len; ++i) {
            vals[i] = switch (str.charAt(i)) {
                case '1', 'r', 'x' -> this.x;
                case '2', 'g', 'y' -> this.y;
                case '3', 'b', 'z' -> this.z;
                case '4', 'a', 'w' -> this.w;
                case '_' -> 0.0;
                default -> {
                    fail = true;
                    yield 0.0;
                }
            };
        }
        return fail ? null : MathUtils.sizedVector(vals);
    }

    @LuaWhitelist
    @LuaMetamethodDoc(overloads={@LuaMetamethodDoc.LuaMetamethodOverload(types={void.class, FiguraVec4.class, Integer.class, Double.class}), @LuaMetamethodDoc.LuaMetamethodOverload(types={void.class, FiguraVec4.class, String.class, Double.class}), @LuaMetamethodDoc.LuaMetamethodOverload(types={void.class, FiguraVec4.class, String.class, FiguraVector.class})})
    public void __newindex(@LuaNotNil String key, Object value) {
        FiguraVector vecVal;
        int len = key.length();
        if (len == 1) {
            if (value instanceof Number) {
                Number n = (Number)value;
                double d = n.doubleValue();
                switch (key) {
                    case "1": 
                    case "x": 
                    case "r": {
                        this.x = d;
                        break;
                    }
                    case "2": 
                    case "y": 
                    case "g": {
                        this.y = d;
                        break;
                    }
                    case "3": 
                    case "z": 
                    case "b": {
                        this.z = d;
                        break;
                    }
                    case "4": 
                    case "w": 
                    case "a": {
                        this.w = d;
                        break;
                    }
                    case "_": {
                        break;
                    }
                    default: {
                        throw new LuaError("Invalid key to vector __newindex: " + key);
                    }
                }
                return;
            }
            throw new LuaError("Invalid call to __newindex - value assigned to key " + key + " must be number.");
        }
        if (value instanceof FiguraVector && len == (vecVal = (FiguraVector)value).size()) {
            double[] vals = new double[]{vecVal.x(), vecVal.y(), vecVal.z(), vecVal.w()};
            block29: for (int i = 0; i < len; ++i) {
                switch (key.charAt(i)) {
                    case '1': 
                    case 'r': 
                    case 'x': {
                        this.x = vals[i];
                        continue block29;
                    }
                    case '2': 
                    case 'g': 
                    case 'y': {
                        this.y = vals[i];
                        continue block29;
                    }
                    case '3': 
                    case 'b': 
                    case 'z': {
                        this.z = vals[i];
                        continue block29;
                    }
                    case '4': 
                    case 'a': 
                    case 'w': {
                        this.w = vals[i];
                        continue block29;
                    }
                    case '_': {
                        continue block29;
                    }
                    default: {
                        throw new LuaError("Invalid key to __newindex: invalid swizzle character: " + key.charAt(i));
                    }
                }
            }
            return;
        }
        throw new LuaError("Invalid call to __newindex - vector swizzles must be the same size.");
    }
}

