/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.lua.docs;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.class_124;
import net.minecraft.class_1664;
import net.minecraft.class_1839;
import net.minecraft.class_2378;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_3959;
import net.minecraft.class_4050;
import net.minecraft.class_5250;
import net.minecraft.class_809;
import org.figuramc.figura.FiguraMod;
import org.figuramc.figura.animation.Animation;
import org.figuramc.figura.lua.docs.FiguraDoc;
import org.figuramc.figura.mixin.input.KeyMappingAccessor;
import org.figuramc.figura.mixin.render.GameRendererAccessor;
import org.figuramc.figura.model.ParentType;
import org.figuramc.figura.model.rendering.EntityRenderMode;
import org.figuramc.figura.model.rendering.texture.FiguraTextureSet;
import org.figuramc.figura.model.rendering.texture.RenderTypes;
import org.figuramc.figura.utils.ColorUtils;
import org.figuramc.figura.utils.FiguraClientCommandSource;
import org.figuramc.figura.utils.FiguraText;

public class FiguraListDocs {
    public static final LinkedHashSet<String> KEYBINDS = new LinkedHashSet();
    private static final LinkedHashMap<String, List<String>> PARENT_TYPES = new LinkedHashMap<String, List<String>>(){
        {
            for (ParentType value : ParentType.values()) {
                this.put(value.name(), Arrays.asList(value.aliases));
            }
        }
    };
    private static final LinkedHashMap<String, List<String>> STRING_ENCODINGS = new LinkedHashMap<String, List<String>>(){
        {
            this.put("utf8", List.of("utf_8"));
            this.put("utf16", List.of("utf_16"));
            this.put("utf16be", List.of("utf_16_be"));
            this.put("utf16le", List.of("utf_16_le"));
            this.put("ascii", List.of());
            this.put("iso88591", List.of("iso_8859_1"));
        }
    };
    private static final LinkedHashSet<String> RENDER_TYPES = new LinkedHashSet<String>(){
        {
            for (RenderTypes value : RenderTypes.values()) {
                this.add(value.name());
            }
        }
    };
    private static final LinkedHashSet<String> TEXTURE_TYPES = new LinkedHashSet<String>(){
        {
            for (FiguraTextureSet.OverrideType value : FiguraTextureSet.OverrideType.values()) {
                this.add(value.name());
            }
        }
    };
    private static final LinkedHashSet<String> ENTITY_POSES = new LinkedHashSet<String>(){
        {
            for (class_4050 value : class_4050.values()) {
                this.add(value.name());
            }
        }
    };
    private static final LinkedHashSet<String> ITEM_DISPLAY_MODES = new LinkedHashSet<String>(){
        {
            for (class_809.class_811 value : class_809.class_811.values()) {
                this.add(value.name());
            }
        }
    };
    private static final LinkedHashSet<String> POST_EFFECTS = new LinkedHashSet<String>(){
        {
            for (class_2960 effect : GameRendererAccessor.getEffects()) {
                String[] split = effect.method_12832().split("/");
                String name = split[split.length - 1];
                this.add(name.split("\\.")[0]);
            }
        }
    };
    private static final LinkedHashSet<String> PLAY_STATES = new LinkedHashSet<String>(){
        {
            for (Animation.PlayState value : Animation.PlayState.values()) {
                this.add(value.name());
            }
        }
    };
    private static final LinkedHashSet<String> LOOP_MODES = new LinkedHashSet<String>(){
        {
            for (Animation.LoopMode value : Animation.LoopMode.values()) {
                this.add(value.name());
            }
        }
    };
    private static final LinkedHashMap<String, List<String>> COLORS = new LinkedHashMap<String, List<String>>(){
        {
            for (ColorUtils.Colors value : ColorUtils.Colors.values()) {
                this.put(value.name(), List.of(value.name()));
            }
        }
    };
    private static final LinkedHashSet<String> PLAYER_MODEL_PARTS = new LinkedHashSet<String>(){
        {
            for (class_1664 value : class_1664.values()) {
                String name = value.name();
                this.add(name.endsWith("_LEG") ? name.substring(0, name.length() - 4) : name);
            }
        }
    };
    private static final LinkedHashSet<String> USE_ACTIONS = new LinkedHashSet<String>(){
        {
            for (class_1839 value : class_1839.values()) {
                this.add(value.name());
            }
        }
    };
    private static final LinkedHashSet<String> RENDER_MODES = new LinkedHashSet<String>(){
        {
            for (EntityRenderMode value : EntityRenderMode.values()) {
                this.add(value.name());
            }
        }
    };
    private static final LinkedHashSet<String> BLOCK_RAYCAST_TYPE = new LinkedHashSet<String>(){
        {
            for (class_3959.class_3960 value : class_3959.class_3960.values()) {
                this.add(value.name());
            }
        }
    };
    private static final LinkedHashSet<String> FLUID_RAYCAST_TYPE = new LinkedHashSet<String>(){
        {
            for (class_3959.class_242 value : class_3959.class_242.values()) {
                this.add(value.name());
            }
        }
    };
    private static final LinkedHashSet<String> HEIGHTMAP_TYPE = new LinkedHashSet<String>(){
        {
            for (class_2902.class_2903 value : class_2902.class_2903.values()) {
                this.add(value.name());
            }
        }
    };
    private static final LinkedHashSet<String> REGISTRIES = new LinkedHashSet<String>(){
        {
            for (class_2960 resourceLocation : class_2378.field_11144.method_10235()) {
                this.add(resourceLocation.method_12832());
            }
        }
    };

    public static LiteralArgumentBuilder<FiguraClientCommandSource> getCommand() {
        LiteralArgumentBuilder root = LiteralArgumentBuilder.literal((String)"enums");
        root.executes(context -> {
            FiguraMod.sendChatMessage((class_2561)FiguraDoc.HEADER.method_27661().method_27693("\n\n").method_10852((class_2561)new class_2585("\u2022 ").method_10852((class_2561)new FiguraText("docs.text.type")).method_27693(":").method_27696(ColorUtils.Colors.PURPLE.style)).method_27693("\n\t").method_10852((class_2561)new class_2585("\u2022 ").method_10852((class_2561)new class_2585("enumerators")).method_27696(ColorUtils.Colors.BLUE.style)).method_27693("\n\n").method_10852((class_2561)new class_2585("\u2022 ").method_10852((class_2561)new FiguraText("docs.text.description")).method_27693(":").method_27696(ColorUtils.Colors.PURPLE.style)).method_27693("\n\t").method_10852((class_2561)new class_2585("\u2022 ").method_10852((class_2561)new FiguraText("docs.enum")).method_27696(ColorUtils.Colors.BLUE.style)));
            return 1;
        });
        for (ListDoc value : ListDoc.values()) {
            root.then(value.generateCommand());
        }
        return root;
    }

    public static List<String> getEnumValues(String enumName) {
        try {
            ListDoc enumListDoc = ListDoc.valueOf(enumName.toUpperCase(Locale.US));
            Collection<?> enumValues = enumListDoc.get();
            ArrayList<String> enumValueList = new ArrayList<String>();
            for (Object value : enumValues) {
                if (value instanceof Map.Entry) {
                    Map.Entry entry = (Map.Entry)value;
                    enumValueList.add(entry.getKey().toString());
                    if (!(entry.getValue() instanceof Collection)) continue;
                    for (Object alias : (Collection)entry.getValue()) {
                        enumValueList.add(alias.toString());
                    }
                    continue;
                }
                enumValueList.add(value.toString());
            }
            return enumValueList;
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Enum " + enumName + " does not exist");
        }
    }

    public static JsonElement toJson(boolean translate) {
        JsonArray array = new JsonArray();
        for (ListDoc value : ListDoc.values()) {
            array.add(value.generateJson(translate));
        }
        return array;
    }

    private static enum ListDoc {
        KEYBINDS(() -> KEYBINDS, "Keybinds", "keybinds", 2),
        PARENT_TYPES(() -> PARENT_TYPES, "ParentTypes", "parent_types", 1),
        RENDER_TYPES(() -> RENDER_TYPES, "RenderTypes", "render_types", 1),
        TEXTURE_TYPES(() -> TEXTURE_TYPES, "TextureTypes", "texture_types", 1),
        KEY_IDS(() -> new LinkedHashSet<Object>(){
            {
                this.addAll(KeyMappingAccessor.getAll().keySet());
            }
        }, "KeyIDs", "key_ids", 2),
        ENTITY_POSES(() -> ENTITY_POSES, "EntityPoses", "entity_poses", 2),
        ITEM_RENDER_TYPES(() -> ITEM_DISPLAY_MODES, "ItemDisplayModes", "item_display_modes", 1),
        POST_EFFECTS(() -> POST_EFFECTS, "PostEffects", "post_effects", 2),
        PLAY_STATES(() -> PLAY_STATES, "PlayStates", "play_states", 1),
        LOOP_MODES(() -> LOOP_MODES, "LoopModes", "loop_modes", 1),
        COLORS(() -> COLORS, "Colors", "colors", 1),
        PLAYER_MODEL_PARTS(() -> PLAYER_MODEL_PARTS, "PlayerModelParts", "player_model_parts", 1),
        USE_ACTIONS(() -> USE_ACTIONS, "UseActions", "use_actions", 1),
        RENDER_MODES(() -> RENDER_MODES, "RenderModes", "render_modes", 1),
        STRING_ENCODINGS(() -> STRING_ENCODINGS, "StringEncodings", "string_encodings", 1),
        BLOCK_RAYCAST_TYPE(() -> BLOCK_RAYCAST_TYPE, "BlockRaycastTypes", "block_raycast_types", 1),
        FLUID_RAYCAST_TYPE(() -> FLUID_RAYCAST_TYPE, "FluidRaycastTypes", "fluid_raycast_types", 1),
        HEIGHTMAP_TYPE(() -> HEIGHTMAP_TYPE, "HeightmapTypes", "heightmap_types", 1),
        REGISTRIES(() -> REGISTRIES, "Registries", "registries", 1);

        private final Supplier<Object> supplier;
        private final String name;
        private final String id;
        private final int split;

        private ListDoc(Supplier<Object> supplier, String name, String id, int split) {
            this.supplier = supplier;
            this.name = name;
            this.id = id;
            this.split = split;
        }

        private Collection<?> get() {
            Object obj = this.supplier.get();
            if (obj instanceof LinkedHashSet) {
                LinkedHashSet set = (LinkedHashSet)obj;
                return set;
            }
            if (obj instanceof Map) {
                Map map = (Map)obj;
                return map.entrySet();
            }
            throw new UnsupportedOperationException("Invalid object " + obj);
        }

        private JsonElement generateJson(boolean translate) {
            JsonObject object = new JsonObject();
            object.addProperty("name", this.name);
            object.addProperty("description", (String)(translate ? class_2477.method_10517().method_4679(new FiguraText("docs.enum." + this.id).getString()) : "figura.docs.enum." + this.id));
            Collection<?> coll = this.get();
            if (coll.size() == 0) {
                return object;
            }
            JsonArray entries = new JsonArray();
            for (Object o : coll) {
                if (o instanceof Map.Entry) {
                    Map.Entry e = (Map.Entry)o;
                    entries.add(e.getKey().toString());
                    for (String s : (List)e.getValue()) {
                        entries.add(s);
                    }
                    continue;
                }
                entries.add(o.toString());
            }
            object.add("entries", (JsonElement)entries);
            return object;
        }

        private LiteralArgumentBuilder<FiguraClientCommandSource> generateCommand() {
            LiteralArgumentBuilder command = LiteralArgumentBuilder.literal((String)this.id);
            command.executes(context -> {
                Collection<?> coll = this.get();
                if (coll.size() == 0) {
                    FiguraMod.sendChatMessage((class_2561)new FiguraText("docs.enum.empty"));
                    return 0;
                }
                class_5250 text = FiguraDoc.HEADER.method_27661().method_27693("\n\n").method_10852((class_2561)new class_2585("\u2022 ").method_10852((class_2561)new FiguraText("docs.text.description")).method_27693(":").method_27696(ColorUtils.Colors.PURPLE.style)).method_27693("\n\t").method_10852((class_2561)new class_2585("\u2022 ").method_10852((class_2561)new FiguraText("docs.enum." + this.id)).method_27696(ColorUtils.Colors.BLUE.style)).method_27693("\n\n").method_10852((class_2561)new class_2585("\u2022 ").method_10852((class_2561)new FiguraText("docs.text.entries")).method_27693(":").method_27696(ColorUtils.Colors.PURPLE.style));
                int i = 0;
                for (Object o : coll) {
                    class_5250 component;
                    if (o instanceof Map.Entry) {
                        Map.Entry e = (Map.Entry)o;
                        component = new class_2585(e.getKey().toString()).method_27692(class_124.field_1068);
                        for (String s : (List)e.getValue()) {
                            component.method_10852((class_2561)new class_2585(" | ").method_27692(class_124.field_1054)).method_10852((class_2561)new class_2585(s).method_27692(class_124.field_1080));
                        }
                    } else {
                        component = new class_2585(o.toString()).method_27692(class_124.field_1068);
                    }
                    text.method_27693(i % this.split == 0 ? "\n\t" : "\t");
                    text.method_10852((class_2561)new class_2585("\u2022 ").method_27692(class_124.field_1054)).method_10852((class_2561)component);
                    ++i;
                }
                FiguraMod.sendChatMessage((class_2561)text);
                return 1;
            });
            Collection<?> coll = this.get();
            for (Object o : coll) {
                String string;
                if (o instanceof Map.Entry) {
                    Map.Entry e = (Map.Entry)o;
                    string = e.getKey().toString();
                } else {
                    string = o.toString();
                }
                String text = string;
                LiteralArgumentBuilder entry = LiteralArgumentBuilder.literal((String)text);
                entry.executes(context -> {
                    FiguraMod.sendChatMessage((class_2561)new class_2585(text).method_27696(ColorUtils.Colors.AWESOME_BLUE.style));
                    return 1;
                });
                if (o instanceof Map.Entry) {
                    Map.Entry e = (Map.Entry)o;
                    for (String s : (List)e.getValue()) {
                        LiteralArgumentBuilder child = LiteralArgumentBuilder.literal((String)s);
                        child.executes(context -> {
                            FiguraMod.sendChatMessage((class_2561)new class_2585(s).method_27696(ColorUtils.Colors.AWESOME_BLUE.style));
                            return 1;
                        });
                        entry.then((ArgumentBuilder)child);
                    }
                }
                command.then((ArgumentBuilder)entry);
            }
            return command;
        }
    }
}

