/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.lua.api.world;

import com.mojang.brigadier.StringReader;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2257;
import net.minecraft.class_2287;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2902;
import net.minecraft.class_310;
import net.minecraft.class_5217;
import org.figuramc.figura.avatar.Avatar;
import org.figuramc.figura.avatar.AvatarManager;
import org.figuramc.figura.lua.LuaNotNil;
import org.figuramc.figura.lua.LuaWhitelist;
import org.figuramc.figura.lua.ReadOnlyLuaTable;
import org.figuramc.figura.lua.api.entity.EntityAPI;
import org.figuramc.figura.lua.api.entity.PlayerAPI;
import org.figuramc.figura.lua.api.world.BiomeAPI;
import org.figuramc.figura.lua.api.world.BlockStateAPI;
import org.figuramc.figura.lua.api.world.ItemStackAPI;
import org.figuramc.figura.lua.docs.LuaMethodDoc;
import org.figuramc.figura.lua.docs.LuaMethodOverload;
import org.figuramc.figura.lua.docs.LuaTypeDoc;
import org.figuramc.figura.math.vector.FiguraVec2;
import org.figuramc.figura.math.vector.FiguraVec3;
import org.figuramc.figura.utils.EntityUtils;
import org.figuramc.figura.utils.LuaUtils;
import org.luaj.vm2.LuaError;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaValue;

@LuaWhitelist
@LuaTypeDoc(name="WorldAPI", value="world")
public class WorldAPI {
    public static final WorldAPI INSTANCE = new WorldAPI();

    public static class_1937 getCurrentWorld() {
        return class_310.method_1551().field_1687;
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={FiguraVec3.class}, argumentNames={"pos"}), @LuaMethodOverload(argumentTypes={Double.class, Double.class, Double.class}, argumentNames={"x", "y", "z"})}, value="world.get_biome")
    public static BiomeAPI getBiome(Object x, Double y, Double z) {
        FiguraVec3 pos = LuaUtils.parseVec3("getBiome", x, y, z);
        return new BiomeAPI((class_1959)WorldAPI.getCurrentWorld().method_23753(pos.asBlockPos()).comp_349(), pos.asBlockPos());
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={FiguraVec3.class}, argumentNames={"pos"}), @LuaMethodOverload(argumentTypes={Double.class, Double.class, Double.class}, argumentNames={"x", "y", "z"})}, value="world.get_block_state")
    public static BlockStateAPI getBlockState(Object x, Double y, Double z) {
        FiguraVec3 pos = LuaUtils.parseVec3("getBlockState", x, y, z);
        class_2338 blockPos = pos.asBlockPos();
        class_1937 world = WorldAPI.getCurrentWorld();
        if (!world.method_22340(blockPos)) {
            return new BlockStateAPI(class_2246.field_10243.method_9564(), blockPos);
        }
        return new BlockStateAPI(world.method_8320(blockPos), blockPos);
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={FiguraVec3.class}, argumentNames={"pos"}), @LuaMethodOverload(argumentTypes={Double.class, Double.class, Double.class}, argumentNames={"x", "y", "z"})}, value="world.is_chunk_loaded")
    public static boolean isChunkLoaded(Object x, Double y, Double z) {
        FiguraVec3 pos = LuaUtils.parseVec3("getBlockState", x, y, z);
        class_2338 blockPos = pos.asBlockPos();
        class_1937 world = WorldAPI.getCurrentWorld();
        return world.method_22340(blockPos);
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={FiguraVec3.class, FiguraVec3.class}, argumentNames={"min", "max"}), @LuaMethodOverload(argumentTypes={Double.class, Double.class, Double.class, FiguraVec3.class}, argumentNames={"minX", "minY", "minZ", "max"}), @LuaMethodOverload(argumentTypes={FiguraVec3.class, Double.class, Double.class, Double.class}, argumentNames={"min", "maxX", "maxY", "maxZ"}), @LuaMethodOverload(argumentTypes={Double.class, Double.class, Double.class, Double.class, Double.class, Double.class}, argumentNames={"minX", "minY", "minZ", "maxX", "maxY", "maxZ"})}, value="world.get_blocks")
    public static List<BlockStateAPI> getBlocks(Object x, Object y, Double z, Double w, Double t, Double h) {
        Pair<FiguraVec3, FiguraVec3> pair = LuaUtils.parse2Vec3("getBlocks", x, y, z, (Object)w, t, h, 1);
        ArrayList<BlockStateAPI> list = new ArrayList<BlockStateAPI>();
        class_2338 min = ((FiguraVec3)pair.getFirst()).asBlockPos();
        class_2338 max = ((FiguraVec3)pair.getSecond()).asBlockPos();
        max = new class_2338(Math.min(min.method_10263() + 8, max.method_10263()), Math.min(min.method_10264() + 8, max.method_10264()), Math.min(min.method_10260() + 8, max.method_10260()));
        class_1937 world = WorldAPI.getCurrentWorld();
        if (!world.method_22343(min, max)) {
            return list;
        }
        class_2338.method_20437((class_2338)min, (class_2338)max).forEach(blockPos -> {
            class_2338 pos = new class_2338((class_2382)blockPos);
            list.add(new BlockStateAPI(world.method_8320(pos), pos));
        });
        return list;
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={FiguraVec3.class}, argumentNames={"pos"}), @LuaMethodOverload(argumentTypes={Double.class, Double.class, Double.class}, argumentNames={"x", "y", "z"})}, value="world.get_redstone_power")
    public static int getRedstonePower(Object x, Double y, Double z) {
        FiguraVec3 pos = LuaUtils.parseVec3("getRedstonePower", x, y, z);
        class_2338 blockPos = pos.asBlockPos();
        if (WorldAPI.getCurrentWorld().method_8500(blockPos) == null) {
            return 0;
        }
        return WorldAPI.getCurrentWorld().method_8482(blockPos);
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={FiguraVec3.class}, argumentNames={"pos"}), @LuaMethodOverload(argumentTypes={Double.class, Double.class, Double.class}, argumentNames={"x", "y", "z"})}, value="world.get_strong_redstone_power")
    public static int getStrongRedstonePower(Object x, Double y, Double z) {
        FiguraVec3 pos = LuaUtils.parseVec3("getStrongRedstonePower", x, y, z);
        class_2338 blockPos = pos.asBlockPos();
        if (WorldAPI.getCurrentWorld().method_8500(blockPos) == null) {
            return 0;
        }
        return WorldAPI.getCurrentWorld().method_8488(blockPos);
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload, @LuaMethodOverload(argumentTypes={Double.class}, argumentNames={"delta"})}, value="world.get_time")
    public static double getTime(double delta) {
        return (double)WorldAPI.getCurrentWorld().method_8510() + delta;
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload, @LuaMethodOverload(argumentTypes={Double.class}, argumentNames={"delta"})}, value="world.get_time_of_day")
    public static double getTimeOfDay(double delta) {
        return (double)WorldAPI.getCurrentWorld().method_8532() + delta;
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload, @LuaMethodOverload(argumentTypes={Double.class}, argumentNames={"delta"})}, value="world.get_day_time")
    public static double getDayTime(double delta) {
        return ((double)WorldAPI.getCurrentWorld().method_8532() + delta) % 24000.0;
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload, @LuaMethodOverload(argumentTypes={Double.class}, argumentNames={"delta"})}, value="world.get_day")
    public static double getDay(double delta) {
        return Math.floor(((double)WorldAPI.getCurrentWorld().method_8532() + delta) / 24000.0);
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload}, value="world.get_moon_phase")
    public static int getMoonPhase() {
        return WorldAPI.getCurrentWorld().method_30273();
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload, @LuaMethodOverload(argumentTypes={Double.class}, argumentNames={"delta"})}, value="world.get_rain_gradient")
    public static double getRainGradient(Float delta) {
        if (delta == null) {
            delta = Float.valueOf(1.0f);
        }
        return WorldAPI.getCurrentWorld().method_8430(delta.floatValue());
    }

    @LuaWhitelist
    @LuaMethodDoc(value="world.is_thundering")
    public static boolean isThundering() {
        return WorldAPI.getCurrentWorld().method_8546();
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={FiguraVec3.class}, argumentNames={"pos"}), @LuaMethodOverload(argumentTypes={Double.class, Double.class, Double.class}, argumentNames={"x", "y", "z"})}, value="world.get_light_level")
    public static Integer getLightLevel(Object x, Double y, Double z) {
        FiguraVec3 pos = LuaUtils.parseVec3("getLightLevel", x, y, z);
        class_2338 blockPos = pos.asBlockPos();
        class_1937 world = WorldAPI.getCurrentWorld();
        if (world.method_8500(blockPos) == null) {
            return null;
        }
        world.method_8533();
        return world.method_22336().method_22363(blockPos, world.method_8594());
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={FiguraVec3.class}, argumentNames={"pos"}), @LuaMethodOverload(argumentTypes={Double.class, Double.class, Double.class}, argumentNames={"x", "y", "z"})}, value="world.get_sky_light_level")
    public static Integer getSkyLightLevel(Object x, Double y, Double z) {
        FiguraVec3 pos = LuaUtils.parseVec3("getSkyLightLevel", x, y, z);
        class_2338 blockPos = pos.asBlockPos();
        class_1937 world = WorldAPI.getCurrentWorld();
        if (world.method_8500(blockPos) == null) {
            return null;
        }
        return world.method_8314(class_1944.field_9284, blockPos);
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={FiguraVec3.class}, argumentNames={"pos"}), @LuaMethodOverload(argumentTypes={Double.class, Double.class, Double.class}, argumentNames={"x", "y", "z"})}, value="world.get_block_light_level")
    public static Integer getBlockLightLevel(Object x, Double y, Double z) {
        FiguraVec3 pos = LuaUtils.parseVec3("getBlockLightLevel", x, y, z);
        class_2338 blockPos = pos.asBlockPos();
        class_1937 world = WorldAPI.getCurrentWorld();
        if (world.method_8500(blockPos) == null) {
            return null;
        }
        return world.method_8314(class_1944.field_9282, blockPos);
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={FiguraVec2.class, String.class}, argumentNames={"pos", "heightmap"}), @LuaMethodOverload(argumentTypes={Double.class, Double.class, String.class}, argumentNames={"x", "z", "heightmap"})}, value="world.get_height")
    public static Integer getHeight(Object x, Double z, String heightmap) {
        class_2902.class_2903 heightmapType;
        class_2338 blockPos;
        FiguraVec2 pos = LuaUtils.parseVec2("getHeight", x, z);
        class_1937 world = WorldAPI.getCurrentWorld();
        if (world.method_8500(blockPos = new class_2338((int)pos.x(), 0, (int)pos.y())) == null) {
            return null;
        }
        try {
            heightmapType = heightmap != null ? class_2902.class_2903.valueOf((String)heightmap.toUpperCase(Locale.US)) : class_2902.class_2903.field_13197;
        }
        catch (IllegalArgumentException e) {
            throw new LuaError("Invalid heightmap type provided");
        }
        return world.method_8624(heightmapType, (int)pos.x(), (int)pos.y());
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={FiguraVec3.class}, argumentNames={"pos"}), @LuaMethodOverload(argumentTypes={Double.class, Double.class, Double.class}, argumentNames={"x", "y", "z"})}, value="world.is_open_sky")
    public static Boolean isOpenSky(Object x, Double y, Double z) {
        FiguraVec3 pos = LuaUtils.parseVec3("isOpenSky", x, y, z);
        class_2338 blockPos = pos.asBlockPos();
        class_1937 world = WorldAPI.getCurrentWorld();
        if (world.method_8500(blockPos) == null) {
            return null;
        }
        return world.method_8311(blockPos);
    }

    @LuaWhitelist
    @LuaMethodDoc(value="world.get_dimension")
    public static String getDimension() {
        class_1937 world = WorldAPI.getCurrentWorld();
        return world.method_27983().method_29177().toString();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="world.get_players")
    public static Map<String, EntityAPI<?>> getPlayers() {
        HashMap playerList = new HashMap();
        for (class_1657 player : WorldAPI.getCurrentWorld().method_18456()) {
            playerList.put(player.method_5477().getString(), PlayerAPI.wrap((class_1297)player));
        }
        return playerList;
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={String.class}, argumentNames={"UUID"})}, value="world.get_entity")
    public static EntityAPI<?> getEntity(@LuaNotNil String uuid) {
        try {
            return EntityAPI.wrap(EntityUtils.getEntityByUUID(UUID.fromString(uuid)));
        }
        catch (Exception ignored) {
            throw new LuaError("Invalid UUID");
        }
    }

    @LuaWhitelist
    @LuaMethodDoc(value="world.avatar_vars")
    public static Map<String, LuaTable> avatarVars() {
        HashMap<String, LuaTable> varList = new HashMap<String, LuaTable>();
        for (Avatar avatar : AvatarManager.getLoadedAvatars()) {
            LuaTable tbl = avatar.luaRuntime == null ? new LuaTable() : avatar.luaRuntime.avatar_meta.storedStuff;
            varList.put(avatar.owner.toString(), new ReadOnlyLuaTable((LuaValue)tbl));
        }
        return varList;
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={String.class}, argumentNames={"block"}), @LuaMethodOverload(argumentTypes={String.class, FiguraVec3.class}, argumentNames={"block", "pos"}), @LuaMethodOverload(argumentTypes={String.class, Double.class, Double.class, Double.class}, argumentNames={"block", "x", "y", "z"})}, value="world.new_block")
    public static BlockStateAPI newBlock(@LuaNotNil String string, Object x, Double y, Double z) {
        class_2338 pos = LuaUtils.parseVec3("newBlock", x, y, z).asBlockPos();
        try {
            class_1937 level = WorldAPI.getCurrentWorld();
            class_2680 block = new class_2257().method_9654(new StringReader(string)).method_9494();
            return new BlockStateAPI(block, pos);
        }
        catch (Exception e) {
            throw new LuaError("Could not parse block state from string: " + string);
        }
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={String.class}, argumentNames={"item"}), @LuaMethodOverload(argumentTypes={String.class, Integer.class}, argumentNames={"item", "count"}), @LuaMethodOverload(argumentTypes={String.class, Integer.class, Integer.class}, argumentNames={"item", "count", "damage"})}, value="world.new_item")
    public static ItemStackAPI newItem(@LuaNotNil String string, Integer count, Integer damage) {
        try {
            class_1937 level = WorldAPI.getCurrentWorld();
            class_1799 item = new class_2287().method_9778(new StringReader(string)).method_9781(1, false);
            if (count != null) {
                item.method_7939(count.intValue());
            }
            if (damage != null) {
                item.method_7974(damage.intValue());
            }
            return new ItemStackAPI(item);
        }
        catch (Exception e) {
            throw new LuaError("Could not parse item stack from string: " + string);
        }
    }

    @LuaWhitelist
    @LuaMethodDoc(value="world.exists")
    public static boolean exists() {
        return WorldAPI.getCurrentWorld() != null;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="world.get_build_height")
    public static int[] getBuildHeight() {
        class_1937 world = WorldAPI.getCurrentWorld();
        return new int[]{world.method_31607(), world.method_31600()};
    }

    @LuaWhitelist
    @LuaMethodDoc(value="world.get_spawn_point")
    public static FiguraVec3 getSpawnPoint() {
        class_1937 world = WorldAPI.getCurrentWorld();
        class_5217 levelData = world.method_8401();
        return FiguraVec3.fromBlockPos(new class_2338(levelData.method_215(), levelData.method_144(), levelData.method_166()));
    }

    public String toString() {
        return "WorldAPI";
    }
}

