/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.lua.api.world;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import org.figuramc.figura.lua.LuaWhitelist;
import org.figuramc.figura.lua.api.world.WorldAPI;
import org.figuramc.figura.lua.docs.LuaFieldDoc;
import org.figuramc.figura.lua.docs.LuaMethodDoc;
import org.figuramc.figura.lua.docs.LuaMethodOverload;
import org.figuramc.figura.lua.docs.LuaTypeDoc;
import org.figuramc.figura.math.vector.FiguraVec3;
import org.figuramc.figura.mixin.BiomeAccessor;
import org.figuramc.figura.utils.ColorUtils;
import org.figuramc.figura.utils.LuaUtils;

@LuaWhitelist
@LuaTypeDoc(name="Biome", value="biome")
public class BiomeAPI {
    private final class_1959 biome;
    private class_2338 pos;
    @LuaWhitelist
    @LuaFieldDoc(value="biome.id")
    public final String id;

    public BiomeAPI(class_1959 biome, class_2338 pos) {
        this.biome = biome;
        this.pos = pos;
        this.id = ((class_2378)WorldAPI.getCurrentWorld().method_30349().method_33310(class_2378.field_25114).get()).method_10221((Object)biome).toString();
    }

    protected class_2338 getBlockPos() {
        return this.pos == null ? class_2338.field_10980 : this.pos;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="biome.get_pos")
    public FiguraVec3 getPos() {
        return FiguraVec3.fromBlockPos(this.getBlockPos());
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={FiguraVec3.class}, argumentNames={"pos"}), @LuaMethodOverload(argumentTypes={Double.class, Double.class, Double.class}, argumentNames={"x", "y", "z"})}, aliases={"pos"}, value="biome.set_pos")
    public BiomeAPI setPos(Object x, Double y, Double z) {
        FiguraVec3 newPos = LuaUtils.parseVec3("setPos", x, y, z);
        this.pos = newPos.asBlockPos();
        return this;
    }

    @LuaWhitelist
    public BiomeAPI pos(Object x, Double y, Double z) {
        return this.setPos(x, y, z);
    }

    @LuaWhitelist
    @LuaMethodDoc(value="biome.get_tags")
    public List<String> getTags() {
        ArrayList<String> list = new ArrayList<String>();
        class_2378 registry = WorldAPI.getCurrentWorld().method_30349().method_30530(class_2378.field_25114);
        Optional key = registry.method_29113((Object)this.biome);
        if (key.isEmpty()) {
            return list;
        }
        for (class_6862 biomeTagKey : registry.method_40290((class_5321)key.get()).method_40228().toList()) {
            list.add(biomeTagKey.comp_327().toString());
        }
        return list;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="biome.get_temperature")
    public float getTemperature() {
        return this.biome.method_8712();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="biome.get_precipitation")
    public String getPrecipitation() {
        return this.biome.method_8694().name();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="biome.get_sky_color")
    public FiguraVec3 getSkyColor() {
        return ColorUtils.intToRGB(this.biome.method_8697());
    }

    @LuaWhitelist
    @LuaMethodDoc(value="biome.get_foliage_color")
    public FiguraVec3 getFoliageColor() {
        return ColorUtils.intToRGB(this.biome.method_8698());
    }

    @LuaWhitelist
    @LuaMethodDoc(value="biome.get_grass_color")
    public FiguraVec3 getGrassColor() {
        class_2338 pos = this.getBlockPos();
        return ColorUtils.intToRGB(this.biome.method_8711((double)pos.method_10263(), (double)pos.method_10264()));
    }

    @LuaWhitelist
    @LuaMethodDoc(value="biome.get_fog_color")
    public FiguraVec3 getFogColor() {
        return ColorUtils.intToRGB(this.biome.method_24376());
    }

    @LuaWhitelist
    @LuaMethodDoc(value="biome.get_water_color")
    public FiguraVec3 getWaterColor() {
        return ColorUtils.intToRGB(this.biome.method_8687());
    }

    @LuaWhitelist
    @LuaMethodDoc(value="biome.get_water_fog_color")
    public FiguraVec3 getWaterFogColor() {
        return ColorUtils.intToRGB(this.biome.method_8713());
    }

    @LuaWhitelist
    @LuaMethodDoc(value="biome.get_downfall")
    public float getDownfall() {
        return this.biome.method_8715();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="biome.is_hot")
    public boolean isHot() {
        return ((BiomeAccessor)this.biome).getTheTemperature(this.getBlockPos()) > 1.0f;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="biome.is_cold")
    public boolean isCold() {
        return this.biome.method_33599(this.getBlockPos());
    }

    @LuaWhitelist
    public boolean __eq(BiomeAPI other) {
        return this.biome.equals(other.biome);
    }

    @LuaWhitelist
    public Object __index(String arg) {
        return "id".equals(arg) ? this.id : null;
    }

    public String toString() {
        return this.id + " (Biome)";
    }
}

