/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.lua.api.sound;

import net.minecraft.class_1111;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_3419;
import net.minecraft.class_4224;
import net.minecraft.class_4225;
import net.minecraft.class_4231;
import net.minecraft.class_4235;
import net.minecraft.class_4237;
import org.figuramc.figura.avatar.Avatar;
import org.figuramc.figura.avatar.AvatarManager;
import org.figuramc.figura.lua.LuaWhitelist;
import org.figuramc.figura.lua.api.sound.SoundAPI;
import org.figuramc.figura.lua.docs.LuaMethodDoc;
import org.figuramc.figura.lua.docs.LuaMethodOverload;
import org.figuramc.figura.lua.docs.LuaTypeDoc;
import org.figuramc.figura.math.vector.FiguraVec3;
import org.figuramc.figura.permissions.Permissions;
import org.figuramc.figura.utils.LuaUtils;
import org.figuramc.figura.utils.TextUtils;
import org.luaj.vm2.LuaError;

@LuaWhitelist
@LuaTypeDoc(name="Sound", value="sound")
public class LuaSound {
    private final Avatar owner;
    private final String id;
    private final class_4231 buffer;
    private final class_1111 sound;
    private class_4235.class_4236 handle;
    private boolean playing = false;
    private FiguraVec3 pos = FiguraVec3.of();
    private float pitch = 1.0f;
    private float volume = 1.0f;
    private float attenuation = 1.0f;
    private boolean loop = false;
    private class_2561 subtitleText;
    private String subtitle;

    public LuaSound(class_4231 buffer, String id, Avatar owner) {
        this(null, buffer, id, (class_2561)new class_2585(id), owner);
    }

    public LuaSound(class_1111 sound, String id, class_2561 subtitle, Avatar owner) {
        this(sound, null, id, subtitle, owner);
    }

    private LuaSound(class_1111 sound, class_4231 buffer, String id, class_2561 subtitle, Avatar owner) {
        this.owner = owner;
        this.id = id;
        this.buffer = buffer;
        this.sound = sound;
        this.subtitleText = subtitle;
        this.subtitle = subtitle == null ? null : subtitle.getString();
    }

    public class_4235.class_4236 getHandle() {
        return this.handle;
    }

    public class_2561 getSubtitleText() {
        return this.subtitleText;
    }

    public String getId() {
        return this.id;
    }

    private float calculateVolume() {
        return SoundAPI.getSoundEngine().figura$getVolume(class_3419.field_15248) * ((float)this.owner.permissions.get(Permissions.VOLUME) / 100.0f);
    }

    @LuaWhitelist
    @LuaMethodDoc(value="sound.play")
    public LuaSound play() {
        if (this.playing) {
            return this;
        }
        if (!this.owner.soundsRemaining.use()) {
            this.owner.noPermissions.add(Permissions.SOUNDS);
            return this;
        }
        this.owner.noPermissions.remove(Permissions.SOUNDS);
        if (this.handle != null) {
            this.handle.method_19735(class_4224::method_19654);
            this.playing = true;
            return this;
        }
        if (this.buffer == null && this.sound == null) {
            return this;
        }
        float vol = this.calculateVolume();
        if (vol <= 0.0f) {
            return this;
        }
        this.playing = true;
        AvatarManager.executeAll("playSoundEvent", avatar -> {
            boolean cancel = avatar.playSoundEvent(this.getId(), this.getPos(), this.getVolume(), this.getPitch(), this.isLooping(), class_3419.field_15248.name(), null);
            if (avatar.permissions.get(Permissions.CANCEL_SOUNDS) >= 1) {
                avatar.noPermissions.remove(Permissions.CANCEL_SOUNDS);
                if (cancel) {
                    this.playing = false;
                }
            } else {
                avatar.noPermissions.add(Permissions.CANCEL_SOUNDS);
            }
        });
        if (!this.playing) {
            return this;
        }
        this.handle = this.buffer != null ? SoundAPI.getSoundEngine().figura$createHandle(this.owner.owner, this.id, class_4225.class_4105.field_18352) : SoundAPI.getSoundEngine().figura$createHandle(this.owner.owner, this.id, this.sound.method_4769() ? class_4225.class_4105.field_18353 : class_4225.class_4105.field_18352);
        if (this.handle == null) {
            this.playing = false;
            return this;
        }
        SoundAPI.getSoundEngine().figura$addSound(this);
        if (this.buffer != null) {
            this.handle.method_19735(channel -> {
                channel.method_19639(this.pitch);
                channel.method_19647(this.volume * vol);
                channel.method_19651(this.attenuation * 16.0f);
                channel.method_19645(this.loop);
                channel.method_19641(this.pos.asVec3());
                channel.method_19649(false);
                channel.method_19642(this.buffer);
                channel.method_19650();
            });
        } else {
            this.handle.method_19735(channel -> {
                channel.method_19639(this.pitch);
                channel.method_19647(this.volume * vol);
                channel.method_19651(this.attenuation * 16.0f);
                channel.method_19645(this.loop && !this.sound.method_4769());
                channel.method_19641(this.pos.asVec3());
                channel.method_19649(false);
            });
            class_4237 lib = SoundAPI.getSoundEngine().figura$getSoundBuffers();
            if (!this.sound.method_4769()) {
                lib.method_19743(this.sound.method_4766()).thenAccept(buffer -> this.handle.method_19735(channel -> {
                    channel.method_19642(buffer);
                    channel.method_19650();
                }));
            } else {
                lib.method_19744(this.sound.method_4766(), this.loop).thenAccept(stream -> this.handle.method_19735(channel -> {
                    channel.method_19643(stream);
                    channel.method_19650();
                }));
            }
        }
        return this;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="sound.is_playing")
    public boolean isPlaying() {
        if (this.handle != null) {
            this.handle.method_19735(channel -> {
                this.playing = channel.method_35598();
            });
        }
        return this.playing;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="sound.pause")
    public LuaSound pause() {
        this.playing = false;
        if (this.handle != null) {
            this.handle.method_19735(class_4224::method_19653);
        }
        return this;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="sound.stop")
    public LuaSound stop() {
        this.playing = false;
        if (this.handle != null) {
            this.handle.method_19735(class_4224::method_19655);
        }
        this.handle = null;
        return this;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="sound.get_pos")
    public FiguraVec3 getPos() {
        return this.pos;
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={FiguraVec3.class}, argumentNames={"pos"}), @LuaMethodOverload(argumentTypes={Double.class, Double.class, Double.class}, argumentNames={"x", "y", "z"})}, aliases={"pos"}, value="sound.set_pos")
    public LuaSound setPos(Object x, Double y, Double z) {
        this.pos = LuaUtils.parseVec3("setPos", x, y, z);
        if (this.handle != null) {
            this.handle.method_19735(channel -> channel.method_19641(this.pos.asVec3()));
        }
        return this;
    }

    @LuaWhitelist
    public LuaSound pos(Object x, Double y, Double z) {
        return this.setPos(x, y, z);
    }

    @LuaWhitelist
    @LuaMethodDoc(value="sound.get_volume")
    public float getVolume() {
        return this.volume;
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={Float.class}, argumentNames={"volume"})}, aliases={"volume"}, value="sound.set_volume")
    public LuaSound setVolume(float volume) {
        this.volume = Math.min(volume, 1.0f);
        if (this.handle != null) {
            this.handle.method_19735(channel -> {
                float f = this.calculateVolume();
                if (f <= 0.0f) {
                    channel.method_19655();
                } else {
                    channel.method_19647(this.volume * f);
                }
            });
        }
        return this;
    }

    @LuaWhitelist
    public LuaSound volume(float volume) {
        return this.setVolume(volume);
    }

    @LuaWhitelist
    @LuaMethodDoc(value="sound.get_attenuation")
    public float getAttenuation() {
        return this.attenuation;
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={Float.class}, argumentNames={"attenuation"})}, aliases={"attenuation"}, value="sound.set_attenuation")
    public LuaSound setAttenuation(float attenuation) {
        this.attenuation = Math.max(attenuation, 1.0f);
        if (this.handle != null) {
            this.handle.method_19735(channel -> channel.method_19651(this.attenuation * 16.0f));
        }
        return this;
    }

    @LuaWhitelist
    public LuaSound attenuation(float attenuation) {
        return this.setAttenuation(attenuation);
    }

    @LuaWhitelist
    @LuaMethodDoc(value="sound.get_pitch")
    public float getPitch() {
        return this.pitch;
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={Float.class}, argumentNames={"pitch"})}, aliases={"pitch"}, value="sound.set_pitch")
    public LuaSound setPitch(float pitch) {
        this.pitch = Math.max(pitch, 0.0f);
        if (this.handle != null) {
            this.handle.method_19735(channel -> channel.method_19639(this.pitch));
        }
        return this;
    }

    @LuaWhitelist
    public LuaSound pitch(float pitch) {
        return this.setPitch(pitch);
    }

    @LuaWhitelist
    @LuaMethodDoc(value="sound.is_looping")
    public boolean isLooping() {
        return this.loop;
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={Boolean.class}, argumentNames={"loop"})}, aliases={"loop"}, value="sound.set_loop")
    public LuaSound setLoop(boolean loop) {
        this.loop = loop;
        if (this.handle != null) {
            this.handle.method_19735(channel -> channel.method_19645(this.loop));
        }
        return this;
    }

    @LuaWhitelist
    public LuaSound loop(boolean loop) {
        return this.setLoop(loop);
    }

    @LuaWhitelist
    @LuaMethodDoc(value="sound.get_subtitle")
    public String getSubtitle() {
        return this.subtitle;
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={String.class}, argumentNames={"subtitle"})}, aliases={"subtitle"}, value="sound.set_subtitle")
    public LuaSound setSubtitle(String subtitle) {
        this.subtitle = subtitle;
        if (subtitle == null) {
            this.subtitleText = null;
        } else {
            this.subtitleText = TextUtils.tryParseJson(subtitle);
            if (this.subtitleText.getString().length() > 48) {
                throw new LuaError("Text length exceeded limit of 48 characters");
            }
        }
        return this;
    }

    @LuaWhitelist
    public LuaSound subtitle(String subtitle) {
        return this.setSubtitle(subtitle);
    }

    public String toString() {
        return this.id + " (Sound)";
    }
}

