/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.lua.api.net;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Locale;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_5250;
import org.figuramc.figura.FiguraMod;
import org.figuramc.figura.avatar.Avatar;
import org.figuramc.figura.config.Configs;
import org.figuramc.figura.lua.LuaWhitelist;
import org.figuramc.figura.lua.api.net.HttpRequestsAPI;
import org.figuramc.figura.lua.docs.LuaFieldDoc;
import org.figuramc.figura.lua.docs.LuaMethodDoc;
import org.figuramc.figura.lua.docs.LuaMethodOverload;
import org.figuramc.figura.lua.docs.LuaTypeDoc;
import org.figuramc.figura.permissions.Permissions;
import org.figuramc.figura.utils.ColorUtils;
import org.luaj.vm2.LuaError;
import org.luaj.vm2.LuaValue;

@LuaWhitelist
@LuaTypeDoc(name="NetworkingAPI", value="net")
public class NetworkingAPI {
    private static FileOutputStream logFileOutputStream;
    private static final String NETWORKING_IS_HOST_ONLY = "NetworkingAPI is only allowed in a host environment!";
    private static final String NETWORKING_DISABLED_ERROR_TEXT = "Networking is disabled in config";
    private static final String NO_PERMISSION_ERROR_TEXT = "This avatar doesn't have networking permissions";
    private static final String NETWORKING_DISALLOWED_FOR_LINK_ERROR = "Networking whitelist/blacklist does not allow access to link: %s";
    final Avatar owner;
    @LuaWhitelist
    @LuaFieldDoc(value="net.http")
    public final HttpRequestsAPI http;

    public NetworkingAPI(Avatar owner) {
        this.owner = owner;
        this.http = new HttpRequestsAPI(this);
    }

    public void securityCheck(String link) throws RuntimeException {
        if (!this.owner.isHost) {
            throw new LuaError(NETWORKING_IS_HOST_ONLY);
        }
        if (!((Boolean)Configs.ALLOW_NETWORKING.value).booleanValue()) {
            throw new LuaError(NETWORKING_DISABLED_ERROR_TEXT);
        }
        if (this.owner.permissions.get(Permissions.NETWORKING) < 1) {
            this.owner.noPermissions.add(Permissions.NETWORKING);
            throw new LuaError(NO_PERMISSION_ERROR_TEXT);
        }
        if (!this.isLinkAllowed(link)) {
            throw new LinkNotAllowedException(NETWORKING_DISALLOWED_FOR_LINK_ERROR.formatted(link));
        }
    }

    @LuaWhitelist
    @LuaMethodDoc(value="net.is_networking_allowed", overloads={@LuaMethodOverload(returnType=Boolean.class)})
    public boolean isNetworkingAllowed() {
        return this.owner.isHost && (Boolean)Configs.ALLOW_NETWORKING.value != false && this.owner.permissions.get(Permissions.NETWORKING) >= 1;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="net.is_link_allowed", overloads={@LuaMethodOverload(argumentNames={"link"}, argumentTypes={String.class}, returnType=Boolean.class)})
    public boolean isLinkAllowed(String link) {
        if (!this.owner.isHost) {
            throw new LuaError(NETWORKING_IS_HOST_ONLY);
        }
        RestrictionLevel level = RestrictionLevel.getById((Integer)Configs.NETWORKING_RESTRICTION.value);
        if (level == null) {
            return false;
        }
        ArrayList<Filter> filters = Configs.NETWORK_FILTER.getFilters();
        try {
            URL url = new URL(link);
            if (url.getPort() != -1 && url.getPort() != 80 && url.getPort() != 443) {
                throw new LuaError("Port %s not allowed, only 80 (HTTP) and 443 (HTTPS) are permitted.".formatted(url.getPort()));
            }
            return switch (level) {
                default -> throw new IncompatibleClassChangeError();
                case RestrictionLevel.WHITELIST -> filters.stream().anyMatch(f -> f.matches(url.getHost()));
                case RestrictionLevel.BLACKLIST -> filters.stream().noneMatch(f -> f.matches(url.getHost()));
                case RestrictionLevel.NONE -> true;
            };
        }
        catch (MalformedURLException e) {
            throw new LinkNotAllowedException(NETWORKING_DISALLOWED_FOR_LINK_ERROR.formatted(link));
        }
    }

    void log(LogSource source, class_2561 text) {
        int log = (Integer)Configs.LOG_NETWORKING.value;
        if (log == 3) {
            return;
        }
        class_5250 finalText = new class_2585("[networking:%s:%s] ".formatted(source.name().toLowerCase(Locale.US), this.owner.entityName)).method_27696(ColorUtils.Colors.LUA_PING.style).method_10852((class_2561)text.method_27661().method_27692(class_124.field_1068));
        String logTextString = finalText.getString();
        switch (log) {
            case 2: {
                FiguraMod.sendChatMessage((class_2561)finalText);
                break;
            }
            case 1: {
                FiguraMod.LOGGER.info(logTextString);
            }
        }
        if (logFileOutputStream == null) {
            NetworkingAPI.prepareLogStream();
        }
        try {
            LocalTime t = LocalTime.now();
            NetworkingAPI.writeToLogStream("[%02d:%02d:%02d] [INFO] %s\n".formatted(t.getHour(), t.getMinute(), t.getSecond(), finalText.getString()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    void error(LogSource source, class_2561 text) {
        int log = (Integer)Configs.LOG_NETWORKING.value;
        if (log == 3) {
            return;
        }
        class_5250 finalText = new class_2585("[networking:%s:%s] ".formatted(source.name().toLowerCase(Locale.US), this.owner.entityName)).method_27696(ColorUtils.Colors.LUA_ERROR.style).method_10852((class_2561)text.method_27661().method_27692(class_124.field_1068));
        String logTextString = finalText.getString();
        switch (log) {
            case 2: {
                FiguraMod.sendChatMessage((class_2561)finalText);
                break;
            }
            case 1: {
                FiguraMod.LOGGER.error(logTextString);
            }
        }
        if (logFileOutputStream == null) {
            NetworkingAPI.prepareLogStream();
        }
        try {
            LocalTime t = LocalTime.now();
            NetworkingAPI.writeToLogStream("[%02d:%02d:%02d] [ERROR] %s\n".formatted(t.getHour(), t.getMinute(), t.getSecond(), finalText.getString()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void writeToLogStream(String s) throws IOException {
        logFileOutputStream.write(s.getBytes(StandardCharsets.UTF_8));
        logFileOutputStream.flush();
    }

    private static void prepareLogStream() {
        try {
            Path p = FiguraMod.getFiguraDirectory().resolve("logs");
            File folder = p.toFile();
            folder.mkdirs();
            LocalDate d = LocalDate.now();
            File logFile = p.resolve(String.format("%d-%02d-%02d.log", d.getYear(), d.getMonthValue(), d.getDayOfMonth())).toFile();
            logFileOutputStream = new FileOutputStream(logFile, true);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @LuaWhitelist
    public Object __index(LuaValue key) {
        if (!key.isstring()) {
            return null;
        }
        if (key.tojstring().equals("http")) {
            return this.http;
        }
        return null;
    }

    public String toString() {
        return "NetworkingAPI";
    }

    static class LinkNotAllowedException
    extends RuntimeException {
        public final LuaError luaError;

        public LinkNotAllowedException(String message) {
            this.luaError = new LuaError(message);
        }

        @Override
        public String toString() {
            return "LinkNotAllowedException";
        }
    }

    public static enum RestrictionLevel {
        WHITELIST(0),
        BLACKLIST(1),
        NONE(2);

        private final int id;

        private RestrictionLevel(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }

        public static RestrictionLevel getById(int id) {
            for (RestrictionLevel t : RestrictionLevel.values()) {
                if (t.id != id) continue;
                return t;
            }
            return null;
        }
    }

    static enum LogSource {
        HTTP,
        SOCKET;

    }

    public static class Filter {
        private String filterSource;

        public Filter(String source) {
            this.setSource(source.trim());
        }

        public String getSource() {
            return this.filterSource;
        }

        public void setSource(String filterSource) {
            this.filterSource = filterSource;
        }

        public boolean matches(String s) {
            return s.trim().equalsIgnoreCase(this.filterSource);
        }
    }
}

