/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.lua.api.entity;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_1263;
import net.minecraft.class_1265;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1675;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3966;
import net.minecraft.class_4048;
import org.figuramc.figura.avatar.Avatar;
import org.figuramc.figura.avatar.AvatarManager;
import org.figuramc.figura.lua.LuaWhitelist;
import org.figuramc.figura.lua.NbtToLua;
import org.figuramc.figura.lua.ReadOnlyLuaTable;
import org.figuramc.figura.lua.api.entity.LivingEntityAPI;
import org.figuramc.figura.lua.api.entity.PlayerAPI;
import org.figuramc.figura.lua.api.world.ItemStackAPI;
import org.figuramc.figura.lua.docs.LuaMetamethodDoc;
import org.figuramc.figura.lua.docs.LuaMethodDoc;
import org.figuramc.figura.lua.docs.LuaMethodOverload;
import org.figuramc.figura.lua.docs.LuaTypeDoc;
import org.figuramc.figura.math.vector.FiguraVec2;
import org.figuramc.figura.math.vector.FiguraVec3;
import org.figuramc.figura.mixin.EntityAccessor;
import org.figuramc.figura.utils.EntityUtils;
import org.figuramc.figura.utils.LuaUtils;
import org.jetbrains.annotations.NotNull;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaValue;

@LuaWhitelist
@LuaTypeDoc(name="EntityAPI", value="entity")
public class EntityAPI<T extends class_1297> {
    @NotNull
    protected final UUID entityUUID;
    @NotNull
    protected T entity;
    private String cacheType;

    public EntityAPI(T entity) {
        this.entity = entity;
        this.entityUUID = entity.method_5667();
    }

    public static EntityAPI<?> wrap(class_1297 e) {
        if (e == null) {
            return null;
        }
        if (e instanceof class_1657) {
            class_1657 p = (class_1657)e;
            return new PlayerAPI(p);
        }
        if (e instanceof class_1309) {
            class_1309 le = (class_1309)e;
            return new LivingEntityAPI<class_1309>(le);
        }
        return new EntityAPI<class_1297>(e);
    }

    protected final boolean checkEntity() {
        boolean thingy = true;
        if (this.entity.method_31481() || this.getLevel() != class_310.method_1551().field_1687) {
            class_1297 newEntityInstance = EntityUtils.getEntityByUUID(this.entityUUID);
            boolean bl = thingy = newEntityInstance != null;
            if (thingy) {
                this.entity = newEntityInstance;
            }
        }
        return thingy;
    }

    protected class_1937 getLevel() {
        return ((EntityAccessor)this.entity).getLevel();
    }

    @NotNull
    public T getEntity() {
        return this.entity;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="entity.is_loaded")
    public boolean isLoaded() {
        return this.checkEntity();
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload, @LuaMethodOverload(argumentTypes={Float.class}, argumentNames={"delta"})}, value="entity.get_pos")
    public FiguraVec3 getPos(Float delta) {
        this.checkEntity();
        if (delta == null) {
            delta = Float.valueOf(1.0f);
        }
        return FiguraVec3.fromVec3(this.entity.method_30950(delta.floatValue()));
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload, @LuaMethodOverload(argumentTypes={Float.class}, argumentNames={"delta"})}, value="entity.get_rot")
    public FiguraVec2 getRot(Float delta) {
        this.checkEntity();
        if (delta == null) {
            delta = Float.valueOf(1.0f);
        }
        return FiguraVec2.of(class_3532.method_16439((float)delta.floatValue(), (float)((class_1297)this.entity).field_6004, (float)this.entity.method_36455()), class_3532.method_16439((float)delta.floatValue(), (float)((class_1297)this.entity).field_5982, (float)this.entity.method_36454()));
    }

    @LuaWhitelist
    @LuaMethodDoc(value="entity.get_uuid")
    public String getUUID() {
        return this.entityUUID.toString();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="entity.get_type")
    public String getType() {
        this.checkEntity();
        return this.cacheType != null ? this.cacheType : (this.cacheType = class_2378.field_11145.method_10221((Object)this.entity.method_5864()).toString());
    }

    @LuaWhitelist
    @LuaMethodDoc(value="entity.get_velocity")
    public FiguraVec3 getVelocity() {
        this.checkEntity();
        return FiguraVec3.of(this.entity.method_23317() - ((class_1297)this.entity).field_6038, this.entity.method_23318() - ((class_1297)this.entity).field_5971, this.entity.method_23321() - ((class_1297)this.entity).field_5989);
    }

    @LuaWhitelist
    @LuaMethodDoc(value="entity.get_look_dir")
    public FiguraVec3 getLookDir() {
        this.checkEntity();
        return FiguraVec3.fromVec3(this.entity.method_5720());
    }

    @LuaWhitelist
    @LuaMethodDoc(value="entity.get_frozen_ticks")
    public int getFrozenTicks() {
        this.checkEntity();
        return this.entity.method_32312();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="entity.get_max_air")
    public int getMaxAir() {
        this.checkEntity();
        return this.entity.method_5748();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="entity.get_dimension_name")
    public String getDimensionName() {
        this.checkEntity();
        return this.getLevel().method_27983().method_29177().toString();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="entity.get_pose")
    public String getPose() {
        this.checkEntity();
        return this.entity.method_18376().toString();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="entity.get_vehicle")
    public EntityAPI<?> getVehicle() {
        this.checkEntity();
        return EntityAPI.wrap(this.entity.method_5854());
    }

    @LuaWhitelist
    @LuaMethodDoc(value="entity.is_on_ground")
    public boolean isOnGround() {
        this.checkEntity();
        return this.entity.method_24828();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="entity.get_eye_height")
    public float getEyeHeight() {
        this.checkEntity();
        return this.entity.method_18381(this.entity.method_18376());
    }

    @LuaWhitelist
    @LuaMethodDoc(value="entity.get_bounding_box")
    public FiguraVec3 getBoundingBox() {
        this.checkEntity();
        class_4048 dim = this.entity.method_18377(this.entity.method_18376());
        return FiguraVec3.of(dim.field_18067, dim.field_18068, dim.field_18067);
    }

    @LuaWhitelist
    @LuaMethodDoc(value="entity.get_name")
    public String getName() {
        this.checkEntity();
        return this.entity.method_5477().getString();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="entity.is_wet")
    public boolean isWet() {
        this.checkEntity();
        return this.entity.method_5637();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="entity.is_in_water")
    public boolean isInWater() {
        this.checkEntity();
        return this.entity.method_5799();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="entity.is_underwater")
    public boolean isUnderwater() {
        this.checkEntity();
        return this.entity.method_5869();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="entity.is_in_lava")
    public boolean isInLava() {
        this.checkEntity();
        return this.entity.method_5771();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="entity.is_in_rain")
    public boolean isInRain() {
        this.checkEntity();
        class_2338 blockPos = this.entity.method_24515();
        return this.getLevel().method_8520(blockPos) || this.getLevel().method_8520(new class_2338(blockPos.method_10263(), (int)this.entity.method_5829().field_1325, (int)this.entity.method_23321()));
    }

    @LuaWhitelist
    @LuaMethodDoc(value="entity.has_avatar")
    public boolean hasAvatar() {
        this.checkEntity();
        return AvatarManager.getAvatar(this.entity) != null;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="entity.is_sprinting")
    public boolean isSprinting() {
        this.checkEntity();
        return this.entity.method_5624();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="entity.get_eye_y")
    public double getEyeY() {
        this.checkEntity();
        return this.entity.method_23320();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="entity.is_glowing")
    public boolean isGlowing() {
        this.checkEntity();
        return this.entity.method_5851();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="entity.is_invisible")
    public boolean isInvisible() {
        this.checkEntity();
        return this.entity.method_5767();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="entity.is_silent")
    public boolean isSilent() {
        this.checkEntity();
        return this.entity.method_5701();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="entity.is_sneaking")
    public boolean isSneaking() {
        this.checkEntity();
        return this.entity.method_21751();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="entity.is_crouching")
    public boolean isCrouching() {
        this.checkEntity();
        return this.entity.method_18276();
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={int.class}, argumentNames={"index"})}, value="entity.get_item")
    public ItemStackAPI getItem(int index) {
        this.checkEntity();
        if (--index < 0) {
            return null;
        }
        int i = 0;
        for (class_1799 item : this.entity.method_5743()) {
            if (i == index) {
                return ItemStackAPI.verify(item);
            }
            ++i;
        }
        return null;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="entity.get_nbt")
    public LuaTable getNbt() {
        this.checkEntity();
        class_2487 tag = new class_2487();
        this.entity.method_5647(tag);
        return (LuaTable)NbtToLua.convert((class_2520)tag);
    }

    @LuaWhitelist
    @LuaMethodDoc(value="entity.is_on_fire")
    public boolean isOnFire() {
        this.checkEntity();
        return this.entity.method_5862();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="entity.is_alive")
    public boolean isAlive() {
        this.checkEntity();
        return this.entity.method_5805();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="entity.get_permission_level")
    public int getPermissionLevel() {
        this.checkEntity();
        return ((EntityAccessor)this.entity).getPermissionLevel();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="entity.get_passengers")
    public List<EntityAPI<?>> getPassengers() {
        this.checkEntity();
        ArrayList list = new ArrayList();
        for (class_1297 passenger : this.entity.method_5685()) {
            list.add(EntityAPI.wrap(passenger));
        }
        return list;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="entity.get_controlling_passenger")
    public EntityAPI<?> getControllingPassenger() {
        this.checkEntity();
        return EntityAPI.wrap(this.entity.method_5642());
    }

    @LuaWhitelist
    @LuaMethodDoc(value="entity.get_controlled_vehicle")
    public EntityAPI<?> getControlledVehicle() {
        this.checkEntity();
        return EntityAPI.wrap(this.entity.method_5668());
    }

    @LuaWhitelist
    @LuaMethodDoc(value="entity.has_container")
    public boolean hasContainer() {
        this.checkEntity();
        return this.entity instanceof class_1263;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="entity.has_inventory")
    public boolean hasInventory() {
        this.checkEntity();
        return this.entity instanceof class_1265;
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload, @LuaMethodOverload(argumentTypes={Boolean.class}, argumentNames={"ignoreLiquids"}), @LuaMethodOverload(argumentTypes={Boolean.class, Double.class}, argumentNames={"ignoreLiquids", "distance"})}, value="entity.get_targeted_block")
    public Object[] getTargetedBlock(boolean ignoreLiquids, Double distance) {
        this.checkEntity();
        if (distance == null) {
            distance = 20.0;
        }
        distance = Math.max(Math.min(distance, 20.0), -20.0);
        class_239 result = this.entity.method_5745(distance.doubleValue(), 1.0f, !ignoreLiquids);
        return LuaUtils.parseBlockHitResult(result);
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload, @LuaMethodOverload(argumentTypes={Double.class}, argumentNames={"distance"})}, value="entity.get_targeted_entity")
    public Object[] getTargetedEntity(Double distance) {
        class_238 aABB;
        this.checkEntity();
        if (distance == null) {
            distance = 20.0;
        }
        distance = Math.max(Math.min(distance, 20.0), 0.0);
        class_243 vec3 = this.entity.method_5836(1.0f);
        class_239 result = this.entity.method_5745(distance.doubleValue(), 1.0f, false);
        distance = result.method_17784().method_1025(vec3);
        class_243 vec32 = this.entity.method_5828(1.0f);
        class_243 vec33 = vec3.method_1031(vec32.field_1352 * distance, vec32.field_1351 * distance, vec32.field_1350 * distance);
        class_3966 entityHit = class_1675.method_18075(this.entity, (class_243)vec3, (class_243)vec33, (class_238)(aABB = this.entity.method_5829().method_18804(vec32.method_1021(distance.doubleValue())).method_1014(1.0)), e -> e != this.entity, (double)distance);
        if (entityHit != null) {
            return new Object[]{EntityAPI.wrap(entityHit.method_17782()), FiguraVec3.fromVec3(entityHit.method_17784())};
        }
        return null;
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload, @LuaMethodOverload(argumentTypes={String.class}, argumentNames={"key"})}, value="entity.get_variable")
    public LuaValue getVariable(String key) {
        this.checkEntity();
        Avatar a = AvatarManager.getAvatar(this.entity);
        LuaTable table = a == null || a.luaRuntime == null ? new LuaTable() : a.luaRuntime.avatar_meta.storedStuff;
        table = new ReadOnlyLuaTable((LuaValue)table);
        return key == null ? table : table.get(key);
    }

    @LuaWhitelist
    @LuaMethodDoc(value="entity.is_living")
    public boolean isLiving() {
        return this instanceof LivingEntityAPI;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="entity.is_player")
    public boolean isPlayer() {
        return this instanceof PlayerAPI;
    }

    @LuaWhitelist
    @LuaMetamethodDoc(overloads={@LuaMetamethodDoc.LuaMetamethodOverload(types={boolean.class, EntityAPI.class, EntityAPI.class})})
    public boolean __eq(EntityAPI<?> rhs) {
        return this.entity.equals(rhs.entity);
    }

    @LuaWhitelist
    @LuaMetamethodDoc(overloads={@LuaMetamethodDoc.LuaMetamethodOverload(types={String.class, EntityAPI.class})})
    public String __tostring() {
        return this.toString();
    }

    public String toString() {
        this.checkEntity();
        return (String)(this.entity.method_16914() ? this.entity.method_5797().getString() + " (" + this.getType() + ")" : this.getType()) + " (Entity)";
    }
}

