/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.lua.api.data;

import org.figuramc.figura.lua.LuaWhitelist;
import org.figuramc.figura.lua.docs.LuaMethodDoc;
import org.figuramc.figura.lua.docs.LuaMethodOverload;
import org.figuramc.figura.lua.docs.LuaTypeDoc;
import org.luaj.vm2.LuaError;

@LuaWhitelist
@LuaTypeDoc(value="future", name="Future")
public class FiguraFuture<T> {
    private boolean isDone;
    private boolean hasError;
    private LuaError errorObject;
    private T value;

    public void handle(T value, Throwable error) {
        if (error != null) {
            this.error(error);
        } else {
            this.complete(value);
        }
    }

    public void complete(T value) {
        if (!this.isDone) {
            this.value = value;
            this.isDone = true;
        }
    }

    public void error(Throwable t) {
        if (!this.isDone) {
            LuaError e;
            this.hasError = true;
            this.isDone = true;
            this.errorObject = t instanceof LuaError ? (e = (LuaError)t) : new LuaError(t);
        }
    }

    @LuaWhitelist
    @LuaMethodDoc(value="future.is_done", overloads={@LuaMethodOverload(returnType=Boolean.class)})
    public boolean isDone() {
        return this.isDone;
    }

    @LuaMethodDoc(value="future.has_error", overloads={@LuaMethodOverload(returnType=Boolean.class)})
    public boolean hasError() {
        return this.hasError;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="future.get_value", overloads={@LuaMethodOverload(returnType=Object.class)})
    public T getValue() {
        return this.value;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="future.get_or_error", overloads={@LuaMethodOverload(returnType=Object.class)})
    public T getOrError() {
        if (this.errorObject != null) {
            throw this.errorObject;
        }
        return this.value;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="future.throw_error")
    public void throwError() {
        if (this.errorObject != null) {
            throw this.errorObject;
        }
    }

    public String toString() {
        return "Future(isDone=%s)".formatted(this.isDone);
    }
}

