/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.lua.api;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import net.minecraft.class_1011;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import org.figuramc.figura.avatar.Avatar;
import org.figuramc.figura.lua.LuaNotNil;
import org.figuramc.figura.lua.LuaWhitelist;
import org.figuramc.figura.lua.docs.LuaMethodDoc;
import org.figuramc.figura.lua.docs.LuaMethodOverload;
import org.figuramc.figura.lua.docs.LuaTypeDoc;
import org.figuramc.figura.mixin.render.MissingTextureAtlasSpriteAccessor;
import org.figuramc.figura.model.rendering.texture.FiguraTexture;
import org.figuramc.figura.utils.ColorUtils;
import org.figuramc.figura.utils.LuaUtils;
import org.luaj.vm2.LuaError;
import org.luaj.vm2.LuaTable;

@LuaWhitelist
@LuaTypeDoc(name="TextureAPI", value="textures")
public class TextureAPI {
    public static final int TEXTURE_LIMIT = 128;
    private final Avatar owner;

    public TextureAPI(Avatar owner) {
        this.owner = owner;
    }

    private void check() {
        if (this.owner.renderer == null) {
            throw new LuaError("Avatar have no active renderer!");
        }
    }

    public FiguraTexture register(String name, class_1011 image, boolean ignoreSize) {
        return this.owner.registerTexture(name, image, ignoreSize);
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={String.class, Integer.class, Integer.class}, argumentNames={"name", "width", "height"})}, value="textures.new_texture")
    public FiguraTexture newTexture(@LuaNotNil String name, int width, int height) {
        class_1011 image;
        try {
            image = new class_1011(width, height, true);
        }
        catch (Exception e) {
            throw new LuaError(e.getMessage());
        }
        FiguraTexture texture = this.register(name, image, false);
        texture.fill(0, 0, width, height, ColorUtils.Colors.AWESOME_BLUE.vec.augmented(1.0), null, null, null);
        return texture;
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={String.class, String.class}, argumentNames={"name", "base64Text"}), @LuaMethodOverload(argumentTypes={String.class, LuaTable.class}, argumentNames={"name", "byteArray"})}, value="textures.read")
    public FiguraTexture read(@LuaNotNil String name, @LuaNotNil Object object) {
        class_1011 image;
        byte[] bytes;
        if (object instanceof LuaTable) {
            LuaTable table = (LuaTable)object;
            bytes = new byte[table.length()];
            for (int i = 0; i < bytes.length; ++i) {
                bytes[i] = (byte)table.get(i + 1).checkint();
            }
        } else if (object instanceof String) {
            String s = (String)object;
            bytes = Base64.getDecoder().decode(s);
        } else {
            throw new LuaError("Invalid type for read \"" + object.getClass().getSimpleName() + "\"");
        }
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            image = class_1011.method_4310(null, (InputStream)bais);
            bais.close();
        }
        catch (Exception e) {
            throw new LuaError(e.getMessage());
        }
        return this.register(name, image, false);
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={String.class, FiguraTexture.class}, argumentNames={"name", "texture"})}, value="textures.copy")
    public FiguraTexture copy(@LuaNotNil String name, @LuaNotNil FiguraTexture texture) {
        class_1011 image = texture.copy();
        return this.register(name, image, false);
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={String.class}, argumentNames={"name"})}, value="textures.get")
    public FiguraTexture get(@LuaNotNil String name) {
        this.check();
        return this.owner.renderer.customTextures.get(name);
    }

    @LuaWhitelist
    @LuaMethodDoc(value="textures.get_textures")
    public List<FiguraTexture> getTextures() {
        this.check();
        return new ArrayList<FiguraTexture>(this.owner.renderer.textures.values());
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={String.class, String.class}, argumentNames={"name", "path"})}, value="textures.from_vanilla")
    public FiguraTexture fromVanilla(@LuaNotNil String name, @LuaNotNil String path) {
        this.check();
        class_2960 resourcePath = LuaUtils.parsePath(path);
        try {
            class_1011 image;
            try {
                image = class_1011.method_4309((InputStream)class_310.method_1551().method_1478().method_14486(resourcePath).method_14482());
            }
            catch (Exception ignored) {
                image = (class_1011)MissingTextureAtlasSpriteAccessor.getImageData().method_15332();
            }
            return this.register(name, image, false);
        }
        catch (Exception e) {
            throw new LuaError(e.getMessage());
        }
    }

    @LuaWhitelist
    public FiguraTexture __index(@LuaNotNil String name) {
        this.check();
        return this.owner.renderer.getTexture(name);
    }

    public String toString() {
        return "TextureAPI";
    }
}

