/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.lua;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.function.Function;
import net.minecraft.class_124;
import net.minecraft.class_1299;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_2585;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import org.figuramc.figura.FiguraMod;
import org.figuramc.figura.avatar.Avatar;
import org.figuramc.figura.config.Configs;
import org.figuramc.figura.lua.FiguraLuaRuntime;
import org.figuramc.figura.lua.LuaTypeManager;
import org.figuramc.figura.lua.LuaWhitelist;
import org.figuramc.figura.permissions.Permissions;
import org.figuramc.figura.utils.ColorUtils;
import org.figuramc.figura.utils.TextUtils;
import org.luaj.vm2.LuaError;
import org.luaj.vm2.LuaString;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.Varargs;
import org.luaj.vm2.lib.VarArgFunction;

public class FiguraLuaPrinter {
    public static DecimalFormat df;
    private static final Function<FiguraLuaRuntime, LuaValue> PRINT_FUNCTION;
    private static final Function<FiguraLuaRuntime, LuaValue> PRINT_JSON_FUNCTION;
    private static final Function<FiguraLuaRuntime, LuaValue> PRINT_TABLE_FUNCTION;
    private static final LinkedList<class_2561> chatQueue;
    private static final int MAX_CHARS_QUEUED = 10000000;
    private static int charsQueued;
    private static final int MAX_CHARS_PER_TICK = 10000;

    public static void updateDecimalFormatting() {
        int config = (Integer)Configs.LOG_NUMBER_LENGTH.value;
        df = new DecimalFormat("0" + (String)(config > 0 ? "." + "#".repeat(config) : ""));
        df.setRoundingMode(RoundingMode.DOWN);
    }

    public static void loadPrintFunctions(FiguraLuaRuntime runtime) {
        LuaValue print = PRINT_FUNCTION.apply(runtime);
        runtime.setGlobal("print", print);
        runtime.setGlobal("log", print);
        LuaValue printJson = PRINT_JSON_FUNCTION.apply(runtime);
        runtime.setGlobal("printJson", printJson);
        runtime.setGlobal("logJson", printJson);
        LuaValue printTable = PRINT_TABLE_FUNCTION.apply(runtime);
        runtime.setGlobal("printTable", printTable);
        runtime.setGlobal("logTable", printTable);
    }

    public static void sendLuaMessage(Object message, String owner) {
        class_2585 class_25852;
        class_5250 class_52502 = class_2585.field_24366.method_27661().method_10852((class_2561)new class_2585("[lua] ").method_27696(ColorUtils.Colors.LUA_LOG.style)).method_10852((class_2561)new class_2585(owner)).method_10852((class_2561)new class_2585(" : ").method_27696(ColorUtils.Colors.LUA_LOG.style));
        if (message instanceof class_2561) {
            class_2561 c = (class_2561)message;
            class_25852 = c;
        } else {
            class_25852 = new class_2585(message.toString());
        }
        class_5250 component = class_52502.method_10852((class_2561)class_25852).method_10852((class_2561)new class_2585("\n"));
        if ((Integer)Configs.LOG_LOCATION.value == 0) {
            FiguraLuaPrinter.sendLuaChatMessage((class_2561)component);
        } else {
            FiguraMod.LOGGER.info(component.getString());
        }
    }

    public static void sendLuaError(LuaError error, Avatar owner) {
        Object message = error.toString().replace("org.luaj.vm2.LuaError: ", "").replace("\n\t[Java]: in ?", "").replace("'<eos>' expected", "Expected end of script");
        if (((Boolean)Configs.EASTER_EGGS.value).booleanValue() && Math.random() < 1.0E-4) {
            message = ((String)message).replaceFirst("attempt to index ? (a nil value) with key", "attempt to key (a ? value) with index nil").replaceFirst("attempt to call a nil value", "attempt to nil a call value");
        }
        if (owner.minify) {
            message = (String)message + "\nscript:\n\tscript heavily minified! - cannot look for line numbers!";
        } else {
            try {
                String left;
                int sub;
                String name;
                String src;
                String[] split = ((String)message).split(":", 2);
                if (split.length > 1 && owner.luaRuntime != null && (src = owner.luaRuntime.scripts.get(name = (sub = split[0].indexOf(left = "[string \"")) == -1 ? split[0] : split[0].substring(sub + left.length(), split[0].indexOf("\"]")))) != null) {
                    int line = Integer.parseInt(split[1].split("\\D", 2)[0]);
                    Object str = src.split("\n")[line - 1].trim();
                    if (((String)str).length() > 96) {
                        str = ((String)str).substring(0, 96) + " [...]";
                    }
                    message = (String)message + "\nscript:\n\t" + (String)str;
                }
            }
            catch (Exception split) {
                // empty catch block
            }
        }
        class_5250 component = class_2585.field_24366.method_27661().method_10852((class_2561)new class_2585("[error] ").method_27696(ColorUtils.Colors.LUA_ERROR.style)).method_10852((class_2561)new class_2585(owner.entityName)).method_10852((class_2561)new class_2585(" : " + (String)message).method_27696(ColorUtils.Colors.LUA_ERROR.style)).method_10852((class_2561)new class_2585("\n"));
        owner.errorText = TextUtils.replaceTabs((class_5348)new class_2585((String)message).method_27696(ColorUtils.Colors.LUA_ERROR.style));
        if (owner.entityType == class_1299.field_6097 && !((Boolean)Configs.LOG_OTHERS.value).booleanValue() && !FiguraMod.isLocal(owner.owner) || owner.permissions.getCategory() == Permissions.Category.BLOCKED) {
            return;
        }
        chatQueue.offer((class_2561)component);
        FiguraMod.LOGGER.error("", (Throwable)error);
    }

    public static void sendPingMessage(Avatar owner, String ping, int size, LuaValue[] args) {
        int config = (Integer)Configs.LOG_PINGS.value;
        if (config == 0 || config == 1 && !owner.isHost) {
            return;
        }
        class_5250 text = class_2585.field_24366.method_27661().method_10852((class_2561)new class_2585("[ping] ").method_27696(ColorUtils.Colors.LUA_PING.style)).method_10852((class_2561)new class_2585(owner.entityName)).method_10852((class_2561)new class_2585(" : ").method_27696(ColorUtils.Colors.LUA_PING.style)).method_27693(ping).method_10852((class_2561)new class_2585(" :: ").method_27696(ColorUtils.Colors.LUA_PING.style)).method_27693(size + " bytes").method_10852((class_2561)new class_2585(" :: ").method_27696(ColorUtils.Colors.LUA_PING.style));
        for (LuaValue arg : args) {
            text.method_10852((class_2561)FiguraLuaPrinter.getPrintText(owner.luaRuntime.typeManager, arg, true, false)).method_27693("\t");
        }
        text.method_10852((class_2561)new class_2585("\n"));
        if ((Integer)Configs.LOG_LOCATION.value == 0) {
            FiguraLuaPrinter.sendLuaChatMessage((class_2561)text);
        } else {
            FiguraMod.LOGGER.info(text.getString());
        }
    }

    private static class_2561 tableToText(LuaTypeManager typeManager, LuaValue value, int depth, int indent, boolean hasTooltip) {
        if (value.isuserdata()) {
            return FiguraLuaPrinter.userdataToText(typeManager, value, depth, indent, hasTooltip);
        }
        if (!value.istable() || depth <= 0) {
            return FiguraLuaPrinter.getPrintText(typeManager, value, hasTooltip, true);
        }
        class_5250 text = class_2585.field_24366.method_27661().method_10852((class_2561)new class_2585("table:").method_27696(FiguraLuaPrinter.getTypeColor(value))).method_10852((class_2561)new class_2585(" {\n").method_27692(class_124.field_1080));
        String spacing = "\t".repeat(indent - 1);
        LuaTable table = value.checktable();
        for (LuaValue key : table.keys()) {
            text.method_10852((class_2561)FiguraLuaPrinter.getTableEntry(typeManager, spacing, key, table.get(key), hasTooltip, depth, indent));
        }
        text.method_27693(spacing).method_10852((class_2561)new class_2585("}").method_27692(class_124.field_1080));
        return text;
    }

    private static class_2561 userdataToText(LuaTypeManager typeManager, LuaValue value, int depth, int indent, boolean hasTooltip) {
        if (!value.isuserdata() || depth <= 0) {
            return FiguraLuaPrinter.getPrintText(typeManager, value, hasTooltip, true);
        }
        class_5250 text = class_2585.field_24366.method_27661().method_10852((class_2561)new class_2585("userdata:").method_27696(FiguraLuaPrinter.getTypeColor(value))).method_10852((class_2561)new class_2585(" {\n").method_27692(class_124.field_1080));
        String spacing = "\t".repeat(indent - 1);
        Object data = value.checkuserdata();
        Class<?> clazz = data.getClass();
        if (clazz.isAnnotationPresent(LuaWhitelist.class)) {
            HashSet<String> fields = new HashSet<String>();
            for (Field field : clazz.getFields()) {
                String name = field.getName();
                if (!field.isAnnotationPresent(LuaWhitelist.class) || fields.contains(name)) continue;
                try {
                    Object obj = field.get(data);
                    text.method_10852((class_2561)FiguraLuaPrinter.getTableEntry(typeManager, spacing, (LuaValue)LuaValue.valueOf((String)name), typeManager.javaToLua(obj).arg1(), hasTooltip, depth, indent));
                    fields.add(name);
                }
                catch (Exception e) {
                    FiguraMod.LOGGER.error("", (Throwable)e);
                }
            }
            HashSet<String> methods = new HashSet<String>();
            for (Method method : clazz.getMethods()) {
                String name = method.getName();
                if (!method.isAnnotationPresent(LuaWhitelist.class) || name.startsWith("__") || methods.contains(name)) continue;
                text.method_10852((class_2561)FiguraLuaPrinter.getTableEntry(typeManager, spacing, (LuaValue)LuaValue.valueOf((String)name), (LuaValue)typeManager.getWrapper(method), hasTooltip, depth, indent));
                methods.add(name);
            }
        }
        text.method_27693(spacing).method_10852((class_2561)new class_2585("}").method_27692(class_124.field_1080));
        return text;
    }

    private static class_5250 getTableEntry(LuaTypeManager typeManager, String spacing, LuaValue key, LuaValue value, boolean hasTooltip, int depth, int indent) {
        class_5250 text = class_2585.field_24366.method_27661().method_27693(spacing).method_27693("\t");
        text.method_10852((class_2561)new class_2585("[").method_27692(class_124.field_1080)).method_10852((class_2561)FiguraLuaPrinter.getPrintText(typeManager, key, hasTooltip, true)).method_10852((class_2561)new class_2585("] = ").method_27692(class_124.field_1080));
        if (value.istable() || value.isuserdata()) {
            text.method_10852(FiguraLuaPrinter.tableToText(typeManager, value, depth - 1, indent + 1, hasTooltip));
        } else {
            text.method_10852((class_2561)FiguraLuaPrinter.getPrintText(typeManager, value, hasTooltip, true));
        }
        text.method_27693("\n");
        return text;
    }

    private static class_5250 getPrintText(LuaTypeManager typeManager, LuaValue value, boolean hasTooltip, boolean quoteStrings) {
        Object ret;
        if (!(value instanceof LuaString) && value.isnumber()) {
            Double d = value.checkdouble();
            ret = d == Math.rint(d) ? value.tojstring() : df.format(d);
        } else {
            ret = value.tojstring();
            if (value.isstring() && quoteStrings) {
                ret = "\"" + (String)ret + "\"";
            }
        }
        class_5250 text = new class_2585((String)ret).method_27696(FiguraLuaPrinter.getTypeColor(value));
        if (hasTooltip && (value.istable() || value.isuserdata())) {
            class_2561 table = TextUtils.replaceTabs((class_5348)FiguraLuaPrinter.tableToText(typeManager, value, 1, 1, false));
            text.method_27696(class_2583.field_24360.method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)table)));
        }
        return text;
    }

    private static class_2583 getTypeColor(LuaValue value) {
        if (value.istable()) {
            return ColorUtils.Colors.AWESOME_BLUE.style;
        }
        if (!(value instanceof LuaString) && value.isnumber()) {
            return ColorUtils.Colors.BLUE.style;
        }
        if (value.isnil()) {
            return ColorUtils.Colors.LUA_ERROR.style;
        }
        if (value.isboolean()) {
            return ColorUtils.Colors.LUA_PING.style;
        }
        if (value.isfunction()) {
            return class_2583.field_24360.method_10977(class_124.field_1060);
        }
        if (value.isuserdata()) {
            return class_2583.field_24360.method_10977(class_124.field_1054);
        }
        if (value.isthread()) {
            return class_2583.field_24360.method_10977(class_124.field_1065);
        }
        return class_2583.field_24360.method_10977(class_124.field_1068);
    }

    private static void sendLuaChatMessage(class_2561 message) throws LuaError {
        if ((charsQueued += message.getString().length()) > 10000000) {
            chatQueue.clear();
            charsQueued = 0;
            throw new LuaError("Chat overflow: printing too much!");
        }
        chatQueue.offer(message);
    }

    public static void clearPrintQueue() {
        chatQueue.clear();
    }

    public static void printChatFromQueue() {
        class_2561 text;
        if (chatQueue.isEmpty()) {
            return;
        }
        class_5250 toPrint = class_2585.field_24366.method_27661();
        int i = 10000;
        while (i > 0 && (text = chatQueue.poll()) != null) {
            int len = text.getString().length();
            if (len <= i) {
                i -= len;
                toPrint.method_10852(text);
                continue;
            }
            chatQueue.offerFirst(TextUtils.substring((class_5348)text, i, len));
            chatQueue.offerFirst(TextUtils.substring((class_5348)text, 0, i));
        }
        String print = toPrint.getString();
        if (!print.isEmpty()) {
            charsQueued -= print.length();
            FiguraMod.sendChatMessage((class_2561)(print.endsWith("\n") ? TextUtils.substring((class_5348)toPrint, 0, print.length() - 1) : toPrint));
        }
    }

    static {
        FiguraLuaPrinter.updateDecimalFormatting();
        PRINT_FUNCTION = runtime -> new VarArgFunction((FiguraLuaRuntime)runtime){
            final /* synthetic */ FiguraLuaRuntime val$runtime;
            {
                this.val$runtime = figuraLuaRuntime;
            }

            public Varargs invoke(Varargs args) {
                if (!((Boolean)Configs.LOG_OTHERS.value).booleanValue() && !FiguraMod.isLocal(this.val$runtime.owner.owner)) {
                    return NIL;
                }
                class_5250 text = class_2585.field_24366.method_27661();
                for (int i = 0; i < args.narg(); ++i) {
                    text.method_10852((class_2561)FiguraLuaPrinter.getPrintText(this.val$runtime.typeManager, args.arg(i + 1), true, false)).method_27693("\t");
                }
                FiguraLuaPrinter.sendLuaMessage(text, this.val$runtime.owner.entityName);
                return LuaValue.valueOf((String)text.getString());
            }

            public String tojstring() {
                return "function: print";
            }
        };
        PRINT_JSON_FUNCTION = runtime -> new VarArgFunction((FiguraLuaRuntime)runtime){
            final /* synthetic */ FiguraLuaRuntime val$runtime;
            {
                this.val$runtime = figuraLuaRuntime;
            }

            public Varargs invoke(Varargs args) {
                boolean local = FiguraMod.isLocal(this.val$runtime.owner.owner);
                if (!((Boolean)Configs.LOG_OTHERS.value).booleanValue() && !local) {
                    return NIL;
                }
                TextUtils.allowScriptEvents = true;
                class_5250 text = class_2585.field_24366.method_27661();
                for (int i = 0; i < args.narg(); ++i) {
                    text.method_10852(TextUtils.tryParseJson(args.arg(i + 1).tojstring()));
                }
                TextUtils.allowScriptEvents = false;
                if (!local) {
                    FiguraLuaPrinter.sendLuaChatMessage(TextUtils.removeClickableObjects((class_5348)text));
                } else {
                    FiguraLuaPrinter.sendLuaChatMessage((class_2561)text);
                }
                return LuaValue.valueOf((String)text.getString());
            }

            public String tojstring() {
                return "function: printJson";
            }
        };
        PRINT_TABLE_FUNCTION = runtime -> new VarArgFunction((FiguraLuaRuntime)runtime){
            final /* synthetic */ FiguraLuaRuntime val$runtime;
            {
                this.val$runtime = figuraLuaRuntime;
            }

            public Varargs invoke(Varargs args) {
                if (!((Boolean)Configs.LOG_OTHERS.value).booleanValue() && !FiguraMod.isLocal(this.val$runtime.owner.owner)) {
                    return NIL;
                }
                boolean silent = false;
                class_5250 text = class_2585.field_24366.method_27661();
                if (args.narg() > 0) {
                    int depth = args.arg(2).isnumber() ? args.arg(2).checkint() : 1;
                    text.method_10852(FiguraLuaPrinter.tableToText(this.val$runtime.typeManager, args.arg(1), depth, 1, true));
                    boolean bl = silent = args.arg(3).isboolean() && args.arg(3).checkboolean();
                }
                if (!silent) {
                    FiguraLuaPrinter.sendLuaMessage(text, this.val$runtime.owner.entityName);
                }
                return LuaValue.valueOf((String)text.getString());
            }

            public String tojstring() {
                return "function: printTable";
            }
        };
        chatQueue = new LinkedList();
        charsQueued = 0;
    }
}

