/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.gui.widgets.lists;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import net.minecraft.class_5348;
import org.figuramc.figura.FiguraMod;
import org.figuramc.figura.gui.widgets.FiguraWidget;
import org.figuramc.figura.gui.widgets.SliderWidget;
import org.figuramc.figura.gui.widgets.SwitchButton;
import org.figuramc.figura.gui.widgets.TextField;
import org.figuramc.figura.gui.widgets.lists.AbstractList;
import org.figuramc.figura.permissions.PermissionManager;
import org.figuramc.figura.permissions.PermissionPack;
import org.figuramc.figura.permissions.Permissions;
import org.figuramc.figura.utils.ColorUtils;
import org.figuramc.figura.utils.FiguraText;
import org.figuramc.figura.utils.ui.UIHelper;

public class PermissionsList
extends AbstractList {
    public boolean precise = false;
    private final Map<class_2561, List<class_364>> permissions = new LinkedHashMap<class_2561, List<class_364>>();

    public PermissionsList(int x, int y, int width, int height) {
        super(x, y, width, height);
    }

    @Override
    public void method_25394(class_4587 stack, int mouseX, int mouseY, float delta) {
        boolean titles;
        int x = this.getX();
        int y = this.getY();
        int width = this.method_25368();
        int height = this.method_25364();
        UIHelper.renderSliced(stack, x, y, width, height, UIHelper.OUTLINE_FILL);
        UIHelper.setupScissor(x + this.scissorsX, y + this.scissorsY, width + this.scissorsWidth, height + this.scissorsHeight);
        class_327 font = class_310.method_1551().field_1772;
        Objects.requireNonNull(font);
        int lineHeight = 9;
        int entryHeight = 27 + lineHeight;
        int titleHeight = 16 + lineHeight;
        int size = 0;
        for (List<class_364> value : this.permissions.values()) {
            size += value.size();
        }
        int totalHeight = size * entryHeight;
        boolean bl = titles = this.permissions.size() > 1;
        if (titles) {
            totalHeight += this.permissions.size() * titleHeight;
        }
        this.scrollBar.setY(y + 4);
        this.scrollBar.setVisible(totalHeight > height);
        this.scrollBar.setScrollRatio(entryHeight, totalHeight - height);
        int xOffset = this.scrollBar.isVisible() ? 8 : 15;
        int yOffset = this.scrollBar.isVisible() ? (int)(-class_3532.method_16436((double)this.scrollBar.getScrollProgress(), (double)-16.0, (double)(totalHeight - height))) : 16;
        for (Map.Entry<class_2561, List<class_364>> entry : this.permissions.entrySet()) {
            if (titles) {
                UIHelper.method_27534((class_4587)stack, (class_327)font, (class_2561)entry.getKey(), (int)(x + (width - xOffset) / 2), (int)(y + yOffset), (int)0xFFFFFF);
                yOffset += titleHeight;
            }
            for (class_364 widget : entry.getValue()) {
                ((FiguraWidget)widget).setX(x + xOffset);
                ((FiguraWidget)widget).setY(y + yOffset);
                yOffset += entryHeight;
            }
        }
        super.method_25394(stack, mouseX, mouseY, delta);
        UIHelper.disableScissor();
    }

    public void updateList(PermissionPack container) {
        for (List<class_364> list : this.permissions.values()) {
            list.forEach(this.children::remove);
        }
        this.permissions.clear();
        this.permissions.put((class_2561)new FiguraText(), this.generateWidgets(container, Permissions.DEFAULT, "figura"));
        for (Map.Entry entry : PermissionManager.CUSTOM_PERMISSIONS.entrySet()) {
            this.permissions.put((class_2561)new class_2588((String)entry.getKey()), this.generateWidgets(container, (Collection)entry.getValue(), (String)entry.getKey()));
        }
    }

    private List<class_364> generateWidgets(PermissionPack container, Collection<Permissions> coll, String id) {
        ArrayList<class_364> list = new ArrayList<class_364>();
        int x = this.getX();
        int y = this.method_25368();
        int width = this.method_25368();
        for (Permissions permissions : coll) {
            Objects.requireNonNull(class_310.method_1551().field_1772);
            int lineHeight = 9;
            String text = id + ".permissions.value." + permissions.name.toLowerCase(Locale.US);
            FiguraWidget widget = !permissions.isToggle ? (!this.precise ? new PermissionSlider(x + 8, y, width - 30, 11 + lineHeight, container, permissions, this, id, text) : new PermissionField(x + 8, y, width - 30, 11 + lineHeight, container, permissions, this, id, text)) : new PermissionSwitch(x + 8, y, width - 30, 20 + lineHeight, container, permissions, this, id, text);
            list.add((class_364)widget);
            this.children.add(widget);
        }
        return list;
    }

    private static class PermissionSlider
    extends SliderWidget {
        private static final class_2561 INFINITY = new FiguraText("permissions.infinity");
        private final PermissionPack container;
        private final Permissions permissions;
        private final PermissionsList parent;
        private final String text;
        private class_2561 value;
        private boolean changed;

        public PermissionSlider(int x, int y, int width, int height, PermissionPack container, Permissions permissions, PermissionsList parent, String id, String text) {
            super(x, y, width, height, class_3532.method_15350((double)((double)container.get(permissions) / ((double)permissions.max.intValue() + 1.0)), (double)0.0, (double)1.0), permissions.max / permissions.stepSize + 1, permissions.showSteps());
            this.container = container;
            this.permissions = permissions;
            this.parent = parent;
            this.text = text;
            this.value = container.get(permissions) == Integer.MAX_VALUE ? INFINITY : new class_2585(String.valueOf(container.get(permissions)));
            this.changed = container.isChanged(permissions);
            this.setAction(slider -> {
                int value = this.showSteps ? ((SliderWidget)slider).getIntValue() * permissions.stepSize : (int)(((double)permissions.max.intValue() + 1.0) * slider.getScrollProgress());
                boolean infinity = permissions.checkInfinity(value);
                container.insert(permissions, infinity ? Integer.MAX_VALUE : value, id);
                this.changed = container.isChanged(permissions);
                this.value = infinity ? INFINITY : new class_2585(String.valueOf(value));
            });
        }

        @Override
        public void method_25359(class_4587 stack, int mouseX, int mouseY, float delta) {
            class_327 font = class_310.method_1551().field_1772;
            stack.method_22903();
            Objects.requireNonNull(font);
            stack.method_22904(0.0, 9.0, 0.0);
            super.method_25359(stack, mouseX, mouseY, delta);
            stack.method_22909();
            class_2588 name = new class_2588(this.text);
            if (this.changed) {
                name = new class_2585("*").method_10862(FiguraMod.getAccentColor()).method_10852((class_2561)name).method_27693("*");
            }
            int valueX = this.getX() + this.method_25368() - font.method_27525((class_5348)this.value) - 1;
            int x = this.getX() + 1;
            int y = this.getY() + 1;
            int width = valueX - this.getX() - 2;
            UIHelper.renderScrollingText(stack, (class_2561)name, x, y, width, 0xFFFFFF);
            font.method_30883(stack, (class_2561)this.value.method_27661().method_10862(FiguraMod.getAccentColor()), (float)valueX, (float)(this.getY() + 1), 0xFFFFFF);
            if (this.parent.isInsideScissors(mouseX, mouseY)) {
                Objects.requireNonNull(font);
                if (UIHelper.isMouseOver(x, y, width, 9, mouseX, mouseY)) {
                    UIHelper.setTooltip((class_2561)new class_2588(this.text + ".tooltip"));
                }
            }
        }

        @Override
        public boolean method_25402(double mouseX, double mouseY, int button) {
            if (!(this.method_37303() && this.method_25367() && this.method_25405(mouseX, mouseY))) {
                return false;
            }
            if (button == 1) {
                this.container.reset(this.permissions);
                this.parent.updateList(this.container);
                this.method_25354(class_310.method_1551().method_1483());
                return true;
            }
            return super.method_25402(mouseX, mouseY, button);
        }

        @Override
        public boolean method_25405(double mouseX, double mouseY) {
            return this.parent.isInsideScissors(mouseX, mouseY) && super.method_25405(mouseX, mouseY);
        }
    }

    private static class PermissionField
    extends TextField {
        private static final Predicate<String> validator = s -> {
            try {
                Integer i = Integer.parseInt(s);
                return i >= 0;
            }
            catch (Exception ignored) {
                return false;
            }
        };
        private final PermissionPack container;
        private final Permissions permissions;
        private final PermissionsList parent;
        private final String text;
        private class_2561 value;
        private boolean changed;

        public PermissionField(int x, int y, int width, int height, PermissionPack container, Permissions permissions, PermissionsList parent, String id, String text) {
            super(x, y, width, height, null, null);
            this.container = container;
            this.permissions = permissions;
            this.parent = parent;
            this.text = text;
            String val = String.valueOf(container.get(permissions));
            this.value = new class_2585(val);
            this.changed = container.isChanged(permissions);
            this.getField().method_1852(val);
            this.getField().method_1863(txt -> {
                if (!validator.test((String)txt)) {
                    return;
                }
                int value = Integer.parseInt(txt);
                container.insert(permissions, value, id);
                this.changed = container.isChanged(permissions);
                this.value = new class_2585(String.valueOf(value));
            });
        }

        @Override
        public void method_25394(class_4587 stack, int mouseX, int mouseY, float delta) {
            class_327 font = class_310.method_1551().field_1772;
            int color = 0xFFFFFF;
            String text = this.getField().method_1882();
            if (!validator.test(text)) {
                color = 0xFF5555;
            } else if (this.changed) {
                class_5251 textColor = FiguraMod.getAccentColor().method_10973();
                color = textColor == null ? ColorUtils.Colors.AWESOME_BLUE.hex : textColor.method_27716();
            }
            this.setColor(color);
            this.setBorderColour(-16777216 + color);
            stack.method_22903();
            super.method_25394(stack, mouseX, mouseY, delta);
            stack.method_22909();
            class_2588 name = new class_2588(this.text);
            if (this.changed) {
                name = new class_2585("*").method_10862(FiguraMod.getAccentColor()).method_10852((class_2561)name).method_27693("*");
            }
            int valueX = this.getX() + this.method_25368() - font.method_27525((class_5348)this.value) - 1;
            int x = this.getX() + 1;
            int n = this.getY() + 1;
            Objects.requireNonNull(font);
            int y = n - 9;
            int width = valueX - this.getX() - 2;
            UIHelper.renderScrollingText(stack, (class_2561)name, x, y, width, 0xFFFFFF);
            class_5250 class_52502 = this.value.method_27661().method_10862(FiguraMod.getAccentColor());
            float f = valueX;
            int n2 = this.getY() + 1;
            Objects.requireNonNull(font);
            font.method_30883(stack, (class_2561)class_52502, f, (float)(n2 - 9), 0xFFFFFF);
            if (this.parent.isInsideScissors(mouseX, mouseY)) {
                Objects.requireNonNull(font);
                if (UIHelper.isMouseOver(x, y, width, 9, mouseX, mouseY)) {
                    UIHelper.setTooltip((class_2561)new class_2588(this.text + ".tooltip"));
                }
            }
        }

        @Override
        public boolean method_25402(double mouseX, double mouseY, int button) {
            if (!this.isEnabled() || !this.method_25405(mouseX, mouseY)) {
                return false;
            }
            if (button == 1) {
                this.container.reset(this.permissions);
                this.parent.updateList(this.container);
                this.getField().method_25354(class_310.method_1551().method_1483());
                return true;
            }
            return super.method_25402(mouseX, mouseY, button);
        }

        @Override
        public boolean method_25405(double mouseX, double mouseY) {
            return this.parent.isInsideScissors(mouseX, mouseY) && super.method_25405(mouseX, mouseY);
        }
    }

    private static class PermissionSwitch
    extends SwitchButton {
        private final PermissionPack container;
        private final Permissions permissions;
        private final PermissionsList parent;
        private final String id;
        private final String text;
        private class_2561 value;
        private boolean changed;

        public PermissionSwitch(int x, int y, int width, int height, PermissionPack container, Permissions permissions, PermissionsList parent, String id, String text) {
            super(x, y, width, height, (class_2561)new class_2588(text), permissions.asBoolean(container.get(permissions)));
            this.container = container;
            this.permissions = permissions;
            this.parent = parent;
            this.id = id;
            this.text = text;
            this.changed = container.isChanged(permissions);
            this.value = new FiguraText("permissions." + (this.toggled ? "enabled" : "disabled"));
        }

        @Override
        public void method_25306() {
            boolean value = !this.isToggled();
            this.container.insert(this.permissions, value ? 1 : 0, this.id);
            this.changed = this.container.isChanged(this.permissions);
            this.value = new FiguraText("permissions." + (value ? "enabled" : "disabled"));
            super.method_25306();
        }

        @Override
        public void method_25359(class_4587 stack, int mouseX, int mouseY, float delta) {
            super.method_25359(stack, mouseX, mouseY, delta);
            if (this.parent.isInsideScissors(mouseX, mouseY)) {
                int n = this.getX() + 1;
                int n2 = this.getY() + 1;
                int n3 = this.method_25368() - 2;
                Objects.requireNonNull(class_310.method_1551().field_1772);
                if (UIHelper.isMouseOver(n, n2, n3, 9, mouseX, mouseY)) {
                    UIHelper.setTooltip((class_2561)new class_2588(this.text + ".tooltip"));
                }
            }
        }

        @Override
        protected void renderDefaultTexture(class_4587 stack, float delta) {
            class_327 font = class_310.method_1551().field_1772;
            stack.method_22903();
            Objects.requireNonNull(font);
            stack.method_22904(0.0, 9.0, 0.0);
            super.renderDefaultTexture(stack, delta);
            stack.method_22909();
        }

        @Override
        protected void renderText(class_4587 stack, float delta) {
            class_327 font = class_310.method_1551().field_1772;
            class_5250 name = this.method_25369().method_27661();
            if (this.changed) {
                name = new class_2585("*").method_10862(FiguraMod.getAccentColor()).method_10852((class_2561)name).method_27693("*");
            }
            int valueX = this.getX() + this.method_25368() - font.method_27525((class_5348)this.value) - 1;
            int n = this.getY();
            Objects.requireNonNull(font);
            int n2 = n + 9 + 11;
            Objects.requireNonNull(font);
            int valueY = n2 - 9 / 2;
            UIHelper.renderScrollingText(stack, (class_2561)name, this.getX() + 1, this.getY() + 1, this.method_25368() - 2, 0xFFFFFF);
            font.method_30883(stack, (class_2561)this.value.method_27661().method_10862(FiguraMod.getAccentColor()), (float)valueX, (float)valueY, 0xFFFFFF);
        }

        @Override
        public boolean method_25402(double mouseX, double mouseY, int button) {
            if (!(this.method_37303() && this.method_25367() && this.method_25405(mouseX, mouseY))) {
                return false;
            }
            if (button == 1) {
                this.container.reset(this.permissions);
                this.parent.updateList(this.container);
                this.method_25354(class_310.method_1551().method_1483());
                return true;
            }
            return super.method_25402(mouseX, mouseY, button);
        }

        @Override
        public boolean method_25405(double mouseX, double mouseY) {
            return this.parent.isInsideScissors(mouseX, mouseY) && super.method_25405(mouseX, mouseY);
        }
    }
}

