/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.gui.widgets.lists;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3532;
import net.minecraft.class_3675;
import net.minecraft.class_4587;
import org.figuramc.figura.FiguraMod;
import org.figuramc.figura.avatar.Avatar;
import org.figuramc.figura.gui.widgets.AbstractContainerElement;
import org.figuramc.figura.gui.widgets.Button;
import org.figuramc.figura.gui.widgets.KeybindWidgetHelper;
import org.figuramc.figura.gui.widgets.Label;
import org.figuramc.figura.gui.widgets.ParentedButton;
import org.figuramc.figura.gui.widgets.lists.AbstractList;
import org.figuramc.figura.lua.api.keybind.FiguraKeybind;
import org.figuramc.figura.utils.FiguraText;
import org.figuramc.figura.utils.TextUtils;
import org.figuramc.figura.utils.ui.UIHelper;

public class KeybindList
extends AbstractList {
    private final List<KeybindElement> keybinds = new ArrayList<KeybindElement>();
    private final Avatar owner;
    private final Button resetAllButton;
    private FiguraKeybind focusedKeybind;

    public KeybindList(int x, int y, int width, int height, Avatar owner, Button resetAllButton) {
        super(x, y, width, height);
        this.owner = owner;
        this.resetAllButton = resetAllButton;
        this.updateList();
        Label noOwner = new Label(new FiguraText("gui.error.no_avatar").method_27692(class_124.field_1054), x + width / 2, y + height / 2, TextUtils.Alignment.CENTER, 0);
        this.children.add(noOwner);
        Label noKeys = new Label(new FiguraText("gui.error.no_keybinds").method_27692(class_124.field_1054), x + width / 2, y + height / 2, TextUtils.Alignment.CENTER, 0);
        this.children.add(noKeys);
        noKeys.centerVertically = true;
        noOwner.centerVertically = true;
        noOwner.setVisible(owner == null);
        noKeys.setVisible(!noOwner.isVisible() && this.keybinds.isEmpty());
    }

    @Override
    public void method_25394(class_4587 stack, int mouseX, int mouseY, float delta) {
        UIHelper.renderSliced(stack, this.getX(), this.getY(), this.method_25368(), this.method_25364(), UIHelper.OUTLINE_FILL);
        UIHelper.setupScissor(this.getX() + this.scissorsX, this.getY() + this.scissorsY, this.method_25368() + this.scissorsWidth, this.method_25364() + this.scissorsHeight);
        if (!this.keybinds.isEmpty()) {
            this.updateEntries();
        }
        super.method_25394(stack, mouseX, mouseY, delta);
        UIHelper.disableScissor();
    }

    private void updateEntries() {
        int totalHeight = -4;
        for (KeybindElement keybind : this.keybinds) {
            totalHeight += keybind.method_25364() + 8;
        }
        int entryHeight = this.keybinds.isEmpty() ? 0 : totalHeight / this.keybinds.size();
        this.scrollBar.setVisible(totalHeight > this.method_25364());
        this.scrollBar.setScrollRatio(entryHeight, totalHeight - this.method_25364());
        int xOffset = this.scrollBar.isVisible() ? 4 : 11;
        int yOffset = this.scrollBar.isVisible() ? (int)(-class_3532.method_16436((double)this.scrollBar.getScrollProgress(), (double)-4.0, (double)(totalHeight - this.method_25364()))) : 4;
        for (KeybindElement keybind : this.keybinds) {
            keybind.setX(this.getX() + xOffset);
            keybind.setY(this.getY() + yOffset);
            yOffset += keybind.method_25364() + 8;
        }
    }

    private void updateList() {
        this.keybinds.forEach(this.children::remove);
        if (this.owner == null || this.owner.luaRuntime == null) {
            return;
        }
        for (FiguraKeybind keybind : this.owner.luaRuntime.keybinds.keyBindings) {
            KeybindElement element = new KeybindElement(this.method_25368() - 22, keybind, this);
            this.keybinds.add(element);
            this.children.add(element);
        }
        this.updateBindings();
    }

    public boolean updateKey(class_3675.class_306 key) {
        if (this.focusedKeybind == null) {
            return false;
        }
        this.focusedKeybind.setKey(key);
        this.focusedKeybind = null;
        FiguraMod.processingKeybind = false;
        this.updateBindings();
        return true;
    }

    public void updateBindings() {
        boolean active = false;
        for (KeybindElement keybind : this.keybinds) {
            keybind.updateText();
            if (active || keybind.keybind.isDefault()) continue;
            active = true;
        }
        this.resetAllButton.setActive(active);
    }

    private static class KeybindElement
    extends AbstractContainerElement {
        private final KeybindWidgetHelper helper = new KeybindWidgetHelper();
        private final FiguraKeybind keybind;
        private final KeybindList parent;
        private final Button resetButton;
        private final Button keybindButton;

        public KeybindElement(int width, FiguraKeybind keybind, KeybindList parent) {
            super(0, 0, width, 20);
            this.keybind = keybind;
            this.parent = parent;
            this.keybindButton = new ParentedButton(0, 0, 90, 20, keybind.getTranslatedKeyMessage(), this, button -> {
                parent.focusedKeybind = keybind;
                FiguraMod.processingKeybind = true;
                this.updateText();
            });
            this.children.add(0, this.keybindButton);
            this.resetButton = new ParentedButton(0, 0, 60, 20, (class_2561)new class_2588("controls.reset"), this, button -> {
                keybind.resetDefaultKey();
                parent.updateBindings();
            });
            this.children.add(this.resetButton);
        }

        @Override
        public void method_25394(class_4587 stack, int mouseX, int mouseY, float delta) {
            if (!this.isVisible()) {
                return;
            }
            this.helper.renderConflictBars(stack, this.keybindButton.field_22760 - 8, this.keybindButton.field_22761 + 2, 4, 16);
            class_327 font = class_310.method_1551().field_1772;
            int n = this.getY() + this.method_25364() / 2;
            Objects.requireNonNull(font);
            int textY = n - 9 / 2;
            this.setHovered(this.method_25405(mouseX, mouseY));
            if (this.isHovered()) {
                font.method_30883(stack, HOVERED_ARROW, (float)(this.getX() + 4), (float)textY, 0xFFFFFF);
                if (this.keybindButton.method_25367()) {
                    this.helper.renderTooltip();
                }
            }
            font.method_1729(stack, this.keybind.getName(), (float)(this.getX() + 16), (float)textY, 0xFFFFFF);
            super.method_25394(stack, mouseX, mouseY, delta);
        }

        @Override
        public boolean method_25405(double mouseX, double mouseY) {
            return this.parent.isInsideScissors(mouseX, mouseY) && super.method_25405(mouseX, mouseY);
        }

        @Override
        public void setX(int x) {
            super.setX(x);
            this.resetButton.setX(x + this.method_25368() - 60);
            this.keybindButton.setX(x + this.method_25368() - 154);
        }

        @Override
        public void setY(int y) {
            super.setY(y);
            this.resetButton.setY(y);
            this.keybindButton.setY(y);
        }

        public void updateText() {
            ArrayList<FiguraKeybind> temp = new ArrayList<FiguraKeybind>();
            for (KeybindElement keybind : this.parent.keybinds) {
                temp.add(keybind.keybind);
            }
            this.helper.setTooltip(this.keybind, temp);
            boolean isDefault = this.keybind.isDefault();
            this.resetButton.setActive(!isDefault);
            boolean selected = this.parent.focusedKeybind == this.keybind;
            class_2561 text = this.helper.getText(isDefault, selected, this.keybind.getTranslatedKeyMessage());
            this.keybindButton.method_25355(text);
        }
    }
}

