/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.gui.widgets.lists;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_304;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_3675;
import net.minecraft.class_4587;
import org.figuramc.figura.FiguraMod;
import org.figuramc.figura.config.ConfigKeyBind;
import org.figuramc.figura.config.ConfigManager;
import org.figuramc.figura.config.ConfigType;
import org.figuramc.figura.gui.screens.ConfigScreen;
import org.figuramc.figura.gui.widgets.TextField;
import org.figuramc.figura.gui.widgets.config.CategoryWidget;
import org.figuramc.figura.gui.widgets.config.InputElement;
import org.figuramc.figura.gui.widgets.lists.AbstractList;
import org.figuramc.figura.utils.ui.UIHelper;

public class ConfigList
extends AbstractList {
    private final List<CategoryWidget> configs = new ArrayList<CategoryWidget>();
    public final ConfigScreen parentScreen;
    public class_304 focusedBinding;
    private int totalHeight = 0;

    public ConfigList(int x, int y, int width, int height, ConfigScreen parentScreen) {
        super(x, y, width, height);
        this.parentScreen = parentScreen;
        this.updateList();
    }

    @Override
    public void method_25394(class_4587 stack, int mouseX, int mouseY, float delta) {
        int x = this.getX();
        int y = this.getY();
        int width = this.method_25368();
        int height = this.method_25364();
        UIHelper.renderSliced(stack, x, y, width, height, UIHelper.OUTLINE_FILL);
        UIHelper.setupScissor(x + this.scissorsX, y + this.scissorsY, width + this.scissorsWidth, height + this.scissorsHeight);
        this.totalHeight = -4;
        int visibleConfig = 0;
        for (CategoryWidget config : this.configs) {
            if (!config.isVisible()) continue;
            this.totalHeight += config.method_25364() + 8;
            ++visibleConfig;
        }
        int entryHeight = visibleConfig == 0 ? 0 : this.totalHeight / visibleConfig;
        this.scrollBar.setVisible(this.totalHeight > height);
        this.scrollBar.setScrollRatio(entryHeight, this.totalHeight - height);
        int xOffset = this.scrollBar.isVisible() ? 4 : 11;
        int yOffset = this.scrollBar.isVisible() ? (int)(-class_3532.method_16436((double)this.scrollBar.getScrollProgress(), (double)-4.0, (double)(this.totalHeight - height))) : 4;
        for (CategoryWidget config : this.configs) {
            if (!config.isVisible()) continue;
            config.setX(x + xOffset);
            config.setY(y + yOffset);
            yOffset += config.method_25364() + 8;
        }
        super.method_25394(stack, mouseX, mouseY, delta);
        UIHelper.disableScissor();
    }

    @Override
    public boolean method_25402(double mouseX, double mouseY, int button) {
        for (CategoryWidget categoryWidget : this.configs) {
            for (class_364 class_3642 : categoryWidget.method_25396()) {
                if (!(class_3642 instanceof InputElement)) continue;
                InputElement inputElement = (InputElement)class_3642;
                TextField field = inputElement.getTextField();
                field.getField().method_1876(field.isEnabled() && field.method_25405(mouseX, mouseY));
            }
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public void updateList() {
        for (CategoryWidget config : this.configs) {
            this.children.remove(config);
        }
        this.configs.clear();
        for (ConfigType.Category category : ConfigManager.CATEGORIES_REGISTRY.values()) {
            CategoryWidget widget = new CategoryWidget(this.method_25368() - 22, category, this);
            for (ConfigType<?> config : category.children) {
                widget.addConfig(config);
            }
            this.configs.add(widget);
            this.children.add(widget);
        }
        for (CategoryWidget config : this.configs) {
            config.setShowChildren(config.isShowingChildren());
        }
    }

    public void updateScroll() {
        double pastScroll = (double)(this.totalHeight - this.method_25364()) * this.scrollBar.getScrollProgress();
        this.totalHeight = -4;
        for (CategoryWidget config : this.configs) {
            if (!config.isVisible()) continue;
            this.totalHeight += config.method_25364() + 8;
        }
        this.scrollBar.setScrollProgress(pastScroll / (double)(this.totalHeight - this.method_25364()));
    }

    public boolean hasChanges() {
        for (CategoryWidget config : this.configs) {
            if (!config.isChanged()) continue;
            return true;
        }
        return false;
    }

    public boolean updateKey(class_3675.class_306 key) {
        if (this.focusedBinding == null) {
            return false;
        }
        this.focusedBinding.method_1422(key);
        if (this.focusedBinding instanceof ConfigKeyBind) {
            ((ConfigKeyBind)this.focusedBinding).saveConfigChanges();
        }
        this.focusedBinding = null;
        FiguraMod.processingKeybind = false;
        this.updateKeybinds();
        return true;
    }

    public void updateKeybinds() {
        for (CategoryWidget widget : this.configs) {
            widget.updateKeybinds();
        }
    }

    public void updateSearch(String query) {
        for (CategoryWidget widget : this.configs) {
            widget.updateFilter(query);
        }
    }
}

