/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.gui.widgets.config;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_4587;
import org.figuramc.figura.FiguraMod;
import org.figuramc.figura.config.ConfigType;
import org.figuramc.figura.config.Configs;
import org.figuramc.figura.gui.screens.ConfigScreen;
import org.figuramc.figura.gui.widgets.AbstractContainerElement;
import org.figuramc.figura.gui.widgets.ContainerButton;
import org.figuramc.figura.gui.widgets.config.AbstractConfigElement;
import org.figuramc.figura.gui.widgets.config.BooleanElement;
import org.figuramc.figura.gui.widgets.config.ButtonElement;
import org.figuramc.figura.gui.widgets.config.EnumElement;
import org.figuramc.figura.gui.widgets.config.InputElement;
import org.figuramc.figura.gui.widgets.config.KeybindElement;
import org.figuramc.figura.gui.widgets.lists.ConfigList;
import org.figuramc.figura.utils.ui.UIHelper;

public class CategoryWidget
extends AbstractContainerElement {
    protected final List<AbstractConfigElement> entries = new ArrayList<AbstractConfigElement>();
    private final ConfigType.Category config;
    private final ConfigList parent;
    private ContainerButton parentConfig;

    public CategoryWidget(int width, ConfigType.Category config, ConfigList parent) {
        super(0, 0, width, 20);
        this.config = config;
        this.parent = parent;
        this.parentConfig = new ContainerButton(parent, 0, 0, width, 20, (class_2561)(config == null ? class_2585.field_24366.method_27661() : config.name), config == null ? null : config.tooltip, button -> {
            boolean toggled = this.parentConfig.isToggled();
            this.setShowChildren(toggled);
            ConfigScreen.CATEGORY_DATA.put(config, toggled);
            parent.updateScroll();
        });
        Boolean expanded = ConfigScreen.CATEGORY_DATA.get(config);
        this.parentConfig.setToggled(expanded == null || expanded != false);
        this.parentConfig.shouldHaveBackground(false);
        this.children.add(this.parentConfig);
    }

    @Override
    public void method_25394(class_4587 poseStack, int mouseX, int mouseY, float delta) {
        if (!this.isVisible()) {
            return;
        }
        if (this.parentConfig.isToggled() && this.entries.size() > 0) {
            UIHelper.method_25294((class_4587)poseStack, (int)this.getX(), (int)(this.getY() + 21), (int)(this.getX() + this.method_25368()), (int)(this.getY() + this.method_25364()), (int)0x11FFFFFF);
        }
        if (this.config == Configs.PAPERDOLL) {
            this.parent.parentScreen.renderPaperdoll = this.parentConfig.isToggled() && this.parent.method_25405(mouseX, mouseY) && this.method_25405(mouseX, mouseY);
        }
        super.method_25394(poseStack, mouseX, mouseY, delta);
    }

    @Override
    public boolean method_25405(double mouseX, double mouseY) {
        return UIHelper.isMouseOver(this.getX(), this.getY(), this.method_25368(), this.method_25364(), mouseX, mouseY);
    }

    public void addConfig(ConfigType<?> config) {
        AbstractConfigElement element;
        if (config.hidden && !FiguraMod.debugModeEnabled()) {
            return;
        }
        int width = this.method_25368();
        if (config instanceof ConfigType.BoolConfig) {
            ConfigType.BoolConfig boolConfig = (ConfigType.BoolConfig)config;
            element = new BooleanElement(width, boolConfig, this.parent, this);
        } else if (config instanceof ConfigType.EnumConfig) {
            ConfigType.EnumConfig enumConfig = (ConfigType.EnumConfig)config;
            element = new EnumElement(width, enumConfig, this.parent, this);
        } else if (config instanceof ConfigType.InputConfig) {
            ConfigType.InputConfig inputConfig = (ConfigType.InputConfig)config;
            element = new InputElement(width, inputConfig, this.parent, this);
        } else if (config instanceof ConfigType.KeybindConfig) {
            ConfigType.KeybindConfig keybindConfig = (ConfigType.KeybindConfig)config;
            element = new KeybindElement(width, keybindConfig, this.parent, this);
        } else if (config instanceof ConfigType.ButtonConfig) {
            ConfigType.ButtonConfig buttonConfig = (ConfigType.ButtonConfig)config;
            element = new ButtonElement(width, buttonConfig, this.parent, this);
        } else {
            return;
        }
        this.setHeight(super.method_25364() + 22);
        this.children.add(element);
        this.entries.add(element);
    }

    public boolean isChanged() {
        for (AbstractConfigElement entry : this.entries) {
            if (!entry.isChanged()) continue;
            return true;
        }
        return false;
    }

    @Override
    public int method_25364() {
        if (!this.parentConfig.isToggled()) {
            return 20;
        }
        int height = 20;
        for (AbstractConfigElement entry : this.entries) {
            if (!entry.isVisible()) continue;
            height += entry.method_25364() + 2;
        }
        return height;
    }

    @Override
    public void setX(int x) {
        super.setX(x);
        this.parentConfig.setX(x);
        for (AbstractConfigElement entry : this.entries) {
            entry.setX(x);
        }
    }

    @Override
    public void setY(int y) {
        super.setY(y);
        this.parentConfig.setY(y);
        int i = 0;
        for (AbstractConfigElement entry : this.entries) {
            if (!entry.isVisible()) continue;
            entry.setY(y + 22 * (i + 1));
            ++i;
        }
    }

    public void setShowChildren(boolean bool) {
        this.parentConfig.setToggled(bool);
        for (AbstractConfigElement element : this.entries) {
            element.setVisible(bool);
        }
    }

    public boolean isShowingChildren() {
        return this.parentConfig.isToggled();
    }

    public void updateKeybinds() {
        for (AbstractConfigElement element : this.entries) {
            if (!(element instanceof KeybindElement)) continue;
            KeybindElement keybind = (KeybindElement)element;
            keybind.updateText();
        }
    }

    public void updateFilter(String query) {
        boolean visible = false;
        for (AbstractConfigElement entry : this.entries) {
            entry.updateFilter(query);
            visible |= entry.matchesFilter();
        }
        this.setVisible(visible);
        if (visible) {
            this.setY(this.getY());
        }
        this.parent.updateScroll();
    }
}

