/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.gui.widgets.config;

import java.util.Locale;
import java.util.Objects;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import org.figuramc.figura.config.ConfigType;
import org.figuramc.figura.gui.widgets.AbstractContainerElement;
import org.figuramc.figura.gui.widgets.Button;
import org.figuramc.figura.gui.widgets.ParentedButton;
import org.figuramc.figura.gui.widgets.config.CategoryWidget;
import org.figuramc.figura.gui.widgets.lists.ConfigList;
import org.figuramc.figura.utils.ui.UIHelper;

public abstract class AbstractConfigElement
extends AbstractContainerElement {
    protected final ConfigType<?> config;
    protected final ConfigList parentList;
    protected final CategoryWidget parentCategory;
    protected Button resetButton;
    protected Object initValue;
    private String filter = "";

    public AbstractConfigElement(int width, ConfigType<?> config, ConfigList parentList, CategoryWidget parentCategory) {
        super(0, 0, width, 20);
        this.config = config;
        this.parentList = parentList;
        this.parentCategory = parentCategory;
        this.initValue = config.value;
        this.resetButton = new ParentedButton(0, 0, 60, 20, (class_2561)new class_2588("controls.reset"), this, button -> config.resetTemp());
        this.children.add(this.resetButton);
    }

    @Override
    public void method_25394(class_4587 poseStack, int mouseX, int mouseY, float delta) {
        if (!this.isVisible()) {
            return;
        }
        class_327 font = class_310.method_1551().field_1772;
        int n = this.getY() + this.method_25364() / 2;
        Objects.requireNonNull(font);
        int textY = n - 9 / 2;
        this.setHovered(this.method_25405(mouseX, mouseY));
        if (this.isHovered()) {
            font.method_30883(poseStack, HOVERED_ARROW, (float)((int)((float)(this.getX() + 8) - (float)font.method_27525((class_5348)HOVERED_ARROW) / 2.0f)), (float)textY, 0xFFFFFF);
        }
        this.renderTitle(poseStack, font, textY);
        super.method_25394(poseStack, mouseX, mouseY, delta);
    }

    public void renderTitle(class_4587 poseStack, class_327 font, int y) {
        font.method_30883(poseStack, this.config.name, (float)(this.getX() + 16), (float)y, (this.config.disabled ? class_124.field_1063 : class_124.field_1068).method_532().intValue());
    }

    @Override
    public boolean method_25405(double mouseX, double mouseY) {
        boolean over;
        boolean bl = over = this.parentList.isInsideScissors(mouseX, mouseY) && super.method_25405(mouseX, mouseY);
        if (over && mouseX < (double)(this.getX() + this.method_25368() - 158)) {
            UIHelper.setTooltip((class_2561)this.getTooltip());
        }
        return over;
    }

    public class_5250 getTooltip() {
        return this.config.tooltip.method_27661();
    }

    public boolean isDefault() {
        return this.config.isDefault();
    }

    public boolean isChanged() {
        return !Objects.equals(this.config.tempValue, this.initValue);
    }

    @Override
    public void setX(int x) {
        super.setX(x);
        this.resetButton.setX(x + this.method_25368() - 60);
    }

    @Override
    public void setY(int y) {
        super.setY(y);
        this.resetButton.setY(y);
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible && this.parentCategory.isShowingChildren() && this.matchesFilter());
    }

    public void updateFilter(String query) {
        this.filter = query;
    }

    public boolean matchesFilter() {
        return this.config.name.getString().toLowerCase(Locale.US).contains(this.filter) || this.config.tooltip.getString().toLowerCase(Locale.US).contains(this.filter);
    }
}

