/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.gui.widgets;

import java.util.List;
import java.util.Objects;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2585;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_364;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import org.figuramc.figura.FiguraMod;
import org.figuramc.figura.avatar.Avatar;
import org.figuramc.figura.avatar.AvatarManager;
import org.figuramc.figura.backend2.NetworkStuff;
import org.figuramc.figura.gui.widgets.FiguraTickable;
import org.figuramc.figura.gui.widgets.FiguraWidget;
import org.figuramc.figura.utils.FiguraText;
import org.figuramc.figura.utils.MathUtils;
import org.figuramc.figura.utils.ui.UIHelper;

public class StatusWidget
implements FiguraWidget,
FiguraTickable,
class_364 {
    public static final String STATUS_INDICATORS = "-*/+";
    public static final List<String> STATUS_NAMES = List.of("size", "texture", "script", "backend");
    public static final List<class_2583> TEXT_COLORS = List.of(class_2583.field_24360.method_10977(class_124.field_1068), class_2583.field_24360.method_10977(class_124.field_1061), class_2583.field_24360.method_10977(class_124.field_1054), class_2583.field_24360.method_10977(class_124.field_1060));
    private final class_327 font;
    protected final int count;
    protected int status = 0;
    private class_2561 scriptError;
    private class_2561 disconnectedReason;
    private int x;
    private int y;
    private int width;
    private int height;
    private boolean visible = true;
    private boolean background = true;

    public StatusWidget(int x, int y, int width) {
        this(x, y, width, STATUS_NAMES.size());
    }

    protected StatusWidget(int x, int y, int width, int count) {
        this.x = x;
        this.y = y;
        this.font = class_310.method_1551().field_1772;
        this.width = width;
        Objects.requireNonNull(this.font);
        this.height = 9 + 5;
        this.count = count;
    }

    @Override
    public void tick() {
        boolean empty;
        if (!this.isVisible()) {
            return;
        }
        Avatar avatar = AvatarManager.getAvatarForPlayer(FiguraMod.getLocalPlayerUUID());
        boolean bl = empty = avatar == null || avatar.nbt == null;
        this.status = empty ? 0 : (avatar.fileSize > NetworkStuff.getSizeLimit() ? 1 : ((double)avatar.fileSize > (double)NetworkStuff.getSizeLimit() * 0.75 ? 2 : 3));
        int texture = empty || !avatar.hasTexture ? 0 : 3;
        this.status += texture << 2;
        int script = empty ? 0 : (avatar.scriptError ? 1 : (avatar.luaRuntime == null ? 0 : (avatar.versionStatus > 0 ? 2 : 3)));
        this.status += script << 4;
        this.scriptError = script == 1 ? avatar.errorText.method_27661() : null;
        int backend = NetworkStuff.backendStatus;
        this.status += backend << 6;
        String dc = NetworkStuff.disconnectedReason;
        this.disconnectedReason = backend == 1 && dc != null && !dc.isBlank() ? new class_2585(dc) : null;
    }

    public void method_25394(class_4587 stack, int mouseX, int mouseY, float delta) {
        if (!this.isVisible()) {
            return;
        }
        int x = this.getX();
        int y = this.getY();
        int width = this.method_25368();
        int height = this.method_25364();
        boolean background = this.hasBackground();
        if (background) {
            UIHelper.renderSliced(stack, x, y, width, height, UIHelper.OUTLINE_FILL);
        }
        boolean hovered = this.method_25405(mouseX, mouseY);
        double spacing = (double)width / (double)this.count;
        double hSpacing = spacing * 0.5;
        for (int i = 0; i < this.count; ++i) {
            int xx = (int)((double)x + spacing * (double)i + hSpacing);
            class_5250 text = this.getStatusIcon(i);
            UIHelper.method_27535((class_4587)stack, (class_327)this.font, (class_2561)text, (int)(xx - this.font.method_27525((class_5348)text) / 2), (int)(y + (background ? 3 : 0)), (int)0xFFFFFF);
            if (!hovered || !((double)mouseX >= (double)xx - hSpacing) || !((double)mouseX < (double)xx + hSpacing) || mouseY < y) continue;
            Objects.requireNonNull(this.font);
            if (mouseY >= y + 9 + (background ? 3 : 0)) continue;
            UIHelper.setTooltip(this.getTooltipFor(i));
        }
    }

    public class_5250 getStatusIcon(int type) {
        return new class_2585(String.valueOf(STATUS_INDICATORS.charAt(this.status >> type * 2 & 3))).method_10862(class_2583.field_24360.method_27704(UIHelper.UI_FONT));
    }

    public class_2561 getTooltipFor(int i) {
        FiguraText info;
        int color = this.status >> i * 2 & 3;
        String part = "gui.status." + STATUS_NAMES.get(i);
        if (i == 0) {
            double size = NetworkStuff.getSizeLimit();
            info = new FiguraText(part + "." + color, MathUtils.asFileSize(size));
        } else {
            info = new FiguraText(part + "." + color);
        }
        class_5250 text = new FiguraText(part).method_27693("\n\u2022 ").method_10852((class_2561)info).method_10862(TEXT_COLORS.get(color));
        if (i == 2 && color == 1 && this.scriptError != null) {
            text.method_27693("\n\n").method_10852((class_2561)new FiguraText("gui.status.reason")).method_27693("\n\u2022 ").method_10852(this.scriptError);
        }
        if (i == 3 && this.disconnectedReason != null) {
            text.method_27693("\n\n").method_10852((class_2561)new FiguraText("gui.status.reason")).method_27693("\n\u2022 ").method_10852(this.disconnectedReason);
        }
        return text;
    }

    public boolean hasBackground() {
        return this.background;
    }

    public void setBackground(boolean background) {
        this.background = background;
    }

    public boolean method_25405(double mouseX, double mouseY) {
        return UIHelper.isMouseOver(this.getX(), this.getY(), this.method_25368(), this.method_25364(), mouseX, mouseY);
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    @Override
    public void setX(int x) {
        this.x = x;
    }

    @Override
    public int getX() {
        return this.x;
    }

    @Override
    public void setY(int y) {
        this.y = y;
    }

    @Override
    public int getY() {
        return this.y;
    }

    @Override
    public void method_25358(int width) {
        this.width = width;
    }

    @Override
    public int method_25368() {
        return this.width;
    }

    @Override
    public void setHeight(int height) {
        this.height = height;
    }

    @Override
    public int method_25364() {
        return this.height;
    }
}

