/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.gui.widgets;

import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import org.figuramc.figura.gui.widgets.ScrollBarWidget;
import org.figuramc.figura.utils.FiguraIdentifier;
import org.figuramc.figura.utils.ui.UIHelper;

public class SliderWidget
extends ScrollBarWidget {
    public static final class_2960 SLIDER_TEXTURE = new FiguraIdentifier("textures/gui/slider.png");
    protected final int headHeight = 11;
    protected final int headWidth = 11;
    protected final boolean showSteps;
    private int max;
    private double stepSize;
    private double steppedPos;

    public SliderWidget(int x, int y, int width, int height, double initialValue, int maxValue, boolean showSteps) {
        super(x, y, width, height, initialValue);
        this.vertical = false;
        this.showSteps = showSteps;
        this.steppedPos = initialValue;
        this.setMax(maxValue);
    }

    @Override
    public boolean method_25401(double mouseX, double mouseY, double amount) {
        if (!this.method_37303()) {
            return false;
        }
        this.scroll(this.stepSize * Math.signum(-amount) * ((double)(this.method_25368() - 11) + 2.0));
        return true;
    }

    @Override
    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (!this.method_37303()) {
            return false;
        }
        if (keyCode > 261 && keyCode < 266) {
            this.scroll(this.stepSize * (double)(keyCode % 2 == 0 ? 1 : -1) * (double)Math.max(modifiers * 10, 1) * ((double)(this.method_25368() - 11) + 2.0));
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    @Override
    protected void scroll(double amount) {
        super.scroll(amount);
        this.steppedPos = this.getClosestStep();
    }

    private double getClosestStep() {
        double distanceHigh;
        double lowest = this.scrollPrecise - this.scrollPrecise % this.stepSize;
        double highest = lowest + this.stepSize;
        double distanceLow = Math.abs(lowest - this.scrollPrecise);
        return distanceLow < (distanceHigh = Math.abs(highest - this.scrollPrecise)) ? lowest : highest;
    }

    @Override
    public void method_25394(class_4587 poseStack, int mouseX, int mouseY, float delta) {
        if (this.isVisible()) {
            this.field_22762 = this.method_25405(mouseX, mouseY);
            this.method_25359(poseStack, mouseX, mouseY, delta);
        }
    }

    @Override
    public void method_25359(class_4587 poseStack, int mouseX, int mouseY, float delta) {
        UIHelper.setupTexture(SLIDER_TEXTURE);
        int x = this.getX();
        int y = this.getY();
        int width = this.method_25368();
        SliderWidget.method_25293((class_4587)poseStack, (int)x, (int)(y + 3), (int)width, (int)5, (float)(this.isScrolling ? 10.0f : 0.0f), (float)0.0f, (int)5, (int)5, (int)33, (int)16);
        if (this.showSteps) {
            for (int i = 0; i < this.max; ++i) {
                SliderWidget.method_25293((class_4587)poseStack, (int)((int)Math.floor((double)(x + 3) + this.stepSize * (double)i * (double)(width - 11))), (int)(y + 3), (int)5, (int)5, (float)(this.isScrolling ? 15.0f : 5.0f), (float)0.0f, (int)5, (int)5, (int)33, (int)16);
            }
        }
        this.lerpPos(delta);
        SliderWidget.method_25290((class_4587)poseStack, (int)((int)((long)x + Math.round(class_3532.method_16436((double)this.scrollPos, (double)0.0, (double)(width - 11))))), (int)y, (float)(this.method_37303() ? (float)(this.method_25367() || this.isScrolling ? 22 : 11) : 0.0f), (float)5.0f, (int)11, (int)11, (int)33, (int)16);
    }

    @Override
    public double getScrollProgress() {
        return this.steppedPos;
    }

    @Override
    public void setScrollProgress(double amount, boolean force) {
        this.steppedPos = force ? amount : class_3532.method_15350((double)amount, (double)0.0, (double)1.0);
        super.setScrollProgress(amount, force);
    }

    public int getMax() {
        return this.max;
    }

    public void setMax(int maxValue) {
        this.max = maxValue;
        this.stepSize = 1.0 / (double)(maxValue - 1);
    }

    public int getIntValue() {
        return (int)Math.round(this.getScrollProgress() * (double)(this.getMax() - 1));
    }
}

