/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.gui.widgets;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_339;
import net.minecraft.class_4185;
import org.figuramc.figura.FiguraMod;
import org.figuramc.figura.gui.widgets.AbstractContainerElement;
import org.figuramc.figura.gui.widgets.Button;
import org.figuramc.figura.gui.widgets.ContextMenu;
import org.figuramc.figura.utils.FiguraText;
import org.figuramc.figura.utils.ui.UIHelper;

public class EnumButton
extends AbstractContainerElement {
    private final Button button;
    private int value;
    private final ContextMenu contextMenu;
    private final Consumer<Integer> onSelect;
    private final ArrayList<class_2561> names = new ArrayList();

    public EnumButton(int x, int y, int width, int height, String translationString, int defaultValue, int length, Consumer<Integer> onSelect) {
        super(x, y, width, height);
        int i;
        this.value = defaultValue;
        ArrayList<FiguraText> tooltips = new ArrayList<FiguraText>();
        for (i = 0; i < length; ++i) {
            this.names.add((class_2561)new FiguraText("%s.%s".formatted(translationString, i)));
            tooltips.add(new FiguraText("%s.%s.tooltip".formatted(translationString, i)));
        }
        this.button = new Button(x, y, width, height, this.names.get(this.value % length), (class_2561)tooltips.get(this.value % length), this::onClick);
        this.children.add(this.button);
        this.contextMenu = new ContextMenu();
        this.contextMenu.setX(this.button.getX());
        this.contextMenu.setY(this.button.getY() + this.button.method_25364());
        this.onSelect = onSelect;
        i = 0;
        while (i < length) {
            class_2561 c = this.names.get(i);
            class_2561 t = (class_2561)tooltips.get(i);
            int finalI = i++;
            this.contextMenu.addAction(c, t, b -> {
                this.button.method_25355(c);
                this.button.setTooltip(t);
                onSelect.accept(finalI);
                this.updateContextText();
                this.value = finalI;
            });
        }
    }

    @Override
    public void setX(int x) {
        super.setX(x);
        this.button.setX(x);
        this.contextMenu.setX(this.button.getX());
    }

    @Override
    public void setY(int y) {
        super.setY(y);
        this.button.setY(y);
        this.contextMenu.setY(this.button.getY() + this.button.method_25364());
    }

    @Override
    public void method_25358(int width) {
        super.method_25358(width);
        this.button.method_25358(width);
    }

    @Override
    public void setHeight(int height) {
        super.setHeight(height);
        this.button.setHeight(height);
        this.contextMenu.setY(this.button.getY() + this.button.method_25364());
    }

    private void updateContextText() {
        List<? extends class_339> entries = this.contextMenu.getEntries();
        for (int i = 0; i < this.names.size(); ++i) {
            class_2561 text = this.names.get(i);
            if (i == this.value % this.names.size()) {
                text = class_2585.field_24366.method_27661().method_10862(FiguraMod.getAccentColor()).method_27692(class_124.field_1073).method_10852(text);
            }
            entries.get(i).method_25355(text);
        }
    }

    private void onClick(class_4185 button) {
        this.contextMenu.setVisible(!this.contextMenu.isVisible());
        if (this.contextMenu.isVisible()) {
            UIHelper.setContext(this.contextMenu);
        }
    }
}

