/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.gui.widgets;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2585;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4587;
import net.minecraft.class_5348;
import org.figuramc.figura.gui.widgets.AbstractContainerElement;
import org.figuramc.figura.gui.widgets.Button;
import org.figuramc.figura.utils.FiguraIdentifier;
import org.figuramc.figura.utils.ui.UIHelper;

public class ContextMenu
extends AbstractContainerElement {
    public static final class_2960 BACKGROUND = new FiguraIdentifier("textures/gui/context.png");
    private final int minWidth;
    private final List<ContextButton> entries = new ArrayList<ContextButton>();
    public class_364 parent;
    private ContextMenu nestedContext;

    public ContextMenu(class_364 parent, int minWidth) {
        super(0, 0, minWidth, 2);
        this.minWidth = minWidth;
        this.parent = parent;
        this.setVisible(false);
    }

    public ContextMenu(class_364 parent) {
        this(parent, 0);
    }

    public ContextMenu() {
        this(null);
    }

    @Override
    public void method_25394(class_4587 poseStack, int mouseX, int mouseY, float delta) {
        if (!this.isVisible()) {
            return;
        }
        UIHelper.renderSliced(poseStack, this.getX(), this.getY(), this.method_25368(), this.method_25364(), 0.0f, 0.0f, 16, 16, 48, 16, BACKGROUND);
        int y = this.getY() + 1;
        for (int i = 0; i < this.entries.size(); ++i) {
            int height = this.entries.get(i).method_25364();
            UIHelper.renderSliced(poseStack, this.getX() + 1, y, this.method_25368() - 2, height, i % 2 == 1 ? 32.0f : 16.0f, 0.0f, 16, 16, 48, 16, BACKGROUND);
            this.entries.get(i).method_25394(poseStack, mouseX, mouseY, delta);
            y += height;
        }
        if (this.nestedContext != null) {
            this.nestedContext.method_25394(poseStack, mouseX, mouseY, delta);
            class_364 class_3642 = this.nestedContext.parent;
            if (class_3642 instanceof Button) {
                Button button = (Button)class_3642;
                button.setHovered(true);
            }
        }
    }

    public void addAction(class_2561 name, class_2561 tooltip, class_4185.class_4241 action) {
        this.addElement(new ContextButton(this.getX(), this.getY() + this.method_25364(), name, tooltip, this, action));
    }

    public void addDivisor() {
        this.addElement(new ContextDivisor(this.getX(), this.getY() + this.method_25364()));
    }

    public void addTab(class_2561 name, class_2561 tooltip, ContextMenu context) {
        TabButton button = new TabButton(this.getX(), this.getY() + this.method_25364(), name, tooltip, this, context);
        this.addElement(button);
        context.parent = button;
        this.children.add(context);
    }

    private void addElement(ContextButton element) {
        this.children.add(element);
        this.entries.add(element);
        this.updateDimensions();
    }

    private void clearNest() {
        if (this.nestedContext != null) {
            this.nestedContext.clearNest();
            this.nestedContext = null;
        }
    }

    public void updateDimensions() {
        this.method_25358(this.minWidth);
        this.setHeight(2);
        for (ContextButton entry : this.entries) {
            this.method_25358(Math.max(entry.getTrueWidth() + 8, this.method_25368()));
            this.setHeight(this.method_25364() + entry.method_25364());
        }
        for (ContextButton entry : this.entries) {
            entry.method_25358(this.method_25368() - 2);
        }
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.clearNest();
    }

    @Override
    public void setX(int x) {
        int clientWidth;
        int realWidth = x + this.method_25368();
        if (realWidth > (clientWidth = class_310.method_1551().method_22683().method_4486())) {
            x -= realWidth - clientWidth;
        }
        super.setX(x);
        for (ContextButton button : this.entries) {
            button.setX(x + 1);
            if (!(button instanceof TabButton)) continue;
            TabButton tab = (TabButton)button;
            tab.context.setX(tab.getX() + tab.method_25368());
        }
    }

    @Override
    public void setY(int y) {
        int clientHeight;
        int realHeight = y + this.method_25364();
        if (realHeight > (clientHeight = class_310.method_1551().method_22683().method_4502())) {
            y -= realHeight - clientHeight;
        }
        super.setY(y);
        int heigth = y + 1;
        for (ContextButton button : this.entries) {
            button.setY(heigth);
            heigth += button.method_25364();
            if (!(button instanceof TabButton)) continue;
            TabButton tab = (TabButton)button;
            tab.context.setY(tab.getY() - 1);
        }
    }

    public List<? extends class_339> getEntries() {
        return this.entries;
    }

    @Override
    public boolean method_25402(double mouseX, double mouseY, int button) {
        boolean result = super.method_25402(mouseX, mouseY, button);
        this.method_25395(null);
        return result;
    }

    private static class ContextButton
    extends Button {
        protected final ContextMenu parent;

        public ContextButton(int x, int y, class_2561 text, class_2561 tooltip, ContextMenu parent, class_4185.class_4241 pressAction) {
            super(x, y, 0, 16, text, tooltip, pressAction);
            this.shouldHaveBackground(false);
            this.parent = parent;
        }

        protected ContextButton(int x, int y, int height) {
            super(x, y, 0, height, (class_2561)class_2585.field_24366.method_27661(), null, button -> {});
            this.shouldHaveBackground(false);
            this.parent = null;
        }

        @Override
        protected void renderText(class_4587 pose, float delta) {
            class_327 font = class_310.method_1551().field_1772;
            class_2561 class_25612 = this.method_25369();
            float f = this.getX() + 3;
            float f2 = (float)this.getY() + (float)this.method_25364() / 2.0f;
            Objects.requireNonNull(font);
            font.method_30881(pose, class_25612, f, (float)((int)(f2 - 9.0f / 2.0f)), this.getTextColor());
        }

        @Override
        public boolean method_25405(double mouseX, double mouseY) {
            if (UIHelper.isMouseOver(this.getX(), this.getY(), this.method_25368(), this.method_25364(), mouseX, mouseY, true)) {
                UIHelper.setTooltip(this.tooltip);
                this.parent.clearNest();
                return true;
            }
            return false;
        }

        public int getTrueWidth() {
            return class_310.method_1551().field_1772.method_27525((class_5348)this.method_25369());
        }
    }

    private static class ContextDivisor
    extends ContextButton {
        public ContextDivisor(int x, int y) {
            super(x, y, 9);
        }

        @Override
        public void method_25359(class_4587 pose, int mouseX, int mouseY, float delta) {
            UIHelper.method_25294((class_4587)pose, (int)(this.getX() + 4), (int)(this.getY() + 4), (int)(this.getX() + this.method_25368() - 4), (int)(this.getY() + 5), (int)(-16777216 + class_124.field_1063.method_532()));
        }

        @Override
        public boolean method_25402(double mouseX, double mouseY, int button) {
            return false;
        }
    }

    private static class TabButton
    extends ContextButton {
        private static final class_2561 ARROW = new class_2585(">").method_10862(class_2583.field_24360.method_27704(UIHelper.UI_FONT));
        private final ContextMenu context;

        public TabButton(int x, int y, class_2561 text, class_2561 tooltip, ContextMenu parent, ContextMenu context) {
            super(x, y, text, tooltip, parent, button -> {});
            this.context = context;
            this.context.setVisible(true);
        }

        @Override
        public void method_25359(class_4587 poseStack, int mouseX, int mouseY, float delta) {
            super.method_25359(poseStack, mouseX, mouseY, delta);
            class_327 font = class_310.method_1551().field_1772;
            float f = this.getX() + this.method_25368() - font.method_27525((class_5348)ARROW) - 3;
            float f2 = (float)this.getY() + (float)this.method_25364() / 2.0f;
            Objects.requireNonNull(font);
            font.method_30881(poseStack, ARROW, f, (float)((int)(f2 - 9.0f / 2.0f)), this.getTextColor());
        }

        @Override
        public boolean method_25405(double mouseX, double mouseY) {
            boolean mouseOver = UIHelper.isMouseOver(this.getX(), this.getY(), this.method_25368(), this.method_25364(), mouseX, mouseY, true);
            if (mouseOver || this.parent.nestedContext == this.context) {
                UIHelper.setTooltip(this.tooltip);
                this.parent.nestedContext = this.context;
                if (mouseOver) {
                    this.context.nestedContext = null;
                }
                return true;
            }
            return false;
        }

        @Override
        public int getTrueWidth() {
            return super.getTrueWidth() + class_310.method_1551().field_1772.method_27525((class_5348)new class_2585(" ").method_10852(ARROW));
        }
    }
}

