/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.gui.widgets;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Objects;
import net.minecraft.class_1144;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_327;
import net.minecraft.class_339;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_4587;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import net.minecraft.class_757;
import org.figuramc.figura.utils.ClickableTextHelper;
import org.figuramc.figura.utils.ui.UIHelper;

public class BackendMotdWidget
extends class_339
implements class_4068,
class_364 {
    private final class_327 font;
    private final ClickableTextHelper textHelper;
    private int maxWidth;
    private double scrollAmount;
    private boolean scrolling;
    private boolean mouseDown = false;

    public BackendMotdWidget(int i, int j, int k, int l, class_2561 text, class_327 font) {
        super(i, j, k, l, text);
        this.font = font;
        this.textHelper = new ClickableTextHelper();
        this.maxWidth = this.method_25368() - this.totalInnerPadding();
    }

    public void method_25355(class_2561 message) {
        super.method_25355(message);
        this.textHelper.setMessage(message);
    }

    public void method_25358(int value) {
        super.method_25358(value);
        int prevWidth = this.maxWidth;
        this.maxWidth = this.method_25368() - this.totalInnerPadding();
        if (this.maxWidth != prevWidth) {
            this.textHelper.markDirty();
        }
    }

    protected int totalInnerPadding() {
        return this.innerPadding() * 2;
    }

    protected int getInnerHeight() {
        Objects.requireNonNull(this.font);
        int n = this.textHelper.lineCount();
        Objects.requireNonNull(this.font);
        return n * 9;
    }

    protected double scrollRate() {
        Objects.requireNonNull(this.font);
        Objects.requireNonNull(this.font);
        return 9.0;
    }

    protected int innerPadding() {
        return 4;
    }

    protected void renderBorder(class_4587 stack, int x, int y, int width, int height) {
        UIHelper.renderSliced(stack, this.field_22760 - this.innerPadding(), this.field_22761 - this.innerPadding(), this.method_25368() + this.totalInnerPadding(), this.method_25364() + this.totalInnerPadding(), UIHelper.OUTLINE_FILL);
    }

    protected void renderBackground(class_4587 pose) {
        UIHelper.renderSliced(pose, this.field_22760 - this.innerPadding(), this.field_22761 - this.innerPadding(), this.method_25368() + this.totalInnerPadding(), this.method_25364() + this.totalInnerPadding(), UIHelper.OUTLINE_FILL);
    }

    public void method_25359(class_4587 pose, int mouseX, int mouseY, float delta) {
        if (this.field_22764) {
            if (!this.scrollbarVisible()) {
                this.renderBackground(pose);
                this.renderContents(pose, mouseX, mouseY, delta);
            } else {
                super.method_25359(pose, mouseX, mouseY, delta);
            }
        }
    }

    protected void renderContents(class_4587 pose, int mouseX, int mouseY, float delta) {
        int xx = this.field_22760 + this.innerPadding();
        int yy = this.field_22761 + this.innerPadding();
        int scroll = (int)this.scrollAmount();
        this.textHelper.update(this.font, this.maxWidth);
        this.textHelper.visit((text, style, x, y, textWidth, textHeight) -> UIHelper.method_27535((class_4587)pose, (class_327)this.font, (class_2561)new class_2585(text).method_10862(style), (int)(xx + x), (int)(yy + y), (int)-1));
        if (this.withinContentAreaPoint(mouseX, mouseY)) {
            class_2561 tooltip = this.textHelper.getHoverTooltip(xx, yy, mouseX, mouseY + scroll);
            if (tooltip != null) {
                UIHelper.setTooltip(tooltip);
            }
            if (this.mouseDown) {
                String link = this.textHelper.getClickLink(xx, yy, mouseX, mouseY + scroll);
                if (link != null) {
                    UIHelper.openURL(link).run();
                }
                this.mouseDown = false;
            }
        }
    }

    public void method_25354(class_1144 soundManager) {
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        this.mouseDown = this.mouseClickedScroll(mouseX, mouseY, button);
        return this.mouseDown;
    }

    public void method_37020(class_6382 builder) {
        builder.method_37034(class_6381.field_33788, this.method_25369());
    }

    public void setHeight(int height) {
        this.field_22759 = height;
    }

    protected boolean scrollbarVisible() {
        return this.getInnerHeight() > this.method_25364();
    }

    public boolean shouldRender() {
        return this.getScrollBarHeight() > 0 && this.field_22759 >= 48;
    }

    public void setPosition(int x, int y) {
        this.field_22760 = x;
        this.field_22761 = y;
    }

    protected double scrollAmount() {
        return this.scrollAmount;
    }

    protected void setScrollAmount(double scrollAmount) {
        this.scrollAmount = class_3532.method_15350((double)scrollAmount, (double)0.0, (double)this.getMaxScrollAmount());
    }

    protected int getMaxScrollAmount() {
        return Math.max(0, this.getContentHeight() - (this.field_22759 - 4));
    }

    private int getContentHeight() {
        return 4;
    }

    private void renderScrollBar() {
        int i = this.getScrollBarHeight();
        int j = this.field_22760 + this.field_22758;
        int k = this.field_22760 + this.field_22758 + 8;
        int l = Math.max(this.field_22761, (int)this.scrollAmount * (this.field_22759 - i) / this.getMaxScrollAmount() + this.field_22761);
        int m = l + i;
        RenderSystem.setShader(class_757::method_34540);
        class_289 tesselator = class_289.method_1348();
        class_287 bufferBuilder = tesselator.method_1349();
        bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
        bufferBuilder.method_22912((double)j, (double)m, 0.0).method_1336(128, 128, 128, 255).method_1344();
        bufferBuilder.method_22912((double)k, (double)m, 0.0).method_1336(128, 128, 128, 255).method_1344();
        bufferBuilder.method_22912((double)k, (double)l, 0.0).method_1336(128, 128, 128, 255).method_1344();
        bufferBuilder.method_22912((double)j, (double)l, 0.0).method_1336(128, 128, 128, 255).method_1344();
        bufferBuilder.method_22912((double)j, (double)(m - 1), 0.0).method_1336(192, 192, 192, 255).method_1344();
        bufferBuilder.method_22912((double)(k - 1), (double)(m - 1), 0.0).method_1336(192, 192, 192, 255).method_1344();
        bufferBuilder.method_22912((double)(k - 1), (double)l, 0.0).method_1336(192, 192, 192, 255).method_1344();
        bufferBuilder.method_22912((double)j, (double)l, 0.0).method_1336(192, 192, 192, 255).method_1344();
        tesselator.method_1350();
    }

    private int getScrollBarHeight() {
        return class_3532.method_15340((int)((int)((float)(this.field_22759 * this.field_22759) / (float)this.getContentHeight())), (int)32, (int)this.field_22759);
    }

    protected void renderDecorations(class_4587 matrices) {
        if (this.scrollbarVisible()) {
            this.renderScrollBar();
        }
    }

    protected boolean withinContentAreaTopBottom(int top, int bottom) {
        return (double)bottom - this.scrollAmount >= (double)this.field_22761 && (double)top - this.scrollAmount <= (double)(this.field_22761 + this.field_22759);
    }

    protected boolean withinContentAreaPoint(double x, double y) {
        return x >= (double)this.field_22760 && x < (double)(this.field_22760 + this.field_22758) && y >= (double)this.field_22761 && y < (double)(this.field_22761 + this.field_22759);
    }

    public boolean mouseClickedScroll(double mouseX, double mouseY, int button) {
        if (!this.field_22764) {
            return false;
        }
        boolean bl = this.withinContentAreaPoint(mouseX, mouseY);
        boolean bl2 = this.scrollbarVisible() && mouseX >= (double)(this.field_22760 + this.field_22758) && mouseX <= (double)(this.field_22760 + this.field_22758 + 8) && mouseY >= (double)this.field_22761 && mouseY < (double)(this.field_22761 + this.field_22759);
        this.method_25365(bl || bl2);
        if (bl2 && button == 0) {
            this.scrolling = true;
            return true;
        }
        return false;
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (button == 0) {
            this.scrolling = false;
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.field_22764 && this.method_25370() && this.scrolling) {
            if (mouseY < (double)this.field_22761) {
                this.setScrollAmount(0.0);
            } else if (mouseY > (double)(this.field_22761 + this.field_22759)) {
                this.setScrollAmount(this.getMaxScrollAmount());
            } else {
                int i = this.getScrollBarHeight();
                double d = Math.max(1, this.getMaxScrollAmount() / (this.field_22759 - i));
                this.setScrollAmount(this.scrollAmount + deltaY * d);
            }
            return true;
        }
        return false;
    }

    public boolean method_25401(double mouseX, double mouseY, double amount) {
        if (this.field_22764 && this.method_25370()) {
            this.setScrollAmount(this.scrollAmount - amount * this.scrollRate());
            return true;
        }
        return false;
    }
}

