/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.gui.widgets;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2585;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_364;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import org.figuramc.figura.FiguraMod;
import org.figuramc.figura.avatar.Avatar;
import org.figuramc.figura.avatar.AvatarManager;
import org.figuramc.figura.font.Emojis;
import org.figuramc.figura.gui.widgets.FiguraTickable;
import org.figuramc.figura.gui.widgets.FiguraWidget;
import org.figuramc.figura.utils.ColorUtils;
import org.figuramc.figura.utils.FiguraText;
import org.figuramc.figura.utils.MathUtils;
import org.figuramc.figura.utils.TextUtils;
import org.figuramc.figura.utils.ui.UIHelper;

public class AvatarInfoWidget
implements FiguraWidget,
FiguraTickable,
class_364 {
    private static final class_5250 UNKNOWN = new class_2585("?").method_10862(ColorUtils.Colors.AWESOME_BLUE.style);
    private static final class_5250 ELLIPSIS = TextUtils.ELLIPSIS.method_27661().method_10862(ColorUtils.Colors.AWESOME_BLUE.style);
    private static final List<class_2561> TITLES = List.of(new FiguraText("gui.name").method_27692(class_124.field_1073), new FiguraText("gui.authors").method_27692(class_124.field_1073), new FiguraText("gui.size").method_27692(class_124.field_1073), new FiguraText("gui.complexity").method_27692(class_124.field_1073));
    private int x;
    private int y;
    private int width;
    private int height;
    private boolean visible = true;
    private final int maxSize;
    private final class_327 font;
    private final List<class_2561> values = new ArrayList<class_2561>(){
        {
            for (class_2561 ignored : TITLES) {
                this.add(UNKNOWN);
            }
        }
    };

    public AvatarInfoWidget(int x, int y, int width, int maxSize) {
        this.x = x;
        this.y = y;
        this.font = class_310.method_1551().field_1772;
        this.width = width;
        Objects.requireNonNull(this.font);
        this.height = (9 + 4) * TITLES.size() * 2 + 4;
        this.maxSize = maxSize;
    }

    @Override
    public void tick() {
        if (!this.visible) {
            return;
        }
        class_2583 accent = FiguraMod.getAccentColor();
        ELLIPSIS.method_10862(accent);
        UNKNOWN.method_10862(accent);
        Avatar avatar = AvatarManager.getAvatarForPlayer(FiguraMod.getLocalPlayerUUID());
        if (avatar != null && avatar.nbt != null) {
            this.values.set(0, (class_2561)(avatar.name == null || avatar.name.isBlank() ? UNKNOWN : Emojis.applyEmojis((class_2561)new class_2585(avatar.name).method_10862(accent))));
            this.values.set(1, (class_2561)(avatar.authors == null || avatar.authors.isBlank() ? UNKNOWN : Emojis.applyEmojis((class_2561)new class_2585(avatar.authors).method_10862(accent))));
            this.values.set(2, (class_2561)new class_2585(MathUtils.asFileSize(avatar.fileSize)).method_10862(accent));
            this.values.set(3, (class_2561)new class_2585(String.valueOf(avatar.complexity.pre)).method_10862(accent));
        } else {
            for (int i = 0; i < TITLES.size(); ++i) {
                this.values.set(i, (class_2561)UNKNOWN);
            }
        }
    }

    public void method_25394(class_4587 pose, int mouseX, int mouseY, float delta) {
        if (!this.visible) {
            return;
        }
        int x = this.x + this.width / 2;
        int y = this.y + 4;
        Objects.requireNonNull(this.font);
        int height = 9 + 4;
        int maxLines = (this.maxSize - 8) / height;
        int authorFreeLines = maxLines - 7;
        class_2561 authors = this.values.get(1);
        List authorLines = authors == null ? Collections.emptyList() : TextUtils.splitText((class_5348)authors, "\n");
        int authorUsedLines = Math.min(authorLines.size(), authorFreeLines);
        int newHeight = height * TITLES.size() * 2 + 4 + height * (authorUsedLines - 1);
        this.height = Math.min(newHeight + height, this.maxSize);
        y += (this.height - newHeight) / 2;
        UIHelper.renderSliced(pose, this.x, this.y, this.width, this.height, UIHelper.OUTLINE_FILL);
        for (int i = 0; i < TITLES.size(); ++i) {
            class_2561 title = TITLES.get(i);
            if (title != null) {
                UIHelper.method_27534((class_4587)pose, (class_327)this.font, (class_2561)title, (int)x, (int)y, (int)0xFFFFFF);
            }
            y += height;
            class_2561 value = this.values.get(i);
            if (value == null) {
                y += height;
                continue;
            }
            if (i != 1) {
                class_2561 toRender = TextUtils.trimToWidthEllipsis(this.font, value, this.width - 10, (class_2561)ELLIPSIS);
                UIHelper.method_27534((class_4587)pose, (class_327)this.font, (class_2561)toRender, (int)x, (int)y, (int)0xFFFFFF);
                if (value != toRender && UIHelper.isMouseOver(this.x, y - height, this.width, height * 2 - 4, mouseX, mouseY)) {
                    UIHelper.setTooltip(value);
                }
                y += height;
                continue;
            }
            for (int j = 0; j < authorUsedLines; ++j) {
                class_2561 text = (class_2561)authorLines.get(j);
                class_2561 newText = TextUtils.trimToWidthEllipsis(this.font, text, this.width - 10, (class_2561)ELLIPSIS);
                if (j == authorUsedLines - 1 && authorLines.size() > authorUsedLines) {
                    text = value;
                    newText = ELLIPSIS;
                }
                if (text != newText && UIHelper.isMouseOver(this.x, y, this.width, height, mouseX, mouseY)) {
                    UIHelper.setTooltip(text);
                }
                UIHelper.method_27534((class_4587)pose, (class_327)this.font, (class_2561)newText, (int)x, (int)y, (int)0xFFFFFF);
                y += height;
            }
        }
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    @Override
    public int getX() {
        return this.x;
    }

    @Override
    public void setX(int x) {
        this.x = x;
    }

    @Override
    public int getY() {
        return this.y;
    }

    @Override
    public void setY(int y) {
        this.y = y;
    }

    @Override
    public int method_25368() {
        return this.width;
    }

    @Override
    public void method_25358(int width) {
        this.width = width;
    }

    @Override
    public int method_25364() {
        return this.height;
    }

    @Override
    public void setHeight(int height) {
        this.height = height;
    }
}

