/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.gui.screens;

import java.nio.file.Path;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1309;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_2585;
import net.minecraft.class_310;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import org.figuramc.figura.FiguraMod;
import org.figuramc.figura.avatar.Avatar;
import org.figuramc.figura.avatar.AvatarManager;
import org.figuramc.figura.avatar.local.LocalAvatarFetcher;
import org.figuramc.figura.avatar.local.LocalAvatarLoader;
import org.figuramc.figura.backend2.NetworkStuff;
import org.figuramc.figura.config.Configs;
import org.figuramc.figura.gui.FiguraToast;
import org.figuramc.figura.gui.screens.AbstractPanelScreen;
import org.figuramc.figura.gui.screens.FiguraConfirmScreen;
import org.figuramc.figura.gui.screens.KeybindScreen;
import org.figuramc.figura.gui.screens.SoundScreen;
import org.figuramc.figura.gui.widgets.AvatarInfoWidget;
import org.figuramc.figura.gui.widgets.BackendMotdWidget;
import org.figuramc.figura.gui.widgets.Button;
import org.figuramc.figura.gui.widgets.EntityPreview;
import org.figuramc.figura.gui.widgets.Label;
import org.figuramc.figura.gui.widgets.LoadingErrorWidget;
import org.figuramc.figura.gui.widgets.StatusWidget;
import org.figuramc.figura.gui.widgets.lists.AvatarList;
import org.figuramc.figura.utils.FiguraIdentifier;
import org.figuramc.figura.utils.FiguraText;
import org.figuramc.figura.utils.IOUtils;
import org.figuramc.figura.utils.TextUtils;
import org.figuramc.figura.utils.ui.UIHelper;

public class WardrobeScreen
extends AbstractPanelScreen {
    private static final class_2561 DEBUG_MOTD_FALLBACK = new class_2585("No motd could be loaded.\n\n").method_27693("Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.\n").method_27692(class_124.field_1080).method_10852((class_2561)new class_2585("(This is some text you can hover)\n").method_27696(class_2583.field_24360.method_36139(-847456).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)new class_2585("hi chat"))))).method_10852((class_2561)new class_2585("(This is some text you can click on)\n").method_27696(class_2583.field_24360.method_10958(new class_2558(class_2558.class_2559.field_11749, "https://github.com/FiguraMC/Figura")))).method_10852((class_2561)new class_2585("(This is only visible in debug mode)").method_27695(new class_124[]{class_124.field_1063, class_124.field_1056}));
    private Label panic;
    private Button upload;
    private Button delete;
    private Button back;
    private AvatarInfoWidget infoWidget;
    private BackendMotdWidget motdWidget;

    public WardrobeScreen(class_437 parentScreen) {
        super(parentScreen, (class_2561)new FiguraText("gui.panels.title.wardrobe"));
    }

    @Override
    protected void method_25426() {
        boolean oldVersion;
        super.method_25426();
        class_310 minecraft = class_310.method_1551();
        int middle = this.field_22789 / 2;
        int panels = this.getPanels();
        int modelBgSize = Math.min(this.field_22789 - panels * 2 - 16, this.field_22790 - 96);
        panels = Math.max((this.field_22789 - modelBgSize) / 2 - 8, panels);
        AvatarList avatarList = new AvatarList(4, 28, panels, this.field_22790 - 32, this);
        this.method_37063((class_364)avatarList);
        int entitySize = 11 * modelBgSize / 29;
        int entityX = middle - modelBgSize / 2;
        int entityY = this.field_22790 / 2 - modelBgSize / 2;
        EntityPreview entity = new EntityPreview(entityX, entityY, modelBgSize, modelBgSize, entitySize, -15.0f, 30.0f, (class_1309)minecraft.field_1724, this);
        this.method_37063((class_364)entity);
        int buttX = entity.getX() + entity.method_25368() / 2;
        int buttY = entity.getY() + entity.method_25364() + 4;
        this.upload = new Button(buttX - 48, buttY, 24, 24, 0, 0, 24, new FiguraIdentifier("textures/gui/upload.png"), 72, 24, (class_2561)new FiguraText("gui.wardrobe.upload.tooltip"), button -> {
            Avatar avatar = AvatarManager.getAvatarForPlayer(FiguraMod.getLocalPlayerUUID());
            try {
                LocalAvatarLoader.loadAvatar(null, null);
            }
            catch (Exception exception) {
                // empty catch block
            }
            NetworkStuff.uploadAvatar(avatar);
            AvatarList.selectedEntry = null;
        });
        this.method_37063((class_364)this.upload);
        this.upload.setActive(false);
        this.method_37063((class_364)new Button(buttX - 12, buttY, 24, 24, 0, 0, 24, new FiguraIdentifier("textures/gui/reload.png"), 72, 24, (class_2561)new FiguraText("gui.wardrobe.reload.tooltip"), button -> {
            AvatarManager.clearAvatars(FiguraMod.getLocalPlayerUUID());
            try {
                LocalAvatarLoader.loadAvatar(null, null);
            }
            catch (Exception exception) {
                // empty catch block
            }
            AvatarManager.localUploaded = true;
            AvatarList.selectedEntry = null;
            NetworkStuff.auth();
        }));
        this.delete = new Button(buttX + 24, buttY, 24, 24, 0, 0, 24, new FiguraIdentifier("textures/gui/delete.png"), 72, 24, (class_2561)new FiguraText("gui.wardrobe.delete.tooltip"), button -> NetworkStuff.deleteAvatar(null));
        this.method_37063((class_364)this.delete);
        this.delete.setActive(false);
        StatusWidget statusWidget = new StatusWidget(entity.getX() + entity.method_25368() - 64, 0, 64);
        statusWidget.setY(entity.getY() - statusWidget.method_25364() - 4);
        this.method_37060(statusWidget);
        this.method_37060(new LoadingErrorWidget(statusWidget.getX() - 18, statusWidget.getY(), 14));
        class_5250 versionText = new FiguraText().method_27693(" " + FiguraMod.VERSION.noBuildString()).method_27692(class_124.field_1056);
        int versionStatus = NetworkStuff.latestVersion != null ? NetworkStuff.latestVersion.compareTo(FiguraMod.VERSION) : 0;
        boolean bl = oldVersion = versionStatus > 0;
        if (oldVersion) {
            versionText.method_27693(" ").method_10852((class_2561)new class_2585("=").method_27696(class_2583.field_24360.method_27704(UIHelper.UI_FONT).method_10978(Boolean.valueOf(false)).method_27707(class_124.field_1068))).method_27696(class_2583.field_24360.method_27706(class_124.field_1075).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)new FiguraText("gui.new_version.tooltip", new class_2585(NetworkStuff.latestVersion.toString()).method_27692(class_124.field_1060)))).method_10958((class_2558)new TextUtils.FiguraClickEvent(UIHelper.openURL(NetworkStuff.latestVersion.pre == null ? FiguraMod.Links.Modrinth.url + "/versions" : FiguraMod.Links.Github.url + "/releases"))));
        } else if (versionStatus < 0) {
            versionText.method_27696(class_2583.field_24360.method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)new FiguraText("gui.old_version.tooltip", new class_2585(NetworkStuff.latestVersion.toString()).method_27692(class_124.field_1076)))));
        }
        Label version = new Label((Object)versionText, middle, this.field_22790 - 4, TextUtils.Alignment.CENTER);
        this.method_37063(version);
        if (!oldVersion) {
            version.setAlpha(51);
        }
        version.setY(version.getRawY() - version.method_25364());
        int rightSide = Math.min(panels, 134);
        this.back = new Button(this.field_22789 - rightSide - 4, this.field_22790 - 24, rightSide, 20, (class_2561)new FiguraText("gui.done"), null, bx -> this.method_25419());
        this.method_37063((class_364)this.back);
        rightSide = panels / 2 + 52;
        Button avatarSettings = new Button(this.field_22789 - rightSide, 28, 24, 24, 0, 0, 24, new FiguraIdentifier("textures/gui/avatar_settings.png"), 72, 24, (class_2561)new FiguraText("gui.avatar_settings.tooltip").method_27693("\n").method_10852((class_2561)new FiguraText("gui.not_available_yet").method_27692(class_124.field_1061)), bx -> {});
        this.method_37063((class_364)avatarSettings);
        avatarSettings.setActive(false);
        Button sounds = new Button(this.field_22789 - rightSide + 36, 28, 24, 24, 0, 0, 24, new FiguraIdentifier("textures/gui/sound.png"), 72, 24, (class_2561)new FiguraText("gui.wardrobe.sound.tooltip"), button -> class_310.method_1551().method_1507((class_437)new SoundScreen(this)));
        this.method_37063((class_364)sounds);
        Button keybinds = new Button(this.field_22789 - rightSide + 72, 28, 24, 24, 0, 0, 24, new FiguraIdentifier("textures/gui/keybind.png"), 72, 24, (class_2561)new FiguraText("gui.wardrobe.keybind.tooltip"), button -> class_310.method_1551().method_1507((class_437)new KeybindScreen(this)));
        this.method_37063((class_364)keybinds);
        this.infoWidget = new AvatarInfoWidget(this.field_22789 - panels - 4, 56, panels, this.back.getY() - 60);
        this.method_37060(this.infoWidget);
        if (this.motdWidget != null) {
            this.method_37066(this.motdWidget);
            this.motdWidget = null;
        }
        this.updateMotdWidget();
        this.panic = new Label(new FiguraText("gui.panic", Configs.PANIC_BUTTON.keyBind.method_16007()).method_27692(class_124.field_1054), middle, version.getRawY(), TextUtils.Alignment.CENTER, 0);
        this.method_37063(this.panic);
        this.panic.setY(this.panic.getRawY() - this.panic.method_25364());
        this.panic.setVisible(false);
    }

    private int getPanels() {
        return Math.min(this.field_22789 / 3, 256) - 8;
    }

    private void updateMotdWidget() {
        int panels = this.getPanels();
        int infoBottom = this.infoWidget.getY() + this.infoWidget.method_25364();
        int width = panels - 8;
        int height = this.back.getY() - infoBottom - 16;
        int x = this.field_22789 - panels;
        int y = infoBottom + 8;
        this.infoWidget.tick();
        if (this.motdWidget == null) {
            class_2561 motd;
            class_2561 class_25612 = motd = NetworkStuff.motd == null ? DEBUG_MOTD_FALLBACK : NetworkStuff.motd;
            if (!FiguraMod.debugModeEnabled() && motd == DEBUG_MOTD_FALLBACK) {
                return;
            }
            this.motdWidget = (BackendMotdWidget)this.method_37063(new BackendMotdWidget(x, y, width, height, motd, this.field_22793));
        } else {
            class_2561 motd;
            this.motdWidget.setPosition(x, y);
            this.motdWidget.method_25358(width);
            this.motdWidget.setHeight(height);
            class_2561 class_25613 = motd = NetworkStuff.motd == null ? DEBUG_MOTD_FALLBACK : NetworkStuff.motd;
            if (!FiguraMod.debugModeEnabled() && motd == DEBUG_MOTD_FALLBACK) {
                return;
            }
            this.motdWidget.method_25355(motd);
        }
        this.motdWidget.field_22764 = this.motdWidget.method_25364() > 48;
    }

    @Override
    public void method_25393() {
        Avatar avatar;
        super.method_25393();
        this.panic.setVisible(AvatarManager.panic);
        this.upload.setActive(NetworkStuff.canUpload() && !AvatarManager.localUploaded && (avatar = AvatarManager.getAvatarForPlayer(FiguraMod.getLocalPlayerUUID())) != null && avatar.nbt != null && avatar.loaded);
        this.delete.setActive(NetworkStuff.isConnected() && AvatarManager.localUploaded);
        this.updateMotdWidget();
    }

    public void method_25432() {
        super.method_25432();
        LocalAvatarFetcher.save();
    }

    public void method_29638(List<Path> paths) {
        super.method_29638(paths);
        StringBuilder packs = new StringBuilder();
        for (int i = 0; i < paths.size(); ++i) {
            if (i > 0) {
                packs.append("\n");
            }
            packs.append(IOUtils.getFileNameOrEmpty(paths.get(i)));
        }
        this.field_22787.method_1507((class_437)new FiguraConfirmScreen(confirmed -> {
            if (confirmed) {
                try {
                    LocalAvatarFetcher.loadExternal(paths);
                    FiguraToast.sendToast((Object)new FiguraText("toast.wardrobe_copy.success", paths.size()));
                }
                catch (Exception e) {
                    FiguraToast.sendToast((Object)new FiguraText("toast.wardrobe_copy.error"), FiguraToast.ToastType.ERROR);
                    FiguraMod.LOGGER.error("Failed to copy files", (Throwable)e);
                }
            }
            this.field_22787.method_1507((class_437)this);
        }, (Object)new FiguraText("gui.wardrobe.drop_files"), packs.toString(), this));
    }
}

