/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.gui.screens;

import java.util.ArrayList;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import org.figuramc.figura.FiguraMod;
import org.figuramc.figura.gui.screens.AbstractPanelScreen;
import org.figuramc.figura.gui.widgets.Button;
import org.figuramc.figura.gui.widgets.Label;
import org.figuramc.figura.utils.FiguraIdentifier;
import org.figuramc.figura.utils.FiguraText;
import org.figuramc.figura.utils.ui.UIHelper;

public class GameScreen
extends AbstractPanelScreen {
    private static final int[][] RULES = new int[][]{{0, 0, 0, 1, 0, 0, 0, 0, 0}, {0, 0, 1, 1, 0, 0, 0, 0, 0}};
    private Label keys;
    private Label stats;
    private Grid grid;
    private boolean paused = false;
    private static int scale = 5;

    protected GameScreen(class_437 parentScreen) {
        super(parentScreen, (class_2561)class_2585.field_24366.method_27661());
    }

    @Override
    public Class<? extends class_437> getSelectedPanel() {
        return this.parentScreen.getClass();
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        this.method_37066((class_364)this.panels);
        this.grid = new Grid(this.field_22789, this.field_22790);
        this.method_37060(this.grid);
        this.method_37063((class_364)new Button(this.field_22789 - 20, 4, 16, 16, 0, 0, 16, new FiguraIdentifier("textures/gui/search_clear.png"), 48, 16, (class_2561)new FiguraText("gui.done"), bx -> this.method_25419()));
        this.keys = new Label((Object)class_2585.field_24366.method_27661().method_10852((class_2561)new class_2585("[R]").method_27696(FiguraMod.getAccentColor())).method_27693(" restart, ").method_10852((class_2561)new class_2585("[P]").method_27696(FiguraMod.getAccentColor())).method_27693(" pause, ").method_10852((class_2561)new class_2585("[SPACE]").method_27696(FiguraMod.getAccentColor())).method_27693(" step").method_27693("\n").method_10852((class_2561)new class_2585("[F1]").method_27696(FiguraMod.getAccentColor())).method_27693(" hide text, ").method_10852((class_2561)new class_2585("[Scroll]").method_27696(FiguraMod.getAccentColor())).method_27693(" scale (restarts)"), 4, 4, 0);
        this.method_37063(this.keys);
        this.stats = new Label((Object)"", 4, this.keys.getRawY() + this.keys.method_25364(), 0);
        this.method_37063(this.stats);
    }

    @Override
    public void method_25393() {
        super.method_25393();
        if (!this.paused) {
            this.grid.tick();
        }
        this.stats.setText((class_2561)new class_2585("Generation").method_10852((class_2561)new class_2585(" " + this.grid.gen).method_27696(FiguraMod.getAccentColor())).method_27693(", Scale").method_10852((class_2561)new class_2585(" " + scale).method_27696(FiguraMod.getAccentColor())));
    }

    @Override
    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        switch (keyCode) {
            case 82: {
                this.grid.init();
                break;
            }
            case 80: {
                this.paused = !this.paused;
                break;
            }
            case 32: {
                this.grid.tick();
                break;
            }
            case 290: {
                this.keys.setVisible(!this.keys.isVisible());
                this.stats.setVisible(!this.stats.isVisible());
                break;
            }
            default: {
                return super.method_25404(keyCode, scanCode, modifiers);
            }
        }
        return true;
    }

    @Override
    public boolean method_25401(double mouseX, double mouseY, double amount) {
        scale = (int)Math.max(1.0, (double)scale + Math.signum(amount));
        this.grid.init();
        return true;
    }

    private static class Grid
    implements class_4068 {
        private Cell[][] grid;
        private final int width;
        private final int height;
        private long gen = 0L;

        private Grid(int width, int height) {
            this.width = width;
            this.height = height;
            this.init();
        }

        private void init() {
            this.gen = 0L;
            int width = this.width / scale;
            int height = this.height / scale;
            this.grid = new Cell[width][height];
            for (int i = 0; i < width; ++i) {
                for (int j = 0; j < height; ++j) {
                    Cell cell = new Cell(i, j, (int)Math.round(Math.random()));
                    if (i > 0) {
                        if (j > 0) {
                            cell.addNeighbor(this.grid[i - 1][j - 1]);
                        }
                        cell.addNeighbor(this.grid[i - 1][j]);
                        if (j < height - 1) {
                            cell.addNeighbor(this.grid[i - 1][j + 1]);
                        }
                    }
                    if (j > 0) {
                        cell.addNeighbor(this.grid[i][j - 1]);
                    }
                    this.grid[i][j] = cell;
                }
            }
        }

        private void tick() {
            ++this.gen;
            Cell[][] cellArray = this.grid;
            int n = cellArray.length;
            for (int i = 0; i < n; ++i) {
                Cell[] cells;
                for (Cell cell : cells = cellArray[i]) {
                    cell.update();
                }
            }
        }

        public void method_25394(class_4587 pose, int mouseX, int mouseY, float delta) {
            pose.method_22903();
            pose.method_22905((float)scale, (float)scale, (float)scale);
            Cell[][] cellArray = this.grid;
            int n = cellArray.length;
            for (int i = 0; i < n; ++i) {
                Cell[] cells;
                for (Cell cell : cells = cellArray[i]) {
                    cell.render(pose);
                }
            }
            pose.method_22909();
        }
    }

    private static class Cell {
        private final int x;
        private final int y;
        private int alive;
        private int future;
        private final ArrayList<Cell> neighbors = new ArrayList();
        private int color = -1;

        private Cell(int x, int y, int alive) {
            this.x = x;
            this.y = y;
            this.alive = alive;
            this.future = alive;
        }

        private void addNeighbor(Cell cell) {
            this.neighbors.add(cell);
            cell.neighbors.add(this);
        }

        private void update() {
            int neigh = 0;
            for (Cell cell : this.neighbors) {
                neigh += cell.alive;
            }
            this.future = RULES[this.alive][neigh];
        }

        private void render(class_4587 pose) {
            this.alive = this.future;
            if (this.alive == 1) {
                UIHelper.method_25294((class_4587)pose, (int)this.x, (int)this.y, (int)(this.x + 1), (int)(this.y + 1), (int)this.color);
            }
        }
    }
}

