/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.gui;

import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_368;
import net.minecraft.class_374;
import net.minecraft.class_4587;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import org.figuramc.figura.FiguraMod;
import org.figuramc.figura.config.Configs;
import org.figuramc.figura.utils.ColorUtils;
import org.figuramc.figura.utils.FiguraIdentifier;
import org.figuramc.figura.utils.ui.UIHelper;

public class FiguraToast
implements class_368 {
    private final ToastType type;
    private class_2561 title;
    private class_2561 message;
    private long startTime;
    private boolean update;

    public FiguraToast(class_2561 title, class_2561 message, ToastType type) {
        this.type = type;
        this.update(title, message, false);
    }

    public void update(class_2561 title, class_2561 message, boolean update) {
        this.title = class_2585.field_24366.method_27661().method_10862(this.type.style).method_10852(title);
        this.message = message;
        this.update = update;
    }

    public class_368.class_369 method_1986(class_4587 stack, class_374 component, long startTime) {
        int time = Math.round(((Float)Configs.TOAST_TIME.value).floatValue() * 1000.0f);
        int titleTime = Math.round(((Float)Configs.TOAST_TITLE_TIME.value).floatValue() * 1000.0f);
        if (this.update) {
            if (startTime - this.startTime < (long)time) {
                class_368.class_369.field_2210.method_1988(component.method_1995().method_1483());
            }
            this.startTime = startTime;
            this.update = false;
        }
        long timeDiff = startTime - this.startTime;
        UIHelper.setupTexture(this.type.texture);
        int frame = (Boolean)Configs.REDUCED_MOTION.value != false ? 0 : (int)((float)FiguraMod.ticks / 5.0f % (float)this.type.frames);
        UIHelper.method_25290((class_4587)stack, (int)0, (int)0, (float)0.0f, (float)(frame * this.method_29050()), (int)this.method_29049(), (int)this.method_29050(), (int)this.method_29049(), (int)(this.method_29050() * this.type.frames));
        class_327 font = component.method_1995().field_1772;
        if (this.message.getString().isBlank()) {
            this.renderText(this.title, font, stack, 255);
        } else if (this.title.getString().isBlank()) {
            this.renderText(this.message, font, stack, 255);
        } else {
            List a = font.method_1728((class_5348)this.title, this.method_29049() - this.type.spacing - 1);
            List b = font.method_1728((class_5348)this.message, this.method_29049() - this.type.spacing - 1);
            if (a.size() == 1 && b.size() == 1) {
                float f = (float)this.method_29050() / 2.0f;
                Objects.requireNonNull(font);
                int y = Math.round(f - 9.0f - 1.0f);
                font.method_30883(stack, this.title, (float)this.type.spacing, (float)y, 0xFFFFFF);
                font.method_30883(stack, this.message, (float)this.type.spacing, (float)(y * 2 + 4), 0xFFFFFF);
            } else if (timeDiff < (long)titleTime) {
                this.renderText(this.title, font, stack, Math.round(Math.min(Math.max((float)((long)titleTime - timeDiff) / 300.0f, 0.0f), 1.0f) * 255.0f));
            } else {
                this.renderText(this.message, font, stack, Math.round(Math.min(Math.max((float)(timeDiff - (long)titleTime) / 300.0f, 0.0f), 1.0f) * 255.0f));
            }
        }
        return timeDiff < (long)time ? class_368.class_369.field_2210 : class_368.class_369.field_2209;
    }

    public void renderText(class_2561 text, class_327 font, class_4587 poseStack, int alpha) {
        List list = font.method_1728((class_5348)text, this.method_29049() - this.type.spacing - 1);
        if (list.size() == 1) {
            float f = this.type.spacing;
            float f2 = (float)this.method_29050() / 2.0f;
            Objects.requireNonNull(font);
            font.method_30883(poseStack, text, f, (float)Math.round(f2 - 9.0f / 2.0f), 0xFFFFFF + (alpha << 24));
        } else {
            float f = (float)this.method_29050() / 2.0f;
            Objects.requireNonNull(font);
            int y = Math.round(f - 9.0f - 1.0f);
            for (int i = 0; i < list.size(); ++i) {
                font.method_27528(poseStack, (class_5481)list.get(i), (float)this.type.spacing, (float)(y * (i + 1) + 4 * i), 0xFFFFFF + (alpha << 24));
            }
        }
    }

    public Object method_1987() {
        return this.type;
    }

    public int method_29049() {
        return this.type.width;
    }

    public int method_29050() {
        return 32;
    }

    public static void sendToast(Object title) {
        FiguraToast.sendToast(title, class_2585.field_24366.method_27661());
    }

    public static void sendToast(Object title, ToastType type) {
        FiguraToast.sendToast(title, class_2585.field_24366.method_27661(), type);
    }

    public static void sendToast(Object title, Object message) {
        FiguraToast.sendToast(title, message, ToastType.DEFAULT);
    }

    public static void sendToast(Object title, Object message, ToastType type) {
        class_2588 text2;
        class_2588 text;
        if (title instanceof class_2561) {
            class_2561 t = (class_2561)title;
            v0 = t;
        } else {
            v0 = text = new class_2588(title.toString());
        }
        if (message instanceof class_2561) {
            class_2561 m = (class_2561)message;
            v1 = m;
        } else {
            v1 = text2 = new class_2588(message.toString());
        }
        if (type == ToastType.DEFAULT && ((Boolean)Configs.EASTER_EGGS.value).booleanValue()) {
            Calendar calendar = FiguraMod.CALENDAR;
            calendar.setTime(new Date());
            if (calendar.get(5) == 1 && calendar.get(2) == 3 || Math.random() < 1.0E-4) {
                type = ToastType.CHEESE;
            }
        }
        class_374 toasts = class_310.method_1551().method_1566();
        FiguraToast toast = (FiguraToast)toasts.method_1997(FiguraToast.class, (Object)type);
        FiguraMod.debug("Sent toast: \"{}\", \"{}\" of type: \"{}\"", text.getString(), text2.getString(), type.name());
        if (toast != null) {
            toast.update((class_2561)text, (class_2561)text2, true);
        } else {
            toasts.method_1999((class_368)new FiguraToast((class_2561)text, (class_2561)text2, type));
        }
    }

    public static enum ToastType {
        DEFAULT(new FiguraIdentifier("textures/gui/toast/default.png"), 4, 160, 31, 0x55FFFF),
        WARNING(new FiguraIdentifier("textures/gui/toast/warning.png"), 4, 160, 31, 0xFFFF00),
        ERROR(new FiguraIdentifier("textures/gui/toast/error.png"), 4, 160, 31, 0xFF0000),
        CHEESE(new FiguraIdentifier("textures/gui/toast/cheese.png"), 1, 160, 31, ColorUtils.Colors.CHEESE.hex);

        private final class_2960 texture;
        private final int frames;
        private final class_2583 style;
        private final int width;
        private final int spacing;

        private ToastType(class_2960 texture, int frames, int width, int spacing, int color) {
            this.texture = texture;
            this.frames = frames;
            this.width = width;
            this.spacing = spacing;
            this.style = class_2583.field_24360.method_36139(color);
        }
    }
}

