/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.class_1041;
import net.minecraft.class_1160;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import org.figuramc.figura.FiguraMod;
import org.figuramc.figura.avatar.Avatar;
import org.figuramc.figura.avatar.AvatarManager;
import org.figuramc.figura.config.Configs;
import org.figuramc.figura.font.Emojis;
import org.figuramc.figura.lua.api.action_wheel.Action;
import org.figuramc.figura.lua.api.action_wheel.Page;
import org.figuramc.figura.math.vector.FiguraVec3;
import org.figuramc.figura.utils.FiguraIdentifier;
import org.figuramc.figura.utils.FiguraText;
import org.figuramc.figura.utils.TextUtils;
import org.figuramc.figura.utils.ui.UIHelper;

public class ActionWheel {
    private static final class_2960 TEXTURE = new FiguraIdentifier("textures/gui/action_wheel.png");
    private static final class_2960 ICONS = new FiguraIdentifier("textures/gui/action_wheel_icons.png");
    private static final double DISTANCE = 41.0;
    private static final double DEADZONE = 19.0;
    private static boolean enabled = false;
    private static int selected = -1;
    private static class_310 minecraft;
    private static int slots;
    private static int leftSlots;
    private static int rightSlots;
    private static float scale;
    private static int x;
    private static int y;
    private static double mouseX;
    private static double mouseY;

    public static void render(class_4587 stack) {
        Page currentPage;
        if (!ActionWheel.isEnabled()) {
            return;
        }
        minecraft = class_310.method_1551();
        class_1041 window = minecraft.method_22683();
        x = (int)((double)window.method_4486() / 2.0);
        y = (int)((double)window.method_4502() / 2.0);
        stack.method_22903();
        stack.method_22904((double)x, (double)y, 0.0);
        scale = ((Float)Configs.ACTION_WHEEL_SCALE.value).floatValue();
        stack.method_22905(scale, scale, scale);
        Avatar avatar = AvatarManager.getAvatarForPlayer(FiguraMod.getLocalPlayerUUID());
        if (avatar == null || avatar.luaRuntime == null || (currentPage = avatar.luaRuntime.action_wheel.currentPage) == null) {
            ActionWheel.renderEmpty(stack, avatar == null);
            return;
        }
        slots = currentPage.getSize();
        leftSlots = (int)Math.floor((double)slots / 2.0);
        rightSlots = (int)Math.ceil((double)slots / 2.0);
        mouseX = ActionWheel.minecraft.field_1729.method_1603() * (double)window.method_4486() / (double)window.method_4480();
        mouseY = ActionWheel.minecraft.field_1729.method_1604() * (double)window.method_4502() / (double)window.method_4507();
        FiguraMod.pushProfiler("selectedSlot");
        ActionWheel.calculateSelected();
        FiguraMod.popPushProfiler("wheel");
        ActionWheel.renderTextures(stack, currentPage);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        FiguraMod.popPushProfiler("items");
        ActionWheel.renderItemsAndIcons(stack, currentPage);
        stack.method_22909();
        FiguraMod.popPushProfiler("texts");
        ActionWheel.renderTexts(stack, currentPage);
        FiguraMod.popProfiler();
    }

    private static double getAngle(int i) {
        double angle = i < rightSlots ? 180.0 / (double)rightSlots * ((double)i - (double)(rightSlots - 1) * 0.5) : 180.0 / (double)leftSlots * (double)((float)(i - rightSlots) - (float)(leftSlots - 1) * 0.5f + (float)leftSlots);
        return Math.toRadians(angle);
    }

    private static void renderEmpty(class_4587 stack, boolean avatar) {
        TextureData data = OverlayTexture.values()[0].data[0];
        data.render(stack, null, false);
        data.render(stack, null, true);
        stack.method_22909();
        class_5250 component = new FiguraText("gui.error." + (avatar ? "no_avatar" : "no_wheel_page")).method_27692(class_124.field_1054);
        class_327 font = ActionWheel.minecraft.field_1772;
        int n = x - font.method_27525((class_5348)component) / 2;
        Objects.requireNonNull(font);
        UIHelper.renderOutlineText(stack, font, (class_2561)component, n, y - 9 / 2, 0xFFFFFF, 0);
    }

    private static void calculateSelected() {
        double mouseDistance = Math.sqrt(Math.pow((double)x - mouseX, 2.0) + Math.pow((double)y - mouseY, 2.0));
        if (rightSlots == 0 || mouseDistance < 19.0 * (double)scale) {
            selected = -1;
            return;
        }
        double angle = Math.toDegrees(Math.atan2(mouseY - (double)y, mouseX - (double)x)) + 90.0;
        if (angle < 0.0) {
            angle += 360.0;
        }
        selected = angle < 180.0 ? (int)Math.floor((double)rightSlots / 180.0 * angle) : (int)Math.floor((double)leftSlots / 180.0 * (angle - 180.0)) + rightSlots;
    }

    private static void renderTextures(class_4587 stack, Page page) {
        for (int i = 0; i < slots; ++i) {
            int relativeIndex;
            Action action = page.slots()[i];
            boolean left = i >= rightSlots;
            int type = left ? leftSlots : rightSlots;
            int n = relativeIndex = left ? i - rightSlots : i;
            FiguraVec3 color = action == null ? null : action.getColor(selected == i);
            OverlayTexture.values()[type - 1].data[relativeIndex].render(stack, color, left);
            if (action == null) continue;
            double angle = ActionWheel.getAngle(i);
            double x = Math.cos(angle) * 15.0 - 4.0;
            double y = Math.sin(angle) * 15.0 - 4.0;
            UIHelper.setupTexture(ICONS);
            if (color != null) {
                RenderSystem.setShaderColor((float)((float)color.x), (float)((float)color.y), (float)((float)color.z), (float)1.0f);
            }
            UIHelper.method_25293((class_4587)stack, (int)((int)Math.round(x)), (int)((int)Math.round(y)), (int)8, (int)8, (float)(action.scroll != null ? 24.0f : (action.toggle != null ? (action.isToggled() ? 16.0f : 8.0f) : 0.0f)), (float)(color == null ? 0.0f : 8.0f), (int)8, (int)8, (int)32, (int)16);
        }
    }

    private static void renderItemsAndIcons(class_4587 stack, Page page) {
        for (int i = 0; i < slots; ++i) {
            class_1799 item;
            Action action = page.slots()[i];
            if (action == null) continue;
            boolean isSelected = selected == i;
            double angle = ActionWheel.getAngle(i);
            double xOff = Math.cos(angle) * 41.0;
            double yOff = Math.sin(angle) * 41.0;
            Action.TextureData texture = action.getTexture(isSelected);
            if (texture != null) {
                UIHelper.setupTexture(texture.texture.getLocation());
                UIHelper.method_25293((class_4587)stack, (int)((int)Math.round(xOff - (double)texture.width * texture.scale / 2.0)), (int)((int)Math.round(yOff - (double)texture.height * texture.scale / 2.0)), (int)((int)Math.round((double)texture.width * texture.scale)), (int)((int)Math.round((double)texture.height * texture.scale)), (float)((float)texture.u), (float)((float)texture.v), (int)texture.width, (int)texture.height, (int)texture.texture.getWidth(), (int)texture.texture.getHeight());
            }
            if ((item = action.getItem(isSelected)) == null || item.method_7960()) continue;
            class_4587 modelStack = RenderSystem.getModelViewStack();
            modelStack.method_22903();
            modelStack.method_22904((double)x, (double)y, 0.0);
            modelStack.method_22905(scale, scale, scale);
            minecraft.method_1480().method_4010(item, (int)Math.round(xOff - 8.0), (int)Math.round(yOff - 8.0));
            if (((Boolean)Configs.ACTION_WHEEL_DECORATIONS.value).booleanValue()) {
                minecraft.method_1480().method_4025(ActionWheel.minecraft.field_1772, item, (int)Math.round(xOff - 8.0), (int)Math.round(yOff - 8.0));
            }
            modelStack.method_22909();
            RenderSystem.applyModelViewMatrix();
        }
    }

    private static void renderTexts(class_4587 stack, Page page) {
        class_327 font = ActionWheel.minecraft.field_1772;
        int titlePosition = (Integer)Configs.ACTION_WHEEL_TITLE.value;
        int indicatorPosition = (Integer)Configs.ACTION_WHEEL_SLOTS_INDICATOR.value;
        Action selectedTitleAction = selected == -1 ? null : page.slots()[selected];
        String selectedTitle = selectedTitleAction == null ? null : selectedTitleAction.getTitle();
        int groupCount = page.getGroupCount();
        if (groupCount > 1 && (selectedTitle == null || indicatorPosition != titlePosition - 2)) {
            class_5250 arrow;
            stack.method_22903();
            stack.method_22904(0.0, 0.0, 999.0);
            int index = page.getSlotsShift();
            int greatest = page.getGreatestSlot() + 1;
            class_5250 indicator = class_2585.field_24366.method_27661();
            int extraWidth = 0;
            if (index > 1) {
                arrow = UIHelper.UP_ARROW.method_27661().method_27693(" ");
                indicator.method_10852((class_2561)arrow);
                extraWidth -= font.method_27525((class_5348)arrow);
            }
            indicator.method_10852((class_2561)new FiguraText("gui.action_wheel.slots_indicator", new class_2585(String.valueOf((index - 1) * 8 + 1)).method_27696(FiguraMod.getAccentColor()), new class_2585(String.valueOf(Math.min(index * 8, greatest))).method_27696(FiguraMod.getAccentColor()), new class_2585(String.valueOf(greatest)).method_27696(FiguraMod.getAccentColor())));
            if (index < groupCount) {
                arrow = new class_2585(" ").method_10852(UIHelper.DOWN_ARROW);
                indicator.method_10852((class_2561)arrow);
                extraWidth += font.method_27525((class_5348)arrow);
            }
            float f = x - (int)((float)(font.method_27525((class_5348)indicator) - extraWidth) / 2.0f);
            Position position = Position.index(indicatorPosition);
            Objects.requireNonNull(font);
            font.method_30881(stack, (class_2561)indicator, f, (float)((int)position.apply(9.0)), 0xFFFFFF);
            stack.method_22909();
        }
        if (titlePosition >= 5) {
            boolean internal = titlePosition == 5;
            double distance = (internal ? 41.0 : 66.0) * (double)scale;
            stack.method_22903();
            stack.method_22904(0.0, 0.0, 999.0);
            for (int i = 0; i < slots; ++i) {
                float f;
                String title;
                Action action = page.slots()[i];
                if (action == null || (title = action.getTitle()) == null) continue;
                double angle = ActionWheel.getAngle(i);
                double xOff = Math.cos(angle) * distance;
                double yOff = Math.sin(angle) * distance;
                int textX = x + (int)Math.round(xOff);
                if (internal) {
                    f = 9.0f * scale;
                } else {
                    Objects.requireNonNull(font);
                    f = (float)(-9) / 2.0f;
                }
                int textY = y + (int)Math.round(yOff + (double)f);
                class_2561 text = TextUtils.replaceInText((class_5348)Emojis.applyEmojis(TextUtils.tryParseJson(title)), "\n|\\\\n", " ");
                int textWidth = font.method_27525((class_5348)text);
                if (internal) {
                    textX = (int)((float)textX - (float)textWidth / 2.0f);
                    textX = i >= rightSlots ? Math.min(textX, x - textWidth - 1) : Math.max(textX, x + 1);
                } else if (i >= rightSlots) {
                    textX -= textWidth;
                }
                font.method_30881(stack, text, (float)textX, (float)textY, 0xFFFFFF);
            }
            stack.method_22909();
            return;
        }
        if (selectedTitle == null) {
            return;
        }
        class_5250 text = Emojis.applyEmojis(TextUtils.tryParseJson(selectedTitle));
        List<class_2561> list = TextUtils.splitText((class_5348)text, "\n");
        Objects.requireNonNull(font);
        int height = 9 * list.size();
        if (titlePosition < 2) {
            UIHelper.renderTooltip(stack, (class_2561)text, (int)mouseX, (int)mouseY, titlePosition == 0);
        } else {
            stack.method_22903();
            stack.method_22904(0.0, 0.0, 999.0);
            int y = (int)Position.index(titlePosition - 2).apply(height);
            for (int i = 0; i < list.size(); ++i) {
                class_2561 component = list.get(i);
                float f = x - (int)((float)font.method_27525((class_5348)component) / 2.0f);
                Objects.requireNonNull(font);
                font.method_30881(stack, component, f, (float)(y + 9 * i), 0xFFFFFF);
            }
            stack.method_22909();
        }
    }

    public static void execute(int index, boolean left) {
        Page currentPage;
        Avatar avatar;
        if (!ActionWheel.isEnabled() || (avatar = AvatarManager.getAvatarForPlayer(FiguraMod.getLocalPlayerUUID())) == null || avatar.luaRuntime == null) {
            selected = -1;
            return;
        }
        if (avatar.luaRuntime.action_wheel.execute(avatar, left)) {
            return;
        }
        if (index < 0 || index > 7 || avatar.luaRuntime == null || (currentPage = avatar.luaRuntime.action_wheel.currentPage) == null) {
            selected = -1;
            return;
        }
        Action action = currentPage.slots()[index];
        if (action != null) {
            action.execute(avatar, left);
        }
        selected = -1;
    }

    public static void hotbarKeyPressed(int i) {
        ActionWheel.execute(i, true);
    }

    public static void scroll(double delta) {
        Action action;
        Avatar avatar;
        if (!ActionWheel.isEnabled() || (avatar = AvatarManager.getAvatarForPlayer(FiguraMod.getLocalPlayerUUID())) == null || avatar.luaRuntime == null) {
            return;
        }
        if (avatar.luaRuntime.action_wheel.mouseScroll(avatar, delta)) {
            return;
        }
        Page currentPage = avatar.luaRuntime.action_wheel.currentPage;
        if (currentPage == null) {
            return;
        }
        if (selected >= 0 && selected <= 7 && (action = currentPage.slots()[selected]) != null && action.scroll != null) {
            action.mouseScroll(avatar, delta);
            return;
        }
        currentPage.setSlotsShift(currentPage.getSlotsShift() - (int)Math.signum(delta));
    }

    public static void setEnabled(boolean enabled) {
        ActionWheel.enabled = enabled;
    }

    public static boolean isEnabled() {
        return enabled;
    }

    public static int getSelected() {
        return selected;
    }

    private static enum OverlayTexture {
        ONE(new TextureData(true, -64, 0.0f, 0.0f, 0)),
        TWO(new TextureData(64.0f, 0.0f), new TextureData(64.0f, 0.0f, 90)),
        THREE(new TextureData(128.0f, 0.0f), new TextureData(-32, 128.0f, 64.0f, 0), new TextureData(0, 64.0f, 64.0f, 0)),
        FOUR(new TextureData(192.0f, 0.0f), new TextureData(192.0f, 64.0f), new TextureData(192.0f, 0.0f, 90), new TextureData(192.0f, 64.0f, 90));

        private final TextureData[] data;

        private OverlayTexture(TextureData ... data) {
            this.data = data;
        }
    }

    private static class TextureData {
        private final int y;
        private final int h;
        private final int rh;
        private final float u;
        private final float v;
        private final int rotation;

        public TextureData(boolean large, int y, float u, float v, int rotation) {
            this.y = y;
            this.h = large ? 128 : 64;
            this.u = u;
            this.v = v;
            this.rh = large ? 128 : 64;
            this.rotation = rotation;
        }

        public TextureData(int y, float u, float v, int rotation) {
            this(false, y, u, v, rotation);
        }

        public TextureData(float u, float v, int rotation) {
            this(-64, u, v, rotation);
        }

        public TextureData(float u, float v) {
            this(u, v, 0);
        }

        public void render(class_4587 stack, FiguraVec3 color, boolean left) {
            stack.method_22903();
            stack.method_22907(class_1160.field_20707.method_23214((float)(this.rotation + (left ? 180 : 0))));
            UIHelper.setupTexture(TEXTURE);
            if (color != null) {
                RenderSystem.setShaderColor((float)((float)color.x), (float)((float)color.y), (float)((float)color.z), (float)1.0f);
            }
            UIHelper.method_25293((class_4587)stack, (int)0, (int)this.y, (int)64, (int)this.h, (float)this.u, (float)(color == null ? this.v : this.v + 128.0f), (int)64, (int)this.rh, (int)256, (int)256);
            stack.method_22909();
        }
    }

    private static enum Position {
        TOP(height -> Math.max((double)((float)y - 64.0f * scale - 4.0f) - height, 4.0)),
        MID(height -> (double)y - height / 2.0),
        BOT(height -> Math.min((double)((float)y + 64.0f * scale + 4.0f) + height, (double)(y * 2 - 4)) - height);

        private final Function<Double, Double> function;

        private Position(Function<Double, Double> function) {
            this.function = function;
        }

        public static Position index(int i) {
            return Position.values()[i];
        }

        public double apply(double d) {
            return this.function.apply(d);
        }
    }
}

