/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.font;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2585;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import org.figuramc.figura.FiguraMod;
import org.figuramc.figura.font.EmojiContainer;
import org.figuramc.figura.utils.FiguraResourceListener;
import org.figuramc.figura.utils.TextUtils;

public class Emojis {
    private static final Map<String, EmojiContainer> EMOJIS = new HashMap<String, EmojiContainer>();
    private static final Map<String, EmojiContainer> SHORTCUT_LOOKUP = new HashMap<String, EmojiContainer>();
    public static final char DELIMITER = ':';
    public static final char ESCAPE = '\\';
    public static final FiguraResourceListener RESOURCE_LISTENER = FiguraResourceListener.createResourceListener("emojis", manager -> {
        EMOJIS.clear();
        for (class_2960 location2 : manager.method_14488("emojis", location -> location.endsWith(".json"))) {
            String[] split = location2.method_12832().split("/", 2);
            if (split.length <= 1) continue;
            String name = split[1].substring(0, split[1].length() - 5);
            try {
                InputStream stream = manager.method_14486(location2).method_14482();
                try {
                    JsonObject json = JsonParser.parseReader((Reader)new InputStreamReader(stream, StandardCharsets.UTF_8)).getAsJsonObject();
                    EmojiContainer container = new EmojiContainer(name, json);
                    EMOJIS.put(name, container);
                    container.getLookup().getShortcuts().forEach(shortcut -> SHORTCUT_LOOKUP.put((String)shortcut, container));
                }
                finally {
                    if (stream == null) continue;
                    stream.close();
                }
            }
            catch (Exception e) {
                FiguraMod.LOGGER.error("Failed to load {} emojis", (Object)name, (Object)e);
            }
        }
        HashMap duplicates = new HashMap();
        HashMap<String, String> map = new HashMap<String, String>();
        for (EmojiContainer curContainer : EMOJIS.values()) {
            for (String curName : curContainer.getLookup().getNames()) {
                List<String> list;
                String prevValue = map.put(curName, curContainer.name);
                if (prevValue == null) continue;
                if (!duplicates.containsKey(curName)) {
                    list = new ArrayList<String>();
                    list.add(curContainer.name);
                    duplicates.put(curName, list);
                } else {
                    list = (List)duplicates.get(curName);
                }
                list.add(prevValue);
            }
        }
        for (String curName : duplicates.keySet()) {
            FiguraMod.LOGGER.warn("Duplicate emoji \"{}\" found in containers: {}", (Object)curName, (Object)String.join((CharSequence)", ", (Iterable)duplicates.get(curName)));
        }
    });

    public static Collection<String> getCategoryNames() {
        return EMOJIS.keySet();
    }

    public static EmojiContainer getCategory(String key) {
        return EMOJIS.get(key);
    }

    public static boolean hasCategory(String key) {
        return EMOJIS.containsKey(key);
    }

    public static class_5250 applyEmojis(class_2561 text) {
        class_2561 newText = TextUtils.parseLegacyFormatting((class_5348)text);
        class_5250 ret = class_2585.field_24366.method_27661();
        newText.method_27658((style, string) -> {
            ret.method_10852((class_2561)Emojis.convertEmoji(string, style));
            return Optional.empty();
        }, class_2583.field_24360);
        return ret;
    }

    private static class_5250 convertEmoji(String string, class_2583 style) {
        Object s;
        ArrayList<Object> strings = new ArrayList<Object>();
        StringBuilder current = new StringBuilder();
        boolean escaped = false;
        boolean inside = false;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\\') {
                boolean bl = escaped = !escaped;
                if (i + 1 != string.length() && string.charAt(i + 1) == ':') continue;
                current.append(c);
                continue;
            }
            if (c == ':' && !escaped) {
                inside = !inside;
                strings.add(current.toString());
                current = new StringBuilder();
                continue;
            }
            escaped = false;
            current.append(c);
            if (c != ' ' || !inside) continue;
            inside = false;
            String removed = (String)strings.remove(strings.size() - 1);
            current = new StringBuilder(removed).append(':').append((CharSequence)current);
        }
        if (current.length() > 0 || inside) {
            String toAdd = current.toString();
            if (inside) {
                int index = strings.size() - 1;
                s = (String)strings.get(index) + ":" + toAdd;
                strings.set(index, s);
            } else {
                strings.add(toAdd);
            }
        }
        class_5250 result = class_2585.field_24366.method_27661().method_27696(style);
        for (int i = 0; i < strings.size(); ++i) {
            s = (String)strings.get(i);
            if (i % 2 == 0) {
                List<String> shortcuts = SHORTCUT_LOOKUP.keySet().stream().filter(((String)s)::contains).toList();
                if (shortcuts.size() > 0) {
                    while (((String)s).length() > 0) {
                        boolean anyFound = false;
                        for (String shortcut : shortcuts) {
                            if (!((String)s).startsWith(shortcut)) continue;
                            s = ((String)s).substring(shortcut.length());
                            result.method_10852(SHORTCUT_LOOKUP.get(shortcut).getShortcutComponent(shortcut));
                            anyFound = true;
                            break;
                        }
                        if (anyFound) continue;
                        result.method_27693(String.valueOf(((String)s).charAt(0)));
                        s = ((String)s).substring(1);
                    }
                    continue;
                }
                result.method_27693((String)s);
                continue;
            }
            Emojis.appendEmoji(result, (String)s, Emojis::getEmoji);
        }
        return result;
    }

    private static void appendEmoji(class_5250 result, String s, Function<String, class_2561> converter) {
        class_2561 emoji = converter.apply(s);
        if (emoji != null) {
            result.method_10852(emoji);
        } else {
            result.method_27693(":" + s + ":");
        }
    }

    public static class_2561 getEmoji(String emojiAlias) {
        for (EmojiContainer container : EMOJIS.values()) {
            class_2561 emoji = container.getEmojiComponent(emojiAlias);
            if (emoji == null) continue;
            return emoji;
        }
        return null;
    }

    public static class_2561 getEmoji(String emojiAlias, class_5250 hover) {
        for (EmojiContainer container : EMOJIS.values()) {
            class_2561 emoji = container.getEmojiComponent(emojiAlias, hover);
            if (emoji == null) continue;
            return emoji;
        }
        return null;
    }

    public static EmojiContainer getCategoryByFont(class_2960 location) {
        for (EmojiContainer container : EMOJIS.values()) {
            if (!location.equals((Object)container.getFont())) continue;
            return container;
        }
        return null;
    }

    public static class_2561 removeBlacklistedEmojis(class_2561 text) {
        for (EmojiContainer container : EMOJIS.values()) {
            text = container.blacklist(text);
        }
        return text;
    }

    public static List<String> getMatchingEmojis(String query) {
        if (query.length() == 0 || query.charAt(0) != ':') {
            return List.of();
        }
        String name = query.substring(1);
        ArrayList<String> emojis = new ArrayList<String>();
        for (EmojiContainer container : EMOJIS.values()) {
            for (String s : container.getLookup().getNames()) {
                if (!s.startsWith(name)) continue;
                emojis.add(":" + s + ":");
            }
        }
        return emojis;
    }

    public static void tickAnimations() {
        for (EmojiContainer container : EMOJIS.values()) {
            container.tickAnimations();
        }
    }
}

